/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.purchase.command.order.UpdateIsCanDeliveryCmd;
import com.els.base.purchase.entity.PurOrderItemExt;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.service.QueryReceiveQuantityService;
import com.els.base.utils.SpringContextHolder;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;

public class UpdateReceiveQuantityCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<PurchaseOrderItem> purItemList;

    public UpdateReceiveQuantityCommand(List<PurchaseOrderItem> purItemList) {
        this.purItemList = purItemList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        if (CollectionUtils.isEmpty(this.purItemList)) {
            this.logger.warn("EVENT=\u67e5\u8be2\u6536\u8d27\u6570\u91cf|WARN=\u67e5\u8be2\u7684\u8ba2\u5355\u884c\u4e3a\u7a7a");
            return null;
        }
        QueryReceiveQuantityService service = (QueryReceiveQuantityService)SpringContextHolder.getOneBean(QueryReceiveQuantityService.class);
        if (service == null) {
            throw new CommonException("\u7cfb\u7edf\u672a\u5b9e\u73b0\u6536\u8d27\u6570\u91cf\u7684\u67e5\u8be2\u63a5\u53e3");
        }
        List<PurOrderItemExt> extList = service.executeQuery(this.purItemList);
        if (CollectionUtils.isEmpty(extList)) {
            return null;
        }
        extList = this.distinct(extList);
        extList.stream().forEach(ext -> {
            PurOrderItemExt temp = new PurOrderItemExt();
            temp.setId(ext.getId());
            temp.setReceivedQuantity(ext.getReceivedQuantity());
            ContextUtils.getPurOrderItemExtService().modifyObj(temp);
            UpdateIsCanDeliveryCmd updateIsCanDeliveryCmd = new UpdateIsCanDeliveryCmd(ext.getOrderItemId());
            this.context.invoke(updateIsCanDeliveryCmd);
        });
        return null;
    }

    private List<PurOrderItemExt> distinct(List<PurOrderItemExt> extList) {
        TreeSet<PurOrderItemExt> extSet = new TreeSet<PurOrderItemExt>((e1, e2) -> e1.getId().compareTo(e2.getId()));
        extSet.addAll(extList);
        extList.clear();
        extList.addAll(extSet);
        return extList;
    }
}

