/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.utils.MaterailUtils;
import com.els.base.purchase.entity.PurOrderItemExt;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class CreateOrderItemCommand
extends AbstractCommand<PurchaseOrderItem> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrderItem item;
    private PurchaseOrder order;

    public CreateOrderItemCommand(PurchaseOrderItem item, PurchaseOrder order) {
        this.item = item;
        this.order = order;
    }

    @Override
    public PurchaseOrderItem execute(ICommandInvoker context) {
        this.valid();
        this.init(this.item, this.order);
        ContextUtils.getPurchaseOrderItemService().addObj(this.item);
        this.createPurOrderItemExt(this.item);
        return this.item;
    }

    private void createPurOrderItemExt(PurchaseOrderItem item) {
        PurOrderItemExt ext = new PurOrderItemExt();
        ext.setOrderId(item.getOrderId());
        ext.setOrderItemId(item.getId());
        ext.setOrderNo(item.getOrderNo());
        ext.setOrderItemNo(item.getOrderItemNo());
        ext.setDeliveredQuantity(BigDecimal.ZERO);
        ext.setOnwayQuantity(BigDecimal.ZERO);
        ext.setReceivedQuantity(BigDecimal.ZERO);
        ext.setReturnQuantity(BigDecimal.ZERO);
        ContextUtils.getPurOrderItemExtService().addObj(ext);
    }

    private void init(PurchaseOrderItem item, PurchaseOrder order) {
        Material material;
        SupplierMaterial supplierMaterial;
        item.setOrderId(order.getId());
        item.setOrderNo(order.getOrderNo());
        item.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        item.setProjectId(order.getProjectId());
        item.setPurCompanyId(order.getPurCompanyId());
        item.setPurCompanyName(order.getPurCompanyName());
        item.setPurUserId(order.getPurUserId());
        item.setPurUserName(order.getPurUserName());
        item.setSupCompanyId(order.getSupCompanyId());
        item.setSupCompanyName(order.getSupCompanyName());
        item.setSupCompanySapCode(order.getSupCompanySapCode());
        item.setSupUserId(order.getSupUserId());
        item.setSupUserName(order.getSupUserName());
        item.setCurrency(order.getCurrency());
        item.setUpdateTime(new Date());
        item.setIsUpdated(Constant.NO_INT);
        item.setQuaWarehouseQuantity(BigDecimal.ZERO);
        item.setHaveChange(ChangeTypeEnum.ADD_ITEM.getValue());
        item.setOrderNoType(order.getOrderType());
        item.setPurchaseGroup(order.getPurchaseGroup());
        if (item.getOrderDate() == null) {
            item.setOrderDate(order.getOrderDate());
        }
        if (item.getFreezeQuantity() == null) {
            item.setFreezeQuantity(BigDecimal.ZERO);
        }
        if (item.getAlreadyApplyMoney() == null) {
            item.setAlreadyApplyMoney(BigDecimal.ZERO);
        }
        if ((supplierMaterial = MaterailUtils.querySupplierMaterial((String)item.getSupCompanyId(), (String)item.getSupCompanySapCode(), (String)item.getMaterialCode(), (String)item.getVersion())) != null) {
            item.setSupMaterialCode(supplierMaterial.getSupplierMaterial());
            item.setSupMaterialDesc(supplierMaterial.getSupplierMaterialDesc());
            item.setBrand(supplierMaterial.getBrand());
        }
        if ((material = MaterailUtils.queryMaterial((String)item.getMaterialCode())) != null) {
            item.setMaterialCategoryId(material.getCategoryId());
            item.setMaterialCategoryName(material.getCategoryName());
            item.setMaterialId(material.getId());
            item.setDeliveryMaterialName(material.getMaterialName());
            if (StringUtils.isNotBlank((String)material.getBrandName())) {
                item.setBrand(material.getBrandName());
            }
        }
        if (item.getTaxTotalPrice() == null) {
            item.setAvailableApplyMoney(BigDecimal.ZERO);
        } else {
            item.setAvailableApplyMoney(item.getTaxTotalPrice());
        }
        item.setIsCanDelivery(Constant.YES_INT);
        if (Constant.NO_INT.equals(item.getIsEnable())) {
            item.setIsCanDelivery(Constant.NO_INT);
        }
        if ("Y".equals(item.getFinishFlag())) {
            item.setIsCanDelivery(Constant.NO_INT);
        }
    }

    private void valid() {
        Assert.isNotBlank((String)this.order.getId(), (String)"\u91c7\u8d2d\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getOrderNo(), (String)"\u91c7\u8d2d\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getPurCompanyId(), (String)"\u91c7\u8d2d\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getPurCompanySrmCode(), (String)"\u91c7\u8d2d\u65b9SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getPurCompanyName(), (String)"\u91c7\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546sap code \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.item.getOrderItemNo(), (String)"\u91c7\u8d2d\u5355\u884c\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.item.getMaterialCode(), (String)"\u91c7\u8d2d\u5355\u884c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.item.getQuantity(), (String)"\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.item.getTaxTotalPrice(), (String)"\u7a0e\u4ef7\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.item.getDeliveredDate(), (String)"\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.item.getFinishFlag(), (String)"\u4ea4\u8d27\u5b8c\u6210\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.item.getIsEnable(), (String)"\u8ba2\u5355\u884c\u662f\u5426\u53ef\u7528\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.item.getIsJit(), (String)"\u662f\u5426\u662fJIT\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

