/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurOrderItemBomMapper;
import com.els.base.purchase.entity.PurOrderItemBom;
import com.els.base.purchase.entity.PurOrderItemBomExample;
import com.els.base.purchase.service.PurOrderItemBomService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurOrderItemBomService")
public class PurOrderItemBomServiceImpl
implements PurOrderItemBomService {
    @Resource
    protected PurOrderItemBomMapper purOrderItemBomMapper;

    @CacheEvict(value={"purOrderItemBom"}, allEntries=true)
    public void addObj(PurOrderItemBom t) {
        this.purOrderItemBomMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purOrderItemBom"}, allEntries=true)
    public void addAll(List<PurOrderItemBom> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purOrderItemBomMapper.insertBatch(list);
    }

    @CacheEvict(value={"purOrderItemBom"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purOrderItemBomMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purOrderItemBom"}, allEntries=true)
    public void modifyObj(PurOrderItemBom t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purOrderItemBomMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public PurOrderItemBom queryObjById(String id) {
        return this.purOrderItemBomMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public List<PurOrderItemBom> queryAllObjByExample(PurOrderItemBomExample example) {
        return this.purOrderItemBomMapper.selectByExample(example);
    }

    @Cacheable(value={"purOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public PageView<PurOrderItemBom> queryObjByPage(PurOrderItemBomExample example) {
        PageView<PurOrderItemBom> pageView = example.getPageView();
        pageView.setQueryResult(this.purOrderItemBomMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"purOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public List<PurOrderItemBom> queryObjByOrderId(String purOrderId) {
        if (StringUtils.isBlank((String)purOrderId)) {
            return null;
        }
        PurOrderItemBomExample example = new PurOrderItemBomExample();
        example.createCriteria().andOrderIdEqualTo(purOrderId);
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        return this.purOrderItemBomMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"purOrderItemBom"}, allEntries=true)
    public void deleteByOrderId(String orderId) {
        PurOrderItemBomExample example = new PurOrderItemBomExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        this.purOrderItemBomMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purOrderItemBom"}, allEntries=true)
    public void deleteByExample(PurOrderItemBomExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purOrderItemBomMapper.deleteByExample(example);
    }
}

