/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurchaseOrderChangeMapper;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderChangeExample;
import com.els.base.purchase.service.PurchaseOrderChangeService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseOrderChangeService")
public class PurchaseOrderChangeServiceImpl
implements PurchaseOrderChangeService {
    @Resource
    protected PurchaseOrderChangeMapper purchaseOrderChangeMapper;

    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void addObj(PurchaseOrderChange t) {
        this.purchaseOrderChangeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void addAll(List<PurchaseOrderChange> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseOrderChangeMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderChangeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void modifyObj(PurchaseOrderChange t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseOrderChangeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseOrderChange"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrderChange queryObjById(String id) {
        return this.purchaseOrderChangeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseOrderChange"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrderChange> queryAllObjByExample(PurchaseOrderChangeExample example) {
        return this.purchaseOrderChangeMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseOrderChange"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrderChange> queryObjByPage(PurchaseOrderChangeExample example) {
        PageView<PurchaseOrderChange> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderChangeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void deleteByExample(PurchaseOrderChangeExample example) {
        this.purchaseOrderChangeMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void modifyByExample(PurchaseOrderChange change, PurchaseOrderChangeExample example) {
        if (CollectionUtils.isEmpty(example.getOredCriteria())) {
            throw new CommonException("\u6279\u91cf\u66f4\u65b0\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.purchaseOrderChangeMapper.updateByExampleSelective(change, example);
    }

    @Override
    @Cacheable(value={"purchaseOrderChange"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrderChange> queryByOrderId(String purOrderId) {
        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        example.createCriteria().andOrderIdEqualTo(purOrderId);
        example.setOrderByClause("CREATE_TIME DESC,ORDER_ITEM_NO ASC");
        return this.purchaseOrderChangeMapper.selectByExample(example);
    }
}

