/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.SupplierOrderItemMapper;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.SupplierOrderItemService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="supplierOrderItemService")
public class SupplierOrderItemServiceImpl
implements SupplierOrderItemService {
    @Resource
    protected SupplierOrderItemMapper supplierOrderItemMapper;

    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void addObj(SupplierOrderItem t) {
        this.supplierOrderItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplierOrderItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void modifyObj(SupplierOrderItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setUpdateTime(new Date());
        this.supplierOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public SupplierOrderItem queryObjById(String id) {
        return this.supplierOrderItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<SupplierOrderItem> queryAllObjByExample(SupplierOrderItemExample example) {
        return this.supplierOrderItemMapper.selectByExample(example);
    }

    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrderItem> queryObjByPage(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public int insertHisByOrderId(String orderHisId, String orderId, String cause) {
        return this.supplierOrderItemMapper.insertHisByOrderId(orderHisId, orderId, cause);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrderItem> querySupplierOrderItemByPage(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        List<SupplierOrderItem> items = this.supplierOrderItemMapper.selectSupplierOrderItemByPage(example);
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void modifyByExample(SupplierOrderItem supplierOrderItem, SupplierOrderItemExample supplierOrderItemExample) {
        this.supplierOrderItemMapper.updateByExampleSelective(supplierOrderItem, supplierOrderItemExample);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<SupplierOrderItem> selectForExcel(SupplierOrderExample example) {
        return this.supplierOrderItemMapper.selectForExcel(example);
    }

    @Override
    public List<SupplierOrderItem> selectForExcelByOutstandingOrder(SupplierOrderExample supplierOrderExample) {
        return this.supplierOrderItemMapper.selectForExcelByOutstandingOrder(supplierOrderExample);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrderItem> queryAllHisOrderItemByExample(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        List<SupplierOrderItem> result = this.supplierOrderItemMapper.selectHisByExampleByPage(example);
        pageView.setQueryResult(result);
        return pageView;
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<SupplierOrderItem> queryByOrderIdList(List<String> orderIdList) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.createCriteria().andOrderIdIn((List)orderIdList);
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        return this.supplierOrderItemMapper.selectByExample(example);
    }

    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void deleteByExample(SupplierOrderItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.supplierOrderItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    @Transactional
    public void addAll(List<SupplierOrderItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.supplierOrderItemMapper.insertSelective((SupplierOrderItem)record));
    }
}

