/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.utils.pdf.HtmlToPdfParam;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PurchaseOrderPrintUtils {
    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderPrintUtils.class);

    public static FileData generatePurchaseOrderPdf(PurchaseOrder purchaseOrder, String fontPathStr) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("purchaseOrder", purchaseOrder);
        params.put("fontPathStr", fontPathStr);
        String headerPath = BeetlTemplateUtils.renderFromFile((String)"purchaseOrderHeader.html", params);
        String footerPath = BeetlTemplateUtils.renderFromFile((String)"purchaseOrderFooter.html", params);
        String html = BeetlTemplateUtils.renderFromFile((String)"purchaseOrderContent.html", params);
        logger.info(headerPath);
        logger.info(footerPath);
        logger.info(html);
        String filename = String.format("\u91c7\u8d2d\u5355_%s_%s", "A4", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm"));
        FileData pdfFile = PurchaseOrderPrintUtils.createEmptyPDF(purchaseOrder.getProjectId(), purchaseOrder.getPurCompanyId(), filename);
        HtmlToPdfParam param = new HtmlToPdfParam();
        param.setHeaderHtml(headerPath);
        param.setHeaderSpacing("3");
        param.setFooterHtml(footerPath);
        param.setMarginTop("85mm");
        param.setMarginBottom("70mm");
        param.setTitle(filename);
        param.setPageSize("A4");
        HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (HtmlToPdfParam)param);
        return pdfFile;
    }

    public static FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }
}

