/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.command.order.pur.ViewPurOrderDetailCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.service.PurchaseOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934(\u8ba1\u5212\u5458)"})
@Controller
@RequestMapping(value={"purchaseOrderPlanHeader"})
public class PurchaseOrderPlanHeaderController {
    @Resource
    protected OrderCommandInvoker invoker;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected PurchaseOrderService purchaseOrderHeaderService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934(\u8ba1\u5212\u5458)")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u5546\u7269\u6599\u53f7") @RequestParam(required=false) String materialCode, @ApiParam(value="\u7269\u6599\u54c1\u724c") @RequestParam(required=false) String brand, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper, @ApiParam(value="\u91c7\u8d2d\u8ba1\u5212\u5458id") @RequestParam(required=true) String purPlanerId) {
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            return ResponseResult.success((Object)new PageView());
        }
        ArrayList<Integer> isEnableValues = new ArrayList<Integer>();
        isEnableValues.add(1);
        isEnableValues.add(2);
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.setPageView((PageView<PurchaseOrder>)new PageView(pageNo, pageSize));
        PurchaseOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andIsEnableIn(isEnableValues);
        criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andPurPlanerIdEqualTo(purPlanerId);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" ORDER_DATE ASC , LAST_UPDATE_TIME DESC , CREATE_TIME DESC");
        PageView<PurchaseOrder> pageData = this.purchaseOrderHeaderService.queryObjNoItemsByPage(example, SpringSecurityUtils.getLoginUserId(), materialCode, brand);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5", httpMethod="GET")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseOrder> findById(@RequestParam(required=true) String orderId) {
        if (!CompanyUtils.isPurCompany()) {
            throw new CommonException("\u65e0\u6743\u9650\u67e5\u770b");
        }
        ViewPurOrderDetailCommand cmd = new ViewPurOrderDetailCommand(orderId);
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }
}

