/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.command.WriteBackToErpCommand;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.service.DeliveryOrderWriteBackService;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.plan.command.BatchModifyPlanIsCanDeliveryCmd;
import com.els.base.plan.command.ModifyPlanOnWayQuantityCmd;
import com.els.base.purchase.command.order.ModifyOrderItemOnWayQuantityCmd;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BatchCancelCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<String> deliveryOrderIdList;

    public BatchCancelCommand(List<String> deliveryOrderIdList) {
        this.deliveryOrderIdList = deliveryOrderIdList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Assert.isNotEmpty(this.deliveryOrderIdList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List<DeliveryOrder> deliveryOrderList = this.queryDeliveryOrders(this.deliveryOrderIdList);
        for (DeliveryOrder deliveryOrder : deliveryOrderList) {
            this.cancelDeliveryOrder(deliveryOrder);
        }
        return null;
    }

    private List<DeliveryOrder> queryDeliveryOrders(List<String> deliveryOrderIdList) {
        deliveryOrderIdList = deliveryOrderIdList.stream().distinct().collect(Collectors.toList());
        DeliveryOrderExample deliveryOrderExample = new DeliveryOrderExample();
        deliveryOrderExample.createCriteria().andIdIn((List)deliveryOrderIdList);
        List deliveryOrderList = ContextUtils.getDeliveryOrderService().queryAllObjByExample((IExample)deliveryOrderExample);
        Assert.isNotEmpty((Collection)deliveryOrderList, (String)"\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        if (deliveryOrderIdList.size() != deliveryOrderIdList.size()) {
            throw new CommonException("\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        DeliveryOrderItemExample itemExample = new DeliveryOrderItemExample();
        itemExample.createCriteria().andDeliveryOrderIdIn((List)deliveryOrderIdList);
        List deliveryOrderItemList = ContextUtils.getDeliveryOrderItemService().queryAllObjByExample((IExample)itemExample);
        deliveryOrderList.forEach(deliveryOrder -> {
            List<DeliveryOrderItem> itemsForOrder = deliveryOrderItemList.stream().filter(item -> item.getDeliveryOrderId().equals(deliveryOrder.getId())).collect(Collectors.toList());
            deliveryOrder.setItems(itemsForOrder);
        });
        return deliveryOrderList;
    }

    private void writeBack(List<DeliveryOrder> deliveryOrderList) {
        DeliveryOrderWriteBackService writeBackService = (DeliveryOrderWriteBackService)SpringContextHolder.getOneBean(DeliveryOrderWriteBackService.class);
        if (writeBackService == null) {
            this.logger.warn("\u7cfb\u7edf\u7f3a\u5c11\u56de\u5199\u9001\u8d27\u5355\u7684service\u5b9e\u73b0");
            return;
        }
        for (DeliveryOrder deliveryOrder : deliveryOrderList) {
            this.context.invoke(new WriteBackToErpCommand(deliveryOrder.getId()));
        }
    }

    protected void cancelDeliveryOrder(DeliveryOrder deliveryOrder) {
        this.valid(deliveryOrder);
        this.cancelWholeDeliveryOrder(deliveryOrder);
    }

    private void cancelWholeDeliveryOrder(DeliveryOrder deliveryOrder) {
        List<DeliveryOrderItem> deliveryOrderItems = deliveryOrder.getItems();
        for (int i = 0; CollectionUtils.isNotEmpty(deliveryOrderItems) && i < deliveryOrderItems.size(); ++i) {
            DeliveryOrderItem deliveryOrderItem = deliveryOrderItems.get(i);
            this.context.invoke(new ModifyPlanOnWayQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), DeliveryOperateEnum.DELIVERY_ORDER_CANCEL, deliveryOrderItem.getDeliveryQuantity()));
            this.context.invoke(new ModifyOrderItemOnWayQuantityCmd(deliveryOrderItem.getPurOrderItemId(), DeliveryOperateEnum.DELIVERY_ORDER_CANCEL, deliveryOrderItem.getDeliveryQuantity()));
        }
        List<String> planItemIdList = deliveryOrderItems.stream().map(DeliveryOrderItem::getDeliveryPlanItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        this.context.invoke(new BatchModifyPlanIsCanDeliveryCmd(planItemIdList));
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        DeliveryOrderItem tempItem = new DeliveryOrderItem();
        tempItem.setIsEnable(Constant.NO_INT);
        ContextUtils.getDeliveryOrderItemService().updateDeliveryOrderItem(tempItem, deliveryOrderItemExample);
        deliveryOrder.setIsEnable(Constant.NO_INT);
        ContextUtils.getDeliveryOrderService().modifyAndAddHis(deliveryOrder, "\u4f5c\u5e9f\u53d1\u8d27\u5355");
    }

    private void valid(DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("\u6ca1\u6709\u627e\u5230\u8be5\u53d1\u8d27\u5355", "do_not_exists", new Object[]{"\u53d1\u8d27\u5355"});
        }
        if (deliveryOrder.getDeliveryStatus() == null) {
            throw new CommonException("\u9001\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u9001\u8d27\u5355\u72b6\u6001"});
        }
        if (Constant.NO_INT.equals(deliveryOrder.getIsEnable())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5df2\u7ecf\u4f5c\u5e9f\u4e86\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c");
        }
        if (DeliveryStatusEnum.UN_SENT.getValue().equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u672a\u53d1\u8d27\uff0c\u4e0d\u53ef\u4f5c\u5e9f", "the_customer_has_received_the_goods");
        }
        if (!DeliveryStatusEnum.ONWAY.getValue().equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5ba2\u6237\u5df2\u6536\u8d27\uff0c\u4e0d\u53ef\u4f5c\u5e9f", "the_customer_has_received_the_goods");
        }
    }
}

