/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.plan.command.BatchModifyPlanIsCanDeliveryCmd;
import com.els.base.plan.command.ModifyPlanOnWayQuantityCmd;
import com.els.base.purchase.command.order.ModifyOrderItemOnWayQuantityCmd;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DeleteCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<String> deliveryOrderIdList;

    public DeleteCommand(List<String> deliveryOrderIdList) {
        Assert.isNotEmpty(deliveryOrderIdList, (String)"\u9001\u8d27id\u4e0d\u80fd\u4e3a\u7a7a");
        this.deliveryOrderIdList = deliveryOrderIdList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.createCriteria().andIdIn((List)this.deliveryOrderIdList);
        List deliveryOrderList = ContextUtils.getDeliveryOrderService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)deliveryOrderList)) {
            return null;
        }
        this.validOrder(deliveryOrderList);
        for (DeliveryOrder deliveryOrder : deliveryOrderList) {
            ContextUtils.getDeliveryOrderService().deleteAndAddHis(deliveryOrder.getId(), "\u5220\u9664\u9001\u8d27\u5355");
        }
        DeliveryOrderItemExample itemExample = new DeliveryOrderItemExample();
        itemExample.createCriteria().andDeliveryOrderIdIn((List)this.deliveryOrderIdList);
        List deliveryOrderItemList = ContextUtils.getDeliveryOrderItemService().queryAllObjByExample((IExample)itemExample);
        this.deleteDeliveryItem(deliveryOrderItemList, "\u5220\u9664\u53d1\u8d27\u5355_\u5220\u9664\u53d1\u8d27\u5355\u884c");
        return null;
    }

    private void validOrder(List<DeliveryOrder> deliveryOrderList) {
        for (DeliveryOrder deliveryOrder : deliveryOrderList) {
            if (DeliveryStatusEnum.UN_SENT.getValue().equals(deliveryOrder.getDeliveryStatus())) continue;
            throw new CommonException(String.format("\u8ba2\u5355 [%s]\u5df2\u7ecf\u53d1\u8d27\uff0c\u4e0d\u80fd\u5220\u9664", deliveryOrder.getDeliveryOrderNo()));
        }
    }

    private void deleteDeliveryItem(List<DeliveryOrderItem> itemList, String remark) {
        for (DeliveryOrderItem deliveryOrderItem : itemList) {
            this.context.invoke(new ModifyPlanOnWayQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), DeliveryOperateEnum.DELIVERY_ORDER_DELETE, deliveryOrderItem.getDeliveryQuantity()));
            this.context.invoke(new ModifyOrderItemOnWayQuantityCmd(deliveryOrderItem.getPurOrderItemId(), DeliveryOperateEnum.DELIVERY_ORDER_DELETE, deliveryOrderItem.getDeliveryQuantity()));
            String hisItemId = UUIDGenerator.generateUUID();
            ContextUtils.getDeliveryOrderItemService().insertHis(hisItemId, deliveryOrderItem.getId(), "\u5220\u9664\u53d1\u8d27\u5355\u5934_\u5220\u9664\u53d1\u8d27\u5355\u884c", new Date());
        }
        List<String> planItemIdList = itemList.stream().map(DeliveryOrderItem::getDeliveryPlanItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        this.context.invoke(new BatchModifyPlanIsCanDeliveryCmd(planItemIdList));
        DeliveryOrderItemExample exampleItem = new DeliveryOrderItemExample();
        DeliveryOrderItemExample.Criteria criteriaItem = exampleItem.createCriteria();
        criteriaItem.andDeliveryOrderIdIn((List)this.deliveryOrderIdList);
        ContextUtils.getDeliveryOrderItemService().deleteByExample(exampleItem);
    }
}

