/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.utils;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.ChangeReasonEnum;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;

public class DeliveryPlanUtils {
    public static boolean isEqualBewteenPurAndSup(List<PurDeliveryPlanItem> purPlanList, List<SupDeliveryPlanItem> supPlanList) {
        if (purPlanList.size() != supPlanList.size()) {
            return false;
        }
        boolean isAllSupCanFindInPur = supPlanList.stream().allMatch(supPlanItem -> DeliveryPlanUtils.findPurPlan(supPlanItem, purPlanList) != null);
        return isAllSupCanFindInPur && purPlanList.stream().allMatch(purPlanItem -> DeliveryPlanUtils.findSupPlan(purPlanItem, supPlanList) != null);
    }

    public static boolean isEqualBewteenPurAndSupIgnoreReason(List<PurDeliveryPlanItem> purPlanList, List<SupDeliveryPlanItem> supPlanList) {
        if (purPlanList.size() != supPlanList.size()) {
            return false;
        }
        boolean isAllCanFind = supPlanList.stream().allMatch(supPlanItem -> DeliveryPlanUtils.findPurPlanIgnoreReason(supPlanItem, purPlanList) != null);
        return isAllCanFind && purPlanList.stream().allMatch(purPlanItem -> DeliveryPlanUtils.findSupPlanIgnoreReason(purPlanItem, supPlanList) != null);
    }

    public static SupDeliveryPlanItem findSupPlanIgnoreReason(PurDeliveryPlanItem purPlanItem, List<SupDeliveryPlanItem> supPlanList) {
        String date = DateFormatUtils.format((Date)purPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd");
        return supPlanList.stream().filter(purPlanIte -> {
            boolean isEqual = DateFormatUtils.format((Date)purPlanIte.getDeliveryDate(), (String)"yyyy-MM-dd").equals(date) && purPlanIte.getDeliveryQuantity().compareTo(purPlanItem.getDeliveryQuantity()) == 0 && purPlanIte.getPurOrderNo().equals(purPlanItem.getPurOrderNo()) && purPlanIte.getPurOrderItemNo().equals(purPlanItem.getPurOrderItemNo());
            return isEqual;
        }).findAny().orElseGet(() -> null);
    }

    public static SupDeliveryPlanItem findSupPlan(PurDeliveryPlanItem purPlanItem, List<SupDeliveryPlanItem> supPlanList) {
        SupDeliveryPlanItem supPlanItem = DeliveryPlanUtils.findSupPlanIgnoreReason(purPlanItem, supPlanList);
        if (supPlanItem == null) {
            return null;
        }
        if (supPlanItem.getChangeReason() == null && purPlanItem.getChangeReason() != null) {
            return null;
        }
        if (supPlanItem.getChangeReason() != null && purPlanItem.getChangeReason() == null) {
            return null;
        }
        if (supPlanItem.getChangeReason() != null && purPlanItem.getChangeReason() != null && !supPlanItem.getChangeReason().equals(purPlanItem.getChangeReason())) {
            return null;
        }
        return supPlanItem;
    }

    public static PurDeliveryPlanItem findPurPlanIgnoreReason(SupDeliveryPlanItem supPlanItem, List<PurDeliveryPlanItem> purPlanList) {
        Assert.isNotNull((Object)supPlanItem.getDeliveryDate(), (String)"\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        String date = DateFormatUtils.format((Date)supPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd");
        return purPlanList.stream().filter(purPlanIte -> {
            boolean isEqual = DateFormatUtils.format((Date)purPlanIte.getDeliveryDate(), (String)"yyyy-MM-dd").equals(date) && purPlanIte.getDeliveryQuantity().compareTo(supPlanItem.getDeliveryQuantity()) == 0 && purPlanIte.getPurOrderNo().equals(supPlanItem.getPurOrderNo()) && purPlanIte.getPurOrderItemNo().equals(supPlanItem.getPurOrderItemNo());
            return isEqual;
        }).findAny().orElseGet(() -> null);
    }

    public static PurDeliveryPlanItem findPurPlan(SupDeliveryPlanItem supPlanItem, List<PurDeliveryPlanItem> purPlanList) {
        PurDeliveryPlanItem purPlanItem = DeliveryPlanUtils.findPurPlanIgnoreReason(supPlanItem, purPlanList);
        if (purPlanItem == null) {
            return null;
        }
        if (purPlanItem.getChangeReason() == null && supPlanItem.getChangeReason() != null) {
            return null;
        }
        if (purPlanItem.getChangeReason() != null && supPlanItem.getChangeReason() == null) {
            return null;
        }
        if (purPlanItem.getChangeReason() != null && supPlanItem.getChangeReason() != null && !purPlanItem.getChangeReason().equals(supPlanItem.getChangeReason())) {
            return null;
        }
        return purPlanItem;
    }

    public static boolean isEqual(List<PurDeliveryPlanItem> sourcePlanItem, List<PurDeliveryPlanItem> targetPlanItem) {
        if (sourcePlanItem.size() != targetPlanItem.size()) {
            return false;
        }
        return targetPlanItem.stream().allMatch(supPlanItem -> sourcePlanItem.stream().anyMatch(purPlanIte -> DeliveryPlanUtils.isEqual(supPlanItem, purPlanIte)));
    }

    public static boolean isEqual(PurDeliveryPlanItem source, PurDeliveryPlanItem target) {
        String supDate = DateFormatUtils.format((Date)source.getDeliveryDate(), (String)"yyyy-MM-dd");
        String purDate = DateFormatUtils.format((Date)target.getDeliveryDate(), (String)"yyyy-MM-dd");
        return purDate.equals(supDate) && target.getDeliveryQuantity().compareTo(source.getDeliveryQuantity()) == 0 && target.getMaterialNo().equals(source.getMaterialNo()) && target.getPurOrderNo().equals(source.getPurOrderNo()) && target.getPurOrderItemNo().equals(source.getPurOrderItemNo());
    }

    public static boolean isEqual(SupDeliveryPlanItem source, SupDeliveryPlanItem target) {
        String supDate = DateFormatUtils.format((Date)source.getDeliveryDate(), (String)"yyyy-MM-dd");
        String purDate = DateFormatUtils.format((Date)target.getDeliveryDate(), (String)"yyyy-MM-dd");
        return purDate.equals(supDate) && target.getDeliveryQuantity().compareTo(source.getDeliveryQuantity()) == 0 && target.getMaterialNo().equals(source.getMaterialNo()) && target.getPurOrderNo().equals(source.getPurOrderNo()) && target.getPurOrderItemNo().equals(source.getPurOrderItemNo());
    }

    public static PurDeliveryPlanItem buildPlanItem(PurchaseOrderItem orderItem, PurchaseOrder order) {
        PurDeliveryPlanItem planItem = new PurDeliveryPlanItem();
        BeanUtils.copyProperties((Object)orderItem, (Object)planItem);
        planItem.setFactoryName(orderItem.getDeliveryLocation());
        planItem.setPurOrderId(orderItem.getOrderId());
        planItem.setPurOrderNo(orderItem.getOrderNo());
        planItem.setPurOrderItemId(orderItem.getId());
        planItem.setPurOrderItemNo(orderItem.getOrderItemNo());
        planItem.setMaterialId(orderItem.getMaterialId());
        planItem.setMaterialNo(orderItem.getMaterialCode());
        planItem.setMaterialDesc(orderItem.getMaterialName());
        planItem.setWarehouseName(orderItem.getWarehouseName());
        planItem.setIsEnable(Constant.YES_INT);
        planItem.setSendStatus("N");
        planItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        planItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        planItem.setChangeStatus(PlanChangeStatusEnum.PUR_CHANGE.getValue());
        planItem.setChangeReason(ChangeReasonEnum.PUR.getValue());
        planItem.setUsedStatus(DeliveryPlanUesdStatusEnum.UN_USED.getValue());
        planItem.setPurOrderStatus(order.getOrderStatus());
        planItem.setPurPlanerId(orderItem.getPurPlanerId());
        planItem.setPurUserId(orderItem.getPurUserId());
        planItem.setPurUserName(order.getPurUserName());
        planItem.setConfirmDeliveryDate(orderItem.getDeliveredDate());
        planItem.setOrderDeliveryDate(orderItem.getDeliveredDate());
        planItem.setDeliveryDate(orderItem.getDeliveredDate());
        planItem.setIsCanDelivery(Constant.YES_INT);
        planItem.setOnwayQuantity(BigDecimal.ZERO);
        planItem.setReceivedQuantity(BigDecimal.ZERO);
        planItem.setDeliveryQuantity(orderItem.getCanDeliveryQuantity());
        planItem.setId(null);
        return planItem;
    }

    private DeliveryPlanUtils() {
    }
}

