/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.product.command.PurchaseUserOrderAddCmd;
import com.els.base.product.entity.PurchaseUserOrder;
import com.els.base.product.entity.PurchaseUserOrderExample;
import com.els.base.product.entity.PurchaseUserOrderItemExample;
import com.els.base.product.service.PurchaseUserOrderItemService;
import com.els.base.product.service.PurchaseUserOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8ba2\u5355\u8868"})
@Controller
@RequestMapping(value={"purchaseUserOrder"})
public class PurchaseUserOrderController {
    @Resource
    protected PurchaseUserOrderService purchaseUserOrderService;
    @Resource
    protected PurchaseUserOrderItemService purchaseUserOrderItemService;
    @Resource
    protected ICommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba2\u5355\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseUserOrder purchaseUserOrder) {
        purchaseUserOrder.setSupCompanyId(CompanyUtils.currentCompanyId());
        purchaseUserOrder.setSupCompanyCode(CompanyUtils.currentCompany().getCompanyCode());
        purchaseUserOrder.setSupCompanyName(CompanyUtils.currentCompany().getCompanyFullName());
        purchaseUserOrder.setCreateTime(new Date());
        purchaseUserOrder.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseUserOrder.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        purchaseUserOrder.setCreateUserNickname(SpringSecurityUtils.getLoginUser().getNickName());
        PurchaseUserOrderAddCmd cmd = new PurchaseUserOrderAddCmd(purchaseUserOrder);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success((Object)purchaseUserOrder.getId());
    }

    @ApiOperation(httpMethod="GET", value="\u8ba2\u5355\u8868\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseUserOrder> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseUserOrder purchaseUserOrder = (PurchaseUserOrder)this.purchaseUserOrderService.queryObjById(id);
        PurchaseUserOrderItemExample e = new PurchaseUserOrderItemExample();
        e.createCriteria().andOrderIdEqualTo(id);
        List purchaseUserOrderItems = this.purchaseUserOrderItemService.queryAllObjByExample((IExample)e);
        purchaseUserOrder.setPurchaseUserOrderItemList(purchaseUserOrderItems);
        return ResponseResult.success((Object)purchaseUserOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u7ba1\u7406\u5458\u67e5\u8be2\u5168\u90e8\u5206\u9875\u8ba2\u5355\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserOrder>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseUserOrderExample example = new PurchaseUserOrderExample();
        example.setPageView((PageView<PurchaseUserOrder>)new PageView(pageNo, pageSize));
        PurchaseUserOrderExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseUserOrderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7528\u6237\u67e5\u8be2\u81ea\u5df1\u7684\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/user/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserOrder>> findByPageForUser(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseUserOrderExample example = new PurchaseUserOrderExample();
        example.setPageView((PageView<PurchaseUserOrder>)new PageView(pageNo, pageSize));
        PurchaseUserOrderExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andCreateUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        PageView pageData = this.purchaseUserOrderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

