/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class BatchConfirmOrRefuseOrderItemCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<SupplierOrderItem> supplierOrderItemList;

    public BatchConfirmOrRefuseOrderItemCommand(List<SupplierOrderItem> orderItemList) {
        this.supplierOrderItemList = orderItemList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.supplierOrderItemList);
        Map<String, List<SupplierOrderItem>> orderIdAndItemMap = this.supplierOrderItemList.stream().collect(Collectors.groupingBy(SupplierOrderItem::getOrderId));
        orderIdAndItemMap.keySet().forEach(orderId -> {
            List itemList = (List)orderIdAndItemMap.get(orderId);
            this.confirmOrRefuseOrderItem(itemList);
        });
        return null;
    }

    private void confirmOrRefuseOrderItem(List<SupplierOrderItem> itemList) {
    }

    private void valid(List<SupplierOrderItem> supplierOrderItemList) {
        Assert.isNotEmpty(supplierOrderItemList, (String)"\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List itemIdList = supplierOrderItemList.stream().map(SupplierOrderItem::getId).collect(Collectors.toList());
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.createCriteria().andIdIn(itemIdList).andOrderStatusNotEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        List confirmOrRefuseItemList = ContextUtils.getSupplierOrderItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)confirmOrRefuseItemList)) {
            SupplierOrderItem item = (SupplierOrderItem)confirmOrRefuseItemList.get(0);
            throw new CommonException(String.format("\u8ba2\u5355\u884c[%s] [%s] \u5df2\u7ecf\u786e\u8ba4\u6216\u62d2\u7edd\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", item.getOrderNo(), item.getOrderItemNo()));
        }
    }
}

