
-- ----------------------------
-- 商品管理
-- ----------------------------
-- DROP TABLE "T_PURCHASE_PRODUCT";
CREATE TABLE "T_PURCHASE_PRODUCT" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PRODUCT_NAME" VARCHAR2(1000 BYTE) ,
  "PRODUCT_CODE" VARCHAR2(255 BYTE) ,
  "PRODUCT_SUMMARY" VARCHAR2(1000 BYTE) ,
  "PRODUCT_IMAGE" VARCHAR2(255 BYTE) ,
  "PRODUCT_ORDER" NUMBER(7) ,
  "PRODUCT_PRICE" NUMBER(12,2) ,
  "PRODUCT_ORIGIN_PRICE" NUMBER(12,2) ,
  "PUTWAY_STATUS" NUMBER(7) ,
  "PRODUCT_CATEGORY_CODE" VARCHAR2(255 BYTE) ,
  "PRODUCT_CATEGORY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_CODE" VARCHAR2(255 BYTE) ,
  "REASON" VARCHAR2(255 BYTE) ,
  "CREATE_USER_ID" VARCHAR2(32 BYTE) ,
  "CREATE_USER_NAME" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "UPDATE_USER_ID" VARCHAR2(32 BYTE) ,
  "UPDATE_USER_NAME" VARCHAR2(255 BYTE) ,
  "UPDATE_TIME" DATE ,
  "SUP_REMARK" VARCHAR2(255 BYTE) ,
  "PUR_REMARK" VARCHAR2(255 BYTE) ,
  "APPROVE_STATUS" NUMBER(7) ,
  "APPROVE_CODE" VARCHAR2(255 BYTE) ,
  "PRODUCT_DESC" CLOB ,
  "PUBLIC_STATUS" NUMBER(7) ,
  "META_DESCRIPTION" VARCHAR2(255 BYTE) ,
  "META_KEYWORDS" VARCHAR2(255 BYTE) ,
  "PRODUCT_FLAG" VARCHAR2(255 BYTE) ,
  "PRODUCT_ORIGIN" VARCHAR2(255 BYTE) ,
  "PRODUCT_STOCK" NUMBER(18,2) ,
  "PUTWAY_TIME" DATE ,
  "PUBLIC_TIME" DATE ,
  "REAL_SALES_COUNT" VARCHAR2(255 BYTE) ,
  "SALES_COUNT" VARCHAR2(255 BYTE) ,
  "REAL_VIEW_COUNT" VARCHAR2(255 BYTE) ,
  "VIEW_COUNT" VARCHAR2(255 BYTE) ,
  "COMMENT_TIME" DATE ,
  "COMMENT_COUNT" VARCHAR2(255 BYTE) ,
  "COMMENT_STATUS" NUMBER(7) ,
  "MATERIAL_SPECIFICATION" VARCHAR2(255 BYTE) ,
  "WEIGHT" NUMBER ,
  "BASIC_UNIT" VARCHAR2(255 BYTE) ,
  "BRAND_NAME" VARCHAR2(255 BYTE) ,
  "MATERIAL_COLOUR" VARCHAR2(255 BYTE) 
);

COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."ID" IS 'ID';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_NAME" IS '商品名称';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_CODE" IS '商品编码';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_SUMMARY" IS '商品概要';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_IMAGE" IS '商品缩略图';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_ORDER" IS '商品排序';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_PRICE" IS '商品价格(含税单价)';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_ORIGIN_PRICE" IS '商品原来价格';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PUTWAY_STATUS" IS '商品上架状态';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_CATEGORY_CODE" IS '商品分类编码';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_CATEGORY_NAME" IS '商品分类名称';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."SUP_COMPANY_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."REASON" IS '拒绝原因';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."CREATE_USER_ID" IS '创建人ID';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."UPDATE_USER_ID" IS '更新人ID';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."UPDATE_USER_NAME" IS '更新人名称';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PUR_REMARK" IS '采购方备注';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."APPROVE_STATUS" IS '审批状态';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."APPROVE_CODE" IS '审批编码';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_DESC" IS '商品详细描述';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PUBLIC_STATUS" IS '供应商发布状态(0未发布，1已发布)';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."META_DESCRIPTION" IS 'SEO描述信息';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."META_KEYWORDS" IS 'SEO关键字';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_FLAG" IS '特殊标识符';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_ORIGIN" IS '商品来源(1供应商，2京东，3齐心，4苏宁)';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PRODUCT_STOCK" IS '商品库存';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PUTWAY_TIME" IS '上架时间';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."PUBLIC_TIME" IS '发布时间';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."REAL_SALES_COUNT" IS '真实的销售量';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."SALES_COUNT" IS '销售量';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."REAL_VIEW_COUNT" IS '真实访问量';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."VIEW_COUNT" IS '访问量';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."COMMENT_TIME" IS '最后评论时间';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."COMMENT_COUNT" IS '评论总数';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."COMMENT_STATUS" IS '评论状态，默认允许评论(0不允许，1允许)';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."MATERIAL_SPECIFICATION" IS '规格';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."WEIGHT" IS '重量';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."BASIC_UNIT" IS '单位';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."BRAND_NAME" IS '品牌';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT"."MATERIAL_COLOUR" IS '颜色';
COMMENT ON TABLE "T_PURCHASE_PRODUCT" IS '商品管理';


-- ----------------------------
-- 产品组图
-- ----------------------------
-- DROP TABLE "T_PURCHASE_PRODUCT_IMAGE";
CREATE TABLE "T_PURCHASE_PRODUCT_IMAGE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PRODUCT_ID" VARCHAR2(32 BYTE) ,
  "IMAGE_SRC" VARCHAR2(255 BYTE) ,
  "ORDER_NUMBER" NUMBER(7) ,
  "CREATE_TIME" DATE ,
  "IMAGE_NAME" VARCHAR2(255 BYTE) 
);

COMMENT ON COLUMN "T_PURCHASE_PRODUCT_IMAGE"."ID" IS 'ID';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT_IMAGE"."PRODUCT_ID" IS '产品ID';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT_IMAGE"."IMAGE_SRC" IS '文件路径';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT_IMAGE"."ORDER_NUMBER" IS '排序';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT_IMAGE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_PURCHASE_PRODUCT_IMAGE"."IMAGE_NAME" IS '附件名字';
COMMENT ON TABLE "T_PURCHASE_PRODUCT_IMAGE" IS '产品组图';

-- ----------------------------
-- 购物车
-- ----------------------------
-- DROP TABLE "T_PURCHASE_USER_CART";
CREATE TABLE "T_PURCHASE_USER_CART" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "CREATE_USER_ID" VARCHAR2(32 BYTE) ,
  "PRODUCT_NAME" VARCHAR2(255 BYTE) ,
  "PRODUCT_IMAGE" VARCHAR2(255 BYTE) ,
  "PRODUCT_ORDER" VARCHAR2(255 BYTE) ,
  "PRODUCT_PRICE" NUMBER(18,2) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "CREATE_USER_NAME" VARCHAR2(255 BYTE) ,
  "UPDATE_USER_ID" VARCHAR2(32 BYTE) ,
  "UPDATE_USER_NAME" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "PRODUCT_TYPE" VARCHAR2(255 BYTE) ,
  "PRODUCT_TYPE_TEXT" VARCHAR2(255 BYTE) ,
  "PRODUCT_ID" VARCHAR2(32 BYTE) ,
  "PRODUCT_LINK" VARCHAR2(255 BYTE) ,
  "PRODUCT_COUNT" NUMBER(18,2) ,
  "WITH_VIRTUAL" NUMBER(7) ,
  "WITH_REFUND" NUMBER(7) ,
  "MATERIAL_SPECIFICATION" VARCHAR2(255 BYTE) ,
  "WEIGHT" NUMBER ,
  "BASIC_UNIT" VARCHAR2(255 BYTE) ,
  "BRAND_NAME" VARCHAR2(255 BYTE) ,
  "MATERIAL_COLOUR" VARCHAR2(255 BYTE) 
);

COMMENT ON COLUMN "T_PURCHASE_USER_CART"."ID" IS 'ID';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."CREATE_USER_ID" IS '用户ID';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_NAME" IS '商品名称';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_IMAGE" IS '商品缩略图';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_ORDER" IS '商品排序';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_PRICE" IS '商品价格(含税单价)';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."UPDATE_USER_ID" IS '更新人ID';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."UPDATE_USER_NAME" IS '更新人';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_TYPE" IS '商品的类别';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_TYPE_TEXT" IS '商品的类别描述';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_ID" IS '产品ID';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_LINK" IS '产品详情链接';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."PRODUCT_COUNT" IS '购买的数量';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."WITH_VIRTUAL" IS '是否是虚拟产品';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."WITH_REFUND" IS '是否支持退款，1支持，0不支持。';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."MATERIAL_SPECIFICATION" IS '规格';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."WEIGHT" IS '重量';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."BASIC_UNIT" IS '单位';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."BRAND_NAME" IS '品牌';
COMMENT ON COLUMN "T_PURCHASE_USER_CART"."MATERIAL_COLOUR" IS '颜色';
COMMENT ON TABLE "T_PURCHASE_USER_CART" IS '购物车';

-- ----------------------------
-- 订单表
-- ----------------------------
-- DROP TABLE "T_PURCHASE_USER_ORDER";
CREATE TABLE "T_PURCHASE_USER_ORDER" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "ORDER_NO" VARCHAR2(32 BYTE) ,
  "PRODUCT_TYPE" VARCHAR2(255 BYTE) ,
  "PRODUCT_NAME" VARCHAR2(255 BYTE) ,
  "PRODUCT_SUMMARY" VARCHAR2(255 BYTE) ,
  "CREATE_USER_ID" VARCHAR2(32 BYTE) ,
  "CREATE_USER_NAME" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "CREATE_USER_NICKNAME" VARCHAR2(255 BYTE) ,
  "BUYER_MSG" VARCHAR2(255 BYTE) ,
  "ORDER_TOTAL_AMOUNT" NUMBER(18,2) ,
  "ORDER_REAL_AMOUNT" NUMBER(18,2) ,
  "COUPON_CODE" VARCHAR2(255 BYTE) ,
  "COUPON_AMOUNT" NUMBER(18,2) ,
  "PAY_STATUS" NUMBER(7) ,
  "PAY_SUCCESS_AMOUNT" NUMBER(18,2) ,
  "PAY_SUCCESS_TIME" DATE ,
  "PAY_SUCCESS_PROOF" VARCHAR2(255 BYTE) ,
  "PAY_SUCCESS_REMARKS" VARCHAR2(255 BYTE) ,
  "PAYMENT_ID" VARCHAR2(32 BYTE) ,
  "PAYMENT_OUTER_ID" VARCHAR2(255 BYTE) ,
  "PAYMENT_OUTER_USER" VARCHAR2(255 BYTE) ,
  "DELIVERY_ID" VARCHAR2(32 BYTE) ,
  "DELIVERY_TYPE" VARCHAR2(255 BYTE) ,
  "DELIVERY_STATUS" VARCHAR2(255 BYTE) ,
  "DELIVERY_ADDR_USERNAME" VARCHAR2(255 BYTE) ,
  "DELIVERY_ADDR_MOBILE" VARCHAR2(255 BYTE) ,
  "DELIVERY_ADDR_PROVINCE" VARCHAR2(255 BYTE) ,
  "DELIVERY_ADDR_CITY" VARCHAR2(255 BYTE) ,
  "DELIVERY_ADDR_DISTRICT" VARCHAR2(255 BYTE) ,
  "DELIVERY_ADDR_DETAIL" VARCHAR2(255 BYTE) ,
  "DELIVERY_ADDR_ZIPCODE" VARCHAR2(255 BYTE) ,
  "INVOICE_ID" VARCHAR2(32 BYTE) ,
  "INVOICE_STATUS" VARCHAR2(255 BYTE) ,
  "REMARKS" VARCHAR2(255 BYTE) ,
  "TRADE_STATUS" VARCHAR2(255 BYTE) ,
  "UPDATE_TIME" DATE ,
  "PRODUCT_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_CODE" VARCHAR2(255 BYTE) 
);

COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."ID" IS 'ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."ORDER_NO" IS '订单号';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PRODUCT_TYPE" IS '产品类型';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PRODUCT_NAME" IS '产品标题';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PRODUCT_SUMMARY" IS '产品概述';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."CREATE_USER_ID" IS '创建人ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."CREATE_TIME" IS '创建日期';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."CREATE_USER_NICKNAME" IS '创建人昵称';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."BUYER_MSG" IS '购买者留言';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."ORDER_TOTAL_AMOUNT" IS '订单总金额，购买人员应该付款的金额';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."ORDER_REAL_AMOUNT" IS '订单的真实金额';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."COUPON_CODE" IS '优惠码';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."COUPON_AMOUNT" IS '优惠金额';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAY_STATUS" IS '支付状态,支付状态：1未付款、 2用户标识已经线下付款完成、3用户标识已经通过微信或者支付宝等工具支付完成 、9已经付款（线上支付）、10已经下线支付、11已经通过微信或支付宝等工具支付';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAY_SUCCESS_AMOUNT" IS '支付成功的金额';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAY_SUCCESS_TIME" IS '支付时间';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAY_SUCCESS_PROOF" IS '支付证明';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAY_SUCCESS_REMARKS" IS '备注';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAYMENT_ID" IS '支付记录ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAYMENT_OUTER_ID" IS '第三方订单号';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PAYMENT_OUTER_USER" IS '第三方支付用户，一般情况下是用户的OPENID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ID" IS '发货情况';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_TYPE" IS '发货类型';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_STATUS" IS '发货状态';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ADDR_USERNAME" IS '收货人地址';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ADDR_MOBILE" IS '收货人手机号（电话）';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ADDR_PROVINCE" IS '收件人省';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ADDR_CITY" IS '收件人的城市';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ADDR_DISTRICT" IS '收件人的区（县）';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ADDR_DETAIL" IS '收件人的详细地址';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."DELIVERY_ADDR_ZIPCODE" IS '收件人地址邮政编码';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."INVOICE_ID" IS '发票';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."INVOICE_STATUS" IS '发票开具状态：1 未申请发票、 2 发票申请中、 3 发票开具中、 8 无需开具发票、 9发票已经开具';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."REMARKS" IS '备注';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."TRADE_STATUS" IS '交易状态：1交易中、 2交易完成（但是可以申请退款） 、3取消交易 、4申请退款、 5拒绝退款、 6退款中、 7退款完成、 9交易结束';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."PRODUCT_ID" IS '产品ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER"."SUP_COMPANY_CODE" IS '供应商编码';
COMMENT ON TABLE "T_PURCHASE_USER_ORDER" IS '订单表';

-- ----------------------------
-- 订单行
-- ----------------------------
-- DROP TABLE "T_PURCHASE_USER_ORDER_ITEM";
CREATE TABLE "T_PURCHASE_USER_ORDER_ITEM" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "ORDER_ID" VARCHAR2(32 BYTE) ,
  "ORDER_NO" VARCHAR2(32 BYTE) ,
  "CREATE_USER_ID" VARCHAR2(32 BYTE) ,
  "CREATE_USER_NAME" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "CREATE_USER_NICKNAME" VARCHAR2(255 BYTE) ,
  "BUYER_MSG" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_CODE" VARCHAR2(255 BYTE) ,
  "PRODUCT_NAME" VARCHAR2(1000 BYTE) ,
  "PRODUCT_CODE" VARCHAR2(255 BYTE) ,
  "PRODUCT_SUMMARY" VARCHAR2(1000 BYTE) ,
  "PRODUCT_IMAGE" VARCHAR2(255 BYTE) ,
  "PRODUCT_PRICE" NUMBER(18,2) ,
  "PRODUCT_ID" VARCHAR2(32 BYTE) ,
  "MATERIAL_SPECIFICATION" VARCHAR2(255 BYTE) ,
  "WEIGHT" NUMBER ,
  "BASIC_UNIT" VARCHAR2(255 BYTE) ,
  "BRAND_NAME" VARCHAR2(255 BYTE) ,
  "MATERIAL_COLOUR" VARCHAR2(255 BYTE) ,
  "UPDATE_TIME" DATE ,
  "PRODUCT_COUNT" NUMBER(18,2) 
);

COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."ID" IS 'ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."ORDER_ID" IS '订单ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."ORDER_NO" IS '订单号';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."CREATE_USER_ID" IS '创建人ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."CREATE_USER_NICKNAME" IS '购买人昵称';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."BUYER_MSG" IS '用户留言（备注）';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."SUP_COMPANY_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."PRODUCT_NAME" IS '商品名称';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."PRODUCT_CODE" IS '商品编码';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."PRODUCT_SUMMARY" IS '商品概要';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."PRODUCT_IMAGE" IS '商品缩略图';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."PRODUCT_PRICE" IS '商品价格(含税单价)';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."PRODUCT_ID" IS '产品ID';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."MATERIAL_SPECIFICATION" IS '规格';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."WEIGHT" IS '重量';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."BASIC_UNIT" IS '单位';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."BRAND_NAME" IS '品牌';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."MATERIAL_COLOUR" IS '颜色';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_PURCHASE_USER_ORDER_ITEM"."PRODUCT_COUNT" IS '购买数量';
COMMENT ON TABLE "T_PURCHASE_USER_ORDER_ITEM" IS '订单行';

-- ----------------------------
-- Primary Key structure for table T_PURCHASE_PRODUCT
-- ----------------------------
ALTER TABLE "T_PURCHASE_PRODUCT" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_PURCHASE_PRODUCT_IMAGE
-- ----------------------------
ALTER TABLE "T_PURCHASE_PRODUCT_IMAGE" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_PURCHASE_USER_CART
-- ----------------------------
ALTER TABLE "T_PURCHASE_USER_CART" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_PURCHASE_USER_ORDER
-- ----------------------------
ALTER TABLE "T_PURCHASE_USER_ORDER" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_PURCHASE_USER_ORDER_ITEM
-- ----------------------------
ALTER TABLE "T_PURCHASE_USER_ORDER_ITEM" ADD  PRIMARY KEY ("ID");

