package com.els.base.command;

import com.els.base.orderchange.service.PurchaseOrderChangeService;
import com.els.base.purchase.service.PurchaseOrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Component
public class PurchaseInvorker {
    private static Logger logger = LoggerFactory.getLogger(PurchaseInvorker.class);

    @Resource
    private PurchaseOrderChangeService purchaseOrderChangeService;
    @Resource
    private PurchaseOrderService purchaseOrderService;

    @Transactional
    public <Result> Result invoke(AbstractPurchaseCommand<Result> command) {
        logger.debug("执行命令[{}]", command.getClass().getName());

        // 此处可添加执行前的统一操作
        // 例如身份认证
        command.setPurchaseInvorker(this);

        Result result = command.execute(this);

        // TODO 此处可添加执行后的操作
        // 例如消息发送
        return result;
    }

    public PurchaseOrderChangeService getPurchaseOrderChangeService() {
        return purchaseOrderChangeService;
    }

    public void setPurchaseOrderChangeService(PurchaseOrderChangeService purchaseOrderChangeService) {
        this.purchaseOrderChangeService = purchaseOrderChangeService;
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }
}
