package com.els.base.delivery.dao;

import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;

import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface DeliveryOrderMapper {
    int countByExample(DeliveryOrderExample example);

    int deleteByExample(DeliveryOrderExample example);

    int deleteByPrimaryKey(String id);

    int insert(DeliveryOrder record);

    int insertSelective(DeliveryOrder record);

    List<DeliveryOrder> selectByExample(DeliveryOrderExample example);

    DeliveryOrder selectByPrimaryKey(String id);

    int updateByExampleSelective(@Param("record") DeliveryOrder record, @Param("example") DeliveryOrderExample example);

    int updateByExample(@Param("record") DeliveryOrder record, @Param("example") DeliveryOrderExample example);

    int updateByPrimaryKeySelective(DeliveryOrder record);

    int updateByPrimaryKey(DeliveryOrder record);

    void insertBatch(List<DeliveryOrder> list);

    List<DeliveryOrder> selectByExampleByPage(DeliveryOrderExample example);


    //############非自动生成开始，请勿覆盖#############

    /**
     * 获取最大的发货单号
     *
     * @return
     */
    String getMaxDeliveryOrderNo();

    /**
     * 根据订单id号，保存当前数据到历史记录表
     *
     * @param id
     * @param cause
     * @param causeTime
     * @return
     */
    int insertHis(@Param("hisId") String hisId, @Param("deliveryOrderId") String deliveryOrderId,
                  @Param("cause") String cause,@Param("operateTime") Date operateTime);

    /**
     * 根据查询条件，查询历史纪录
     *
     * @param example
     * @return
     */
    List<DeliveryOrder> selectHisByExampleByPage(DeliveryOrderExample example);
    /**
     * 根据查询条件，查询送货单区间查询
     *
     * @param example
     * @return
     */
	List<DeliveryOrder> queryAllExpectArriveTime(@Param("timeStart")String timeStart, @Param("timeEnd")String timeEnd);


    //####################非自动生成结束，请勿覆盖#######################


}