package com.els.base.delivery.dao.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.utils.SpringContextHolder;

public class DeliveryOrderItemTypeHandler implements TypeHandler<List<DeliveryOrderItem>> {

	@Override	
	public void setParameter(PreparedStatement ps, int i, List<DeliveryOrderItem> parameter, JdbcType jdbcType)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public List<DeliveryOrderItem> getResult(ResultSet rs, String columnName) throws SQLException {
		DeliveryOrderItemService purchaseOrderItemService = SpringContextHolder.getOneBean(DeliveryOrderItemService.class);
		String doId = rs.getString(columnName);

		DeliveryOrderItemExample example = new DeliveryOrderItemExample();
		example.createCriteria().andDeliveryOrderIdEqualTo(doId);

		return purchaseOrderItemService.queryAllObjByExample(example);
	}

	@Override
	public List<DeliveryOrderItem> getResult(ResultSet rs, int columnIndex) throws SQLException {
		DeliveryOrderItemService purchaseOrderItemService = SpringContextHolder.getOneBean(DeliveryOrderItemService.class);
		String doId = rs.getString(columnIndex);

		DeliveryOrderItemExample example = new DeliveryOrderItemExample();
		example.createCriteria().andDeliveryOrderIdEqualTo(doId);

		return purchaseOrderItemService.queryAllObjByExample(example);
	}

	@Override
	public List<DeliveryOrderItem> getResult(CallableStatement cs, int columnIndex) throws SQLException {
		DeliveryOrderItemService purchaseOrderItemService = SpringContextHolder.getOneBean(DeliveryOrderItemService.class);
		String doId = cs.getString(columnIndex);

		DeliveryOrderItemExample example = new DeliveryOrderItemExample();
		example.createCriteria().andDeliveryOrderIdEqualTo(doId);

		return purchaseOrderItemService.queryAllObjByExample(example);
	}

}
