package com.els.base.delivery.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.els.base.utils.json.IntegerFromBooleanDeserializer;
import com.els.base.utils.json.IntegerToBooleanSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@ApiModel(value="送货包装")
public class DeliveryPackage implements Serializable {

    //非自动生成
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
    //非自动生成

    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("企业id")
    private String companyId;

    @ApiModelProperty("企业名称")
    private String companyName;

    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("供应商id")
    private String userId;

    @ApiModelProperty("供应商名称")
    private String userName;

    private String deliveryOrderId;

    @ApiModelProperty("送货单号")
    private String deliveryOrderNo;

    private String deliveryOrderItemId;

    @ApiModelProperty("送货单行号")
    private String deliveryOrderItemNo;

    private String materialId;

    @ApiModelProperty("采购方物料号")
    private String materialNo;

    @ApiModelProperty("采购方物料描述")
    private String materialDesc;

    @ApiModelProperty("单位")
    private String orderUnit;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("体积")
    private String volume;

    @ApiModelProperty("长度")
    private BigDecimal length;

    @ApiModelProperty("宽度")
    private BigDecimal width;

    @ApiModelProperty("高度")
    private BigDecimal height;

    @ApiModelProperty("每件数量")
    private Integer deliveryQuantity;

    @ApiModelProperty("件数")
    private Integer packageQuantity;

    @ApiModelProperty("总数量")
    private Integer totalQuantity;

    @ApiModelProperty("箱号")
    private String caseNo;

    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    @JsonSerialize(using=IntegerToBooleanSerializer.class)
    @JsonDeserialize(using=IntegerFromBooleanDeserializer.class)
    @ApiModelProperty("合并到一个箱子")
    private Integer isMerger;

    @ApiModelProperty("卡板号")
    private String palletNumber;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode == null ? null : companyCode.trim();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getDeliveryOrderId() {
        return deliveryOrderId;
    }

    public void setDeliveryOrderId(String deliveryOrderId) {
        this.deliveryOrderId = deliveryOrderId == null ? null : deliveryOrderId.trim();
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo == null ? null : deliveryOrderNo.trim();
    }

    public String getDeliveryOrderItemId() {
        return deliveryOrderItemId;
    }

    public void setDeliveryOrderItemId(String deliveryOrderItemId) {
        this.deliveryOrderItemId = deliveryOrderItemId == null ? null : deliveryOrderItemId.trim();
    }

    public String getDeliveryOrderItemNo() {
        return deliveryOrderItemNo;
    }

    public void setDeliveryOrderItemNo(String deliveryOrderItemNo) {
        this.deliveryOrderItemNo = deliveryOrderItemNo == null ? null : deliveryOrderItemNo.trim();
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId == null ? null : materialId.trim();
    }

    public String getMaterialNo() {
        return materialNo;
    }

    public void setMaterialNo(String materialNo) {
        this.materialNo = materialNo == null ? null : materialNo.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getOrderUnit() {
        return orderUnit;
    }

    public void setOrderUnit(String orderUnit) {
        this.orderUnit = orderUnit == null ? null : orderUnit.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getVolume() {
        return volume;
    }

    public void setVolume(String volume) {
        this.volume = volume == null ? null : volume.trim();
    }

    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public Integer getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(Integer deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public Integer getPackageQuantity() {
        return packageQuantity;
    }

    public void setPackageQuantity(Integer packageQuantity) {
        this.packageQuantity = packageQuantity;
    }

    public Integer getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getCaseNo() {
        return caseNo;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo == null ? null : caseNo.trim();
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public Integer getIsMerger() {
        return isMerger;
    }

    public void setIsMerger(Integer isMerger) {
        this.isMerger = isMerger;
    }

    public String getPalletNumber() {
        return palletNumber;
    }

    public void setPalletNumber(String palletNumber) {
        this.palletNumber = palletNumber == null ? null : palletNumber.trim();
    }
}