package com.els.base.delivery.service.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.dao.DeliveryOrderMapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.entity.DeliveryOrderPrint;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.delivery.entity.DeliveryPackageExample;
import com.els.base.delivery.service.DeliveryOrderBatchNoService;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.service.DeliveryPackageService;
import com.els.base.delivery.utils.DeliverOrderComparator;
import com.els.base.delivery.utils.DeliveryOrderPrintUtils;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.file.entity.FileData;
import com.els.base.leadtime.entity.PurLeadTime;
import com.els.base.leadtime.entity.PurLeadTimeExample;
import com.els.base.leadtime.service.PurLeadTimeService;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.MaterialCodeService;
import com.els.base.material.service.MaterialSealService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.orderchange.entity.PurchaseOrderChange;
import com.els.base.orderchange.entity.PurchaseOrderChangeExample;
import com.els.base.orderchange.service.PurchaseOrderChangeService;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderExample.Criteria;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.ReceiveOrderService;
import com.els.base.purchase.utils.HKStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.purchase.utils.SysUtil;
import com.els.base.supperorder.entity.SupplierOrder;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.supperorder.entity.SupplierOrderItemExample;
import com.els.base.supperorder.service.SupplierOrderItemService;
import com.els.base.supperorder.service.SupplierOrderService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.google.zxing.WriterException;

@Service("deliveryOrderService")
public class DeliveryOrderServiceImpl implements DeliveryOrderService {
    private static Logger logger = LoggerFactory.getLogger(DeliveryOrderServiceImpl.class);

    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected MaterialCodeService materialCodeService;
    @Resource
    protected DeliveryOrderMapper deliveryOrderMapper;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected PurchaseOrderService purchaseOrderHeaderService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected MaterialSealService materialSealService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected ReceiveOrderService receiveOrderService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected DeliveryPackageService deliveryPackageService;
    @Resource
    protected CompanyAddressService companyAddressService;
    @Resource
    protected PurchaseOrderChangeService purchaseOrderChangeService;
    @Resource
    protected PurLeadTimeService purLeadTimeService;
    @Resource
    protected DeliveryOrderBatchNoService deliveryOrderBatchNoService;

    @CacheEvict(value = {"deliveryOrder", "deliveryOrderItem"}, allEntries = true)
    @Transactional
    @Override
    public void addObj(DeliveryOrder deliveryOrder) {
        // 根据送货单的送货数量，更新订单的在途数量和可发货数量
        handlePurchaseOrderForDeliveryOrder(deliveryOrder, true);

        // 通过供应商公司id和采购公司id查询供应商下面采购负责人
        FriendGroup friendGroup = this.companyPurRefService.queryPurchaseFriendGroup(deliveryOrder.getCompanyId(),
                deliveryOrder.getPurCompanyId());
        if (friendGroup != null && CollectionUtils.isNotEmpty(friendGroup.getUserList())) {
            deliveryOrder.setPurUserId(friendGroup.getUserList().get(0).getId());
            deliveryOrder.setPurUserName(friendGroup.getUserList().get(0).getNickName());
        }
        // 发货状态为未发货
        deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
        deliveryOrder.setCreateTime(new Date());
        //启用了批次才生成批次号
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            if (Constant.YES_STRING.equals(deliveryOrderItem.getBatchFlag())) {
                deliveryOrder.setBatch(deliveryOrderBatchNoService.getBatchNo(deliveryOrder.getCompanyCode()));
                break;
            }
        }
        this.deliveryOrderMapper.insertSelective(deliveryOrder);

        List<DeliveryOrderItem> items = deliveryOrder.getItems();
        int deliveryOrderItemNo = 1;
        for (DeliveryOrderItem deliveryOrderItem : items) {

            // 检查送货单中采购订单行项目的可发货数量是否满足当前送货单中的发货数量。
            if (deliveryOrderItem.getDeliveryQuantity().compareTo(deliveryOrderItem.getCanDeliveryQuantity()) == 1) {
                throw new CommonException("发货数量大于可发货数量，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！",
                        "delivery_gt_candelivery", "，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！");
            }

            //加入提前期控制
            this.checkPurLeadTime(deliveryOrderItem.getCompanyCode(), deliveryOrderItem.getFactoryCode(), deliveryOrderItem.getMaterialNo(),
                    deliveryOrderItem.getPurOrderNo(), deliveryOrderItem.getPurOrderItemNo(), deliveryOrderItem.getDeliveryDate());

            // 判断采购方是否修改了订单
            this.isHaveNewOrder(deliveryOrderItem.getPurOrderNo(), deliveryOrderItem.getCompanyId());

            deliveryOrderItem.setId(null);
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
            deliveryOrderItem.setType(deliveryOrder.getType());
            deliveryOrderItem.setDeliveryOrderItemNo(String.valueOf(deliveryOrderItemNo));
            deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
            deliveryOrderItemNo++;
            // String companyId = deliveryOrderItem.getCompanyId();
            // Company company = this.companyService.queryObjById(companyId);
            // 供应商SAP编码以“0002”开头+“外部制造商（external_manufacturer）”为“转厂”的，则要判断是否是有效的关封（判断转厂订单）

            // 暂时屏蔽
            /*
             * if (company != null && StringUtils.isNotBlank(company.getCompanySapCode()) &&
             * company.getCompanySapCode().startsWith("0002") &&
             * StringUtils.isNotBlank(company.getExternalManufacturer()) &&
             * company.getExternalManufacturer().equals("2")) { Boolean flag =
             * this.materialSealService.judgeSealIsEffective(deliveryOrderItem.getMaterialNo()); if (!flag) { String
             * content = "物料" + deliveryOrderItem.getMaterialNo() + "没有有效的关封";
             *
             * MessageUtils.pushSystemMessage("转厂订单判断", content, deliveryOrderItem.getUserId(),
             * deliveryOrderItem.getCompanyCode(), MessageLevelEnum.HIGH); } } //送货单才修改关封
             * if(deliveryOrder.getType().equals("D")){ // 增加关封里的发货数量
             * this.materialSealService.updateDeliveryNum(deliveryOrderItem.getMaterialNo(),
             * deliveryOrderItem.getDeliveryQuantity(), "I"); }
             */
            deliveryOrderItem.setDeliveryOrderId(deliveryOrder.getId());
            deliveryOrderItem.setProjectId(deliveryOrder.getProjectId());
            deliveryOrderItem.setCompanyId(deliveryOrder.getCompanyId());
            deliveryOrderItem.setUserId(deliveryOrder.getUserId());
            deliveryOrderItem.setUserName(deliveryOrder.getUserName());
            deliveryOrderItem.setReceiptQuantity("0");// 创建送货单的时候，收货数量默认为0
//            // 如果包装件数为空，则默认0
//            if (StringUtils.isBlank(deliveryOrderItem.getPackQuantity())) {
//                deliveryOrderItem.setPackQuantity("0");
//            }

            //如果启用了批次就插入批次号
            if (Constant.YES_STRING.equals(deliveryOrderItem.getBatchFlag())) {
                deliveryOrderItem.setBatch(deliveryOrder.getBatch());
            }

            // 插入发货行
            this.deliveryOrderItemService.addObj(deliveryOrderItem);

            // 插入包装明细,设置默认值以及排除0x0=0的记录或者1x0，0x1=0的记录
            this.insertDeliveryPackage(deliveryOrder, deliveryOrderItem);
        }
    }

    /**
     * 插入送货单包装数
     *
     * @param deliveryOrder
     * @param deliveryOrderItem
     */
    private void insertDeliveryPackage(DeliveryOrder deliveryOrder, DeliveryOrderItem deliveryOrderItem) {

        //页面获取的包装数
        List<DeliveryPackage> deliveryPackageLists = deliveryOrderItem.getDeliveryPackageLists();
        logger.info("页面获取的包装方案为：{}", deliveryPackageLists);

        //排除后剩下的包装数量--排除0x0=0的记录或者1x0，0x1=0的记录
        List<DeliveryPackage> deliveryPackages = new ArrayList<DeliveryPackage>();
        if (CollectionUtils.isNotEmpty(deliveryPackageLists)) {
            logger.info("包装条数：{}", deliveryPackageLists.size());

            Integer DeliveryQuantity = deliveryOrderItem.getDeliveryQuantity().intValue();
            Integer TotalQuantity = new Integer("0");
            logger.info("插入送货单包装数 送货数量是：{}", DeliveryQuantity);
            Integer deliveryPackageCount = deliveryPackageLists.size();
            Integer _Index = 0;
            for (DeliveryPackage deliveryPackage : deliveryPackageLists) {
                _Index++;
                //设置基本信息
                deliveryPackage.setUserId(deliveryOrder.getUserId());
                deliveryPackage.setUserName(deliveryOrder.getUserName());
                deliveryPackage.setProjectId(deliveryOrder.getProjectId());
                deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
                deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
                deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                deliveryPackage.setDeliveryOrderItemId(deliveryOrderItem.getId());
                deliveryPackage.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());
                // 设置值
                deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
                deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
                deliveryPackage.setMaterialId(deliveryOrderItem.getMaterialId());
                deliveryPackage.setMaterialNo(deliveryOrderItem.getMaterialNo());
                deliveryPackage.setMaterialDesc(deliveryOrderItem.getMaterialDesc());

                //校验数量书否已经和送货数量一致
                Integer packageQuantity = deliveryPackage.getPackageQuantity();
                logger.info("当前包装外包装数量 getPackageQuantity---{}", packageQuantity);
                if (packageQuantity == null) {
                    packageQuantity = 0;
                }
                Integer deliveryQuantity = deliveryPackage.getDeliveryQuantity();
                logger.info("当前包装单件数量 getDeliveryQuantity---{}", deliveryQuantity);
                if (deliveryQuantity == null) {
                    deliveryQuantity = 0;
                }
                TotalQuantity += packageQuantity * deliveryQuantity;
                logger.info("包装总数量{}", TotalQuantity);
                logger.info("送货数量{}", deliveryOrderItem.getDeliveryQuantity());
                logger.info("校验包装总数量书否已经和送货数量一致");
                if (deliveryQuantity > 0) {
                    if (TotalQuantity > deliveryOrderItem.getDeliveryQuantity().intValue()) {
                        break;
                    }
                } else {
                    if (TotalQuantity >= deliveryOrderItem.getDeliveryQuantity().intValue()) {
                        break;
                    }
                }


                // 排除0x0=0的记录或者1x0，0x1=0的记录 包装明细数量不为空
                if (deliveryPackage.getTotalQuantity() != null && deliveryPackage.getTotalQuantity() != 0) {
                    logger.info("新增送货单插入包装方案：{}", deliveryPackageLists.size());
                    if (deliveryPackage.getDeliveryQuantity() == null || deliveryPackage.getDeliveryQuantity() == 0) {
                        deliveryPackage.setDeliveryQuantity(DeliveryQuantity / packageQuantity);
                        //deliveryPackage.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                    }
                    deliveryPackages.add(deliveryPackage);
                } else {
                    //发货数量可以平均分配到包装信息中
                    logger.info("发货数量可以平均分配到包装信息中：{}", deliveryPackageLists.size());
                    if (DeliveryQuantity % deliveryPackageCount == 0) {
                        if (packageQuantity == 0) {
                            Integer defalutPackageQuantity = 1;
                            deliveryPackage.setPackageQuantity(defalutPackageQuantity);
                            deliveryPackage.setTotalQuantity(DeliveryQuantity / deliveryPackageCount);
                            deliveryPackage.setDeliveryQuantity(DeliveryQuantity / deliveryPackageCount);
                            deliveryPackages.add(deliveryPackage);
                        } else {
                            deliveryPackage.setTotalQuantity((DeliveryQuantity / deliveryPackageCount) * packageQuantity);
                            deliveryPackage.setDeliveryQuantity(DeliveryQuantity / deliveryPackageCount);
                            deliveryPackages.add(deliveryPackage);
                        }
                    } else {
                        if (_Index < deliveryPackageCount) {
                            if (packageQuantity == 0) {
                                deliveryPackage.setPackageQuantity(1);
                                deliveryPackage.setTotalQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                deliveryPackage.setDeliveryQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                deliveryPackages.add(deliveryPackage);
                            } else {
                                deliveryPackage.setTotalQuantity((DeliveryQuantity / (deliveryPackageCount - 1)) * packageQuantity);
                                deliveryPackage.setDeliveryQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                deliveryPackages.add(deliveryPackage);
                            }
                        } else {
                            Integer leftDeliveryQuantity = DeliveryQuantity % (deliveryPackageCount - 1);
                            deliveryPackage.setPackageQuantity(1);
                            deliveryPackage.setTotalQuantity(leftDeliveryQuantity);
                            deliveryPackage.setDeliveryQuantity(leftDeliveryQuantity);
                            deliveryPackages.add(deliveryPackage);
                        }
                    }
                }

            }

            if (CollectionUtils.isNotEmpty(deliveryPackages)) {
                // 保存包装
                logger.info("过滤后的包装方案为：{}", deliveryPackages);
                this.deliveryPackageService.save(deliveryPackages);
            } else {

                //排除后的判断
                throw new CommonException("外包装件数不能为空，请先维护包装方式才能保存");
            }
        } else {
            logger.info("不存在包装方案");
            logger.info("送货单明细包装条数" + deliveryOrderItem.getPackQuantity());
            //生成默认包装方案
            DeliveryPackage deliveryPackage = new DeliveryPackage();
            deliveryPackage.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
            deliveryPackage.setUserId(deliveryOrder.getUserId());
            deliveryPackage.setUserName(deliveryOrder.getUserName());
            deliveryPackage.setProjectId(deliveryOrder.getProjectId());
            deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
            deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
            deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
            deliveryPackage.setDeliveryOrderItemId(deliveryOrderItem.getId());
            deliveryPackage.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());
            deliveryPackage.setPackageQuantity(new Integer(deliveryOrderItem.getPackQuantity()));
            deliveryPackage.setTotalQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
            logger.info("送货包装明细" + deliveryPackage.getPackageQuantity());
            // 设置值
            deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
            deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
            deliveryPackage.setMaterialId(deliveryOrderItem.getMaterialId());
            deliveryPackage.setMaterialNo(deliveryOrderItem.getMaterialNo());
            deliveryPackage.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
            deliveryPackages.add(deliveryPackage);
            if (CollectionUtils.isNotEmpty(deliveryPackages)) {
                // 保存包装
                logger.info("初始化后的包装方案：{}", deliveryPackages);
                this.deliveryPackageService.save(deliveryPackages);
            } else {

                //排除前的判断
                throw new CommonException("外包装件数不能为空，请先维护包装方式才能保存");
            }
        }
    }

    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.deliveryOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Override
    public void modifyObj(DeliveryOrder t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.deliveryOrderMapper.updateByPrimaryKeySelective(t);
    }

    // @Cacheable(value = "deliveryOrder", keyGenerator="redisKeyGenerator")
    @Override
    public DeliveryOrder queryObjById(String id) {
        return this.deliveryOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "deliveryOrder", keyGenerator = "redisKeyGenerator")
    @Override
    public List<DeliveryOrder> queryAllObjByExample(DeliveryOrderExample example) {
        return this.deliveryOrderMapper.selectByExample(example);
    }

    @Cacheable(value = "deliveryOrder", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<DeliveryOrder> queryObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    /**
     * 生成发货单前判断
     *
     * @param orderItemIdList
     * @param projectId
     * @param deliveryOrder
     * @return
     */
    public void checkDelivery(List<String> orderItemIdList, String projectId, DeliveryOrder deliveryOrder) {

        String orderNos = "";
        String orderIds = "";
        String supUserId = "";
        String supUserName = "";
        String supCompanyId = "";
        String supCompanyCode = "";
        String supCompanyName = "";
        String purUserId = "";
        String purUserName = "";
        String purCompanyId = "";
        String purCompanyName = "";
        String purCompanyCode = "";
        String voucherType = "";
        List<DeliveryOrderItem> items = deliveryOrder.getItems();
        Map<String, String> orderNoMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(orderItemIdList)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();

        criteria.andFinishFlagEqualTo("N").andProjectIdEqualTo(projectId).andIdIn(orderItemIdList);
        example.setOrderByClause("MATERIAL_CODE ASC");

        List<SupplierOrderItem> supplierOrderItemList = this.supplierOrderItemService.queryAllObjByExample(example);

        if (CollectionUtils.isEmpty(supplierOrderItemList)) {
            throw new CommonException("没有找到采购订单", "not_found", "采购订单");
        }

        //检查分批是否同意
        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            logger.info("supplierOrderItem.getOrderStatus() = " +
                    supplierOrderItem.getOrderStatus());
            logger.info("supplierOrderItem.getAgreeBatch() = " +
                    supplierOrderItem.getAgreeBatch());
            logger.info(String.valueOf(supplierOrderItem.getOrderStatus() == 4 &&
                    (supplierOrderItem.getAgreeBatch() == null || supplierOrderItem.getAgreeBatch() == 0)));
            if (supplierOrderItem.getOrderStatus() == 4 &&
                    (supplierOrderItem.getAgreeBatch() == null || supplierOrderItem.getAgreeBatch() == 0)) {
                throw new CommonException("分批订单还未同意.订单号[" + supplierOrderItem.getOrderNo() + "], "
                        + "订单行号[" + supplierOrderItem.getOrderItemNo() + "]");
            }
        }
//        //先判断是否有启用批次号，如果有一个启用就生成批次号跳出循环，如没有就不生成批次号
//        for(SupplierOrderItem supplierOrderItem : supplierOrderItemList){
//        	if(Constant.YES_STRING.equals(supplierOrderItem.getBatchFlag())){
//        		deliveryOrder.setBatch(deliveryOrderBatchNoService.getBatchNo(supplierOrderItemList.get(0).getSapSupCompanyCode()));
//        		break;
//        	}
//        }

        //检查是否变更未确认
        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            String tempOrderNo = supplierOrderItem.getOrderNo();
            String tempOrderItemNo = supplierOrderItem.getOrderItemNo();
            PurchaseOrderChangeExample changeExample = new PurchaseOrderChangeExample();
            PurchaseOrderChangeExample.Criteria changeCriteria = changeExample.createCriteria();
            changeCriteria.andOrderNoEqualTo(tempOrderNo);
            changeCriteria.andOrderItemNoEqualTo(tempOrderItemNo);
            List<PurchaseOrderChange> tempChangeList = purchaseOrderChangeService.queryAllObjByExample(changeExample);
            if (tempChangeList != null) {
                for (PurchaseOrderChange tempChange : tempChangeList) {
                    //变更未确认，不能创建送货单
                    if ("0".equals(tempChange.getConfirmStatus())) {
                        throw new CommonException("订单变更未确认，不能创建送货单.订单号[" + tempOrderNo + "], "
                                + "订单行号[" + tempOrderItemNo + "]");
                    }
                }
            }
            //判断是否启用批次
//        		if(Constant.YES_STRING.equals(supplierOrderItem.getBatchFlag())){
//        			deliveryOrder.setBatch(batch);
//        		}
        }

        //检查提前交期限制
        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            this.checkPurLeadTime(supplierOrderItem.getSapSupCompanyCode(), supplierOrderItem.getFactory(), supplierOrderItem.getMaterialCode()
                    , supplierOrderItem.getOrderNo(), supplierOrderItem.getOrderItemNo(), supplierOrderItem.getDeliveredDate());
        }

        // 根据订单行是否全部是转厂订单或者全部是非转厂订单判断是否能够发货
        this.checkInterType(supplierOrderItemList);

        // 检查国际贸易条款是否一样，不一样的不能发货
        this.checkInterTrade(supplierOrderItemList);

        Set<String> orderIdList = new HashSet<String>();
        for (SupplierOrderItem item : supplierOrderItemList) {
            orderIdList.add(item.getOrderId());
        }
        if (!this.supplierOrderService.isSameType(orderIdList)) {
            throw new CommonException("单据类型不一致，不能创建到同一个送货单");
        }

        // 判断物料编码是否存在有效关封
        // for (String orderItemId : orderItemIdList) {
        // SupplierOrderItem supplierOrderItem = supplierOrderItemService.queryObjById(orderItemId);
        // String materialCode = supplierOrderItem.getMaterialCode();
        // boolean judgeSealIsEffective = materialSealService.judgeSealIsEffective(materialCode);
        // if (judgeSealIsEffective == false) {
        // throw new CommonException("物料编码:" + materialCode + "不存在有效的关封", "do_not_exists", "物料编码:"
        // + materialCode + "对应的有效关封");
        // }
        // }

        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            // double quantity = supplierOrderItem.getQuantity().doubleValue();// 订单数量
            // double deliveredQuantity = supplierOrderItem.getDeliveredQuantity().doubleValue();//
            // 已经发货数量
            // double returnQuantity = supplierOrderItem.getReceivedQuantity().doubleValue();// 退货数量
            // double freezeQuantity = supplierOrderItem.getFreezeQuantity().doubleValue();//冻结数量
            //if (supplierOrderItem.getDeliveryAmount() <= 0) {
            if (supplierOrderItem.getDeliveryAmount().compareTo(BigDecimal.ZERO) == -1) {// 如果订单数量=已经发货数量-退货数量，说明已经全部发货
                throw new CommonException("已经全部发货，不能重复发货", "cannot_repeat_shipment");
            }

            DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
            SupplierOrder supplierOrderTemp = this.supplierOrderService.queryObjById(supplierOrderItem.getOrderId());

            // 把订单转换为发货单
            convertDeliveryOrderItem(supplierOrderItem, deliveryOrderItem, deliveryOrder);

            // 查询供应商公司编码
            if (supplierOrderTemp != null) {
                purCompanyCode = supplierOrderTemp.getPurCompanyCode();
                supCompanyCode = supplierOrderTemp.getCompanySapCode();
                voucherType = supplierOrderTemp.getVoucherType();
                deliveryOrderItem.setExchangeRate(supplierOrderTemp.getExchangeRate());// 汇率
                deliveryOrderItem.setCompanyCode(supplierOrderTemp.getCompanySapCode());
                deliveryOrderItem.setPurCompanyCode(purCompanyCode);
                deliveryOrderItem.setCompanyCode(supCompanyCode);
            }
            purCompanyId = supplierOrderItem.getPurCompanyId();
            purCompanyName = supplierOrderItem.getPurCompanyName();
            purUserId = supplierOrderItem.getPurUserId();
            purUserName = supplierOrderItem.getPurUserName();
            supCompanyId = supplierOrderItem.getCompanyId();
            supCompanyName = supplierOrderItem.getCompanyName();
            supUserId = supplierOrderItem.getUserId();
            supUserName = supplierOrderItem.getUserName();
            String key = supplierOrderItem.getOrderId();
            // 过滤相同的采购订单id
            if (!orderNoMap.containsKey(key)) {
                orderIds = orderIds + key + ",";
                orderNos = orderNos + deliveryOrderItem.getPurOrderNo() + ",";
                orderNoMap.put(key, key);
            }

            // 获取供应商料号和物料描述
            String supplierMaterialName = "";
            String supplierMaterialNumber = "";
            String brand = "";
            String supModel = "";
            String productArea = "";
            BigDecimal length = BigDecimal.ZERO;// 长度
            BigDecimal width = BigDecimal.ZERO; // 宽度
            BigDecimal height = BigDecimal.ZERO;// 高度
            BigDecimal grossWeight = BigDecimal.ZERO;// 毛重
            BigDecimal netWeight = BigDecimal.ZERO;// 净重

            // 根据物料号进行查询
            SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
            supplierMaterialExample.createCriteria().andProjectIdEqualTo(deliveryOrderItem.getProjectId())
                    .andCompanySapCodeEqualTo(deliveryOrderItem.getCompanyCode())
                    .andMaterialCodeEqualTo(deliveryOrderItem.getMaterialNo());
            List<SupplierMaterial> supplierMaterialList =
                    this.supplierMaterialService.queryAllObjByExample(supplierMaterialExample);

            if (CollectionUtils.isNotEmpty(supplierMaterialList)) {
                SupplierMaterial supplierMaterial = supplierMaterialList.get(0);
                supplierMaterialNumber = supplierMaterial.getSupplierMaterial();
                supplierMaterialName = supplierMaterial.getSupplierMaterialDesc();
                brand = supplierMaterial.getBrand();
                supModel = supplierMaterial.getSupModel();
                productArea = supplierMaterial.getProductArea();
                if (supplierMaterial.getLength() != null)
                    length = supplierMaterial.getLength();
                if (supplierMaterial.getWidth() != null)
                    width = supplierMaterial.getWidth();
                if (supplierMaterial.getHeight() != null)
                    height = supplierMaterial.getHeight();
                if (supplierMaterial.getGrossWeight() != null)
                    grossWeight = supplierMaterial.getGrossWeight();
                if (supplierMaterial.getNetWeight() != null)
                    netWeight = supplierMaterial.getNetWeight();
            }
            deliveryOrderItem.setSupplierMaterialName(supplierMaterialName);
            deliveryOrderItem.setSupplierMaterialNumber(supplierMaterialNumber);
            deliveryOrderItem.setBrand(brand);
            deliveryOrderItem.setModel(supModel);
            deliveryOrderItem.setSourceArea(productArea);

            // 设置值
            deliveryOrderItem.setTotalGrossWeight(grossWeight);

            MaterialExample materialExample = new MaterialExample();
            materialExample.createCriteria().andMaterialCodeEqualTo(supplierOrderItem.getMaterialCode());
            List<Material> materialList = this.materialService.queryAllObjByExample(materialExample);
            if (CollectionUtils.isNotEmpty(materialList) && StringUtils.isNotBlank(materialList.get(0).getWeight())) {
                deliveryOrderItem.setSingleWeight(new BigDecimal(materialList.get(0).getWeight()));
            }

            // 设置默认值
            List<DeliveryPackage> list = new ArrayList<DeliveryPackage>();
            DeliveryPackage deliveryPackage = new DeliveryPackage();
            deliveryPackage.setHeight(height);
            deliveryPackage.setWidth(width);
            deliveryPackage.setLength(length);
            deliveryPackage.setVolume(deliveryPackage.getHeight().multiply(deliveryPackage.getWidth())
                    .multiply(deliveryPackage.getLength()).divide(new BigDecimal("1000000")).toString());
            deliveryPackage.setGrossWeight(grossWeight);

            list.add(deliveryPackage);
            deliveryOrderItem.setDeliveryPackageLists(list);
            if (!supplierOrderItem.getMaterialCode().isEmpty()) {
                boolean isJit = this.materialService.isJTL(supplierOrderItem.getMaterialCode());
                if (isJit) {
                    deliveryOrderItem.setRemark("JIT");
                }
            }
            items.add(deliveryOrderItem);

        }

        deliveryOrder.setPurCompanyCode(purCompanyCode);
        deliveryOrder.setCompanyCode(supCompanyCode);
        deliveryOrder.setUserId(supUserId);
        deliveryOrder.setUserName(supUserName);
        deliveryOrder.setCompanyId(supCompanyId);
        deliveryOrder.setCompanyName(supCompanyName);
        deliveryOrder.setPurUserId(purUserId);
        deliveryOrder.setPurUserName(purUserName);
        deliveryOrder.setPurCompanyId(purCompanyId);
        deliveryOrder.setPurCompanyName(purCompanyName);
//        deliveryOrder.setPurchaseOrderId(orderIds);
        deliveryOrder.setPurchaseOrderNo(StringUtils.abbreviate(orderNos, 1000));
        deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
        deliveryOrder.setVoucherType(voucherType);
    }


    /**
     * 交货提前期的检测
     *
     * @param supplierSapCode
     * @param factoryCode
     * @param materialCode
     * @param orderNo
     * @param orderNoItem
     * @param planDeliveredDate
     */
    private void checkPurLeadTime(String supplierSapCode, String factoryCode, String materialCode, String
            orderNo, String orderNoItem, Date planDeliveredDate) {
        Assert.isNotNull(supplierSapCode);
        Assert.isNotNull(factoryCode);
        Assert.isNotNull(materialCode);

        //提前期主要通过三个维度去控制

        //第一种情况：根据工厂+供应商sap编码+物料编码的组合去查询
        PurLeadTimeExample example1 = new PurLeadTimeExample();
        example1.createCriteria()
                .andFactoryTypeEqualTo(factoryCode)
                .andSupCompanySapCodeEqualTo(supplierSapCode)
                .andMaterialCodeEqualTo(materialCode);
        List<PurLeadTime> purLeadTimes = purLeadTimeService.queryAllObjByExample(example1);

        //第二种情况：根据工厂+供应商sap编码的组合去查询
        if (CollectionUtils.isEmpty(purLeadTimes)) {

            //如果第一种情况没有，那么就按照第二种情况去找
            PurLeadTimeExample example2 = new PurLeadTimeExample();
            example2.createCriteria()
                    .andFactoryTypeEqualTo(factoryCode)
                    .andSupCompanySapCodeEqualTo(supplierSapCode)
                    .andMaterialCodeIsNull();
            purLeadTimes = purLeadTimeService.queryAllObjByExample(example2);


            //如果第二种情况，还是没有的话，那么就走第三种情况

            //第三种情况：根据工厂去查询
            if (CollectionUtils.isEmpty(purLeadTimes)) {
                PurLeadTimeExample example3 = new PurLeadTimeExample();
                example3.createCriteria()
                        .andFactoryTypeEqualTo(factoryCode)
                        .andSupCompanySapCodeIsNull()
                        .andMaterialCodeIsNull();
                purLeadTimes = purLeadTimeService.queryAllObjByExample(example3);
            }
        }

        if (CollectionUtils.isNotEmpty(purLeadTimes)) {
            PurLeadTime purLeadTime = purLeadTimes.get(0);
            Assert.isNotNull(purLeadTime);

            //（订单交货日期-控制日期）+1 day=交货日期 与 当前日期比对
            //当前日期< 交货日期 不给创建送货单

            //控制日期
            Integer daysNumber = purLeadTime.getDaysNumber();
            Assert.isNotNull(daysNumber);

            //理论交货日期
            //Date planDeliveredDate = supplierOrderItem.getDeliveredDate();
            Assert.isNotNull("订单交货日期为空.订单号[" + orderNo + "], "
                    + "订单行号[" + orderNoItem + "]");
            Date date = DateUtils.addDays(DateUtils.addDays(planDeliveredDate, -daysNumber), 1);

            //系统日期
            Date systemDate = DateUtils.truncate(new Date(), Calendar.DAY_OF_MONTH);

            if (systemDate.getTime() < date.getTime()) {
                throw new CommonException("采购订单[" + orderNo + "], " + "行项目[" + orderNoItem + "]"
                        + "当前不允许生成送货单,最多允许提前" + daysNumber + "天创建交货单");
            }
        }
    }

    /**
     * 检查国际贸易条件
     *
     * @param supplierOrderItemList
     */
    private void checkInterTrade(List<SupplierOrderItem> supplierOrderItemList) {
        String interTradeCode = null;
        for (int i = 0; CollectionUtils.isNotEmpty(supplierOrderItemList) && i < supplierOrderItemList.size(); i++) {
            SupplierOrderItem supplierOrderItem = supplierOrderItemList.get(i);
            if (interTradeCode == null) {
                interTradeCode = supplierOrderItem.getInterTradeCode();

            } else if (supplierOrderItem.getInterTradeCode() != null && !interTradeCode.equals(supplierOrderItem.getInterTradeCode())) {
                throw new CommonException("国际贸易条款不一致的，不能一起送货");
            }
        }
    }

    /**
     * 检查国际类型，是否是转厂或者香港上料
     *
     * @param supplierOrderItemList
     */
    private void checkInterType(List<SupplierOrderItem> supplierOrderItemList) {
        String interType = null;
        for (int i = 0; CollectionUtils.isNotEmpty(supplierOrderItemList) && i < supplierOrderItemList.size(); i++) {
            SupplierOrderItem supplierOrderItem = supplierOrderItemList.get(i);
            if (interType == null) {
                interType = supplierOrderItem.getInterType();

            } else if (supplierOrderItem.getInterType() != null && !interType.equals(supplierOrderItem.getInterType())) {
                throw new CommonException("转厂订单与非转厂订单不可创建在同一张送货单中", "cannot_create_the_same_deliveryOrder");
            }

        }
    }

    /**
     * 把订单转换为发货单
     *
     * @param supplierOrderItem
     * @param deliveryOrderItem
     * @param deliveryOrder
     */
    private void convertDeliveryOrderItem(SupplierOrderItem supplierOrderItem, DeliveryOrderItem deliveryOrderItem,
                                          DeliveryOrder deliveryOrder) {

        // 可发送数量
        //long deliveryAmount = 0;
        BigDecimal deliveryAmount = BigDecimal.ZERO;
        if (!supplierOrderItem.getFinishFlag().equals("Y")) {// 如果已经交货完成，就设置可发货数量为0
            deliveryAmount =
                    SysUtil.getCanDeliveryAmount(supplierOrderItem.getQuantity(), supplierOrderItem.getOnwayQuantity(),
                            supplierOrderItem.getReceivedQuantity(), supplierOrderItem.getFreezeQuantity());
            //deliveryOrderItem.setCanDeliveryQuantity(new BigDecimal(deliveryAmount));
            deliveryOrderItem.setCanDeliveryQuantity(deliveryAmount);
        }
        deliveryOrderItem.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
        // deliveryOrderItem.setFreezeQuantity(supplierOrderItem.getFreezeQuantity());
        BeanUtils.copyProperties(supplierOrderItem, deliveryOrderItem);
        deliveryOrderItem.setPurCompanyId(supplierOrderItem.getPurCompanyId());
        deliveryOrderItem.setPurCompanyName(supplierOrderItem.getPurCompanyName());
        deliveryOrderItem.setCompanyId(supplierOrderItem.getCompanyId());
        deliveryOrderItem.setCompanyName(supplierOrderItem.getCompanyName());
        deliveryOrderItem.setBatchFlag(supplierOrderItem.getBatchFlag());//是否启用批次号
        String supMaterialCode = supplierOrderItem.getSupMaterialCode();// 供应商料号
        Date deliveredDate = supplierOrderItem.getDeliveredDate();// 交货日期
        String taxCode = supplierOrderItem.getSaleTaxCode();// 税码
        String factory = supplierOrderItem.getFactory();// 工厂
        String materialName = supplierOrderItem.getMaterialName();
        String materialCode = supplierOrderItem.getMaterialCode();
        String purOrderItemId = supplierOrderItem.getId();
        String purOrderNo = supplierOrderItem.getOrderNo();
        String purOrderId = supplierOrderItem.getOrderId();
        String purOrderItemNo = supplierOrderItem.getOrderItemNo();
        BigDecimal noTaxAmount = supplierOrderItem.getNonTaxAmount();
        BigDecimal taxPrice = supplierOrderItem.getPrice();
        String taxAmount = supplierOrderItem.getOrderValue().toString();
        String departmentId = supplierOrderItem.getMaterialCategoryId();
        String departmentName = supplierOrderItem.getMaterialCategoryName();
        String warehouseCode = supplierOrderItem.getWarehouseLocation();
        String warehouseName = supplierOrderItem.getWarehouseName();
        BigDecimal receiptQuantity = supplierOrderItem.getReceivedQuantity();

        deliveryOrderItem.setDeliveryDate(deliveredDate);
        deliveryOrderItem.setSupplierMaterialNumber(supMaterialCode);
        deliveryOrderItem.setFactoryCode(factory);
        deliveryOrderItem.setTaxCode(taxCode);
        deliveryOrderItem.setDeliveredQuantity(supplierOrderItem.getDeliveredQuantity());
        deliveryOrderItem.setPurOrderId(purOrderId);
        deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
        deliveryOrderItem.setMaterialDesc(materialName);
        deliveryOrderItem.setMaterialNo(materialCode);
        deliveryOrderItem.setPurOrderItemId(purOrderItemId);
        deliveryOrderItem.setPurOrderItemNo(purOrderItemNo);
        deliveryOrderItem.setPurOrderNo(purOrderNo);
        deliveryOrderItem.setNoTaxAmount(noTaxAmount);
        deliveryOrderItem.setTaxAmount(new BigDecimal(taxAmount));
        deliveryOrderItem.setTaxPrice(taxPrice);
        deliveryOrderItem.setDepartmentId(departmentId);
        deliveryOrderItem.setDepartmentName(departmentName);
        deliveryOrderItem.setWarehouseCode(warehouseCode);
        deliveryOrderItem.setWarehouseName(warehouseName);
        deliveryOrderItem.setChineseName(supplierOrderItem.getIndustryStandard());
        deliveryOrderItem.setDeliveryMaterialName(supplierOrderItem.getIndustryStandard());
        deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
        deliveryOrderItem.setInterTradeCode(supplierOrderItem.getInterTradeCode());
        deliveryOrderItem.setInterTradeDesc(supplierOrderItem.getInterTradeDesc());

        deliveryOrderItem.setMapNo(supplierOrderItem.getMapNo());
        deliveryOrderItem.setSpecification(supplierOrderItem.getSpecification());
        deliveryOrderItem.setSupplierMaterialInt(supplierOrderItem.getSupMaterialCode());
        deliveryOrderItem.setCourseAssignType(supplierOrderItem.getCourseAssignType());
        deliveryOrderItem.setWbsNo(supplierOrderItem.getWbsNo());
//        if(Constant.YES_STRING.equals(supplierOrderItem.getBatchFlag())){
//        	deliveryOrderItem.setBatch(deliveryOrder.getBatch());
//        }
//        deliveryOrderItem.setMaterialDesc(supplierOrderItem.getMaterialName());

        // 送货单创建时候，提供预览的数据中，显示采购订单的收货数量
        logger.info("送货单创建时候，提供预览的数据中，显示采购订单的收货数量");
        if (receiptQuantity == null) {
            deliveryOrderItem.setReceiptQuantity("0");
        } else {
            logger.info("设置送货单收货数量为订单收货数量");
            //deliveryOrderItem.setReceiptQuantity(receiptQuantity.toString());
        }
    }

    @Override
    public DeliveryOrder createDeliveryData(List<String> supplierOrderItemIds, String projectId) {
        List<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        deliveryOrder.setItems(items);
        // 获取下一个的发货单号
        String deliveryOrderNo = SysUtil.getNextDeliveryNumber();
        deliveryOrder.setDeliveryOrderNo(deliveryOrderNo);
        checkDelivery(supplierOrderItemIds, projectId, deliveryOrder);
        return deliveryOrder;
    }

    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Transactional
    @Override
    public void sendDelivery(DeliveryOrder deliveryOrder) {
        logger.info("发送送货单：", deliveryOrder.getDeliveryOrderNo());
        // 参数长度判断
        if (deliveryOrder.getInvoiceNo() != null && deliveryOrder.getInvoiceNo().length() > 255
                || deliveryOrder.getDriverName() != null && deliveryOrder.getDriverName().length() > 255
                || deliveryOrder.getIdCard() != null && deliveryOrder.getIdCard().length() > 255
                || deliveryOrder.getCar() != null && deliveryOrder.getCar().length() > 255) {
            throw new CommonException("参数长度超标", "database_length_error");
        }
        logger.info("获取送货单行数据");
        // 获取送货单行数据
        List<DeliveryOrderItem> items = deliveryOrder.getItems();
        if (CollectionUtils.isEmpty(items)) {
            items = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrder.getId());
        }

        if (CollectionUtils.isEmpty(items)) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }

        if ((deliveryOrder.getDeliveryStatus() != null)
                && (!DeliveryStatusEnum.UN_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus()))) {
            throw new CommonException("已经全部发货，不能重复发货", "cannot_repeat_shipment");
        }

        for (DeliveryOrderItem item : deliveryOrder.getItems()) {
            SupplierOrderItem orderItem = this.supplierOrderItemService.queryObjById(item.getPurOrderItemId());
            //if (orderItem.getDeliveryAmount() < 0) {
            if (orderItem.getDeliveryAmount().compareTo(BigDecimal.ZERO) == -1) {
                throw new CommonException("发货数量大于可发货数量，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！",
                        "delivery_gt_candelivery", "，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！");
            }
            logger.info("加入提前期控制");
            //加入提前期控制
            this.checkPurLeadTime(item.getCompanyCode(), item.getFactoryCode(), item.getMaterialNo(), item.getPurOrderNo(), item.getPurOrderItemNo()
                    , item.getDeliveryDate());
            logger.info("校验外包装件数");
            //校验外包装件数
            List<DeliveryPackage> deliveryPackageList = new ArrayList<>();
            List<DeliveryPackage> deliveryPackageTempList = item.getDeliveryPackageLists();
            logger.info("deliveryPackageTempList");
            if (CollectionUtils.isNotEmpty(deliveryPackageTempList)) {
                logger.info("原外包装数量---" + deliveryPackageTempList.size());
                logger.info("包装条数：{}", deliveryPackageTempList.size());

                Integer DeliveryQuantity = item.getDeliveryQuantity().intValue();
                Integer TotalQuantity = new Integer("0");
                logger.info("插入送货单包装数 送货数量是：{}", DeliveryQuantity);
                Integer deliveryPackageCount = deliveryPackageTempList.size();
                Integer _deliveryPackageIndex = 0;
                for (DeliveryPackage deliveryPackage : deliveryPackageTempList) {
                    _deliveryPackageIndex++;
                    deliveryPackage.setUserId(deliveryOrder.getUserId());
                    deliveryPackage.setUserName(deliveryOrder.getUserName());
                    deliveryPackage.setProjectId(deliveryOrder.getProjectId());
                    deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
                    deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
                    deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                    deliveryPackage.setDeliveryOrderItemId(item.getId());
                    deliveryPackage.setDeliveryOrderItemNo(item.getDeliveryOrderItemNo());
                    // 设置值
                    deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
                    deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
                    deliveryPackage.setMaterialId(item.getMaterialId());
                    deliveryPackage.setMaterialNo(item.getMaterialNo());
                    deliveryPackage.setMaterialDesc(item.getMaterialDesc());

                    logger.info("getTotalQuantity---" + deliveryPackage.getTotalQuantity());
                    logger.info("getDeliveryQuantity---" + deliveryPackage.getDeliveryQuantity());
                    logger.info("getTotalQuantity---" + deliveryPackage.getTotalQuantity());
                    //校验数量书否已经和送货数量一致
                    Integer packageQuantity = deliveryPackage.getPackageQuantity();
                    logger.info("当前包装外包装数量 getPackageQuantity---", packageQuantity);
                    if (packageQuantity == null) {
                        packageQuantity = 0;
                    }
                    Integer deliveryQuantity = deliveryPackage.getDeliveryQuantity();
                    logger.info("当前包装单件数量 getDeliveryQuantity---", deliveryQuantity);
                    if (deliveryQuantity == null) {
                        deliveryQuantity = 0;
                    }
                    TotalQuantity += packageQuantity * deliveryQuantity;
                    logger.info("包装总数量", TotalQuantity);
                    logger.info("送货数量", item.getDeliveryQuantity());
                    logger.info("校验包装总数量书否已经和送货数量一致");
                    if (deliveryQuantity > 0) {
                        if (TotalQuantity > item.getDeliveryQuantity().intValue()) {
                            break;
                        }
                    } else {
                        if (TotalQuantity >= item.getDeliveryQuantity().intValue()) {
                            break;
                        }
                    }
                    logger.info("计算处理新增情况");
                    if (deliveryPackage.getTotalQuantity() != null && deliveryPackage.getTotalQuantity() != 0) {
                        logger.info("--新增送货单插入包装方案：{}", deliveryPackageList.size());
                        if (deliveryPackage.getDeliveryQuantity() == null || deliveryPackage.getDeliveryQuantity() == 0) {
                            deliveryPackage.setDeliveryQuantity(DeliveryQuantity / packageQuantity);
                        }
                        deliveryPackageList.add(deliveryPackage);
                    } else {
                        //发货数量可以平均分配到包装信息中
                        if (DeliveryQuantity % deliveryPackageCount == 0) {
                            logger.info("--发货数量可以平均分配到包装信息中：{}", deliveryPackageTempList.size());
                            if (packageQuantity == 0) {
                                logger.info("----外包装数量为0");
                                Integer defalutPackageQuantity = 1;
                                deliveryPackage.setPackageQuantity(defalutPackageQuantity);
                                deliveryPackage.setTotalQuantity(DeliveryQuantity / deliveryPackageCount);
                                deliveryPackage.setDeliveryQuantity(DeliveryQuantity / deliveryPackageCount);
                                deliveryPackageList.add(deliveryPackage);
                            } else {
                                logger.info("----外包装数量不为0");
                                deliveryPackage.setTotalQuantity((DeliveryQuantity / deliveryPackageCount) * packageQuantity);
                                deliveryPackage.setDeliveryQuantity(DeliveryQuantity / deliveryPackageCount);
                                deliveryPackageList.add(deliveryPackage);
                            }
                        } else {
                            //发货数量可以无法分配到包装信息中
                            logger.info("--发货数量可以无法分配到包装信息中");
                            if (_deliveryPackageIndex < deliveryPackageCount) {
                                if (packageQuantity == 0) {
                                    logger.info("-----外包装数量为0");
                                    deliveryPackage.setPackageQuantity(1);
                                    deliveryPackage.setTotalQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                    deliveryPackage.setDeliveryQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                    deliveryPackageList.add(deliveryPackage);
                                } else {
                                    logger.info("--外包装数量不为0");
                                    deliveryPackage.setTotalQuantity((DeliveryQuantity / (deliveryPackageCount - 1)) * packageQuantity);
                                    deliveryPackage.setDeliveryQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                    deliveryPackageList.add(deliveryPackage);
                                }
                            } else {
                                logger.info("-----无法均分  余数直接打包在最后一个包装上");
                                Integer leftDeliveryQuantity = DeliveryQuantity % (deliveryPackageCount - 1);
                                deliveryPackage.setPackageQuantity(1);
                                deliveryPackage.setTotalQuantity(leftDeliveryQuantity);
                                deliveryPackage.setDeliveryQuantity(leftDeliveryQuantity);
                                deliveryPackageList.add(deliveryPackage);
                            }
                        }
                    }
                }


            } else {
                DeliveryPackage deliveryPackage = new DeliveryPackage();
                deliveryPackage.setUserId(deliveryOrder.getUserId());
                deliveryPackage.setUserName(deliveryOrder.getUserName());
                deliveryPackage.setProjectId(deliveryOrder.getProjectId());
                deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
                deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
                deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                deliveryPackage.setDeliveryOrderItemId(item.getId());
                deliveryPackage.setDeliveryOrderItemNo(item.getDeliveryOrderItemNo());
                // 设置值
                deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
                deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
                deliveryPackage.setMaterialId(item.getMaterialId());
                deliveryPackage.setMaterialNo(item.getMaterialNo());
                deliveryPackage.setMaterialDesc(item.getMaterialDesc());
                deliveryPackage.setPackageQuantity(new Integer(item.getPackQuantity()));
                deliveryPackage.setDeliveryQuantity(item.getDeliveryQuantity().intValue());
                deliveryPackage.setTotalQuantity(item.getDeliveryQuantity().intValue());
                deliveryPackageList.add(deliveryPackage);
            }

            item.setDeliveryPackageLists(deliveryPackageList);
        }
        logger.info("如果没有保存，则先保存");
        // 如果没有保存，则先保存
        if (StringUtils.isBlank(deliveryOrder.getId())) {
            Collections.sort(deliveryOrder.getItems(), new DeliverOrderComparator());
            this.addObj(deliveryOrder);
        }

        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria()
                .andDeliveryOrderIdEqualTo(deliveryOrder.getId());

        DeliveryOrderItem tmpItem = new DeliveryOrderItem();
        tmpItem.setDeliveryStatus(DeliveryStatusEnum.ONWAY.getValue());

        /*//批次号
        String batch = deliveryOrder.getBatch();
        if (StringUtils.isBlank(batch)) {
            batch = deliveryOrderBatchNoService.getBatchNo(deliveryOrder.getCompanyCode());
            deliveryOrder.setBatch(batch);
        }
        tmpItem.setBatch(batch);*/

        //外包装件数

        //修改发运行
        this.deliveryOrderItemService.updateDeliveryOrderItem(tmpItem, deliveryOrderItemExample);

        // 当前记录添加到历史纪录（发货头记录）
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrder.getId(), "发送发货单", date);

        // 3、修改发货单头状态为已发货在途
        deliveryOrder.setDeliveryDate(date);
        deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.ONWAY.getValue());
        this.deliveryOrderMapper.updateByPrimaryKeySelective(deliveryOrder);
    }

    private void handlePurchaseOrderForDeliveryOrder(DeliveryOrder deliveryOrder, boolean isNew) {
        // 1、检查采购方，是否有发布变更的采购订单。如果有，那么就不能发货
        this.isHaverNewOrder(deliveryOrder);

        // 2、计算送货数量，并根据采购订单行分组。map里面， key是 orderItemId, value是 送货数量
        if (isNew) {
            // 新建送货单
            for (DeliveryOrderItem currentItem : deliveryOrder.getItems()) {

                String purchaseOrderItemId = currentItem.getPurOrderItemId();
                if (StringUtils.isBlank(purchaseOrderItemId)) {
                    throw new CommonException("参数异常，送货单行中，缺少采购订单行id");
                }

                SupplierOrderItem item = this.supplierOrderItemService.queryObjById(purchaseOrderItemId);
                //if (currentItem.getDeliveryQuantity().longValue() > item.getDeliveryAmount()) {
                if (currentItem.getDeliveryQuantity().compareTo(item.getDeliveryAmount()) == 1) {
                    throw new CommonException("发货数量大于可发货数量，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！",
                            "delivery_gt_candelivery", "，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！");
                }
                this.updatePurchaseOrderForDelivery(purchaseOrderItemId, currentItem.getDeliveryQuantity());
            }
            return;
        }
        // 如果 送货单id已存在，就是修改送货单，

        List<String> existPurOrderItemIds = new ArrayList<String>(); // 当前的提交的采购订单行id
        for (DeliveryOrderItem currentItem : deliveryOrder.getItems()) {
            existPurOrderItemIds.add(currentItem.getPurOrderItemId());

            String purchaseOrderItemId = currentItem.getPurOrderItemId();
            if (StringUtils.isBlank(purchaseOrderItemId)) {
                throw new CommonException("参数异常，送货单行中，缺少采购订单行id");
            }

            SupplierOrderItem item = this.supplierOrderItemService.queryObjById(purchaseOrderItemId);

            BigDecimal changQuantity = null;
            //Long canDeliveryQuantity = null; // 可发货数量
            BigDecimal canDeliveryQuantity = null;
            DeliveryOrderItem prevouse = null;
            if (StringUtils.isNotBlank(currentItem.getId())) {
                prevouse = this.deliveryOrderItemService.queryObjById(currentItem.getId());
            }

            if (prevouse != null) {
                changQuantity = currentItem.getDeliveryQuantity().subtract(prevouse.getDeliveryQuantity());
                //canDeliveryQuantity = item.getDeliveryAmount() + prevouse.getDeliveryQuantity().longValue();
                canDeliveryQuantity = item.getDeliveryAmount().add(prevouse.getDeliveryQuantity());
            } else {
                changQuantity = currentItem.getDeliveryQuantity();
                //canDeliveryQuantity = item.getDeliveryAmount();
                canDeliveryQuantity = item.getDeliveryAmount();
            }

            //if (currentItem.getDeliveryQuantity().longValue() > canDeliveryQuantity) {
            if (currentItem.getDeliveryQuantity().compareTo(canDeliveryQuantity) == 1) {
                throw new CommonException("发货数量大于可发货数量，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！",
                        "delivery_gt_candelivery", "，请重新录入可发货数量（有可能是该采购订单已发生变更，请刷新界面重新进入）！");
            }
            //if (canDeliveryQuantity < 0) {
            //    canDeliveryQuantity = 0l;
            //}
            if (canDeliveryQuantity.compareTo(BigDecimal.ZERO) == -1) {
                canDeliveryQuantity = BigDecimal.ZERO;
            }
            this.updatePurchaseOrderForDelivery(purchaseOrderItemId, changQuantity);
        }

        // 查询出之前所有的送货行
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        List<DeliveryOrderItem> deliveryOrderItems =
                this.deliveryOrderItemService.queryAllObjByExample(deliveryOrderItemExample);
        logger.info("原始送货单明细：deliveryOrderItems " + deliveryOrderItems.size());
        // 根据之前的送货行，把提交上来的采购订单行去掉，剩余的就是删除的采购订单行
        List<DeliveryOrderItem> existList = new ArrayList<DeliveryOrderItem>();

        for (DeliveryOrderItem item : deliveryOrderItems) {
            String purOrderItemId = item.getPurOrderItemId();
            if (existPurOrderItemIds.contains(purOrderItemId)) {
                existList.add(item);
            }
        }

        deliveryOrderItems.removeAll(existList);
        for (int i = 0; CollectionUtils.isNotEmpty(deliveryOrderItems) && i < deliveryOrderItems.size(); i++) {
            DeliveryOrderItem deliveryOrderItem = deliveryOrderItems.get(i);
            this.updatePurchaseOrderForDelivery(deliveryOrderItem.getPurOrderItemId(),
                    deliveryOrderItem.getDeliveryQuantity().multiply(new BigDecimal(-1)));
        }
    }

    /**
     * 修改采购订单的数量
     *
     * @param id
     * @param deliveryQuantity
     */
    @Override
    public void updatePurchaseOrderForDelivery(String id, BigDecimal deliveryQuantity) {
        if (BigDecimal.ZERO.compareTo(deliveryQuantity) == 0) {
            return;
        }

        SupplierOrderItem supplierOrderItem = this.supplierOrderItemService.queryObjById(id);
        BigDecimal onwayQuantity = supplierOrderItem.getOnwayQuantity().add(deliveryQuantity); // 在途数量
        BigDecimal deliveriedQuantity = supplierOrderItem.getDeliveredQuantity().add(deliveryQuantity); // 发货数量

        BigDecimal freezeQuantity = supplierOrderItem.getFreezeQuantity();// 冻结数量
        if (freezeQuantity == null) {
            freezeQuantity = BigDecimal.ZERO;
        }
        //Long canDeliveryQuantity = supplierOrderItem.getQuantity().subtract(onwayQuantity)
        //        .subtract(supplierOrderItem.getReceivedQuantity()).subtract(freezeQuantity).longValue(); // 可发货数量
        BigDecimal canDeliveryQuantity = supplierOrderItem.getQuantity().subtract(onwayQuantity)
                .subtract(supplierOrderItem.getReceivedQuantity()).subtract(freezeQuantity); // 可发货数量

        SupplierOrderItem tmp = new SupplierOrderItem();
        tmp.setId(id);
        tmp.setDeliveryAmount(canDeliveryQuantity);
        tmp.setOnwayQuantity(onwayQuantity);
        tmp.setDeliveredQuantity(deliveriedQuantity);
        this.supplierOrderItemService.modifyObj(tmp);

        PurchaseOrderItem purchaseOrderItem = this.purchaseOrderItemService.queryObjById(id);
        onwayQuantity = purchaseOrderItem.getOnwayQuantity().add(deliveryQuantity); // 在途数量
        deliveriedQuantity = purchaseOrderItem.getDeliveredQuantity().add(deliveryQuantity); // 发货数量

        freezeQuantity = purchaseOrderItem.getFreezeQuantity();// 冻结数量
        if (freezeQuantity == null) {
            freezeQuantity = BigDecimal.ZERO;
        }
        //canDeliveryQuantity = purchaseOrderItem.getQuantity().subtract(onwayQuantity)
        //        .subtract(purchaseOrderItem.getReceivedQuantity()).subtract(freezeQuantity).longValue(); // 可发货数量
        canDeliveryQuantity = purchaseOrderItem.getQuantity().subtract(onwayQuantity)
                .subtract(purchaseOrderItem.getReceivedQuantity()).subtract(freezeQuantity);
        PurchaseOrderItem tmpPurchaseOrderItem = new PurchaseOrderItem();
        tmpPurchaseOrderItem.setId(id);
        tmpPurchaseOrderItem.setDeliveryAmount(canDeliveryQuantity);
        tmpPurchaseOrderItem.setOnwayQuantity(onwayQuantity);
        tmpPurchaseOrderItem.setDeliveredQuantity(deliveriedQuantity);
        this.purchaseOrderItemService.modifyObj(tmpPurchaseOrderItem);
    }

    /**
     * 检查与送货单关联的采购订单，采购订单是否已经变更了。
     *
     * @param deliveryOrder
     */
    private void isHaverNewOrder(DeliveryOrder deliveryOrder) {
        Set<String> orderNoList = new HashSet<>();
        for (DeliveryOrderItem item : deliveryOrder.getItems()) {
            orderNoList.add(item.getPurOrderNo());
        }

        Iterator<String> orderNoIterator = orderNoList.iterator();

        while (orderNoIterator.hasNext()) {
            // 检查每个采购订单，是否有问题
            String supplierOrderNo = orderNoIterator.next();
            this.isHaveNewOrder(supplierOrderNo, deliveryOrder.getCompanyId());
        }
    }

    /*
     * @CacheEvict(value = { "deliveryOrder" }, allEntries = true)
     *
     * @Transactional
     *
     * @Override public void cancelDelivery(DeliveryOrder deliveryOrder) { List<DeliveryOrderItem> items =
     * deliveryOrder.getItems(); if (CollectionUtils.isEmpty(items)) { throw new CommonException("行数据不存在",
     * "do_not_exists", "行数据"); } Map<String, SupplierOrder> orderIdMap = new HashMap<>(); // 缓存采购单id与对应的采购单 for
     * (DeliveryOrderItem deliveryOrderItem : items) {
     *
     * SupplierOrder sOrder = null; String purOrderId = deliveryOrderItem.getPurOrderId();
     *
     * if (!orderIdMap.containsKey(purOrderId)) { sOrder =
     * this.supplierOrderService.queryObjById(deliveryOrderItem.getPurOrderId()); SupplierOrderItemExample example = new
     * SupplierOrderItemExample(); example.createCriteria().andOrderNoEqualTo(deliveryOrderItem.getPurOrderNo())
     * .andCompanyIdEqualTo(deliveryOrderItem.getCompanyId()); List<SupplierOrderItem> supplierOrderItems =
     * this.supplierOrderItemService .queryAllObjByExample(example); sOrder.setItems(supplierOrderItems); if (sOrder ==
     * null || CollectionUtils.isEmpty(sOrder.getItems())) { throw new CommonException("送货单关联的采购单不存在", "do_not_exists",
     * "送货单关联的采购单"); } // pOrder.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
     * orderIdMap.put(purOrderId, sOrder); } sOrder = orderIdMap.get(purOrderId); for (SupplierOrderItem
     * supplierOrderItemTemp : sOrder.getItems()) { if
     * (!supplierOrderItemTemp.getId().equals(deliveryOrderItem.getPurOrderItemId())) { continue; } // 当前发货的数量
     * BigDecimal currentDeliveryQuantity = deliveryOrderItem.getDeliveryQuantity(); // 已经发货数量 BigDecimal
     * deliveredQuantity = supplierOrderItemTemp.getDeliveredQuantity(); // 在途数量 BigDecimal onwayQuantity =
     * supplierOrderItemTemp.getOnwayQuantity(); // 可发货数量 long deliveryAmount =
     * supplierOrderItemTemp.getDeliveryAmount(); deliveryAmount = deliveryAmount + currentDeliveryQuantity.intValue();
     *
     * BigDecimal deliveredQuantityNew = deliveredQuantity.subtract(currentDeliveryQuantity); BigDecimal
     * onwayQuantityNew = onwayQuantity.subtract(currentDeliveryQuantity);
     * supplierOrderItemTemp.setDeliveredQuantity(deliveredQuantityNew);
     * supplierOrderItemTemp.setOnwayQuantity(onwayQuantityNew);
     * supplierOrderItemTemp.setDeliveryAmount(deliveryAmount); } } // 1、更新采购单数据 for (String key : orderIdMap.keySet())
     * { // 修改采购订单 this.updatePurchaseOrderForDelivery(orderIdMap.get(key)); // 修改销售订单
     * this.updateSupplierOrderForDelivery(orderIdMap.get(key)); }
     *
     * // 2、删除收货单关联数据 ReceiveOrderExample example = new ReceiveOrderExample(); ReceiveOrderExample.Criteria criteria =
     * example.createCriteria(); criteria.andDeliveryOrderIdEqualTo(deliveryOrder.getId());
     * criteria.andDeliveryOrderNoEqualTo(deliveryOrder.getDeliveryOrderNo());
     * receiveOrderService.deleteByExample(example);
     *
     * // 3、修改发货单头状态为未发货 deliveryOrder.setDeliveryDate(null);
     * deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue()); deliveryOrder.setLastUpdateTime(new
     * Date()); // 当前记录添加到历史纪录（发货头记录） String hisId = UUIDGenerator.generateUUID();
     * this.deliveryOrderMapper.insertHis(hisId, deliveryOrder.getId(), "撤销发货单", new Date());
     * this.deliveryOrderMapper.updateByPrimaryKeySelective(deliveryOrder);
     *
     * }
     */

    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Transactional
    @Override
    public void cancellation(List<String> deliveryOrderIdList) {

        for (String id : deliveryOrderIdList) {
            DeliveryOrder deliveryOrder = this.deliveryOrderMapper.selectByPrimaryKey(id);

            // 数据校验
            if (deliveryOrder == null) {
                throw new CommonException("没有找到该发货单", "do_not_exists", "发货单");
            }
            if ((deliveryOrder.getDeliveryStatus() == null)) {
                throw new CommonException("送货单状态不能为空", "base_canot_be_null", "送货单状态");
            }

            // 如果已经收获的，不允许作废
            if (DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())
                    || DeliveryStatusEnum.HK_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())) {
                throw new CommonException("该送货单客户有收货，不可作废发货，谢谢！", "the_customer_has_received_the_goods");
            }

            // 如果送货单已发货，而且生成物流单，要先删除物流单才能作废
            if (StringUtils.isNotEmpty(deliveryOrder.getLogisticOrderNo())) {
                throw new CommonException("该送货单已创建在" + deliveryOrder.getLogisticOrderNo() + "物流单内，请删除物流单后再作废发货单",
                        "delivery_order_backout_error", deliveryOrder.getLogisticOrderNo());
            }

            List<DeliveryOrderItem> deliveryOrderItems = this.deliveryOrderItemService.queryByDeliveryOrderId(id);
            for (int i = 0; CollectionUtils.isNotEmpty(deliveryOrderItems) && i < deliveryOrderItems.size(); i++) {
                // 减少采购订单里面的可发货数量和在途数量
                DeliveryOrderItem deliveryOrderItem = deliveryOrderItems.get(i);
                if (DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrderItem.getDeliveryStatus())
                        || DeliveryStatusEnum.HK_RECEIVED.getValue().equals(deliveryOrderItem.getDeliveryStatus())) {
                    throw new CommonException("该送货单行客户有收货，不可作废发货，谢谢！", "the_customer_has_received_the_goods");
                }
                if (!DeliveryStatusEnum.ONWAY.getValue().equals(deliveryOrderItem.getDeliveryStatus())) {
                    throw new CommonException("送货单"+deliveryOrder.getDeliveryOrderNo()+ "存在非在途状态明细,无法整单作废");
                }
                if (Constant.NO_INT.equals(deliveryOrderItem.getIsEnable())) {
                    throw new CommonException("送货单"+deliveryOrder.getDeliveryOrderNo()+ "存在已经作废的明细,无法整单作废");
                }
                this.updatePurchaseOrderForDelivery(deliveryOrderItem.getPurOrderItemId(),
                        deliveryOrderItem.getDeliveryQuantity().multiply(new BigDecimal(-1)));
            }

            DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
            deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());

            DeliveryOrderItem tempItem = new DeliveryOrderItem();
            tempItem.setIsEnable(Constant.NO_INT);
            this.deliveryOrderItemService.updateDeliveryOrderItem(tempItem, deliveryOrderItemExample);

            // 设置为0
            deliveryOrder.setIsEnable(Constant.NO_INT);
            deliveryOrderMapper.updateByPrimaryKeySelective(deliveryOrder);

            // 当前记录添加到历史纪录（发货头记录）
            String hisId = UUIDGenerator.generateUUID();
            this.deliveryOrderMapper.insertHis(hisId, id, "作废发货单", new Date());
        }
    }

    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Transactional
    @Override
    public void deleteDelivery(List<String> deliveryOrderIdList) {
        for (String id : deliveryOrderIdList) {
            DeliveryOrder deliveryOrder = this.deliveryOrderMapper.selectByPrimaryKey(id);
            if (deliveryOrder == null) {
                throw new CommonException("没有找到该发货单", "do_not_exists", "发货单");
            }
            if (DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())
                    || DeliveryStatusEnum.HK_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())) {
                throw new CommonException("该状态不允许删除");
            }
            // 当前记录添加到历史纪录（发货头记录）
            String hisId = UUIDGenerator.generateUUID();
            this.deliveryOrderMapper.insertHis(hisId, id, "删除发货单", new Date());
        }

        // 删除发货头信息
        DeliveryOrderExample example = new DeliveryOrderExample();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn(deliveryOrderIdList);

        this.deliveryOrderMapper.deleteByExample(example);

        // 删除发货单行之前保存历史记录
        DeliveryOrderItemExample exampleItemQuery = new DeliveryOrderItemExample();
        DeliveryOrderItemExample.Criteria criteriaItemQuery = exampleItemQuery.createCriteria();
        criteriaItemQuery.andDeliveryOrderIdIn(deliveryOrderIdList);
        List<DeliveryOrderItem> itemList = this.deliveryOrderItemService.queryAllObjByExample(exampleItemQuery);

        for (DeliveryOrderItem deliveryOrderItem : itemList) {
            // 减少关封里的发货数量

            // 暂时屏蔽
            /*
             * this.materialSealService.updateDeliveryNum(deliveryOrderItem.getMaterialNo(),
             * deliveryOrderItem.getDeliveryQuantity(), "D");
             */

            String hisItemId = UUIDGenerator.generateUUID();
            this.deliveryOrderItemService.insertHis(hisItemId, deliveryOrderItem.getId(), "删除发货单头_删除发货单行", new Date());

            // 减少采购订单里面的可发货数量和在途数量
            this.updatePurchaseOrderForDelivery(deliveryOrderItem.getPurOrderItemId(),
                    deliveryOrderItem.getDeliveryQuantity().multiply(new BigDecimal(-1)));
        }

        // 删除发货行信息
        DeliveryOrderItemExample exampleItem = new DeliveryOrderItemExample();
        DeliveryOrderItemExample.Criteria criteriaItem = exampleItem.createCriteria();
        criteriaItem.andDeliveryOrderIdIn(deliveryOrderIdList);
        this.deliveryOrderItemService.deleteByExample(exampleItem);
    }

    @Cacheable(value = "deliveryOrder", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<DeliveryOrder> queryHisObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    public PageView<DeliveryOrder> queryDeliveryOrderByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();

        // 送货单
        List<DeliveryOrder> list = this.deliveryOrderMapper.selectByExampleByPage(example);
        if (CollectionUtils.isEmpty(list)) {
            return new PageView<>(1, pageView.getPageSize());
        }

        for (DeliveryOrder deliveryOrder : list) {

            // 送货单行
            DeliveryOrderItemExample exampleItem = new DeliveryOrderItemExample();
            DeliveryOrderItemExample.Criteria criteriaItem = exampleItem.createCriteria();
            criteriaItem.andDeliveryOrderIdEqualTo(deliveryOrder.getId());
            exampleItem.setOrderByClause("DELIVERY_ORDER_ITEM_NO ASC,MATERIAL_NO ASC ,DELIVERY_DATE DESC");

            List<DeliveryOrderItem> itemList = this.deliveryOrderItemService.queryAllObjByExample(exampleItem);
            if (CollectionUtils.isEmpty(itemList)) {
                continue;
            }

            for (DeliveryOrderItem deliveryOrderItem : itemList) {

                if (StringUtils.isNotBlank(deliveryOrderItem.getSupplierMaterialNumber())
                        && StringUtils.isNotBlank(deliveryOrderItem.getSupplierMaterialName())) {
                    continue;
                }

                this.setSupplierMaterialCode(deliveryOrderItem);
            }

            deliveryOrder.setItems(itemList);
        }

        pageView.setQueryResult(list);
        return pageView;
    }

    private void setSupplierMaterialCode(DeliveryOrderItem deliveryOrderItem) {
        // 获取供应商料号和物料描述
        SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
        supplierMaterialExample.createCriteria().andProjectIdEqualTo(deliveryOrderItem.getProjectId())
                .andSupplierCodeEqualTo(deliveryOrderItem.getCompanyCode())
                .andMaterialCodeEqualTo(deliveryOrderItem.getMaterialNo());

        List<SupplierMaterial> supplierMaterialList =
                this.supplierMaterialService.queryAllObjByExample(supplierMaterialExample);

        if (CollectionUtils.isEmpty(supplierMaterialList)) {
            return;
        }
        deliveryOrderItem.setSupplierMaterialName(supplierMaterialList.get(0).getSupplierMaterialDesc());
        deliveryOrderItem.setSupplierMaterialNumber(supplierMaterialList.get(0).getSupplierMaterial());
        // deliveryOrderItem.setDeliveryMaterialName(supplierMaterialList.get(0).getMaterialDesc());
    }

    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Transactional
    @Override
    public void updateForHK(List<String> deliveryOrderIdList) {

        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }
        for (String id : deliveryOrderIdList) {
            // 当前记录添加到历史纪录（发货头记录）
            String hisId = UUIDGenerator.generateUUID();
            this.deliveryOrderMapper.insertHis(hisId, id, "香港到货", new Date());
            DeliveryOrder deliveryOrder = new DeliveryOrder();
            deliveryOrder.setId(id);
            // 香港到货时间
            deliveryOrder.setLastUpdateTime(new Date());
            deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.HK_RECEIVED.getValue());
            // 修改为香港到货
            deliveryOrder.setIsHk(HKStatusEnum.HK.getValue());
            this.deliveryOrderMapper.updateByPrimaryKeySelective(deliveryOrder);

            DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
            deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(id);

            DeliveryOrderItem record = new DeliveryOrderItem();
            record.setDeliveryStatus(DeliveryStatusEnum.HK_RECEIVED.getValue());
            this.deliveryOrderItemService.updateDeliveryOrderItem(record, deliveryOrderItemExample);
        }
    }

    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Override
    public void updateByDeliveryOrder(DeliveryOrder record, DeliveryOrderExample example) {
        this.deliveryOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    public DeliveryOrder createInvoiceData(List<String> purchaseOrderItemIds, String projectId) {
        List<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        deliveryOrder.setItems(items);
        // 获取下一个的Invoice单号
        String invoiceNo = SysUtil.getNextInvoiceNumber();
        deliveryOrder.setDeliveryOrderNo(invoiceNo);
        checkDelivery(purchaseOrderItemIds, projectId, deliveryOrder);

        for (int i = 0; CollectionUtils.isNotEmpty(items) && i < items.size(); i++) {
            DeliveryOrderItem item = items.get(i);
            String purMaterialCode = item.getMaterialNo(); // 华阳的物料编码
            if (StringUtils.isBlank(purMaterialCode)) {
                continue;
            }

            MaterialExample materialExample = new MaterialExample();
            materialExample.createCriteria().andMaterialCodeEqualTo(purMaterialCode);
            List<Material> materialList = this.materialService.queryAllObjByExample(materialExample);
            if (CollectionUtils.isEmpty(materialList) || StringUtils.isBlank(materialList.get(0).getWeight())) {
                continue;
            }

            item.setSingleWeight(new BigDecimal(materialList.get(0).getWeight()));
        }

        return deliveryOrder;
    }

    /**
     * 查询订单的可发货数量
     *
     * @param orderNo     订单号
     * @param orderItemNo 订单行号
     * @param companyId   供应商公司id
     * @return
     */
    /*
     * public SupplierOrderItem getCanDeliveryAmount(String orderNo, String orderItemNo, String companyId) { long
     * canDeliveryAmount = 0; SupplierOrderItem supplierOrderItem = new SupplierOrderItem(); SupplierOrderItemExample
     * example = new SupplierOrderItemExample(); com.els.base.supperorder.entity.SupplierOrderItemExample.Criteria criteria
     * = example.createCriteria(); if (orderNo == null) { orderNo = ""; } if (orderItemNo == null) { orderItemNo = ""; }
     * if (companyId == null) { companyId = ""; } criteria.andOrderNoEqualTo(orderNo);
     * criteria.andOrderItemNoEqualTo(orderItemNo); criteria.andCompanyIdEqualTo(companyId); // List<PurchaseOrderItem>
     * purchaseOrderItemList = purchaseOrderItemService // .queryAllObjByExample(example); List<SupplierOrderItem>
     * supplierOrderItemList = this.supplierOrderItemService .queryAllObjByExample(example); if
     * (CollectionUtils.isNotEmpty(supplierOrderItemList)) { supplierOrderItem = supplierOrderItemList.get(0);
     * BigDecimal quantity = supplierOrderItem.getQuantity() == null ? BigDecimal.ZERO :
     * supplierOrderItem.getQuantity();// 采购订单数量 BigDecimal onwayQuantity = supplierOrderItem.getOnwayQuantity() == null
     * ? BigDecimal.ZERO : supplierOrderItem.getOnwayQuantity();// 在途数量 BigDecimal receivedQuantity =
     * supplierOrderItem.getReceivedQuantity() == null ? BigDecimal.ZERO : supplierOrderItem.getReceivedQuantity();//
     * 收货数量 BigDecimal freezeQuantity = supplierOrderItem.getFreezeQuantity() == null ? BigDecimal.ZERO :
     * supplierOrderItem.getFreezeQuantity(); canDeliveryAmount =
     * quantity.subtract(onwayQuantity).subtract(receivedQuantity) .subtract(freezeQuantity).longValue(); // if
     * (canDeliveryAmount < 0) { // canDeliveryAmount = 0; // } } else { throw new CommonException("没有找到订单号:" +
     * "orderNo" + ",项目号:" + orderItemNo + "的订单记录"); } // 可发货数量 supplierOrderItem.setDeliveryAmount(canDeliveryAmount);
     * return supplierOrderItem; }
     */
    @Override
    public FileData packageListPrint(DeliveryOrderPrint deliveryOrderPrint)
            throws WriterException, IOException, InterruptedException {
        List<DeliveryOrderItem> items = deliveryOrderPrint.getItems();
        logger.info("订单行数据为：" + items);

        if (CollectionUtils.isEmpty(items)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }

        for (DeliveryOrderItem deliveryOrderItem : items) {

            DeliveryPackageExample example = new DeliveryPackageExample();
            example.createCriteria().andProjectIdEqualTo(deliveryOrderItem.getProjectId())
                    .andDeliveryOrderNoEqualTo(deliveryOrderPrint.getDeliveryOrderNo())
                    .andDeliveryOrderItemNoEqualTo(deliveryOrderItem.getDeliveryOrderItemNo());

            List<DeliveryPackage> packageList = this.deliveryPackageService.queryAllObjByExample(example);

            if (CollectionUtils.isEmpty(packageList)) {
                continue;
            }

            deliveryOrderItem.setDeliveryPackageLists(packageList);
        }

        // 进行自定义排序
        Collections.sort(items, new DeliverOrderComparator());

        // FileData returnFileData = SysUtil.packageListPrint(deliveryOrderPrint);
        FileData returnFileData = DeliveryOrderPrintUtils.generateDeliveryOrderPdf(deliveryOrderPrint, "PACKINGLIST");
        if (returnFileData == null) {
            throw new CommonException("pdf文件生成失败", "base_fail");
        }
        return returnFileData;

    }

    @Override
    public List<DeliveryOrderItem> orderItemToDeliveryData(List<String> supplierOrderItemIds, String projectId) {
        List<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        deliveryOrder.setItems(items);
        checkDelivery(supplierOrderItemIds, projectId, deliveryOrder);
        return deliveryOrder.getItems();
    }

    public void updatePurchaseOrderForDelivery(SupplierOrder supplierOrder) {
        List<SupplierOrderItem> items = supplierOrder.getItems();
        for (SupplierOrderItem supplierOrderItem : items) {
            PurchaseOrderItem purchaseOrderItemTemp =
                    this.purchaseOrderItemService.queryObjById(supplierOrderItem.getId());
            PurchaseOrderItem record = new PurchaseOrderItem();
            record.setDeliveredQuantity(supplierOrderItem.getDeliveredQuantity());
            record.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
            record.setId(purchaseOrderItemTemp.getId());
            //long deliveryAmount = SysUtil.getCanDeliveryAmount(purchaseOrderItemTemp.getQuantity(),
            //        supplierOrderItem.getOnwayQuantity(), supplierOrderItem.getReceivedQuantity(),
            //        supplierOrderItem.getFreezeQuantity());
            BigDecimal deliveryAmount = SysUtil.getCanDeliveryAmount(purchaseOrderItemTemp.getQuantity(),
                    supplierOrderItem.getOnwayQuantity(), supplierOrderItem.getReceivedQuantity(),
                    supplierOrderItem.getFreezeQuantity());
            record.setDeliveryAmount(deliveryAmount);
            this.purchaseOrderItemService.modifyObj(record);
        }
    }

    /**
     * 判断采购方是否修改了然后发送的订单
     *
     * @param purchaseOrderNo
     */
    public void isHaveNewOrder(String purchaseOrderNo, String supCompanyId) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(purchaseOrderNo);
        criteria.andSupCompanyIdEqualTo(supCompanyId);

        List<PurchaseOrder> purchaseOrders = this.purchaseOrderHeaderService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(purchaseOrders)) {
            throw new CommonException("数据异常，采购订单[" + purchaseOrderNo + "]，在采购方不存在");
        }

        PurchaseOrder purchaseOrder = purchaseOrders.get(0);
        // 判断是否采购方订单发生变更并且已发送
        if (purchaseOrder != null && purchaseOrder.getOrderStatus() == PurchaseOrderStatusEnum.UNCONFIRM.getValue()
                && purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue()) {
            throw new CommonException("采购订单[" + purchaseOrderNo + "],已发布新订单，旧订单不可创建送货单，谢谢");
        }

    }


    @CacheEvict(value = {"deliveryOrder"}, allEntries = true)
    @Transactional
    @Override
    public void updateDeliveryOrder(DeliveryOrder deliveryOrder) {
        //获取原始发运行明细
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        //读取原始送货单明细行
        logger.info("原始送货单ID：" + deliveryOrder.getId());

        List<DeliveryOrderItem> deliveryOrderItemOldArray = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrder.getId());
        logger.info("原始送货单明细：DeliveryOrderItemOldArray " + deliveryOrderItemOldArray.size());
        List<DeliveryOrderItem> DeliveryOrderItemOldArray = new ArrayList<>();
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrderItemOldArray) {
            DeliveryOrderItem oldDeliveryOrderItem = new DeliveryOrderItem();
            BeanUtils.copyProperties(deliveryOrderItem, oldDeliveryOrderItem);
            DeliveryOrderItemOldArray.add(oldDeliveryOrderItem);
        }
        // 处理采购订单的可发货数量，在途数量
        this.handlePurchaseOrderForDeliveryOrder(deliveryOrder, false);
        logger.info("原始送货单明细：DeliveryOrderItemOldArray " + DeliveryOrderItemOldArray.size());
        // 先删除行
        this.deliveryOrderItemService.deleteByExample(example);

        // 删除包装数
        DeliveryPackageExample deliveryPackageExample = new DeliveryPackageExample();
        deliveryPackageExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        //读取原始包装明细 直接删除新增会导致问题 会导致有多条包装明细数据在新增物料之后变成单条
        List<DeliveryPackage> DeliveryPackageOldArray = this.deliveryPackageService.queryAllObjByExample(deliveryPackageExample);
        this.deliveryPackageService.deleteByExample(deliveryPackageExample);
        logger.info("原始包装明细：" + DeliveryPackageOldArray.size());

        Set<String> purOrderNoList = new HashSet<>();

        // 重新插入送货单行
        int deliveryOrderItemNo = 0;
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {

            //加入提前期控制
            this.checkPurLeadTime(deliveryOrderItem.getCompanyCode(), deliveryOrderItem.getFactoryCode(), deliveryOrderItem.getMaterialNo(),
                    deliveryOrderItem.getPurOrderNo(), deliveryOrderItem.getPurOrderItemNo(), deliveryOrderItem.getDeliveryDate());

            purOrderNoList.add(deliveryOrderItem.getPurOrderNo());
            // 判断采购方是否修改了订单
            this.isHaveNewOrder(deliveryOrderItem.getPurOrderNo(), deliveryOrderItem.getCompanyId());

            deliveryOrderItemNo++;

            deliveryOrderItem.setId(null);
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
            deliveryOrderItem.setType(deliveryOrder.getType());
            deliveryOrderItem.setDeliveryOrderItemNo(String.valueOf(deliveryOrderItemNo));
            deliveryOrderItem.setDeliveryOrderId(deliveryOrder.getId());
            deliveryOrderItem.setProjectId(deliveryOrder.getProjectId());
            deliveryOrderItem.setCompanyId(deliveryOrder.getCompanyId());
            deliveryOrderItem.setUserId(deliveryOrder.getUserId());
            deliveryOrderItem.setUserName(deliveryOrder.getUserName());

//            if (StringUtils.isBlank(deliveryOrderItem.getPackQuantity())) {
//                // 如果包装件数为空，则默认0
//                deliveryOrderItem.setPackQuantity("0");
//            }

            //插入批次号
            if (Constant.YES_STRING.equals(deliveryOrderItem.getBatchFlag())) {
                deliveryOrderItem.setBatch(deliveryOrder.getBatch());
            }
            //如果送货单行收货数量大于0 则修改送货单收货数量为0
            if (StringUtils.isNotEmpty(deliveryOrderItem.getReceiptQuantity())) {
                Double qty = Double.valueOf(deliveryOrderItem.getReceiptQuantity());
                BigDecimal receiptQuantity = BigDecimal.valueOf(qty);
                if (receiptQuantity.compareTo(BigDecimal.ZERO) > 0) {
                    deliveryOrderItem.setReceiptQuantity("0");
                }
            }

            // 插入发货行
            this.deliveryOrderItemService.addObj(deliveryOrderItem);
            logger.info("处理外包装---");
            List<DeliveryPackage> deliveryPackageTempList = deliveryOrderItem.getDeliveryPackageLists();


            List<DeliveryPackage> deliveryPackageTempList2 = new ArrayList<DeliveryPackage>();
            if (CollectionUtils.isNotEmpty(deliveryPackageTempList)) {
                logger.info("原外包装数量---" + deliveryPackageTempList.size());
                logger.info("包装条数：{}", deliveryPackageTempList.size());

                Integer DeliveryQuantity = deliveryOrderItem.getDeliveryQuantity().intValue();
                Integer TotalQuantity = new Integer("0");
                logger.info("插入送货单包装数 送货数量是：{}", DeliveryQuantity);
                Integer deliveryPackageCount = deliveryPackageTempList.size();
                Integer _Index = 0;
                for (DeliveryPackage deliveryPackage2 : deliveryPackageTempList) {
                    _Index++;
                    deliveryPackage2.setUserId(deliveryOrder.getUserId());
                    deliveryPackage2.setUserName(deliveryOrder.getUserName());
                    deliveryPackage2.setProjectId(deliveryOrder.getProjectId());
                    deliveryPackage2.setCompanyId(deliveryOrder.getCompanyId());
                    deliveryPackage2.setDeliveryOrderId(deliveryOrder.getId());
                    deliveryPackage2.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                    deliveryPackage2.setDeliveryOrderItemId(deliveryOrderItem.getId());
                    deliveryPackage2.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());

                    // 设置值
                    deliveryPackage2.setCompanyCode(deliveryOrder.getCompanyCode());
                    deliveryPackage2.setCompanyName(deliveryOrder.getCompanyName());
                    deliveryPackage2.setMaterialId(deliveryOrderItem.getMaterialId());
                    deliveryPackage2.setMaterialNo(deliveryOrderItem.getMaterialNo());
                    deliveryPackage2.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
                    logger.info("getTotalQuantity---" + deliveryPackage2.getTotalQuantity());
                    logger.info("getDeliveryQuantity---" + deliveryPackage2.getDeliveryQuantity());
                    logger.info("getTotalQuantity---" + deliveryPackage2.getTotalQuantity());


                    //校验数量书否已经和送货数量一致
                    Integer packageQuantity = deliveryPackage2.getPackageQuantity();
                    logger.info("当前包装外包装数量 getPackageQuantity---", packageQuantity);
                    if (packageQuantity == null) {
                        packageQuantity = 0;
                    }
                    Integer deliveryQuantity = deliveryPackage2.getDeliveryQuantity();
                    logger.info("当前包装单件数量 getDeliveryQuantity---", deliveryQuantity);
                    if (deliveryQuantity == null) {
                        deliveryQuantity = 0;
                    }
                    TotalQuantity += packageQuantity * deliveryQuantity;
                    logger.info("包装总数量", TotalQuantity);
                    logger.info("送货数量", deliveryOrderItem.getDeliveryQuantity());
                    logger.info("校验包装总数量书否已经和送货数量一致");
                    if (deliveryQuantity > 0) {
                        if (TotalQuantity > deliveryOrderItem.getDeliveryQuantity().intValue()) {
                            break;
                        }
                    } else {
                        if (TotalQuantity >= deliveryOrderItem.getDeliveryQuantity().intValue()) {
                            break;
                        }
                    }

                    // 排除0x0=0的记录或者1x0，0x1=0的记录 包装明细数量不为空
                    logger.info("计算处理新增情况");
                    if (deliveryPackage2.getTotalQuantity() != null && deliveryPackage2.getTotalQuantity() != 0) {
                        logger.info("--新增送货单插入包装方案：{}", deliveryPackageTempList2.size());
                        if (deliveryPackage2.getDeliveryQuantity() == null || deliveryPackage2.getDeliveryQuantity() == 0) {
                            deliveryPackage2.setDeliveryQuantity(DeliveryQuantity / packageQuantity);
                            //deliveryPackage.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                        }
                        deliveryPackageTempList2.add(deliveryPackage2);
                    } else {
                        //发货数量可以平均分配到包装信息中
                        if (DeliveryQuantity % deliveryPackageCount == 0) {
                            logger.info("--发货数量可以平均分配到包装信息中：{}", deliveryPackageTempList.size());
                            if (packageQuantity == 0) {
                                logger.info("--外包装数量为0");
                                Integer defalutPackageQuantity = 1;
                                deliveryPackage2.setPackageQuantity(defalutPackageQuantity);
                                deliveryPackage2.setTotalQuantity(DeliveryQuantity / deliveryPackageCount);
                                deliveryPackage2.setDeliveryQuantity(DeliveryQuantity / deliveryPackageCount);
                                deliveryPackageTempList2.add(deliveryPackage2);
                            } else {
                                logger.info("--外包装数量不为0");
                                deliveryPackage2.setTotalQuantity((DeliveryQuantity / deliveryPackageCount) * packageQuantity);
                                deliveryPackage2.setDeliveryQuantity(DeliveryQuantity / deliveryPackageCount);
                                deliveryPackageTempList2.add(deliveryPackage2);
                            }
                        } else {
                            //发货数量可以无法分配到包装信息中
                            if (_Index < deliveryPackageCount) {
                                if (packageQuantity == 0) {
                                    logger.info("--外包装数量为0");
                                    deliveryPackage2.setPackageQuantity(1);
                                    deliveryPackage2.setTotalQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                    deliveryPackage2.setDeliveryQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                    deliveryPackageTempList2.add(deliveryPackage2);
                                } else {
                                    logger.info("--外包装数量不为0");
                                    deliveryPackage2.setTotalQuantity((DeliveryQuantity / (deliveryPackageCount - 1)) * packageQuantity);
                                    deliveryPackage2.setDeliveryQuantity(DeliveryQuantity / (deliveryPackageCount - 1));
                                    deliveryPackageTempList2.add(deliveryPackage2);
                                }
                            } else {
                                logger.info("--无法均分  余数直接打包在最后一个包装上");
                                Integer leftDeliveryQuantity = DeliveryQuantity % (deliveryPackageCount - 1);
                                deliveryPackage2.setPackageQuantity(1);
                                deliveryPackage2.setTotalQuantity(leftDeliveryQuantity);
                                deliveryPackage2.setDeliveryQuantity(leftDeliveryQuantity);
                                deliveryPackageTempList2.add(deliveryPackage2);
                            }
                        }
                    }


                    //if (deliveryPackage2.getTotalQuantity() != null && deliveryPackage2.getTotalQuantity() != 0) {
                    //    logger.info("getTotalQuantity不为null---");
                    //     deliveryPackageTempList2.add(deliveryPackage2);
                    // } else {
                    //      logger.info("getTotalQuantity为null---");
                    //     deliveryPackage2.setPackageQuantity(new Integer(deliveryOrderItem.getPackQuantity()));
                    //     deliveryPackage2.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                    //     deliveryPackage2.setTotalQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                    //    deliveryPackageTempList2.add(deliveryPackage2);
                    //}
                }

                if (CollectionUtils.isNotEmpty(deliveryPackageTempList2)) {
                    // 保存包装
                    deliveryPackageService.save(deliveryPackageTempList2);
                }

            } else {
                //页面传递过来的包装明细为空
                if (CollectionUtils.isNotEmpty(DeliveryPackageOldArray)) {
                    logger.info("循环遍历查找原始包装明细");
                    List<DeliveryPackage> deliveryPackageTempOld = new ArrayList<DeliveryPackage>();
                    Integer TotalQuantity = 0;
                    //DeliveryOrderItemOldArray
                    DeliveryOrderItem DeliveryOrderItemOld = null;
                    for (DeliveryOrderItem deliveryOrderItemOld : DeliveryOrderItemOldArray) {
                        logger.info("新发运明细发运单号" + deliveryOrderItem.getDeliveryOrderNo());
                        logger.info("原始发运明细下发运单号" + deliveryOrderItemOld.getDeliveryOrderItemNo());
                        logger.info("新发运明细订单号" + deliveryOrderItem.getPurOrderNo());
                        logger.info("原始发运明细订单号" + deliveryOrderItemOld.getPurOrderNo());
                        logger.info("新发运明细订单行id" + deliveryOrderItem.getPurOrderItemId());
                        logger.info("原始发运明细订单行id" + deliveryOrderItemOld.getPurOrderItemId());
                        logger.info("新发运明细订单行号" + deliveryOrderItem.getPurOrderItemNo());
                        logger.info("原始发运明细订单行号" + deliveryOrderItemOld.getPurOrderItemNo());

                        if (deliveryOrderItem.getDeliveryOrderNo().equals(deliveryOrderItemOld.getDeliveryOrderNo())
                                && deliveryOrderItem.getPurOrderNo().equals(deliveryOrderItemOld.getPurOrderNo())
                                && deliveryOrderItem.getPurOrderItemId().equals(deliveryOrderItemOld.getPurOrderItemId())
                                && deliveryOrderItem.getPurOrderItemNo().equals(deliveryOrderItemOld.getPurOrderItemNo())) {
                            DeliveryOrderItemOld = deliveryOrderItemOld;
                            break;
                        }
                    }
                    if (DeliveryOrderItemOld == null) {
                        //新增送货单明细
                        logger.info(" 新增送货单明细 不存在原始包装明细 直接默认一条包装方案");
                        DeliveryPackage deliveryPackage = new DeliveryPackage();
                        deliveryPackage.setUserId(deliveryOrder.getUserId());
                        deliveryPackage.setUserName(deliveryOrder.getUserName());
                        deliveryPackage.setProjectId(deliveryOrder.getProjectId());
                        deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
                        deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
                        deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                        deliveryPackage.setDeliveryOrderItemId(deliveryOrderItem.getId());
                        deliveryPackage.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());

                        // 设置值
                        deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
                        deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
                        deliveryPackage.setMaterialId(deliveryOrderItem.getMaterialId());
                        deliveryPackage.setMaterialNo(deliveryOrderItem.getMaterialNo());
                        deliveryPackage.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
                        deliveryPackage.setPackageQuantity(1);
                        deliveryPackage.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                        deliveryPackage.setTotalQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                        deliveryPackageTempList2.add(deliveryPackage);
                    } else {
                        //原始送货单明细
                        //货源原始送货明细对应的包装方案明细
                        for (DeliveryPackage deliveryPackageOld : DeliveryPackageOldArray) {

                            logger.info("deliveryPackageOld.getDeliveryOrderNo()--" + deliveryPackageOld.getDeliveryOrderNo());
                            logger.info("deliveryPackageOld.getDeliveryOrderItemNo()--" + deliveryPackageOld.getDeliveryOrderItemNo());
                            logger.info("deliveryOrderItem.getDeliveryOrderNo()--" + deliveryOrderItem.getDeliveryOrderNo());
                            logger.info("deliveryOrderItem.getDeliveryOrderItemNo()--" + deliveryOrderItem.getDeliveryOrderItemNo());

                            if (deliveryPackageOld.getDeliveryOrderNo().equals(DeliveryOrderItemOld.getDeliveryOrderNo())
                                    && deliveryPackageOld.getDeliveryOrderItemNo().equals(DeliveryOrderItemOld.getDeliveryOrderItemNo())
                                    && deliveryPackageOld.getDeliveryOrderItemId().equals(DeliveryOrderItemOld.getId())
                                    && deliveryPackageOld.getDeliveryOrderId().equals(DeliveryOrderItemOld.getDeliveryOrderId())) {
                                //
                                logger.info("开始计算原始包装明细数量之和");
                                deliveryPackageTempOld.add(deliveryPackageOld);
                                TotalQuantity += deliveryPackageOld.getTotalQuantity();

                            }

                        }
                        logger.info("原始包装明细数量" + deliveryPackageTempOld.size());
                        logger.info("送货单号---" + deliveryOrderItem.getDeliveryOrderNo() + "---送货单行号---" + deliveryOrderItem.getDeliveryOrderItemNo());
                        logger.info("原始送货数量---" + TotalQuantity);
                        logger.info("现在送货数量---" + deliveryOrderItem.getDeliveryQuantity().intValue());
                        if (TotalQuantity != deliveryOrderItem.getDeliveryQuantity().intValue()) {
                            //送货数量修改
                            logger.info("送货数量改变，且页面尚未维护新的包装方案，直接默认一条包装方案");
                            DeliveryPackage deliveryPackage = new DeliveryPackage();
                            deliveryPackage.setUserId(deliveryOrder.getUserId());
                            deliveryPackage.setUserName(deliveryOrder.getUserName());
                            deliveryPackage.setProjectId(deliveryOrder.getProjectId());
                            deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
                            deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
                            deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                            deliveryPackage.setDeliveryOrderItemId(deliveryOrderItem.getId());
                            deliveryPackage.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());

                            // 设置值
                            deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
                            deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
                            deliveryPackage.setMaterialId(deliveryOrderItem.getMaterialId());
                            deliveryPackage.setMaterialNo(deliveryOrderItem.getMaterialNo());
                            deliveryPackage.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
                            deliveryPackage.setPackageQuantity(1);
                            deliveryPackage.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                            deliveryPackage.setTotalQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                            deliveryPackageTempList2.add(deliveryPackage);

                        } else {
                            logger.info("数量尚未修改  直接复制原始原始包装方案");
                            if (CollectionUtils.isNotEmpty(deliveryPackageTempOld)) {
                                for (DeliveryPackage deliveryPackageOldNew : deliveryPackageTempOld) {
                                    deliveryPackageOldNew.setUserId(deliveryOrder.getUserId());
                                    deliveryPackageOldNew.setUserName(deliveryOrder.getUserName());
                                    deliveryPackageOldNew.setProjectId(deliveryOrder.getProjectId());
                                    deliveryPackageOldNew.setCompanyId(deliveryOrder.getCompanyId());
                                    deliveryPackageOldNew.setDeliveryOrderId(deliveryOrder.getId());
                                    deliveryPackageOldNew.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                                    deliveryPackageOldNew.setDeliveryOrderItemId(deliveryOrderItem.getId());
                                    deliveryPackageOldNew.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());

                                    // 设置值
                                    deliveryPackageOldNew.setCompanyCode(deliveryOrder.getCompanyCode());
                                    deliveryPackageOldNew.setCompanyName(deliveryOrder.getCompanyName());
                                    deliveryPackageOldNew.setMaterialId(deliveryOrderItem.getMaterialId());
                                    deliveryPackageOldNew.setMaterialNo(deliveryOrderItem.getMaterialNo());
                                    deliveryPackageOldNew.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
                                    deliveryPackageTempList2.add(deliveryPackageOldNew);
                                }
                            } else {
                                logger.info("不存在原始包装明细 直接默认一条包装方案");
                                DeliveryPackage deliveryPackage = new DeliveryPackage();
                                deliveryPackage.setUserId(deliveryOrder.getUserId());
                                deliveryPackage.setUserName(deliveryOrder.getUserName());
                                deliveryPackage.setProjectId(deliveryOrder.getProjectId());
                                deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
                                deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
                                deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                                deliveryPackage.setDeliveryOrderItemId(deliveryOrderItem.getId());
                                deliveryPackage.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());

                                // 设置值
                                deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
                                deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
                                deliveryPackage.setMaterialId(deliveryOrderItem.getMaterialId());
                                deliveryPackage.setMaterialNo(deliveryOrderItem.getMaterialNo());
                                deliveryPackage.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
                                deliveryPackage.setPackageQuantity(1);
                                deliveryPackage.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                                deliveryPackage.setTotalQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                                deliveryPackageTempList2.add(deliveryPackage);
                            }
                        }
                    }
                    //

                } else {
                    logger.info("原外包装明细不存在 且页面未维护包装明细");
                    DeliveryPackage deliveryPackage = new DeliveryPackage();
                    deliveryPackage.setUserId(deliveryOrder.getUserId());
                    deliveryPackage.setUserName(deliveryOrder.getUserName());
                    deliveryPackage.setProjectId(deliveryOrder.getProjectId());
                    deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
                    deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
                    deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                    deliveryPackage.setDeliveryOrderItemId(deliveryOrderItem.getId());
                    deliveryPackage.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());

                    // 设置值
                    deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
                    deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
                    deliveryPackage.setMaterialId(deliveryOrderItem.getMaterialId());
                    deliveryPackage.setMaterialNo(deliveryOrderItem.getMaterialNo());
                    deliveryPackage.setMaterialDesc(deliveryOrderItem.getMaterialDesc());


                    Integer packageQuantity = new Integer(deliveryOrderItem.getPackQuantity());
                    Integer deliveryQuantity = deliveryOrderItem.getDeliveryQuantity().intValue();

                    if (deliveryPackage.getTotalQuantity() != null && deliveryPackage.getTotalQuantity() != 0) {
                        logger.info("getTotalQuantity不为null---");

                        if (deliveryPackage.getDeliveryQuantity() == null || deliveryPackage.getDeliveryQuantity() == 0) {
                            deliveryPackage.setDeliveryQuantity(deliveryOrderItem.getDeliveryQuantity().intValue());
                        }

                        deliveryPackageTempList2.add(deliveryPackage);
                    } else {
                        logger.info("getTotalQuantity为null---");

                        deliveryPackage.setPackageQuantity(packageQuantity);
                        deliveryPackage.setDeliveryQuantity(deliveryQuantity / packageQuantity);
                        deliveryPackage.setTotalQuantity(deliveryQuantity);
                        deliveryPackageTempList2.add(deliveryPackage);
                    }
                }
                if (CollectionUtils.isNotEmpty(deliveryPackageTempList2)) {
                    // 保存包装
                    deliveryPackageService.save(deliveryPackageTempList2);
                }
            }
        }

        // 更新送货单头
        String purOrderNoStr = StringUtils.join(purOrderNoList, ",");
        if (StringUtils.isNotBlank(purOrderNoStr) && purOrderNoStr.getBytes().length > 1000)

        {
            throw new CommonException("送货单更新失败，该单关联过多的采购订单号，最多100个不同的的采购订单");
        }

        deliveryOrder.setPurchaseOrderNo(purOrderNoStr);
        deliveryOrder.setLastUpdateTime(new

                Date());
        this.deliveryOrderMapper.updateByPrimaryKeySelective(deliveryOrder);
    }

    @Override
    public DeliveryOrder queryDeliveryOrderId(String deliveryOrderId) {
        DeliveryOrder deliveryOrder = this.deliveryOrderMapper.selectByPrimaryKey(deliveryOrderId);

        List<DeliveryOrderItem> items = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrderId);

        for (DeliveryOrderItem deliveryOrderItem : items) {
            SupplierOrderItem supplierOrderItem =
                    supplierOrderItemService.queryObjById(deliveryOrderItem.getPurOrderItemId());
            if (supplierOrderItem != null) {
                deliveryOrderItem.setQuantity(
                        supplierOrderItem.getQuantity() == null ? BigDecimal.ZERO : supplierOrderItem.getQuantity());

                if (supplierOrderItem.getDeliveryAmount() != null) {
                    //deliveryOrderItem.setCanDeliveryQuantity(new BigDecimal(supplierOrderItem.getDeliveryAmount()));
                    deliveryOrderItem.setCanDeliveryQuantity(supplierOrderItem.getDeliveryAmount());
                }
                if (supplierOrderItem.getReceivedQuantity() != null) {
                    deliveryOrderItem.setReceiptQuantity(supplierOrderItem.getReceivedQuantity().toString());
                }
                if (supplierOrderItem.getOnwayQuantity() != null) {
                    deliveryOrderItem.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
                }
                deliveryOrderItem.setFreezeQuantity(supplierOrderItem.getFreezeQuantity() == null ? BigDecimal.ZERO
                        : supplierOrderItem.getFreezeQuantity());
            }
        }
        deliveryOrder.setItems(items);
        return deliveryOrder;
    }


    @CacheEvict(value = {"deliveryOrder", "deliveryOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void addAll(List<DeliveryOrder> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (DeliveryOrder record : arg0) {
			this.deliveryOrderMapper.insertSelective(record);
		}
	}

    @CacheEvict(value = {"deliveryOrder", "deliveryOrderItem"}, allEntries = true)
	@Override
	public void deleteByExample(DeliveryOrderExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.deliveryOrderMapper.deleteByExample(arg0);
	}

	@Override
	public List<DeliveryOrder> queryAllExpectArriveTime(String timeStart, String timeEnd) {
		// TODO Auto-generated method stub
		return deliveryOrderMapper.queryAllExpectArriveTime(timeStart,timeEnd);
	}
}
