package com.els.base.delivery.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.time.DateFormatUtils;

import com.els.base.delivery.entity.DeliveryOrderPrint;

/**
 * 数据组装
 */
public class DataResultUtils {


    public static Map<String,Object> process(DeliveryOrderPrint deliveryOrderPrint){
        Map<String,Object> root=new HashMap<String,Object>();


        //特殊数据的处理


        //默认数据，防止出现null情况
        if(deliveryOrderPrint.getPurchaseTel()==null){
            deliveryOrderPrint.setPurchaseTel("");
        }
        if(deliveryOrderPrint.getReceiveAddress()==null){
            deliveryOrderPrint.setReceiveAddress("");
        }
        if(deliveryOrderPrint.getPurchasePerson()==null){
            deliveryOrderPrint.setPurchasePerson("");
        }
        if(deliveryOrderPrint.getSupplierTel()==null){
            deliveryOrderPrint.setSupplierTel("");
        }


        //惠州奥华电子有限公司
        root.put("companyName",deliveryOrderPrint.getCompanyName()==null?"":deliveryOrderPrint.getCompanyName());

        //条形码
        root.put("scanPicPath",deliveryOrderPrint.getScanPicPath()==null?"":deliveryOrderPrint.getScanPicPath());

        //送货单号：D201707280000004
        root.put("deliveryOrderNo",deliveryOrderPrint.getDeliveryOrderNo());

        //客户：华阳通用电子有限公司
        root.put("purCompanyName",deliveryOrderPrint.getPurCompanyName());

        //单据日期：2017-07-28
        Date date=deliveryOrderPrint.getDeliveryDate();
        if(date==null){
            date=deliveryOrderPrint.getCreateTime();
        }
        root.put("date",DateFormatUtils.format(date, "yyyy-MM-dd"));

        //收货地址：惠州市东江高新科技产业园上霞北路1号华阳工业园A区
        root.put("receiveAddress",deliveryOrderPrint.getReceiveAddress());

        //供应商联系人：50000112
        root.put("supplierPerson",deliveryOrderPrint.getSupplierPerson());


        //客户联系人：王卫文
        root.put("purchasePerson",deliveryOrderPrint.getPurchasePerson());

        //供应商联系电话：
        root.put("supplierTel",deliveryOrderPrint.getSupplierTel());


        //客户联系电话：13927300139
        root.put("purchaseTel",deliveryOrderPrint.getPurchaseTel());

        // 序号	订单号码	项目	物料号	物料描述	数量	单位	箱数	备注
        // List<DeliveryOrderItemPrint> printItems = deliveryOrderPrint.getPrintItems();

      /*  int materialDescSize=20;

        if(CollectionUtils.isNotEmpty(printItems)){
            for (DeliveryOrderItemPrint deliveryOrderItemPrint : printItems) {

                //物料号长度处理
                String materialNo="";
                if(deliveryOrderItemPrint.getMaterialNo().length()>20){
                    materialNo=deliveryOrderItemPrint.getMaterialNo().substring(0, 20)+"</br></br>"+deliveryOrderItemPrint.getMaterialNo().substring(20, deliveryOrderItemPrint.getMaterialNo().length());
                    deliveryOrderItemPrint.setMaterialNo(materialNo);
                }

                //物料描述处理
                String materialDesc="";
                if(deliveryOrderItemPrint.getMaterialDesc().length()>materialDescSize){
                    materialDesc=deliveryOrderItemPrint.getMaterialDesc().substring(0, materialDescSize)+"</br></br>"+deliveryOrderItemPrint.getMaterialDesc().substring(materialDescSize, deliveryOrderItemPrint.getMaterialDesc().length());
                    deliveryOrderItemPrint.setMaterialDesc(materialDesc);
                }

                //备注
                if(deliveryOrderItemPrint.getRemark()==null){
                    deliveryOrderItemPrint.setRemark("");
                }


            }
        }
        root.put("printItems",printItems);*/


        //root.put("deliveryOrderPrint",deliveryOrderPrint);
        return  root;
    }


}
