package com.els.base.delivery.utils;

import com.els.base.delivery.entity.DeliveryOrderItem;
import org.apache.commons.lang.StringUtils;

import java.util.Comparator;

/**
 * 自定义送货单行字段排序
 */
public class DeliverOrderComparator implements Comparator<DeliveryOrderItem> {

    @Override
    public int compare(DeliveryOrderItem o1, DeliveryOrderItem o2) {

        if (o1==null){
            return -1;
        }

        if (o2==null){
            return 1;
        }

        if (StringUtils.isBlank(o1.getCaseNo()) && StringUtils.isNotBlank(o2.getCaseNo())){
            return -1;
        }

        if (StringUtils.isNotBlank(o1.getCaseNo()) && StringUtils.isBlank(o2.getCaseNo())){
            return 1;
        }
        
        if(StringUtils.isNotBlank(o1.getCaseNo()) 
        		&& StringUtils.isNotBlank(o2.getCaseNo()) 
        		&& o1.getCaseNo().compareTo(o2.getCaseNo()) != 0){
        	
            return o1.getCaseNo().compareTo(o2.getCaseNo());
        }

        if (StringUtils.isBlank(o1.getMaterialNo()) && StringUtils.isNotBlank(o2.getMaterialNo())){
            return -1;
        }

        if (StringUtils.isNotBlank(o1.getMaterialNo()) && StringUtils.isBlank(o2.getMaterialNo())){
            return 1;
        }
        
        if (StringUtils.isNotBlank(o1.getMaterialNo()) 
        		&& StringUtils.isNotBlank(o2.getMaterialNo())) {
        	return o1.getMaterialNo().compareTo(o2.getMaterialNo());
		}

        return 0;

    }
}
