package com.els.base.delivery.utils;
/**
 * 订单收交状态
 * @author Administrator
 *
 */
public enum DeliveryStatusEnum {

	UN_RECEIVED(1, "未发货"), 
	ONWAY(2, "订单发货在途"), 
	ALL_RECEIVED(3, "全部收货"),
	HK_RECEIVED(4, "香港到货"),
	REFUSE(5, "拒绝收货"),
	SOME_RECEIVED(6, "部分收货");

	private final Integer value;
	private final String desc;

	// 构造器默认也只能是private, 从而保证构造函数只能在内部使用
	DeliveryStatusEnum(Integer value, String desc) {
		this.value = value;
		this.desc = desc;
	}

	public Integer getValue() {
		return value;
	}

	public String getDesc() {
		return desc;
	}

}
