package com.els.base.delivery.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.DeliveryOrderBatchNo;
import com.els.base.delivery.entity.DeliveryOrderBatchNoExample;
import com.els.base.delivery.service.DeliveryOrderBatchNoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="送货单批次号记录")
@Controller
@RequestMapping("deliveryOrderBatchNo")
public class DeliveryOrderBatchNoController {
    @Resource
    protected DeliveryOrderBatchNoService deliveryOrderBatchNoService;

   /* @ApiOperation(httpMethod="POST", value="创建送货单批次号记录")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DeliveryOrderBatchNo deliveryOrderBatchNo) {
        this.deliveryOrderBatchNoService.addObj(deliveryOrderBatchNo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑送货单批次号记录")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DeliveryOrderBatchNo deliveryOrderBatchNo) {
        Assert.isNotBlank(deliveryOrderBatchNo.getId(), "id 为空，保存失败");
        this.deliveryOrderBatchNoService.modifyObj(deliveryOrderBatchNo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除送货单批次号记录")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.deliveryOrderBatchNoService.deleteObjById(id);
        return ResponseResult.success();
    }*/

    @ApiOperation(httpMethod="POST", value="查询送货单批次号记录")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 DeliveryOrderBatchNo", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderBatchNo>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderBatchNoExample example = new DeliveryOrderBatchNoExample();
        example.setPageView(new PageView<DeliveryOrderBatchNo>(pageNo, pageSize));
        
        DeliveryOrderBatchNoExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<DeliveryOrderBatchNo> pageData = this.deliveryOrderBatchNoService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}