package com.els.base.leadtime.service;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;
import com.els.base.leadtime.entity.PurLeadTime;
import com.els.base.leadtime.entity.PurLeadTimeExample;

import java.util.List;

public interface PurLeadTimeService extends BaseService<PurLeadTime, PurLeadTimeExample, String> {
    /**
     * 创建
     * @param project
     * @param company
     * @param loginUser
     * @param purLeadTime
     */
    void create(Project project, Company company, User loginUser, PurLeadTime purLeadTime);

    /**
     * 批量删除
     * @param ids
     */
    void deleteObjByIds(List<String> ids);

    /**
     * 编辑
     * @param project
     * @param company
     * @param loginUser
     * @param purLeadTime
     */
    void edit(Project project, Company company, User loginUser, PurLeadTime purLeadTime);

	void importFromExcel(Project project, Company currentCompany, User loginUser, List<PurLeadTime> list);
}