package com.els.base.logistic.service;

import java.util.List;

import com.els.base.core.service.BaseService;
import com.els.base.logistic.entity.LogisticOrder;
import com.els.base.logistic.entity.LogisticOrderExample;
import com.els.base.purchase.entity.PurchaseOrder;

public interface LogisticOrderService extends BaseService<LogisticOrder, LogisticOrderExample, String> {
	/**
	 * 删除物流
	 * @param logisticOrderIdList
	 */
	public void deleteLogisticOrder(List<String> logisticOrderIdList);
	/**
	 * 生成物流单数据
	 * @param deliveryOrderIdList
	 * @return
	 */
	public LogisticOrder createLogisticOrderData(List<String> deliveryOrderIdList);
	/**
	 * 保存物流单
	 * @param logisticOrder
	 * @return
	 */
	public void saveLogisticOrder(LogisticOrder logisticOrder);
	/**
	 * 根据物流单号或者发货单号查询司机、车牌信息
	 * @param queryNo 物流单号或者发货单号
	 * @param type E(物流单号) D(发货单号)
	 * @return
	 */
	public LogisticOrder queryLogisticOrder(String queryNo,String type);
	/**
	 * 根据物流单号或者发货单号查询采购单信息
	 * @param queryNo 物流单号或者发货单号
	 * @param type E(物流单号) D(发货单号)
	 * @return
	 */
	public List<PurchaseOrder> queryPurchaseOrder(String queryNo,String type);

}