package com.els.base.orderchange.web.controller;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.orderchange.entity.PurchaseOrderChange;
import com.els.base.orderchange.entity.PurchaseOrderChangeExample;
import com.els.base.orderchange.service.PurchaseOrderChangeService;

import com.els.base.orderchange.util.BillStatusConfirmEnum;
import com.els.base.purchase.entity.*;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.supperorder.entity.SupplierOrder;
import com.els.base.supperorder.entity.SupplierOrderExample;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.supperorder.entity.SupplierOrderItemExample;
import com.els.base.supperorder.service.SupplierOrderItemService;
import com.els.base.supperorder.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value = "订单变更申请")
@Controller
@RequestMapping("purchaseOrderChange")
public class PurchaseOrderChangeController {
    Logger logger = LoggerFactory.getLogger(PurchaseOrderChangeController.class);
    @Resource
    protected PurchaseOrderChangeService purchaseOrderChangeService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;

    @ApiOperation(httpMethod = "POST", value = "创建订单变更申请")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseOrderChange purchaseOrderChange) {
        this.purchaseOrderChangeService.addObj(purchaseOrderChange);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑订单变更申请")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseOrderChange purchaseOrderChange) {
        if (StringUtils.isBlank(purchaseOrderChange.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.purchaseOrderChangeService.modifyObj(purchaseOrderChange);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "caozuo订单变更申请")
    @RequestMapping("service/oper")
    @ResponseBody
    public ResponseResult<String> oper(@RequestBody List<PurchaseOrderChange> purchaseOrderChange) {
        this.purchaseOrderChangeService.importFromSap(purchaseOrderChange);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除订单变更申请")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.purchaseOrderChangeService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询订单变更申请(采购方)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 PurchaseOrderChange", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderChange>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(
                SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isEmpty(companyList)) {
            throw new CommonException("当前用户没有分配供应商");
        }
        List<String> companyCodeList = new ArrayList<String>();
        for (Company company : companyList) {
            companyCodeList.add(company.getCompanySapCode());
        }

        List<String> confirmStatus = new ArrayList<String>();
        confirmStatus.add("0");
        confirmStatus.add("1");
        confirmStatus.add("2");

        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        PurchaseOrderChangeExample.Criteria criteria = example.createCriteria()
                .andSupCompanySapCodeIn(companyCodeList)
                .andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andConfirmStatusIn(confirmStatus)
                .andStatusNotEqualTo("CLOSE");
        example.setPageView(new PageView<PurchaseOrderChange>(pageNo, pageSize));

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView<PurchaseOrderChange> pageData = this.purchaseOrderChangeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "变更申请确认")
    @RequestMapping("service/supplierChangeApplyConfirm")
    @ResponseBody
    public ResponseResult<String> supplierChangeApplyConfirm(
            @RequestBody List<PurchaseOrderChange> purchaseOrderChangeList) {
        //校验
        this.filterForChangeApplyConfirm(purchaseOrderChangeList);

        for (PurchaseOrderChange purchaseOrderChange : purchaseOrderChangeList) {
           /* if (purchaseOrderChange.getRemark() != null && purchaseOrderChange.getRemark().length() > 255) {
                throw new CommonException("输入的参数长度超标", "database_length_error");
            }*/

            //1、采购订单需要变更为已经确认
            this.updatePurOrder(purchaseOrderChange);

            this.updateSupOrder(purchaseOrderChange);

            //2、变更清单里面也需要变成已经确认
            purchaseOrderChange.setConfirmStatus(BillStatusConfirmEnum.STATUS_CONFIRM.getCode());
            this.purchaseOrderChangeService.modifyObj(purchaseOrderChange);
        }
        return ResponseResult.success();

    }

    /**
     * 更新供应商采购订单
     *
     * @param purchaseOrderChange
     */
    private void updateSupOrder(PurchaseOrderChange purchaseOrderChange) {
        Assert.isNotNull(purchaseOrderChange, "更新的采购订单不能为空！");
        String orderNo = purchaseOrderChange.getOrderNo();
        String orderItemNo = purchaseOrderChange.getOrderItemNo();
        String supCompanyId = purchaseOrderChange.getSupCompanyId();
        logger.info("变更供应商ID为：{}", supCompanyId);
        logger.info("变更供应商订单号为：{}", orderNo);
        logger.info("变更供应商订单行号为：{}", orderItemNo);

        logger.info("=======更新供应商采购订单状态为已确认开始=========");
        SupplierOrderExample supplierOrderExample = new SupplierOrderExample();
        supplierOrderExample.createCriteria()
                .andCompanyIdEqualTo(supCompanyId)
                .andOrderNoEqualTo(orderNo);
        List<SupplierOrder> supplierOrders = this.supplierOrderService.queryAllObjByExample(supplierOrderExample);
        if (CollectionUtils.isEmpty(supplierOrders)) {
            return;
        }

        //确认状态：1订单未确认，2已确认，3已退回
        for (SupplierOrder supplierOrder : supplierOrders) {
            //取消修改采购订单状态
            //supplierOrder.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
            supplierOrderService.modifyObj(supplierOrder);
        }
        logger.info("=======更新供应商采购订单状态为已确认结束=========");

        logger.info("=======更新供应商采购订单行状态为已确认开始=========");
        SupplierOrderItemExample supplierOrderItemExample = new SupplierOrderItemExample();
        supplierOrderItemExample.createCriteria()
                .andCompanyIdEqualTo(supCompanyId)
                .andOrderNoEqualTo(orderNo)
                .andOrderItemNoEqualTo(orderItemNo);
        List<SupplierOrderItem> supplierOrderItems = supplierOrderItemService.queryAllObjByExample(supplierOrderItemExample);
        if (CollectionUtils.isEmpty(supplierOrderItems)) {
            return;
        }
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            supplierOrderItem.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
            this.supplierOrderItemService.modifyObj(supplierOrderItem);
        }
        logger.info("=======更新供应商采购订单行状态为已确认结束=========");
    }


    private void updatePurOrder(PurchaseOrderChange purchaseOrderChange) {
        Assert.isNotNull(purchaseOrderChange, "更新的采购订单不能为空！");
        String orderNo = purchaseOrderChange.getOrderNo();
        String orderItemNo = purchaseOrderChange.getOrderItemNo();
        String supCompanyId = purchaseOrderChange.getSupCompanyId();
        logger.info("变更供应商ID为：{}", supCompanyId);
        logger.info("变更供应商订单号为：{}", orderNo);
        logger.info("变更供应商订单行号为：{}", orderItemNo);

        logger.info("=======更新采购订单状态为已确认开始=========");
        PurchaseOrderExample purchaseOrderExample = new PurchaseOrderExample();
        purchaseOrderExample.createCriteria()
                .andSupCompanyIdEqualTo(supCompanyId)
                .andOrderNoEqualTo(orderNo);
        List<PurchaseOrder> purchaseOrders = this.purchaseOrderService.queryAllObjByExample(purchaseOrderExample);
        if (CollectionUtils.isEmpty(purchaseOrders)) {
            return;
        }
        for (PurchaseOrder purchaseOrder : purchaseOrders) {
            //取消修改采购订单状态
            //purchaseOrder.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
            this.purchaseOrderService.updateByPrimaryKeySelective(purchaseOrder);
        }
        logger.info("=======更新采购订单状态为已确认结束=========");

        logger.info("=======更新采购订单行状态为已确认开始=========");
        PurchaseOrderItemExample purchaseOrderItemExample = new PurchaseOrderItemExample();
        purchaseOrderItemExample.createCriteria()
                .andSupCompanyIdEqualTo(supCompanyId)
                .andOrderNoEqualTo(orderNo)
                .andOrderItemNoEqualTo(orderItemNo);
        List<PurchaseOrderItem> purchaseOrderItems = this.purchaseOrderItemService.queryAllObjByExample(purchaseOrderItemExample);
        if (CollectionUtils.isEmpty(purchaseOrderItems)) {
            return;
        }
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrderItems) {
            purchaseOrderItem.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
            this.purchaseOrderItemService.modifyObj(purchaseOrderItem);
        }
        logger.info("=======更新采购订单行状态为已确认结束=========");

    }

    /**
     * 校验该订单是否已经发送过了
     *
     * @param purchaseOrderChangeList
     */
    private void filterForChangeApplyConfirm(List<PurchaseOrderChange> purchaseOrderChangeList) {
        Assert.isNotEmpty(purchaseOrderChangeList, "没有查询到数据");
        for (int i = 0; i < purchaseOrderChangeList.size(); i++) {
            String id = purchaseOrderChangeList.get(i).getId();
//            PurchaseOrderChange changeOrder = this.purchaseOrderChangeService.queryObjById(id);
            PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
            PurchaseOrderChangeExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(id);
            criteria.andStatusEqualTo("NEW");
            List<PurchaseOrderChange> changeOrders = purchaseOrderChangeService.queryAllObjByExample(example);
            Assert.isNotEmpty(changeOrders, "未找到此订单");
            PurchaseOrderChange changeOrder = changeOrders.get(0);
            if (changeOrder != null && changeOrder.getConfirmStatus().equals("2")) {
                throw new CommonException("该变更申请已再次发送，此次操作的数据为旧数据，请重新选择确认的数据。", "old_data", "该变更申请已再次发送，");
            }
        }
    }

    @ApiOperation(httpMethod = "POST", value = "查询订单变更申请(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 PurchaseOrderChange", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/findChangeOrderOfSupplier")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderChange>> findChangeOrderOfSupplier(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        Company currentCompany = CompanyUtils.currentCompany();
        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        List<String> confirmStatus = new ArrayList<String>();
        confirmStatus.add("0");
        confirmStatus.add("1");
        confirmStatus.add("2");
        PurchaseOrderChangeExample.Criteria criteria = example.createCriteria()
                //.andSupCompanySapCodeEqualTo(currentCompany.getCompanySapCode())
                .andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                .andConfirmStatusIn(confirmStatus)
                .andStatusNotEqualTo("CLOSE");
        example.setPageView(new PageView<PurchaseOrderChange>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        //增加排序
        example.setOrderByClause("ORDER_NO, ORDER_ITEM_NO,APPLY_DATE DESC, DELIVERY_DATE DESC, VOUCHER_DATE DESC,ORDER_DATE DESC");

        PageView<PurchaseOrderChange> pageData = this.purchaseOrderChangeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value = "订单变更导出Excel(全部)", httpMethod = "GET")
    @RequestMapping(value = "service/downloadChangeOrderOfSupplierExcel")
    @ResponseBody
    public ModelAndView downloadChangeOrderOfSupplierExcel(String queryParams, HttpServletResponse response) {
        try {
            logger.info("订单变更导出Excel 参数" + queryParams);
//            Company currentCompany = CompanyUtils.currentCompany();
            PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
//            List<String> confirmStatus = new ArrayList<String>();
//            confirmStatus.add("0");
//            confirmStatus.add("1");
//            confirmStatus.add("2");
            PurchaseOrderChangeExample.Criteria criteria = example.createCriteria()
                    //.andSupCompanySapCodeEqualTo(currentCompany.getCompanySapCode())
                    .andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
//                    .andConfirmStatusIn(confirmStatus)
                    .andStatusNotEqualTo("CLOSE");
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            example.setOrderByClause("ORDER_NO, ORDER_ITEM_NO,APPLY_DATE DESC, DELIVERY_DATE DESC, VOUCHER_DATE DESC,ORDER_DATE DESC");
            List<PurchaseOrderChange> purchaseOrderChangeList = this.purchaseOrderChangeService.queryAllObjByExample(example);
            logger.info("订单变更导出Excel 数据条数" + purchaseOrderChangeList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "订单变更" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("订单变更导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("客户简称", "purCompanyName"));
//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factoryName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单号", "orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行项目号", "orderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receiveQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("在途数量", "onwayQuantity"));
//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单位", "unit"));
//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("净价", "noTaxPrice"));
//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价税合计", "itemPriceTaxTotal"));
//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("币别", "currency"));

            TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("订单日期", "orderDate");
            DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter);
            titleAndModelKey.setToStrConverter(dateConverter);
            titleAndModelKeys.add(titleAndModelKey);

            TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("最新交货日期", "deliveryDate");
            DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter2);
            titleAndModelKey.setToStrConverter(dateConverter2);
            titleAndModelKeys.add(titleAndModelKey2);

            TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey("变更前交货日期", "beforeDeliveryDate");
            DateConverter dateConverter3 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter3);
            titleAndModelKey.setToStrConverter(dateConverter3);
            titleAndModelKeys.add(titleAndModelKey3);

            TitleAndModelKey titleAndModelKey4 = ExcelUtils.createTitleAndModelKey("申请日期", "applyDate");
            DateConverter dateConverter4 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter4);
            titleAndModelKey.setToStrConverter(dateConverter4);
            titleAndModelKeys.add(titleAndModelKey4);


//            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "remark"));

            logger.info("订单变更导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    purchaseOrderChangeList, "采购订单报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("订单变更导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    @ApiOperation(value = "订单变更导出Excel(选中)", httpMethod = "GET")
    @RequestMapping(value = "service/downloadChangeOrderOfSupplierExcelSelect")
    @ResponseBody
    public ModelAndView downloadChangeOrderOfSupplierExcelSelect(
            @ApiParam(value = "ids", defaultValue = "") @RequestParam(defaultValue = "") String ids,
            HttpServletResponse response) {
        try {
            PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
            PurchaseOrderChangeExample.Criteria criteria = example.createCriteria();
            criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(
                    ProjectUtils.getProjectId());
            if (StringUtils.isNotBlank(ids)) {
                criteria.andIdIn(Arrays.asList(ids.split(",")));
            }
            example.setOrderByClause("ORDER_NO, ORDER_ITEM_NO,APPLY_DATE DESC, DELIVERY_DATE DESC, VOUCHER_DATE DESC,ORDER_DATE DESC");
            List<PurchaseOrderChange> purchaseOrderChangeList = this.purchaseOrderChangeService.queryAllObjByExample(example);
            logger.info("订单变更导出Excel 数据条数" + purchaseOrderChangeList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "订单变更" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("订单变更导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单号", "orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行项目号", "orderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receiveQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("在途数量", "onwayQuantity"));

            TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("订单日期", "orderDate");
            DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter);
            titleAndModelKey.setToStrConverter(dateConverter);
            titleAndModelKeys.add(titleAndModelKey);

            TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("最新交货日期", "deliveryDate");
            DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter2);
            titleAndModelKey.setToStrConverter(dateConverter2);
            titleAndModelKeys.add(titleAndModelKey2);

            TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey("变更前交货日期", "beforeDeliveryDate");
            DateConverter dateConverter3 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter3);
            titleAndModelKey.setToStrConverter(dateConverter3);
            titleAndModelKeys.add(titleAndModelKey3);

            TitleAndModelKey titleAndModelKey4 = ExcelUtils.createTitleAndModelKey("申请日期", "applyDate");
            DateConverter dateConverter4 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter4);
            titleAndModelKey.setToStrConverter(dateConverter4);
            titleAndModelKeys.add(titleAndModelKey4);
            logger.info("订单变更导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    purchaseOrderChangeList, "采购订单报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("订单变更导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }




}