package com.els.base.purchase.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel(value="采购方订单头")
public class PurchaseOrder implements Serializable {

    //	------------以下非自动生成，请勿覆盖------------------------

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

	/** 操作历史id */
	@JsonIgnore
	private String hisId;

	@ApiModelProperty("操作原因")
	private String cause;

	@ApiModelProperty("订单行")
	private List<PurchaseOrderItem> items;

    public String getHisId() {
		return hisId;
	}

	public void setHisId(String hisId) {
		this.hisId = hisId;
	}

	public String getCause() {
		return cause;
	}

	public void setCause(String cause) {
		this.cause = cause;
	}

	public List<PurchaseOrderItem> getItems() {
		return items;
	}

	public void setItems(List<PurchaseOrderItem> items) {
		this.items = items;
	}

    //	------------------------------------

	private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("采购企业id")
    private String companyId;

    @ApiModelProperty("采购企业名称")
    private String companyName;

    @ApiModelProperty("公司编码")
    private String companyCode;

    @ApiModelProperty("采购员id")
    private String userId;

    @ApiModelProperty("采购员名称")
    private String userName;

    @ApiModelProperty("采购组织")
    private String departmentId;

    @ApiModelProperty("采购组织名称")
    private String departmentName;

    @ApiModelProperty("供应商id")
    private String supCompanyId;

    @ApiModelProperty("供应企业名称")
    private String supCompanyName;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应员ID")
    private String supUserId;

    @ApiModelProperty("供应员名称")
    private String supUserName;

    @ApiModelProperty("采购订单号")
    private String orderNo;

    @ApiModelProperty("订单类型")
    private String orderType;

    @ApiModelProperty("订单状态：1订单未确认，2已确认，3已退回")
    private Integer orderStatus;

    @ApiModelProperty("订单发送状态：1未发送，2已发送，3变更未发送，4变更已发送")
    private Integer orderSendStatus;

    @ApiModelProperty("采购订单生成日期")
    private Date orderDate;

    @ApiModelProperty("交收状态 1:未交收2：订单发货在途3：部分交收4：全部交收")
    private Integer deliveryStatus;

    @ApiModelProperty("采购员备注")
    private String purRemark;

    @ApiModelProperty("供应商备注")
    private String supRemark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("发送供应商时间")
    private Date sendTime;

    @ApiModelProperty("税率")
    private String taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("汇率")
    private String exchangeRate;

    @ApiModelProperty("审批状态：1-审批通过，2-未审批，3-审批中，4-审批拒绝")
    private Integer auditStatus;

    @ApiModelProperty("审批标识：审批标识 Y 已审批")
    private String isAudit;

    @ApiModelProperty("付款条件")
    private String payTerms;

    @ApiModelProperty("付款条件描述")
    private String payTermsDesc;

    @ApiModelProperty("币别")
    private String currency;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("总数量")
    private BigDecimal totalQuantity;

    @ApiModelProperty("是否删除，1未删除，0删除,2冻结")
    private Integer isEnable;

    @ApiModelProperty("版本")
    private String version;

    @ApiModelProperty("供应商电话")
    private String supplierTel;

    @ApiModelProperty("供应商传值")
    private String supplierTax;

    @ApiModelProperty("供应商联系人")
    private String supplierPersion;

    @ApiModelProperty("采购组")
    private String purchaseGroup;

    @ApiModelProperty("单据名称")
    private String billName;

    @ApiModelProperty("地址号码")
    private String addressNo;

    @ApiModelProperty("采购凭证类型(单据类型)")
    private String voucherType;

    @ApiModelProperty("价税合计")
    private String priceTaxTotal;

    @ApiModelProperty("供应商办公室的责任销售员")
    private String salePerson;

    @ApiModelProperty("税码")
    private String saleTaxCode;

    @ApiModelProperty("税率描述")
    private String addedTax;

    @ApiModelProperty("抬头文本")
    private String headTxt;

    @ApiModelProperty("供应商简称")
    private String supShortName;

    @ApiModelProperty("SAP公司代码")
    private String purSapCompanyCode;

    @ApiModelProperty("国际类型：国内采购1；转厂订单2；香港上料3.")
    private String interType;

    @ApiModelProperty("附件")
    private String attachment;

    @ApiModelProperty("变更次数")
    private Integer changeTimes;

    @ApiModelProperty("订单类型描述")
    private String orderTypeDesc;

    @ApiModelProperty("汇总号")
    private String gatherNo;

    @ApiModelProperty("康尼合同号")
    private String contractNo;

    @ApiModelProperty("暂存标识")
    private String tempStorageFlag;

    @ApiModelProperty("SAP创建人描述")
    private String createUserName;

    @ApiModelProperty("SAP公司名称")
    private String butxt;

    @ApiModelProperty("SAP公司编码")
    private String bukrs;

    @ApiModelProperty("含税金额")
    private BigDecimal priceHs;

    @ApiModelProperty("首批订单生成时间")
    private Date firstOrderDate;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode == null ? null : companyCode.trim();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId == null ? null : departmentId.trim();
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName == null ? null : departmentName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType == null ? null : orderType.trim();
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getOrderSendStatus() {
        return orderSendStatus;
    }

    public void setOrderSendStatus(Integer orderSendStatus) {
        this.orderSendStatus = orderSendStatus;
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public String getPurRemark() {
        return purRemark;
    }

    public void setPurRemark(String purRemark) {
        this.purRemark = purRemark == null ? null : purRemark.trim();
    }

    public String getSupRemark() {
        return supRemark;
    }

    public void setSupRemark(String supRemark) {
        this.supRemark = supRemark == null ? null : supRemark.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public String getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate == null ? null : taxRate.trim();
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate == null ? null : exchangeRate.trim();
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getIsAudit() {
        return isAudit;
    }

    public void setIsAudit(String isAudit) {
        this.isAudit = isAudit == null ? null : isAudit.trim();
    }

    public String getPayTerms() {
        return payTerms;
    }

    public void setPayTerms(String payTerms) {
        this.payTerms = payTerms == null ? null : payTerms.trim();
    }

    public String getPayTermsDesc() {
        return payTermsDesc;
    }

    public void setPayTermsDesc(String payTermsDesc) {
        this.payTermsDesc = payTermsDesc == null ? null : payTermsDesc.trim();
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version == null ? null : version.trim();
    }

    public String getSupplierTel() {
        return supplierTel;
    }

    public void setSupplierTel(String supplierTel) {
        this.supplierTel = supplierTel == null ? null : supplierTel.trim();
    }

    public String getSupplierTax() {
        return supplierTax;
    }

    public void setSupplierTax(String supplierTax) {
        this.supplierTax = supplierTax == null ? null : supplierTax.trim();
    }

    public String getSupplierPersion() {
        return supplierPersion;
    }

    public void setSupplierPersion(String supplierPersion) {
        this.supplierPersion = supplierPersion == null ? null : supplierPersion.trim();
    }

    public String getPurchaseGroup() {
        return purchaseGroup;
    }

    public void setPurchaseGroup(String purchaseGroup) {
        this.purchaseGroup = purchaseGroup == null ? null : purchaseGroup.trim();
    }

    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName == null ? null : billName.trim();
    }

    public String getAddressNo() {
        return addressNo;
    }

    public void setAddressNo(String addressNo) {
        this.addressNo = addressNo == null ? null : addressNo.trim();
    }

    public String getVoucherType() {
        return voucherType;
    }

    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType == null ? null : voucherType.trim();
    }

    public String getPriceTaxTotal() {
        return priceTaxTotal;
    }

    public void setPriceTaxTotal(String priceTaxTotal) {
        this.priceTaxTotal = priceTaxTotal == null ? null : priceTaxTotal.trim();
    }

    public String getSalePerson() {
        return salePerson;
    }

    public void setSalePerson(String salePerson) {
        this.salePerson = salePerson == null ? null : salePerson.trim();
    }

    public String getSaleTaxCode() {
        return saleTaxCode;
    }

    public void setSaleTaxCode(String saleTaxCode) {
        this.saleTaxCode = saleTaxCode == null ? null : saleTaxCode.trim();
    }

    public String getAddedTax() {
        return addedTax;
    }

    public void setAddedTax(String addedTax) {
        this.addedTax = addedTax == null ? null : addedTax.trim();
    }

    public String getHeadTxt() {
        return headTxt;
    }

    public void setHeadTxt(String headTxt) {
        this.headTxt = headTxt == null ? null : headTxt.trim();
    }

    public String getSupShortName() {
        return supShortName;
    }

    public void setSupShortName(String supShortName) {
        this.supShortName = supShortName == null ? null : supShortName.trim();
    }

    public String getPurSapCompanyCode() {
        return purSapCompanyCode;
    }

    public void setPurSapCompanyCode(String purSapCompanyCode) {
        this.purSapCompanyCode = purSapCompanyCode == null ? null : purSapCompanyCode.trim();
    }

    public String getInterType() {
        return interType;
    }

    public void setInterType(String interType) {
        this.interType = interType == null ? null : interType.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public Integer getChangeTimes() {
        return changeTimes;
    }

    public void setChangeTimes(Integer changeTimes) {
        this.changeTimes = changeTimes;
    }

    public String getOrderTypeDesc() {
        return orderTypeDesc;
    }

    public void setOrderTypeDesc(String orderTypeDesc) {
        this.orderTypeDesc = orderTypeDesc == null ? null : orderTypeDesc.trim();
    }

    public String getGatherNo() {
        return gatherNo;
    }

    public void setGatherNo(String gatherNo) {
        this.gatherNo = gatherNo == null ? null : gatherNo.trim();
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo == null ? null : contractNo.trim();
    }

    public String getTempStorageFlag() {
        return tempStorageFlag;
    }

    public void setTempStorageFlag(String tempStorageFlag) {
        this.tempStorageFlag = tempStorageFlag == null ? null : tempStorageFlag.trim();
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getButxt() {
        return butxt;
    }

    public void setButxt(String butxt) {
        this.butxt = butxt == null ? null : butxt.trim();
    }

    public String getBukrs() {
        return bukrs;
    }

    public void setBukrs(String bukrs) {
        this.bukrs = bukrs == null ? null : bukrs.trim();
    }

    public BigDecimal getPriceHs() {
        return priceHs;
    }

    public void setPriceHs(BigDecimal priceHs) {
        this.priceHs = priceHs;
    }

    public Date getFirstOrderDate() {
        return firstOrderDate;
    }

    public void setFirstOrderDate(Date firstOrderDate) {
        this.firstOrderDate = firstOrderDate;
    }
}