package com.els.base.purchase.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="采购订单报表")
public class PurchaseOrderReport implements Serializable {
    @ApiModelProperty("单据行号")
    private String rowNo;

    @ApiModelProperty("供应商订单行Id")
    private String id;

    @ApiModelProperty("公司ID")
    private String companyId;

    @ApiModelProperty("采购订单类型描述")
    private String orderTypeDesc;

    @ApiModelProperty("采购订单号")
    private String orderNo;

    @ApiModelProperty("行项目号")
    private String orderItemNo;

    @ApiModelProperty("确认状态")
    private String orderStatus;

    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("删除标识")
    private String isEnable;
    @ApiModelProperty("退货项目")
    private String backGoodsItem;
    @ApiModelProperty("项目类别描述")
    private String itemDescription;
    @ApiModelProperty("工厂")
    private String factory;
    @ApiModelProperty("物料编码")
    private String materialCode;
    @ApiModelProperty("物料描述")
    private String materialName;
    @ApiModelProperty("规格")
    private String specification;
    @ApiModelProperty("图号")
    private String mapNo;
    @ApiModelProperty("订单数量")
    private String quantity;
    @ApiModelProperty("订单单位")
    private String orderUnit;
    @ApiModelProperty("交货日期")
    private Date deliveredDate;
    @ApiModelProperty("已收货数量")
    private String receivedQuantity;
    @ApiModelProperty("待收货数量")
    private String waitReceiveQuantity;
    @ApiModelProperty("交货已完成")
    private String finishFlag;
    @ApiModelProperty("订单日期")
    private Date mOrderDate;
    @ApiModelProperty("采购员名称（对应SRM创建者名称）")
    private String buyerName;
    @ApiModelProperty("需求跟踪号")
    private String needFollowNo;
    @ApiModelProperty("净价")
    private BigDecimal noTaxPrice;
    @ApiModelProperty("价格单位")
    private String priceUnit;
    @ApiModelProperty("金额")
    private String orderValue;
    @ApiModelProperty("价税合计")
    private BigDecimal priceTaxTotal;
    @ApiModelProperty("币别")
    private String currency;
    @ApiModelProperty("WBS项目号")
    private String wbsNo;
    @ApiModelProperty("项目描述")
    private String projectDesc;
    @ApiModelProperty("WBS项目描述")
    private String wbsNoDesc;
    @ApiModelProperty("理论交货日")
    private Date theoryDeliverDate;
    @ApiModelProperty("是否紧急")
    private String isUrgency;
    @ApiModelProperty("采购周期")
    private String purchasePeriod;
    @ApiModelProperty("库存地点")
    private String storageSite;
    @ApiModelProperty("采购信息记录")
    private String purchaseInfoRecord;
    @ApiModelProperty("采购协议号")
    private String purchaseProtocalNo;
    @ApiModelProperty("采购协议项目")
    private String purchaseProtocalItemNo;
    @ApiModelProperty("采购申请号")
    private String purReqNo;
    @ApiModelProperty("采购申请行号")
    private String purchaseApplyItemNo;
    @ApiModelProperty("采购申请创建人")
    private String purApplyCreator;
    @ApiModelProperty("需求者")
    private String needer;
    @ApiModelProperty("可发货数量")
    private Long deliveryAmount;
    @ApiModelProperty("在途数量")
    private BigDecimal onwayQuantity;
    @ApiModelProperty("预制发票数量")
    private BigDecimal preInvoiceQuantity;
    @ApiModelProperty("发票已过账数量")
    private BigDecimal postAccountQuantity;
    @ApiModelProperty("待开发票数量")
    private BigDecimal waitInvoiceQuantity;
    @ApiModelProperty("供应商编码")
    private String supCompanyCode;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("供应商名称全称")
    private String supCompanyFullName;

    @ApiModelProperty("仅显示未清采购订单")
    private String outStanding;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    @ApiModelProperty("备用字段6")
    private String attribute6;

    @ApiModelProperty("备用字段7")
    private String attribute7;

    @ApiModelProperty("备用字段8")
    private String attribute8;

    @ApiModelProperty("备用字段9")
    private String attribute9;

    @ApiModelProperty("备用字段10")
    private String attribute10;

    @ApiModelProperty("首批标记")
    private Integer firstFlag;



    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName;
    }


    public String getRowNo() {
        return rowNo;
    }

    public void setRowNo(String rowNo) {
        this.rowNo = rowNo;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getOrderTypeDesc() {
        return orderTypeDesc;
    }

    public void setOrderTypeDesc(String orderTypeDesc) {
        this.orderTypeDesc = orderTypeDesc;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderItemNo() {
        return orderItemNo;
    }

    public void setOrderItemNo(String orderItemNo) {
        this.orderItemNo = orderItemNo;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(String isEnable) {
        this.isEnable = isEnable;
    }

    public String getBackGoodsItem() {
        return backGoodsItem;
    }

    public void setBackGoodsItem(String backGoodsItem) {
        this.backGoodsItem = backGoodsItem;
    }

    public String getItemDescription() {
        return itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo;
    }

    public String getQuantity() {
        return quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public String getOrderUnit() {
        return orderUnit;
    }

    public void setOrderUnit(String orderUnit) {
        this.orderUnit = orderUnit;
    }

    public Date getDeliveredDate() {
        return deliveredDate;
    }

    public void setDeliveredDate(Date deliveredDate) {
        this.deliveredDate = deliveredDate;
    }

    public String getReceivedQuantity() {
        return receivedQuantity;
    }

    public void setReceivedQuantity(String receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
    }

    public String getWaitReceiveQuantity() {
        return waitReceiveQuantity;
    }

    public void setWaitReceiveQuantity(String waitReceiveQuantity) {
        this.waitReceiveQuantity = waitReceiveQuantity;
    }

    public String getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(String finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Date getMOrderDate() {
        return mOrderDate;
    }

    public void setMOrderDate(Date mOrderDate) {
        this.mOrderDate = mOrderDate;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getNeedFollowNo() {
        return needFollowNo;
    }

    public void setNeedFollowNo(String needFollowNo) {
        this.needFollowNo = needFollowNo;
    }

    public BigDecimal getNoTaxPrice() {
        return noTaxPrice;
    }

    public void setNoTaxPrice(BigDecimal noTaxPrice) {
        this.noTaxPrice = noTaxPrice;
    }

    public String getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(String priceUnit) {
        this.priceUnit = priceUnit;
    }

    public String getOrderValue() {
        return orderValue;
    }

    public void setOrderValue(String orderValue) {
        this.orderValue = orderValue;
    }

    public BigDecimal getPriceTaxTotal() {
        return priceTaxTotal;
    }

    public void setPriceTaxTotal(BigDecimal priceTaxTotal) {
        this.priceTaxTotal = priceTaxTotal;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getWbsNo() {
        return wbsNo;
    }

    public void setWbsNo(String wbsNo) {
        this.wbsNo = wbsNo;
    }

    public String getProjectDesc() {
        return projectDesc;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc;
    }

    public String getWbsNoDesc() {
        return wbsNoDesc;
    }

    public void setWbsNoDesc(String wbsNoDesc) {
        this.wbsNoDesc = wbsNoDesc;
    }

    public Date getTheoryDeliverDate() {
        return theoryDeliverDate;
    }

    public void setTheoryDeliverDate(Date theoryDeliverDate) {
        this.theoryDeliverDate = theoryDeliverDate;
    }

    public String getIsUrgency() {
        return isUrgency;
    }

    public void setIsUrgency(String isUrgency) {
        this.isUrgency = isUrgency;
    }

    public String getPurchasePeriod() {
        return purchasePeriod;
    }

    public void setPurchasePeriod(String purchasePeriod) {
        this.purchasePeriod = purchasePeriod;
    }

    public String getStorageSite() {
        return storageSite;
    }

    public void setStorageSite(String storageSite) {
        this.storageSite = storageSite;
    }

    public String getPurchaseInfoRecord() {
        return purchaseInfoRecord;
    }

    public void setPurchaseInfoRecord(String purchaseInfoRecord) {
        this.purchaseInfoRecord = purchaseInfoRecord;
    }

    public String getPurchaseProtocalNo() {
        return purchaseProtocalNo;
    }

    public void setPurchaseProtocalNo(String purchaseProtocalNo) {
        this.purchaseProtocalNo = purchaseProtocalNo;
    }

    public String getPurchaseProtocalItemNo() {
        return purchaseProtocalItemNo;
    }

    public void setPurchaseProtocalItemNo(String purchaseProtocalItemNo) {
        this.purchaseProtocalItemNo = purchaseProtocalItemNo;
    }

    public String getPurReqNo() {
        return purReqNo;
    }

    public void setPurReqNo(String purReqNo) {
        this.purReqNo = purReqNo;
    }

    public String getPurchaseApplyItemNo() {
        return purchaseApplyItemNo;
    }

    public void setPurchaseApplyItemNo(String purchaseApplyItemNo) {
        this.purchaseApplyItemNo = purchaseApplyItemNo;
    }

    public String getPurApplyCreator() {
        return purApplyCreator;
    }

    public void setPurApplyCreator(String purApplyCreator) {
        this.purApplyCreator = purApplyCreator;
    }

    public String getNeeder() {
        return needer;
    }

    public void setNeeder(String needer) {
        this.needer = needer;
    }

    public Long getDeliveryAmount() {
        return deliveryAmount;
    }

    public void setDeliveryAmount(Long deliveryAmount) {
        this.deliveryAmount = deliveryAmount;
    }

    public BigDecimal getOnwayQuantity() {
        return onwayQuantity;
    }

    public void setOnwayQuantity(BigDecimal onwayQuantity) {
        this.onwayQuantity = onwayQuantity;
    }

    public BigDecimal getPreInvoiceQuantity() {
        return preInvoiceQuantity;
    }

    public void setPreInvoiceQuantity(BigDecimal preInvoiceQuantity) {
        this.preInvoiceQuantity = preInvoiceQuantity;
    }

    public BigDecimal getPostAccountQuantity() {
        return postAccountQuantity;
    }

    public void setPostAccountQuantity(BigDecimal postAccountQuantity) {
        this.postAccountQuantity = postAccountQuantity;
    }

    public BigDecimal getWaitInvoiceQuantity() {
        return waitInvoiceQuantity;
    }

    public void setWaitInvoiceQuantity(BigDecimal waitInvoiceQuantity) {
        this.waitInvoiceQuantity = waitInvoiceQuantity;
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode;
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName;
    }

    public String getOutStanding() {
        return outStanding;
    }

    public void setOutStanding(String outStanding) {
        this.outStanding = outStanding;
    }

    public Date getmOrderDate() {
        return mOrderDate;
    }

    public void setmOrderDate(Date mOrderDate) {
        this.mOrderDate = mOrderDate;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4;
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5;
    }

    public String getAttribute6() {
        return attribute6;
    }

    public void setAttribute6(String attribute6) {
        this.attribute6 = attribute6;
    }

    public String getAttribute7() {
        return attribute7;
    }

    public void setAttribute7(String attribute7) {
        this.attribute7 = attribute7;
    }

    public String getAttribute8() {
        return attribute8;
    }

    public void setAttribute8(String attribute8) {
        this.attribute8 = attribute8;
    }

    public String getAttribute9() {
        return attribute9;
    }

    public void setAttribute9(String attribute9) {
        this.attribute9 = attribute9;
    }

    public String getAttribute10() {
        return attribute10;
    }

    public void setAttribute10(String attribute10) {
        this.attribute10 = attribute10;
    }

    public Integer getFirstFlag() {
        return firstFlag;
    }

    public void setFirstFlag(Integer firstFlag) {
        this.firstFlag = firstFlag;
    }
}
