package com.els.base.purchase.service;

import com.els.base.company.entity.Company;
import com.els.base.core.service.BaseService;
import com.els.base.file.entity.FileData;
import com.els.base.purchase.entity.LabelPrintRecord;
import com.els.base.purchase.entity.LabelPrintRecordExample;
import com.els.base.purchase.entity.LabelPrintRecordExtend;

import java.util.List;

public interface LabelPrintRecordService extends BaseService<LabelPrintRecord, LabelPrintRecordExample, String> {

	/**
	 * 获取原来的rid流水号
	 * @param projectId
	 * @param company
	 * @return
	 */
	long getOldRidSerialNumber(String projectId,Company company);

	/**
	 * 在查询送货单管理界面生成打印记录
	 * @param ids
	 * @return
	 */
	 List<LabelPrintRecord> createPrintDataDelivery(List<String> ids);

	/**
	 * 保存二维码数据
	 * @param projectId
	 * @param company
	 * @param items
	 */
	 List<LabelPrintRecord> saveLabelPrintRecord(String projectId, Company company, List<LabelPrintRecord> items);

	/**
	 * 添加二维码导出到EXCEL功能
	 * @param ids
	 * @return
	 */
	 List<LabelPrintRecord> exportToExcel(List<String> ids);

	/**
	 * 添加二维码内箱数据导出到EXCEL功能
	 * @param ids
	 * @return
	 */
	 List<LabelPrintRecordExtend> innerBoxList(String printType,List<LabelPrintRecord> items, String projectId, Company company);

	/**
	 * 添加二维码外箱数据导出到EXCEL功能
	 * @param ids
	 * @return
	 */
	 List<LabelPrintRecordExtend> outterBoxBoxList(String printType,List<LabelPrintRecord> items, String projectId, Company company);


	/**
	 * 打印二维码
	 * @param items
	 * @param projectId
	 * @param company
	 * @return
	 */
	List<FileData> printQRcode(String printType,List<LabelPrintRecord> items, String projectId, Company company) throws Exception;
	
	/**
	 * 打印二维码
	 * @param items
	 * @param projectId
	 * @param company
	 * @return
	 */
	List<FileData> knPrintMaterialQRcode(String printType,List<LabelPrintRecord> items, String projectId, Company company) throws Exception;
}