package com.els.base.purchase.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.purchase.dao.PurchaseOrderItemMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.PurchaseOrderReport;
import com.els.base.purchase.entity.PurchaseOrderReportExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.SysUtil;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.supperorder.service.SupplierOrderItemService;

@Service("purchaseOrderItemService")
public class PurchaseOrderItemServiceImpl implements PurchaseOrderItemService {
    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderItemServiceImpl.class);
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected CompanyService companyService;

    @Resource
    protected PurchaseOrderItemMapper purchaseOrderItemMapper;

    @Resource
    protected PurchaseOrderService purchaseOrderHeaderService;

    @Resource
    protected SupplierOrderItemService supplierOrderItemService;

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public void addObj(PurchaseOrderItem t) {
        this.purchaseOrderItemMapper.insertSelective(t);
    }

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setId(id);
        item.setIsEnable(Constant.NO_INT);
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(item);
    }

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public void modifyObj(PurchaseOrderItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "purchaseOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public PurchaseOrderItem queryObjById(String id) {
        return this.purchaseOrderItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "purchaseOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public List<PurchaseOrderItem> queryAllObjByExample(PurchaseOrderItemExample example) {
        return this.purchaseOrderItemMapper.selectByExample(example);
    }

    @Cacheable(value = "purchaseOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<PurchaseOrderItem> queryObjByPage(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectByExampleByPage(example);
        for (PurchaseOrderItem purchaseOrderItem : items) {
            //可发货数量的设置

            if (Constant.YES_STRING.equals(purchaseOrderItem.getFinishFlag())) {
                //purchaseOrderItem.setDeliveryAmount(0l);
                purchaseOrderItem.setDeliveryAmount(new BigDecimal(0));
                continue;
            }
            if (purchaseOrderItem.getDeliveryAmount() == null) {
                purchaseOrderItem.setDeliveryAmount(SysUtil.getCanDeliveryAmount(purchaseOrderItem.getQuantity(),
                        purchaseOrderItem.getOnwayQuantity(), purchaseOrderItem.getReceivedQuantity(), purchaseOrderItem.getFreezeQuantity()));
            }
        }
        pageView.setQueryResult(items);
        return pageView;
    }

    @Cacheable(value = "purchaseOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<PurchaseOrderItem> queryHisAllObjByExample(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderItemMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public void deleteByOrderId(String orderId) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(orderId);

        this.purchaseOrderItemMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public void insertHisByOrderId(String orderHisId, String orderId, String cause, String version) {
        this.purchaseOrderItemMapper.insertHis(orderHisId, orderId, cause, version);
    }

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public int insertHis(String hisId, String orderId, String cause, String version) {
        // TODO Auto-generated method stub
        return purchaseOrderItemMapper.insertHis(hisId, orderId, cause, version);
    }

    @Override
    public PageView<PurchaseOrderItem> queryPurchaseOrderItemByPage(Map<String, Object> map) {
        @SuppressWarnings("unchecked")
        PageView<PurchaseOrderItem> pageView = (PageView<PurchaseOrderItem>) map.get("pageView");
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectPurchaseOrderItemByPage(map);
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    public String selectMaxVersion() {
        // TODO Auto-generated method stub
        return purchaseOrderItemMapper.selectMaxVersion();
    }

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public void updateByPurcahseOrder(PurchaseOrderItem record, PurchaseOrderItemExample example) {
        this.purchaseOrderItemMapper.updateByExample(record, example);
    }

    @Override
    public PurchaseOrderItem queryByMaterialCode(String materialCode, String supCompanyCode) {
        PurchaseOrderItem purchaseOrderItem = new PurchaseOrderItem();
        //查询供应商物料号
        SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
        supplierMaterialExample.createCriteria()
                .andCompanySapCodeEqualTo(supCompanyCode)
                .andMaterialCodeEqualTo(materialCode);
        List<SupplierMaterial> supplierMaterialList = this.supplierMaterialService.queryAllObjByExample(supplierMaterialExample);
        if (!CollectionUtils.isEmpty(supplierMaterialList)) {
            for (SupplierMaterial sm : supplierMaterialList) {
                if (StringUtils.isNotBlank(sm.getSupplierMaterial())) {
                    purchaseOrderItem.setSupMaterialCode(sm.getSupplierMaterial());
                    break;
                }
            }
        }
        //查在途数量,累加采购订单的在途数量
        double onwayQuantity = purchaseOrderItemMapper.calculateOnwayQuantity(materialCode, supCompanyCode);
        purchaseOrderItem.setOnwayQuantity(new BigDecimal(onwayQuantity));
        return purchaseOrderItem;
    }

    @Override
    public List<PurchaseOrderItem> selectForExcel(PurchaseOrderExample purchaseOrder) {
        // TODO Auto-generated method stub
        return this.purchaseOrderItemMapper.selectForExcel(purchaseOrder);
    }

    @Override
    public List<PurchaseOrderItem> selectForExcelFirst(PurchaseOrderExample purchaseOrder) {
        // TODO Auto-generated method stub
        return this.purchaseOrderItemMapper.selectForExcelFirst(purchaseOrder);
    }

    //	@CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
//	@Override
//	public void updateByPrimaryKey(PurchaseOrderItem purchaseOrderItem) {
//		this.purchaseOrderItemMapper.updateByPrimaryKey(purchaseOrderItem);
//		
//	}
    @Override
    public PageView<PurchaseOrderReport> selectPurchOrderReportByPage(PurchaseOrderReportExample example) {
        // TODO Auto-generated method stub
        PageView<PurchaseOrderReport> pageView = example.getPageView();
        List<PurchaseOrderReport> items = this.purchaseOrderItemMapper.selectPurchOrderReportByPage(example);
        logger.info(String.valueOf(items.size()));
        pageView.setQueryResult(items);
        return pageView;
    }
    @Override
    public List<PurchaseOrderReport> selectPurchOrderReportforExcel(PurchaseOrderReportExample example) {
        // TODO Auto-generated method stub
        return this.purchaseOrderItemMapper.selectPurchOrderReportforExcel(example);
    }


    @Override
    public  PageView<PurchaseOrderReport> selectReturnPoByPage(PurchaseOrderReportExample example) {
        PageView<PurchaseOrderReport> pageView = example.getPageView();
        List<PurchaseOrderReport> items = this.purchaseOrderItemMapper.selectReturnPOByPage(example);
        logger.info(String.valueOf(items.size()));
        pageView.setQueryResult(items);
        return pageView;
    }



    @Override
    public List<String> queryOrderNoByUserName(String userName) {
        return purchaseOrderItemMapper.queryOrderNoByUserName(userName, Constant.YES_INT);
    }

    @Override
    public List<String> queryOrderNoAll() {
        return purchaseOrderItemMapper.queryOrderNoAll(Constant.YES_INT, Constant.YES_INT);
    }
 
    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Override
    public void sendOrderItem(List<PurchaseOrderItem> list) {

        logger.info("sendOrderItem");
        for (PurchaseOrderItem item : list) {

            item.setUpdateTime(new Date());
            // 如果是变更未发送或者变更已发送
            logger.info("如果是变更未发送或者变更已发送");
            item.setAttribute1(String.valueOf(PurchaseOrderSendStatusEnum.SENDED.getValue()));
            //
            this.purchaseOrderItemMapper.updateByPrimaryKeySelective(item);
            //
            SupplierOrderItem supplierOrderItem = this.supplierOrderItemService.queryObjById(item.getId());
            if (supplierOrderItem == null) {
                //供应商订单行不存在
                logger.info("供应商订单行不存在");
                supplierOrderItem = new SupplierOrderItem();
                BeanUtils.copyProperties(item, supplierOrderItem);

                PurchaseOrder purchaseOrder=this.purchaseOrderHeaderService.queryObjById(item.getOrderId());

                supplierOrderItem.setUserId(purchaseOrder.getSupUserId());
                supplierOrderItem.setUserName(purchaseOrder.getSupUserName());
                supplierOrderItem.setCompanyId(purchaseOrder.getSupCompanyId());
                supplierOrderItem.setCompanyName(purchaseOrder.getSupCompanyName());
                supplierOrderItem.setPurUserId(purchaseOrder.getUserId());
                supplierOrderItem.setPurUserName(purchaseOrder.getUserName());
                supplierOrderItem.setPurCompanyId(purchaseOrder.getCompanyId());
                supplierOrderItem.setPurCompanyName(purchaseOrder.getCompanyName());
                supplierOrderItem.setSapSupCompanyCode(purchaseOrder.getSupCompanySapCode());
                //添加项目类别
                supplierOrderItem.setItemDescription(item.getItemDescription());
                supplierOrderItem.setItemType(item.getItemType());
                supplierOrderItem.setOrderType(purchaseOrder.getOrderType());
                supplierOrderItem.setOrderTypeDesc(purchaseOrder.getOrderTypeDesc());
                supplierOrderItem.setNeedFollowNo(item.getNeedFollowNo());
                supplierOrderItem.setWbsNo(item.getWbsNo());
                supplierOrderItem.setWbsNoDesc(item.getWbsNoDesc());
                supplierOrderItem.setAttribute1(String.valueOf(PurchaseOrderSendStatusEnum.SENDED.getValue()));
                supplierOrderItem.setUpdateTime(new Date());
                logger.info("新增订单行");
                this.supplierOrderItemService.addObj(supplierOrderItem);
            } else {
                logger.info("修改订单行");
                supplierOrderItem.setAttribute1(String.valueOf(PurchaseOrderSendStatusEnum.SENDED.getValue()));
                supplierOrderItem.setUpdateTime(new Date());
                this.supplierOrderItemService.modifyObj(supplierOrderItem);
            }
            //PurchaseOrder purchaseOrderHeader = this.purchaseOrderHeaderService.queryObjById(item.getOrderId());
            //SupplierOrderItem supplierOrderItem = SysUtil.purhcaseItemTosSupplierItem(purchaseOrderHeader, item);
            //supplierOrderItemService.addObj(supplierOrderItem);
        }
        //发送消息
        this.sendMessages(list);

    }


    private void sendMessages(List<PurchaseOrderItem> list) {
        // 通过供应商公司id查询用户
        //User user = companyUserRefService.queryMainUserOfCompany(purchaseOrder.getSupCompanyId());
        //if (user != null) {
        //    supplierOrder.setUserId(user.getId());
        //    supplierOrder.setUserName(user.getNickName());
        //    purchaseOrder.setSupUserId(user.getId());
        //   purchaseOrder.setSupUserName(user.getNickName());

        //   Message<PurchaseOrder> message = new Message<PurchaseOrder>(purchaseOrder.getCompanyCode(),
        //           purchaseOrder.getUserId(), user.getId(), OrderBusinessTypeEnum.PO_NEW_SEND.getCode(),
        //           MessageLevelEnum.MIDDLE, purchaseOrder);
        //   MessageSendUtils.sendMessage(message);

        // }
    }

	@Override
	public List<PurchaseOrderItem> purFindOverdue(String purUserId, Date date) {
		List<PurchaseOrderItem> purchaseOrderItemList=this.purchaseOrderItemMapper.purFindOverdue(purUserId,date);	
		return purchaseOrderItemList;
	}


    @Override
    public PageView<PurchaseOrderItem> queryFirstOrderByExample(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectFirstOrderByExampleByPage(example);
        logger.info(String.valueOf(items.size()));
        pageView.setQueryResult(items);
        return pageView;
    }


    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void addAll(List<PurchaseOrderItem> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (PurchaseOrderItem record : arg0) {
			this.purchaseOrderItemMapper.insertSelective(record);
		}
	}

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
	@Override
	public void deleteByExample(PurchaseOrderItemExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.purchaseOrderItemMapper.deleteByExample(arg0);
	}

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void updateByExampleSelective(PurchaseOrderItem purchaseOrderItem,
			PurchaseOrderItemExample purchaseOrderItemExample) {
		this.purchaseOrderItemMapper.updateByExampleSelective(purchaseOrderItem, purchaseOrderItemExample);
		
	}

    @CacheEvict(value = {"purchaseOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void modifyByExample(PurchaseOrderItem availableItems, PurchaseOrderItemExample purchaseOrderItemExample) {
		this.purchaseOrderItemMapper.updateByExampleSelective(availableItems, purchaseOrderItemExample);

	}
}