package com.els.base.purchase.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.dao.user.UserMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.file.entity.FileData;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.orderchange.entity.PurchaseOrderChange;
import com.els.base.orderchange.service.PurchaseOrderChangeService;
import com.els.base.orderchange.util.BillStatusConfirmEnum;
import com.els.base.purchase.dao.PurchaseOrderItemMapper;
import com.els.base.purchase.dao.PurchaseOrderMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.SaleOrderService;
import com.els.base.purchase.service.interceptor.UpdatePurchaseOrderInterceptor;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderPdfPrintUtil;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.purchase.utils.SysUtil;
import com.els.base.purchase.vo.KnPurOrderPdfItemVO;
import com.els.base.purchase.vo.KnPurOrderPdfVO;
import com.els.base.supperorder.entity.SupplierOrder;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.supperorder.entity.SupplierOrderItemExample;
import com.els.base.supperorder.service.SupplierOrderItemService;
import com.els.base.supperorder.service.SupplierOrderService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("purchaseOrderService")
public class PurchaseOrderServiceImpl implements PurchaseOrderService {
    Logger logger = LoggerFactory.getLogger(PurchaseOrderServiceImpl.class);
    @Resource
    protected PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    protected PurchaseOrderItemMapper purchaseOrderItemMapper;
    //@Resource
    //protected CompanyMapper companyMapper;
    @Resource
    protected UserMapper userMapper;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected SaleOrderService saleOrderService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderChangeService purchaseOrderChangeService;
    @Resource
    protected ProjectService projectService;

    @Transactional
    @CacheEvict(value = {"purchaseOrder", "purchaseOrderItem"}, allEntries = true)
    @Override
    public void updateByPrimaryKeySelective(PurchaseOrder purchaseOrder) {
        Assert.isNotNull(purchaseOrder, "更新采购订单不能为空！");
        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }

    @Transactional
    @CacheEvict(value = {"purchaseOrder", "purchaseOrderItem"}, allEntries = true)
    @Override
    public void addObj(PurchaseOrder purchaseOrder) {
        int finishFlagDeleteNum = 0;// 交货已完成标识数量(同时是删除的)
        int finishFlagNoDeleteNum = 0;// 交货已完成标识数量(不是删除的)
        int isFrozenNum = 0;// 冻结标识数量
        int isDeleteNum = 0;// 删除标识数量
        Date date = new Date();
        if (purchaseOrder.getPurRemark() == null) {
            purchaseOrder.setPurRemark("");
        }
        if (purchaseOrder.getSupRemark() == null) {
            purchaseOrder.setSupRemark("");
        }
        // 设置默认的插入值
        // purchaseOrder.setId(null);
        purchaseOrder.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());// 未确认
        purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.NOTSEND.getValue());// 未发送
        purchaseOrder.setDeliveryStatus(1);// 交货未完成（交货已完成标识,2完成1未完成）
        // 修改为交货已完成标识,2完成1未完成
        // purchaseOrder.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());//
        // 未收交
        purchaseOrder.setCreateTime(date);
        purchaseOrder.setAuditStatus(1);// 1-审批通过，2-未审批，3-审批中，4-审批拒绝
        purchaseOrder.setIsAudit("Y");// 审批标识 Y 已审批
        purchaseOrder.setIsEnable(1);// 是否删除，1未删除，0删除
        this.purchaseOrderMapper.insertSelective(purchaseOrder);

        if (CollectionUtils.isEmpty(purchaseOrder.getItems())) {
            return;
        }
        int orderItemNo = 1;

        // 插入订单行
        for (PurchaseOrderItem item : purchaseOrder.getItems()) {
            // item.setId(null);
            if (StringUtils.isBlank(item.getOrderItemNo())) {
                item.setOrderItemNo(String.valueOf(orderItemNo));
                orderItemNo++;
            }
            if (StringUtils.isNotBlank(item.getMaterialCode())) {
                SupplierMaterialExample labelPrintExample = new SupplierMaterialExample();
                labelPrintExample.createCriteria().andMaterialCodeEqualTo(item.getMaterialCode())
                        .andSupplierCodeEqualTo(purchaseOrder.getSupCompanySapCode());
                List<SupplierMaterial> supplierMaterialList = supplierMaterialService
                        .queryAllObjByExample(labelPrintExample);
                if (!CollectionUtils.isEmpty(supplierMaterialList)) {
                    String brand = supplierMaterialList.get(0).getBrand();// 品牌
                    item.setBrand(brand);
                    String supplierMaterial = supplierMaterialList.get(0).getSupplierMaterial();// 供应商物料号
                    item.setSupMaterialCode(supplierMaterial);
                }
            }
            MaterialExample example = new MaterialExample();
            example.createCriteria().andMaterialCodeEqualTo(item.getMaterialCode());

            List<Material> materialList = materialService.queryAllObjByExample(example);
            if (!CollectionUtils.isEmpty(materialList)) {
                String materialId = materialList.get(0).getId();// 物料id
                String materialCategoryId = materialList.get(0).getCategoryId();// 物料组
                String materialCategoryName = materialList.get(0).getCategoryName();// 物料组名称
                item.setMaterialCategoryId(materialCategoryId);
                item.setMaterialCategoryName(materialCategoryName);
                item.setMaterialId(materialId);
                item.setDeliveryMaterialName(materialList.get(0).getMaterialName());
            }

            item.setCurrency(purchaseOrder.getCurrency());
            item.setOrderId(purchaseOrder.getId());
            item.setOrderNo(purchaseOrder.getOrderNo());
            item.setProjectId(purchaseOrder.getProjectId());
            item.setPurCompanyId(purchaseOrder.getCompanyId());
            item.setPurCompanyOcde(purchaseOrder.getCompanyCode());
            item.setPurCompanyName(purchaseOrder.getCompanyName());
            item.setSapPurCompanyCode(purchaseOrder.getPurSapCompanyCode());
            item.setPurUserId(purchaseOrder.getUserId());
            item.setPurUserName(purchaseOrder.getUserName());
            item.setSupCompanyId(purchaseOrder.getSupCompanyId());
            item.setSupCompanyName(purchaseOrder.getSupCompanyName());
            item.setSupUserId(purchaseOrder.getSupUserId());
            item.setSupUserName(purchaseOrder.getSupUserName());
            item.setUpdateTime(date);
            if (item.getOrderDate() == null) {
                item.setOrderDate(date);
            }
            item.setIsUpdated(0);// 是否被修改过，0没有，1已修改
            if (item.getIsEnable() == null) {
                item.setIsEnable(1);// 是否删除，1未删除，0删除
            }
            if (StringUtils.isBlank(item.getFinishFlag())) {
                item.setFinishFlag("N");// 交货已完成标识,Y完成
            }

            BigDecimal receivedQuantity = BigDecimal.ZERO;
            if (item.getReceivedQuantity() != null) {
                receivedQuantity = item.getReceivedQuantity();// 已经收货数量
            }
            BigDecimal quantity = BigDecimal.ZERO;
            if (item.getQuantity() != null) {
                quantity = item.getQuantity();// 订单数量
            }
            if (receivedQuantity.doubleValue() >= quantity.doubleValue()) {
                // 如果“已收货数量”≥“订单数量”，那么收货已完成标识被自动标识为Y
                item.setFinishFlag("Y");
            }

            // 可发货数量
            BigDecimal canDeliveryAmount = SysUtil.getCanDeliveryAmount(item.getQuantity(), item.getOnwayQuantity(),
                    item.getReceivedQuantity(), item.getFreezeQuantity());
            item.setDeliveryAmount(canDeliveryAmount);
            if (item.getFinishFlag().equals("Y")) {
                if (item.getIsEnable() == 0) {// 收货完成同时又是删除的
                    finishFlagDeleteNum++;
                } else {// 收货完成同时不是删除的
                    finishFlagNoDeleteNum++;
                }
            }
            if (item.getIsEnable() == 0) {
                isDeleteNum++;
            }
            if (item.getIsEnable() == 2) {
                isFrozenNum++;
            }
            this.purchaseOrderItemService.addObj(item);
        }

        if (purchaseOrder.getItems() != null && purchaseOrder.getItems().size() > 0) {
            purchaseOrder = updateOrderHeaderStatus(purchaseOrder, isDeleteNum, isFrozenNum, finishFlagDeleteNum,
                    finishFlagNoDeleteNum);
            this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
        }
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.purchaseOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void modifyObj(PurchaseOrder t) {
        this.modifyObj(t, "修改采购订单");
    }

    @Transactional
    @CacheEvict(value = {"purchaseOrder", "purchaseOrderItem"}, allEntries = true)
    @Override
    public void modifyObj(PurchaseOrder purchaseOrder, String cause) {
        if (StringUtils.isBlank(purchaseOrder.getId())) {
            throw new NullPointerException("id为空");
        }
        if (CollectionUtils.isEmpty(purchaseOrder.getItems())) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        if (purchaseOrder.getPurRemark() == null) {
            purchaseOrder.setPurRemark("");
        }
        if (purchaseOrder.getSupRemark() == null) {
            purchaseOrder.setSupRemark("");
        }

        PurchaseOrderExample exampleTemp = new PurchaseOrderExample();
        exampleTemp.createCriteria().andProjectIdEqualTo(purchaseOrder.getProjectId())
                .andSupCompanySapCodeEqualTo(purchaseOrder.getSupCompanySapCode())
                .andOrderNoEqualTo(purchaseOrder.getOrderNo());
        List<PurchaseOrder> tempOrder = purchaseOrderMapper.selectByExample(exampleTemp);
        int tempOrderStatus = tempOrder.get(0).getOrderStatus();
        int tempOrderSendStatus = tempOrder.get(0).getOrderSendStatus();

        Map<String, Object> tempOrderHisMap = new HashMap<>();
        tempOrderHisMap.put("orderNo", purchaseOrder.getOrderNo());
        List<Integer> tempOrderHisOrderStatus = new ArrayList<>();
        tempOrderHisOrderStatus.add(PurchaseOrderStatusEnum.CONFIRM.getValue());
        tempOrderHisOrderStatus.add(PurchaseOrderStatusEnum.BACK.getValue());
        tempOrderHisOrderStatus.add(PurchaseOrderStatusEnum.PART_BACK.getValue());
        tempOrderHisMap.put("orderStatusList", tempOrderHisOrderStatus);

        int tempOrderHisTotal = purchaseOrderItemMapper.countOrderHisByExample(tempOrderHisMap);

        int finishFlagDeleteNum = 0;// 交货已完成标识数量(同时是删除的)
        int finishFlagNoDeleteNum = 0;// 交货已完成标识数量(不是删除的)
        int isFrozenNum = 0;// 冻结标识数量
        int isDeleteNum = 0;// 删除标识数量
        // this.purchaseOrderItemService.deleteByOrderId(purchaseOrder.getId());
        for (int i = 0; i < purchaseOrder.getItems().size(); i++) {
            Date date = new Date();
            PurchaseOrderItem item = purchaseOrder.getItems().get(i);
            if (StringUtils.isBlank(item.getId())) {
                // 设置订单行的值
                setOldPurchaseOrderItem(item);
            }

            MaterialExample example = new MaterialExample();
            example.createCriteria().andMaterialCodeEqualTo(item.getMaterialCode());
            List<Material> materialList = materialService.queryAllObjByExample(example);
            if (!CollectionUtils.isEmpty(materialList)) {
                String materialId = materialList.get(0).getId();// 物料id
                String materialCategoryId = materialList.get(0).getCategoryId();// 物料组
                String materialCategoryName = materialList.get(0).getCategoryName();// 物料组名称
                item.setMaterialCategoryId(materialCategoryId);
                item.setMaterialCategoryName(materialCategoryName);
                item.setMaterialId(materialId);
            }

            // 获取供应商料号
            if (StringUtils.isNotBlank(item.getMaterialCode())) {
                SupplierMaterialExample labelPrintExample = new SupplierMaterialExample();
                labelPrintExample.createCriteria().andMaterialCodeEqualTo(item.getMaterialCode())
                        .andSupplierCodeEqualTo(purchaseOrder.getSupCompanySapCode());
                List<SupplierMaterial> supplierMaterialList = supplierMaterialService
                        .queryAllObjByExample(labelPrintExample);
                if (!CollectionUtils.isEmpty(supplierMaterialList)) {
                    String brand = supplierMaterialList.get(0).getBrand();// 品牌
                    item.setBrand(brand);
                    String supplierMaterial = supplierMaterialList.get(0).getSupplierMaterial();// 供应商物料号
                    item.setSupMaterialCode(supplierMaterial);
                }
            }
            item.setCurrency(purchaseOrder.getCurrency());
            item.setOrderId(purchaseOrder.getId());
            item.setProjectId(purchaseOrder.getProjectId());
            item.setPurCompanyId(purchaseOrder.getCompanyId());
            item.setPurCompanyName(purchaseOrder.getCompanyName());
            item.setSupCompanyId(purchaseOrder.getSupCompanyId());
            item.setSupCompanyName(purchaseOrder.getSupCompanyName());
            item.setUpdateTime(date);
            item.setOrderNo(purchaseOrder.getOrderNo());
            if (item.getOrderDate() == null) {
                item.setOrderDate(date);
            }
            item.setIsUpdated(1);// 是否被修改过，0没有，1已修改
            if (item.getIsEnable() == null) {
                item.setIsEnable(1);// 是否删除，1未删除，0删除
            }
            if (StringUtils.isBlank(item.getFinishFlag())) {
                item.setFinishFlag("N");// 交货已完成标识,Y完成
            }
            BigDecimal receivedQuantity = BigDecimal.ZERO;
            if (item.getReceivedQuantity() != null) {
                receivedQuantity = item.getReceivedQuantity();// 已经收货数量
            }
            BigDecimal quantity = BigDecimal.ZERO;
            if (item.getQuantity() != null) {
                quantity = item.getQuantity();// 订单数量
            }
            if (receivedQuantity.doubleValue() >= quantity.doubleValue()) {
                // 如果“已收货数量”≥“订单数量”，那么收货已完成标识被自动标识为Y
                item.setFinishFlag("Y");
            }

            if (item.getFinishFlag().equals("Y")) {
                if (item.getIsEnable() == 0) {// 收货完成同时又是删除的
                    finishFlagDeleteNum++;
                } else {// 收货完成同时不是删除的
                    finishFlagNoDeleteNum++;
                }
            }
            // // 如果订单被修改，订单行的确认状态应该是未确认
            // item.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());//
            // 未确认
            // item.setPurRemark(item.getPurRemark());
            logger.info("item.setPurRemark = " + item.getPurRemark());
            item.setSupRemark("");
            if (StringUtils.isNotBlank(item.getId())) {
                /**
                 * 找出以前的订单头，设置订单行都可以修改 1、未发送、未确认。 2、已发送、未确认。 3、未发送、未确认，
                 * SAP改了，状态变成变更未发送、未确认 4、已发送、未确认状态， SAP改了，状态变成变更未发送、未确认
                 * 5、变更未发送、未确认（以前所有的历史都没有确认、拒绝过）， SAP修改后，状态变成变更未发送、未确认
                 * 6、变更已发送、未确认（以前所有的历史都没有确认、拒绝过）， SAP修改后，状态变成变更未发送、未确认 以上是可全部修改的
                 * ---------------------- 1、变更未发送、未确认；如果之前历史有确认、拒绝过，那么只能变更行修改
                 * 2、变更已发送、未确认；如果之前历史有确认、拒绝过，那么只能变更行修改 3、变更已发送、已确认；只能部分行修改
                 * 4、变更已发送、已拒绝；只能部分行修改 5、变更已发送、部分拒绝；只能部分行修改 6、已发送、已拒绝；只能部分行修改
                 * 7、已发送、已确认；只能部分行修改 8、已发送、部分拒绝；只能部分行修改
                 */

                logger.info("OrderStatus = " + tempOrderStatus);
                logger.info("OrderSendStatus = " + tempOrderSendStatus);
                logger.info("tempOrderHisTotal = " + tempOrderHisTotal);

                if (item.getHaveChange() == 1) {// 表示修改
                    // item.setHaveChange(0);
                } else {
                    logger.info("order send Status[" + tempOrderSendStatus + "]");
                    logger.info("order Status[" + tempOrderStatus + "]");
                    logger.info("order item Status[" + item.getOrderStatus() + "]");
                    if (tempOrderSendStatus == PurchaseOrderSendStatusEnum.NOTSEND.getValue()
                            && tempOrderStatus == PurchaseOrderStatusEnum.UNCONFIRM.getValue()) {
                        item.setHaveChange(0);
                    } else if (tempOrderSendStatus == PurchaseOrderSendStatusEnum.SENDED.getValue()
                            && tempOrderStatus == PurchaseOrderStatusEnum.UNCONFIRM.getValue()) {
                        item.setHaveChange(0);
                    } else if (tempOrderSendStatus == PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue()
                            && tempOrderStatus == PurchaseOrderStatusEnum.UNCONFIRM.getValue()
                            && tempOrderHisTotal < 1) {
                        item.setHaveChange(0);
                    } else if (tempOrderSendStatus == PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue()
                            && tempOrderStatus == PurchaseOrderStatusEnum.UNCONFIRM.getValue()
                            && tempOrderHisTotal < 1) {
                        item.setHaveChange(0);
                    } else {
                        item.setHaveChange(-1);// 表示不能修改
                    }
                    // 拒绝的行，SAP没有修改，直接发送回来，需要重新确认
                    if (item.getOrderStatus() != null
                            && item.getOrderStatus().equals(PurchaseOrderStatusEnum.BACK.getValue())) {
                        item.setHaveChange(0);
                    }
                }
                // 如果订单被修改，订单行的确认状态应该是未确认
                item.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());// 未确认
                // this.purchaseOrderItemMapper.updateByPrimaryKeySelective(item);
                this.purchaseOrderItemService.modifyObj(item);
            } else {
                // 如果订单被修改，订单行的确认状态应该是未确认
                item.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());// 未确认
                this.purchaseOrderItemService.addObj(item);
            }

            if (item.getIsEnable() == 0) {
                isDeleteNum++;
            }
            if (item.getIsEnable() == 2) {
                isFrozenNum++;
            }
        }
        if (purchaseOrder.getItems() != null && purchaseOrder.getItems().size() > 0) {
            purchaseOrder = updateOrderHeaderStatus(purchaseOrder, isDeleteNum, isFrozenNum, finishFlagDeleteNum,
                    finishFlagNoDeleteNum);
        }
        this.purchaseOrderMapper.updateByPrimaryKey(purchaseOrder);
    }

    // @Cacheable(value = "purchaseOrder", keyGenerator="redisKeyGenerator")
    @Override
    public PurchaseOrder queryObjById(String id) {
        return this.purchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "purchaseOrder", keyGenerator = "redisKeyGenerator")
    @Override
    public List<PurchaseOrder> queryAllObjByExample(PurchaseOrderExample example) {
        return this.purchaseOrderMapper.selectByExample(example);
    }

    @Cacheable(value = "purchaseOrder", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<PurchaseOrder> queryObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectByExampleByPage(example);
        for (PurchaseOrder purchaseOrder : list) {
            Company company = companyService.queryObjById(purchaseOrder.getSupCompanyId());
            if (company != null) {
                purchaseOrder.setSupShortName(company.getCompanyName());
            }
        }
        pageView.setQueryResult(list);
        return pageView;
    }

    /*
     * @Transactional
     *
     * @CacheEvict(value = { "purchaseOrder" }, allEntries = true)
     *
     * @Override public void sendPurchaseOrder(PurchaseOrder purchaseOrder) { //
     * 如果是变更未发送或者变更已发送 if (purchaseOrder.getOrderSendStatus() ==
     * PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue() ||
     * purchaseOrder.getOrderSendStatus() ==
     * PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue()) {
     * purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.
     * UPDATE_SENDED.getValue()); } else {
     * purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.SENDED.
     * getValue()); } // 插入销售单 SaleOrder saleOrder = new SaleOrder();
     * saleOrder.setUserId(purchaseOrder.getSupUserId());
     * saleOrder.setUserName(purchaseOrder.getSupUserName());
     * saleOrder.setCompanyId(purchaseOrder.getSupCompanyId());
     * saleOrder.setCompanyCode(purchaseOrder.getSupCompanySapCode());
     * saleOrder.setCompanyName(purchaseOrder.getSupCompanyName());
     * saleOrder.setProjectId(purchaseOrder.getProjectId());
     * saleOrder.setPurOrderId(purchaseOrder.getId());
     * saleOrder.setPurOrderNo(purchaseOrder.getOrderNo());
     * saleOrder.setCreateTime(new Date());
     *
     * // 通过供应商公司id查询用户 List<User> userList =
     * companyUserRefService.queryUserListOfCompany(purchaseOrder.getProjectId()
     * , purchaseOrder.getSupCompanyId()); if
     * (CollectionUtils.isNotEmpty(userList)) {
     * saleOrder.setUserId(userList.get(0).getId());
     * saleOrder.setUserName(userList.get(0).getNickName());
     * purchaseOrder.setSupUserId(userList.get(0).getId());
     * purchaseOrder.setSupUserName(userList.get(0).getNickName()); //
     * Set<String> accounts = new HashSet<>(); List<String> accounts = new
     * ArrayList(); for (User user : userList) { accounts.add(user.getId()); }
     *
     * Message<PurchaseOrder> message = new
     * Message<PurchaseOrder>(purchaseOrder.getCompanyCode(), accounts,
     * OrderBusinessTypeEnum.PO_NEW_SEND.getCode(), MessageLevelEnum.MIDDLE,
     * purchaseOrder); MessageSendUtils.sendMessage(message);
     *
     *
     * String content = "来自华阳通用的订单号：" + purchaseOrder.getOrderNo(); Map<String,
     * String> extras = new HashMap<>(); extras.put("orderId",
     * purchaseOrder.getId()); try { MessageUtils.pushSystemMessage("发送订单",
     * content, accounts, saleOrder.getCompanyCode(), MessageLevelEnum.HIGH,
     * MessagePageRedirectEnum.PUR_ORDER_ITEM_SIGN_PAGE, null, extras); } catch
     * (ConnectException e) { e.printStackTrace(); }
     *
     *
     * } saleOrderService.addObj(saleOrder); purchaseOrder.setSendTime(new
     * Date());
     * this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder); //
     * this.modifyObj(purchaseOrder, "发送采购订单"); }
     */

    @Cacheable(value = "purchaseOrder", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<PurchaseOrder> queryHisObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void importPurchaseOrder(List<PurchaseOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("采购单的导入列表为空");
        }
        for (PurchaseOrder order : orders) {
            PurchaseOrderExample example = new PurchaseOrderExample();
            example.createCriteria().andProjectIdEqualTo(order.getProjectId())
                    .andSupCompanySapCodeEqualTo(order.getSupCompanySapCode()).andOrderNoEqualTo(order.getOrderNo());

            List<PurchaseOrder> temp = purchaseOrderMapper.selectByExample(example);
            if (!CollectionUtils.isEmpty(temp)) {
                // 如果修改订单数量了，在订单重新导入之前插入历史记录
                PurchaseOrder purchaseOrder = temp.get(0);
                String hisId = UUIDGenerator.generateUUID();
                // 查询最新的历史版本
                String version = purchaseOrder.getVersion();
                if (StringUtils.isBlank(version)) {
                    version = "0";
                }
                this.purchaseOrderMapper.insertHis(hisId, purchaseOrder.getId(), "修改订单提交sap",
                        String.valueOf(Integer.valueOf(version) + 1));
                // 先把当前记录添加到历史纪录
                // 查询最新的历史版本
                // 4、如果订单中包含行数据,就在删除，重新插入
                this.purchaseOrderItemService.insertHisByOrderId(hisId, purchaseOrder.getId(), "修改订单提交sap",
                        String.valueOf(Integer.valueOf(version) + 1));

                // 进行修改,更新版本
                order.setPurRemark("");
                order.setSupRemark("");
                order.setAuditStatus(1);// 1-审批通过，2-未审批，3-审批中，4-审批拒绝
                order.setIsAudit("Y");// 审批标识 Y 已审批
                order.setCreateTime(temp.get(0).getCreateTime());
                order.setIsEnable(temp.get(0).getIsEnable());
                order.setSendTime(temp.get(0).getSendTime());
                order.setVersion(String.valueOf(Integer.valueOf(version) + 1));
                order.setCreateUser("");
                order.setId(temp.get(0).getId());
                order.setLastUpdateTime(new Date());
                order.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());// 未确认
                order.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue());// 变更未发送
                order.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());// 未收交
                this.modifyObj(order, "导入采购订单");
                continue;
            }
            // 保存数据
            order.setSendTime(null);
            this.addObj(order);
        }
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void setIsEnable(String id, boolean isEnable) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("id为空，操作失败", "id_is_blank");
        }
        PurchaseOrder order = new PurchaseOrder();
        order.setId(id);
        if (isEnable) {
            order.setIsEnable(Constant.YES_INT);
        } else {
            order.setIsEnable(Constant.NO_INT);
        }
        this.purchaseOrderMapper.updateByPrimaryKeySelective(order);
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public int insertHis(String hisId, String orderId, String cause, String version) {
        return purchaseOrderMapper.insertHis(hisId, orderId, cause, version);
    }

    @Override
    public String selectMaxVersion() {
        return purchaseOrderMapper.selectMaxVersion();
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void updateForSap(PurchaseOrder purchaseOrder) {
        if (purchaseOrder == null) {
            throw new CommonException("采购方订单头数据为空，创建采购方订单头失败", "base_fail");
        }
        if (StringUtils.isBlank(purchaseOrder.getId())) {
            throw new NullPointerException("id为空，操作失败");
        }
        if (CollectionUtils.isEmpty(purchaseOrder.getItems())) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        List<PurchaseOrderItem> itemTemps = new ArrayList<PurchaseOrderItem>();
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrder.getItems()) {
            //long changeAmount = 0;
            BigDecimal changeAmount = BigDecimal.ZERO;
            BigDecimal onwayQuantity = BigDecimal.ZERO;// 在途数量
            BigDecimal receivedQuantity = BigDecimal.ZERO;// 已经收货数量
            BigDecimal deliveredQuantity = BigDecimal.ZERO;// 最低更改的数量

            //			if (purchaseOrderItem.getChangeAmount() != null
            //					&& (purchaseOrderItem.getQuantity() - purchaseOrderItem.getChangeAmount() != 0)) {
            if (purchaseOrderItem.getChangeAmount() != null
                    && (purchaseOrderItem.getQuantity().subtract(purchaseOrderItem.getChangeAmount()) != BigDecimal.ZERO)) {
                itemTemps.add(purchaseOrderItem);
                if (purchaseOrderItem.getReceivedQuantity() != null) {
                    receivedQuantity = purchaseOrderItem.getReceivedQuantity();
                }
                if (purchaseOrderItem.getOnwayQuantity() != null) {
                    onwayQuantity = purchaseOrderItem.getOnwayQuantity();
                }
                deliveredQuantity = onwayQuantity.add(receivedQuantity);
                //if (deliveredQuantity.compareTo(BigDecimal.valueOf(changeAmount)) == -1) {// -1是小于
                if (deliveredQuantity.compareTo(changeAmount) == -1) {// -1是小于
                    throw new CommonException("物料" + purchaseOrderItem.getMaterialCode() + "已经收货" + receivedQuantity
                            + ",在途" + onwayQuantity + ",更改订单数量不能低于" + deliveredQuantity);
                }
            } else {
                changeAmount = BigDecimal.ZERO;
            }
            if (purchaseOrderItem.getChangeAmount() != null) {
                changeAmount = purchaseOrderItem.getChangeAmount();
            }

        }
        // 发布sap修改事件
        if (CollectionUtils.isNotEmpty(itemTemps) && itemTemps.size() != 0) {
            Map<String, UpdatePurchaseOrderInterceptor> interceptors = SpringContextHolder
                    .getBeans(UpdatePurchaseOrderInterceptor.class);
            if (interceptors != null && interceptors.size() != 0) {
                Iterator<String> keyIterator = interceptors.keySet().iterator();
                while (keyIterator.hasNext()) {
                    UpdatePurchaseOrderInterceptor interceptor = interceptors.get(keyIterator.next());
                    String message = interceptor.preHandle(itemTemps);
                    if (StringUtils.isNotBlank(message)) {
                        throw new CommonException(message);
                    }
                }
            }
        }

    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void updateByPurcahseOrder(PurchaseOrder record, PurchaseOrderExample example) {
        this.purchaseOrderMapper.updateByExampleSelective(record, example);
    }

    @Cacheable(value = "purchaseOrder", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<PurchaseOrder> queryObjNoItemsByPage(PurchaseOrderExample example, String purUserId) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectForPurUserByExampleByPage(example, pageView,
                purUserId);
        pageView.setQueryResult(list);
        return pageView;
    }

    /**
     * 发送订单给销售方
     */
    @Transactional
    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void sendOrder(PurchaseOrder purchaseOrder) {
        purchaseOrder.setSendTime(new Date());
        // 如果是变更未发送或者变更已发送
        if (purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue()
                || purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue()) {
            purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue());
        } else {
            purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.SENDED.getValue());
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria()
                .andOrderNoEqualTo(purchaseOrder.getOrderNo())
                .andBackGoodsItemNotEqualTo("X")//排除退货订单行
                .andSupCompanyIdEqualTo(purchaseOrder.getSupCompanyId());
        List<PurchaseOrderItem> items = this.purchaseOrderItemService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(items)) {
            for (PurchaseOrderItem purchaseOrderItem : items) {
                BigDecimal canDeliveryAmount = SysUtil.getCanDeliveryAmount(purchaseOrderItem.getQuantity(),
                        purchaseOrderItem.getOnwayQuantity(), purchaseOrderItem.getReceivedQuantity(),
                        purchaseOrderItem.getFreezeQuantity());
                purchaseOrderItem.setDeliveryAmount(canDeliveryAmount);
                purchaseOrderItem.setPurUserId(purchaseOrder.getUserId());
                purchaseOrderItem.setPurUserName(purchaseOrder.getUserName());
                purchaseOrderItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());// 未确认
            }
        }
        purchaseOrder.setItems(items);
        SupplierOrder supplierOrder = new SupplierOrder();
        // 转为销售订单
        SysUtil.purhcaseTosSupplier(purchaseOrder, supplierOrder);
        supplierOrderService.saveSupplierOrder(supplierOrder);

        //发送消息
        this.sendMessages(purchaseOrder, supplierOrder);

        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }


    @Transactional
    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void deleteOrder(PurchaseOrder purchaseOrder) {
        purchaseOrder.setSendTime(new Date());
        purchaseOrder.setIsEnable(Constant.NO_INT);
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria()
                .andOrderNoEqualTo(purchaseOrder.getOrderNo())
                .andSupCompanyIdEqualTo(purchaseOrder.getSupCompanyId());
        List<PurchaseOrderItem> items = this.purchaseOrderItemService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(items)) {
            for (PurchaseOrderItem purchaseOrderItem : items) {
                BigDecimal canDeliveryAmount = BigDecimal.ZERO;
                purchaseOrderItem.setIsEnable(Constant.NO_INT);
                purchaseOrderItem.setDeliveryAmount(canDeliveryAmount);
                purchaseOrderItem.setPurUserId(purchaseOrder.getUserId());
                purchaseOrderItem.setPurUserName(purchaseOrder.getUserName());
                purchaseOrderItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());// 未确认
                this.purchaseOrderItemService.modifyObj(purchaseOrderItem);
            }
        }
        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }


    private void sendMessages(PurchaseOrder purchaseOrder, SupplierOrder supplierOrder) {
        // 通过供应商公司id查询用户
        User user = companyUserRefService.queryMainUserOfCompany(purchaseOrder.getSupCompanyId());
        if (user != null) {
            supplierOrder.setUserId(user.getId());
            supplierOrder.setUserName(user.getNickName());
            purchaseOrder.setSupUserId(user.getId());
            purchaseOrder.setSupUserName(user.getNickName());

            Message<PurchaseOrder> message = new Message<PurchaseOrder>(purchaseOrder.getCompanyCode(),
                    "1", user.getId(), OrderBusinessTypeEnum.PO_NEW_SEND.getCode(),
                    MessageLevelEnum.MIDDLE, purchaseOrder);
            MessageSendUtils.sendMessage(message);

        }
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void modifyObjByKey(PurchaseOrder purchaseOrder) {
        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }

    /**
     * 修改订单头的冻结、删除、收货完成标识
     *
     * @param purchaseOrder
     * @param isDeleteNum           行删除个数
     * @param isFrozenNum           行冻结个数
     * @param finishFlagDeleteNum   行收货完成标识个数(同时是删除的)
     * @param finishFlagNoDeleteNum 行收货完成标识个数（不是删除的）
     * @return
     */
    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    public PurchaseOrder updateOrderHeaderStatus(PurchaseOrder purchaseOrder, int isDeleteNum, int isFrozenNum,
                                                 int finishFlagDeleteNum, int finishFlagNoDeleteNum) {
        int finishFlagNum = isDeleteNum + finishFlagNoDeleteNum;
        logger.info(purchaseOrder.getOrderNo() + "------------finishFlagNoDeleteNum---" + finishFlagNoDeleteNum
                + "------------isDeleteNum--- " + isDeleteNum + "------------------------finishFlagNum---"
                + finishFlagNum + "--------------------------purchaseOrder.getItems().size()--"
                + purchaseOrder.getItems().size());
        // 如果订单行全部都是删除的，则订单头也改为删除
        if (isDeleteNum == purchaseOrder.getItems().size()) {
            purchaseOrder.setIsEnable(0);
        } else {
            // 如果订单行全部都是冻结的，则订单头也改为冻结(包括冻结的行数+删除的行数=订单的行数)
            if (isFrozenNum == purchaseOrder.getItems().size()
                    || ((isFrozenNum + isDeleteNum) == purchaseOrder.getItems().size())) {
                purchaseOrder.setIsEnable(2);
            }
        }
        // 如果订单行全部都是交货已完成标识的，则订单头也改为交货已完成标识
        if (finishFlagNum == purchaseOrder.getItems().size()) {
            // 交货已完成标识,2完成1未完成
            purchaseOrder.setDeliveryStatus(2);
        }
        logger.info(purchaseOrder.getOrderNo() + "------------------------finishFlagNum---" + finishFlagNum
                + "--------------------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
        if (StringUtils.isNotBlank(purchaseOrder.getId())) {
            PurchaseOrder purchaseOrderTemp = this.purchaseOrderMapper.selectByPrimaryKey(purchaseOrder.getId());
            if (purchaseOrderTemp != null) {
                // 如果订单头状态是删除的，但是行项目不是所有的都是，则需要还原
                if (purchaseOrderTemp.getIsEnable() != null && purchaseOrderTemp.getIsEnable() == 0) {
                    logger.info(purchaseOrder.getOrderNo() + "------------------------isDeleteNum---"
                            + isDeleteNum + "-----------isFrozenNum---" + isFrozenNum
                            + "------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
                    if (isDeleteNum < purchaseOrder.getItems().size()) {
                        purchaseOrder.setIsEnable(1);
                    }
                }
                // 如果订单头状态是冻结的，但是行项目不是所有的都是，则需要还原
                if (purchaseOrderTemp.getIsEnable() != null && purchaseOrderTemp.getIsEnable() == 2) {
                    if ((isFrozenNum + isDeleteNum) < purchaseOrder.getItems().size()) {
                        purchaseOrder.setIsEnable(1);
                    }
                }

                // 如果订单头是交货已完成标识的，但是行项目不是所有的都是，则需要还原
                if (purchaseOrderTemp.getDeliveryStatus() != null && purchaseOrderTemp.getDeliveryStatus() == 2) {
                    if (finishFlagNum < purchaseOrder.getItems().size()) {
                        purchaseOrder.setDeliveryStatus(1);
                    }
                }
            }
        }
        return purchaseOrder;
    }

    /**
     * 设置订单行的值
     *
     * @param item
     */
    private void setOldPurchaseOrderItem(PurchaseOrderItem item) {
        PurchaseOrderItemExample purchaseOrderItemExample = new PurchaseOrderItemExample();
        purchaseOrderItemExample.createCriteria().andOrderNoEqualTo(item.getOrderNo())
                .andOrderItemNoEqualTo(item.getOrderItemNo());
        List<PurchaseOrderItem> purchaseOrderItemList = this.purchaseOrderItemService
                .queryAllObjByExample(purchaseOrderItemExample);

        if (CollectionUtils.isEmpty(purchaseOrderItemList)) {
            return;
        }

        PurchaseOrderItem purchaseOrderItem = purchaseOrderItemList.get(0);
        item.setId(purchaseOrderItem.getId());

        purchaseOrderItem.setPurUserName(null);// 采购员名称
        purchaseOrderItem.setPurUserId(null);// 采购员id
        purchaseOrderItem.setSupUserName(null);// 供应商名称
        purchaseOrderItem.setSupUserId(null);// 供应商id
        item.setOrderStatus(null);
        item.setOnwayQuantity(null);
        item.setDeliveredQuantity(null);
        item.setReceivedQuantity(null);
        item.setReturnQuantity(null);
        item.setQuaWarehouseQuantity(null);
        item.setWarehouseLocation(null);

        BigDecimal nonTaxAmount = purchaseOrderItem.getNonTaxAmount() == null ? BigDecimal.ZERO
                : purchaseOrderItem.getNonTaxAmount();// 不含税金额
        item.setNonTaxAmount(nonTaxAmount);

        // 可发货数量
        BigDecimal canDeliveryAmount = SysUtil.getCanDeliveryAmount(item.getQuantity(), purchaseOrderItem.getOnwayQuantity(),
                purchaseOrderItem.getReceivedQuantity(), purchaseOrderItem.getFreezeQuantity());
        item.setDeliveryAmount(canDeliveryAmount);

    }

    /**
     * @param purchaseOrderFromSap SAP 变更后采购订单数据
     */
    @Transactional
    @CacheEvict(value = {"purchaseOrder", "purchaseOrderItem"}, allEntries = true)
    @Override
    public void orderChangeBySap(PurchaseOrder purchaseOrderFromSap) {
        if (purchaseOrderFromSap == null) {
            return;
        }
        logger.info("=================订单变更==================================");
        String projectId = purchaseOrderFromSap.getProjectId();
        String orderNo = purchaseOrderFromSap.getOrderNo();
        String supplierSapCode = purchaseOrderFromSap.getSupCompanySapCode();
        String supplierCompanyId = purchaseOrderFromSap.getSupCompanyId();
        logger.info("项目ID为：{}", projectId);
        logger.info("订单号为：{}", orderNo);
        logger.info("供应商sap编码为：{}", supplierSapCode);
        logger.info("供应商ID为：{}", supplierCompanyId);

        //查询
        PurchaseOrderExample exampleTemp = new PurchaseOrderExample();
        exampleTemp.createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanySapCodeEqualTo(supplierSapCode)
                .andOrderNoEqualTo(orderNo);
        List<PurchaseOrder> oldPurchaseOrders = purchaseOrderMapper.selectByExample(exampleTemp);

        //一：新增。数据库里面没有该订单，直接插入
        if (CollectionUtils.isEmpty(oldPurchaseOrders)) {
            logger.info("订单数据在数据库不存在，插入");
            this.addObj(purchaseOrderFromSap);
            return;
        }

        //二：变更。
        String purchaseOrderId = oldPurchaseOrders.get(0).getId();
        // int tempOrderStatus = tempOrder.get(0).getOrderStatus();
        // int tempOrderSendStatus = tempOrder.get(0).getOrderSendStatus();
        // 0删除，1未删除
        int deleteFlag = purchaseOrderFromSap.getIsEnable();
        String hisId = UUIDGenerator.generateUUID();
        String version = StringUtils.defaultIfBlank(purchaseOrderFromSap.getVersion(), "0");
        logger.info("变更的采购订单ID为：{}", purchaseOrderId);
        logger.info("变更的采购订单删除标识为：{}", deleteFlag);
        logger.info("新的历史ID为：{}", hisId);
        logger.info("最新的历史版本为：{}", version);

        //把原来的订单记录插入到历史记录中，方便查询上一次的信息
        this.purchaseOrderMapper.insertHis(hisId, purchaseOrderId, "修改订单提交sap", String.valueOf(Integer.valueOf(version) + 1));
        this.purchaseOrderItemService.insertHisByOrderId(hisId, purchaseOrderId, "修改订单提交sap", String.valueOf(Integer.valueOf(version) + 1));

        if (deleteFlag == 0) {
            //如果整条订单标记为删除，那么整个订单就删除，并结束
            //TODO 整单删除，是否需要同步到供应商？？？
            logger.info("整单删除");
            this.deleteOrderPurOrder(oldPurchaseOrders, purchaseOrderId);
            return;

        } else {
            //更新订单的变更次数
            logger.info("更新订单的变更次数");
            this.createPurOrder(oldPurchaseOrders, purchaseOrderFromSap);
        }

        //SAP来的变更列表
        List<PurchaseOrderItem> sapChangeItemList = purchaseOrderFromSap.getItems();
        if (CollectionUtils.isEmpty(sapChangeItemList)) {
            logger.info("没有变更的订单行");
            return;
        }

        logger.info("------------订单行的变更-------------------");

        //查询采购订单行数据
        PurchaseOrderItemExample orderItemExample = new PurchaseOrderItemExample();
        orderItemExample.createCriteria()
                .andOrderNoEqualTo(oldPurchaseOrders.get(0).getOrderNo());
        List<PurchaseOrderItem> oldPurchaseOrderItems = this.purchaseOrderItemMapper.selectByExample(orderItemExample);

        //全部行删除 且 没有新行
        if (this.isAllDelete(sapChangeItemList, oldPurchaseOrderItems)) {
            logger.info("全部行删除 且 没有新行，更新订单头状态为禁用");
            PurchaseOrder deletePurchaseOrder = new PurchaseOrder();
            deletePurchaseOrder.setId(purchaseOrderId);
            deletePurchaseOrder.setIsEnable(Constant.NO_INT);
            this.purchaseOrderMapper.updateByPrimaryKeySelective(deletePurchaseOrder);
        }
        //全部行完成 且 没有新行
        if (this.isAllFinish(sapChangeItemList, oldPurchaseOrderItems)) {
            logger.info("全部行完成 且 没有新行，更新订单头状态为已完成");
            PurchaseOrder finishPurchaseOrder = new PurchaseOrder();
            finishPurchaseOrder.setId(purchaseOrderId);
            finishPurchaseOrder.setDeliveryStatus(4);//交收状态 1:未交收2：订单发货在途3：部分交收4：全部交收
            this.purchaseOrderMapper.updateByPrimaryKeySelective(finishPurchaseOrder);
        }

        List<PurchaseOrderChange> changeList = new ArrayList<>();//变更列表
        List<SupplierOrderItem> changeOrderItemList = new ArrayList<>();

        for (PurchaseOrderItem sapChangeItem : sapChangeItemList) {

            PurchaseOrderItem oldOrderItem = this.getOldItem(sapChangeItem, oldPurchaseOrderItems);
            if (oldOrderItem == null) {
                //如果是新的行
                logger.info("插入新的订单行");
                sapChangeItem.setCurrency(purchaseOrderFromSap.getCurrency());

                // 可发货数量
                BigDecimal canDeliveryAmount = SysUtil.getCanDeliveryAmount(sapChangeItem.getQuantity(), sapChangeItem.getOnwayQuantity(),
                        sapChangeItem.getReceivedQuantity(), sapChangeItem.getFreezeQuantity());
                sapChangeItem.setDeliveryAmount(canDeliveryAmount);

                this.insertNewPurOrderItem(supplierSapCode, purchaseOrderId, sapChangeItem);

                SupplierOrderItem supplierOrderItem = this.createSupOrderItem(sapChangeItem, oldPurchaseOrders.get(0));
                supplierOrderItem.setSapSupCompanyCode(supplierSapCode);
                supplierOrderItem.setOrderTypeDesc(purchaseOrderFromSap.getOrderTypeDesc());
                supplierOrderItem.setCurrency(purchaseOrderFromSap.getCurrency());
                changeOrderItemList.add(supplierOrderItem);
                continue;
            }

            //如果是变更的行
            logger.info("变更订单行");
            SupplierOrderItem changeItem = this.updateOldOrderItem(oldPurchaseOrders.get(0), sapChangeItem, oldOrderItem);
            if (changeItem != null) {
                changeOrderItemList.add(changeItem);
            }
            PurchaseOrderChange chang = this.addNewChangeOrder(sapChangeItem, oldOrderItem, oldPurchaseOrders.get(0));
            if (chang != null && this.isNeedToConfirm(sapChangeItem, oldOrderItem)) {
                changeList.add(chang);
            }

        }// end for


        SupplierOrder supplierOrder = this.supplierOrderService.queryObjById(oldPurchaseOrders.get(0).getId());
        if (supplierOrder != null) {
            logger.info("已经发送给供应商，更新供应商的数据");
            //如果已经发送给供应商，就相应的更新送货单
            this.sendToSupplier(changeOrderItemList);
            this.sendToSupplier(supplierOrder, purchaseOrderFromSap);

            logger.info("已经发送给供应商了，更新变更申请的数据");
            this.purchaseOrderChangeService.importFromSap(changeList);

        } else {

            logger.info("没有发送给供应商，订单变更完就结束");
        }
    }

    private boolean isNeedToConfirm(PurchaseOrderItem sapChangeItem, PurchaseOrderItem oldOrderItem) {
        boolean needToConfirm = false;

        if ((sapChangeItem.getDeliveredDate() == null && oldOrderItem.getDeliveredDate() != null)
                || (sapChangeItem.getDeliveredDate() != null && oldOrderItem.getDeliveredDate() == null)
                || (sapChangeItem.getDeliveredDate() != null && oldOrderItem.getDeliveredDate() != null && sapChangeItem.getDeliveredDate().getTime() != oldOrderItem.getDeliveredDate().getTime())) {
            needToConfirm = true;
        }

        if ((sapChangeItem.getQuantity() != null && oldOrderItem.getQuantity() == null)
                || (sapChangeItem.getQuantity() != null && oldOrderItem.getQuantity() != null && sapChangeItem.getQuantity().compareTo(oldOrderItem.getQuantity()) != 0)) {
            needToConfirm = true;
        }

        return needToConfirm;
    }

    private boolean isChangeItem(PurchaseOrderItem sapChangeItem, PurchaseOrderItem oldOrderItem) {
        boolean isChangeItem = false;
        if (sapChangeItem.getIsEnable() != null
                && oldOrderItem.getIsEnable() != null
                && !oldOrderItem.getIsEnable().equals(sapChangeItem.getIsEnable())) {
            isChangeItem = true;
        }

        if ((sapChangeItem.getDeliveredDate() == null && oldOrderItem.getDeliveredDate() != null)
                || (sapChangeItem.getDeliveredDate() != null && oldOrderItem.getDeliveredDate() == null)
                || (sapChangeItem.getDeliveredDate() != null && oldOrderItem.getDeliveredDate() != null && sapChangeItem.getDeliveredDate().getTime() != oldOrderItem.getDeliveredDate().getTime())) {
            isChangeItem = true;
        }

        if ((sapChangeItem.getQuantity() != null && oldOrderItem.getQuantity() == null)
                || (sapChangeItem.getQuantity() != null && oldOrderItem.getQuantity() != null && sapChangeItem.getQuantity().compareTo(oldOrderItem.getQuantity()) != 0)) {
            isChangeItem = true;
        }

        if (sapChangeItem.getFinishFlag() != null &&
                oldOrderItem.getFinishFlag() != null
                && !sapChangeItem.getFinishFlag().equals(oldOrderItem.getFinishFlag())) {
            isChangeItem = true;
        }
        //退货项目改变
        if (sapChangeItem.getBackGoodsItem() != null &&
                oldOrderItem.getBackGoodsItem() != null
                && !sapChangeItem.getBackGoodsItem().equals(oldOrderItem.getBackGoodsItem())) {
            isChangeItem = true;
        }

        //Wbs_No 变更
        if (sapChangeItem.getWbsNo() != null &&
                oldOrderItem.getWbsNo() != null
                && !sapChangeItem.getWbsNo().equals(oldOrderItem.getWbsNo())) {
            isChangeItem = true;
        }


        return isChangeItem;
    }

    private void sendToSupplier(SupplierOrder supplierOrder, PurchaseOrder purchaseOrderFromSap) {
        SupplierOrder temp = new SupplierOrder();
        temp.setId(supplierOrder.getId());
        temp.setTotalAmount(purchaseOrderFromSap.getTotalAmount());
        temp.setPriceHs(purchaseOrderFromSap.getPriceHs());
        this.supplierOrderService.modifyObj(temp);
    }

    private boolean isNeedToConfirm(SupplierOrderItem sapChangeItem, SupplierOrderItem oldOrderItem) {
        boolean needToConfirm = false;

        if ((sapChangeItem.getDeliveredDate() == null && oldOrderItem.getDeliveredDate() != null)
                || (sapChangeItem.getDeliveredDate() != null && oldOrderItem.getDeliveredDate() == null)
                || (sapChangeItem.getDeliveredDate() != null && oldOrderItem.getDeliveredDate() != null && sapChangeItem.getDeliveredDate().getTime() != oldOrderItem.getDeliveredDate().getTime())) {
            needToConfirm = true;
        }

        if ((sapChangeItem.getQuantity() != null && oldOrderItem.getQuantity() == null)
                || (sapChangeItem.getQuantity() != null && oldOrderItem.getQuantity() != null && sapChangeItem.getQuantity().compareTo(oldOrderItem.getQuantity()) != 0)) {
            needToConfirm = true;
        }

        return needToConfirm;
    }

    private void sendToSupplier(List<SupplierOrderItem> changeOrderItemList) {

        logger.info("changeOrderItemList size = {}", changeOrderItemList.size());
        //供应商订单变更
        for (SupplierOrderItem soItem : changeOrderItemList) {
            Assert.isNotBlank(soItem.getId(), "id不能为空");

            //
            soItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());

            SupplierOrderItem oldItem = this.supplierOrderItemService.queryObjById(soItem.getId());
            PurchaseOrderItem item = this.purchaseOrderItemService.queryObjById(soItem.getId());
            soItem.setUserId(item.getSupUserId());
            soItem.setUserName(item.getSupUserName());
            soItem.setCompanyId(item.getSupCompanyId());
            soItem.setCompanyName(item.getSupCompanyName());
            soItem.setPurUserId(item.getPurUserId());
            soItem.setPurUserName(item.getPurUserName());
            soItem.setPurCompanyId(item.getPurCompanyId());
            soItem.setPurCompanyName(item.getPurCompanyName());
            soItem.setUpdateTime(new Date());
            //添加项目类别
            soItem.setItemDescription(item.getItemDescription());
            soItem.setItemType(item.getItemType());
            soItem.setNeedFollowNo(item.getNeedFollowNo());
            soItem.setWbsNo(item.getWbsNo());
            soItem.setWbsNoDesc(item.getWbsNoDesc());
            if (oldItem != null) {
                if (isNeedToConfirm(oldItem, soItem)) {
                    soItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
                } else {
                    soItem.setOrderStatus(oldItem.getOrderStatus());
                }
                this.supplierOrderItemService.modifyObj(soItem);
                continue;
            }

            this.supplierOrderItemService.addObj(soItem);
        }
    }

    private SupplierOrderItem createSupOrderItem(PurchaseOrderItem newOrderItem, PurchaseOrder purchaseOrder) {
        SupplierOrderItem supplierOrderItem = new SupplierOrderItem();
        BeanUtils.copyProperties(newOrderItem, supplierOrderItem);
        supplierOrderItem.setOrderItemNo(newOrderItem.getOrderItemNo());
        supplierOrderItem.setOrderNo(newOrderItem.getOrderNo());
        supplierOrderItem.setId(newOrderItem.getId());
        //变更之后都变为未确认//确认状态：1订单未确认，2已确认，3已退回
        supplierOrderItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        return supplierOrderItem;
    }

    /**
     * 是否全部都是已完成
     *
     * @param sapChangeItemList
     * @param oldPurchaseOrderItems
     * @return
     */
    private boolean isAllFinish(List<PurchaseOrderItem> sapChangeItemList, List<PurchaseOrderItem> oldPurchaseOrderItems) {
//		finishItemCount == oldPurchaseOrderItems.size() && haveNewItem == false

        int finishItemCount = 0;
        for (PurchaseOrderItem sapChangeItem : sapChangeItemList) {
            if (this.getOldItem(sapChangeItem, oldPurchaseOrderItems) == null) {
                //如果有新增的行，就不是全删除
                return false;
            }

            if (Constant.YES_STRING.equals(sapChangeItem.getIsEnable())) {
                //记录多少个已删除
                finishItemCount++;
            }
        }

        return finishItemCount == oldPurchaseOrderItems.size();
    }

    /**
     * 是否所有的行都是被删除的
     *
     * @param sapChangeItemList
     * @param oldPurchaseOrderItems
     * @return
     */
    private boolean isAllDelete(List<PurchaseOrderItem> sapChangeItemList, List<PurchaseOrderItem> oldPurchaseOrderItems) {
//		deleteItemCount == oldPurchaseOrderItems.size() && haveNewItem == false

        int deleteItemCount = 0;
        for (PurchaseOrderItem sapChangeItem : sapChangeItemList) {
            if (this.getOldItem(sapChangeItem, oldPurchaseOrderItems) == null) {
                //如果有新增的行，就不是全删除
                return false;
            }

            if (Constant.NO_INT.equals(sapChangeItem.getIsEnable())) {
                //记录多少个已删除
                deleteItemCount++;
            }
        }

        return deleteItemCount == oldPurchaseOrderItems.size();
    }

    /**
     * 从旧的订单数据中，找出订单行
     *
     * @param sapChangeItem
     * @param oldPurchaseOrderItems
     * @return
     */
    private PurchaseOrderItem getOldItem(PurchaseOrderItem sapChangeItem, List<PurchaseOrderItem> oldPurchaseOrderItems) {

        for (PurchaseOrderItem purchaseOrderItem : oldPurchaseOrderItems) {
            if (sapChangeItem.getOrderNo().equals(purchaseOrderItem.getOrderNo())
                    && sapChangeItem.getOrderItemNo().equals(purchaseOrderItem.getOrderItemNo())) {
                return purchaseOrderItem;
            }
        }
        return null;
    }

    private SupplierOrderItem updateOldOrderItem(PurchaseOrder purchaseOrder, PurchaseOrderItem sapChangeItem, PurchaseOrderItem oldOrderItem) {
        sapChangeItem.setId(oldOrderItem.getId());

        if (!this.isChangeItem(sapChangeItem, oldOrderItem)) {
            return null;
        }

        if (this.isNeedToConfirm(sapChangeItem, oldOrderItem)) {
            sapChangeItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        }

        sapChangeItem.setHaveChange(1);//订单更改
        sapChangeItem.setChangeTimes(oldOrderItem.getChangeTimes() + 1);//订单变更次数
//		sapChangeItem.setDeliveryAmount(oldOrderItem.getDeliveryAmount() + sapChangeItem.getQuantity().subtract(oldOrderItem.getQuantity()).longValue());
        sapChangeItem.setDeliveryAmount(oldOrderItem.getDeliveryAmount().add(sapChangeItem.getQuantity().subtract(oldOrderItem.getQuantity())));
        if (sapChangeItem.getDeliveryAmount().compareTo(BigDecimal.ZERO) == 0) {
			//如果可发货数量为0并且收货未完成 需要根据订单数量 在途数量 收货数量 冻结数量 进行计算可发货数量
            if(!"Y".equals(sapChangeItem.getFinishFlag())) {
                sapChangeItem.setDeliveryAmount(SysUtil.getCanDeliveryAmount(sapChangeItem.getQuantity(),
                        sapChangeItem.getOnwayQuantity(), sapChangeItem.getReceivedQuantity(), sapChangeItem.getFreezeQuantity()));
            }
        }

        this.purchaseOrderItemService.modifyObj(sapChangeItem);


        SupplierOrderItem supOrderItem = new SupplierOrderItem();
//		supOrderItem.setId(sapChangeItem.getId());
//		supOrderItem.setDeliveredDate(supOrderItem.getDeliveredDate());
//		supOrderItem.setQuantity(sapChangeItem.getQuantity());
//		supOrderItem.setFinishFlag(sapChangeItem.getFinishFlag());
//		supOrderItem.setIsEnable(sapChangeItem.getIsEnable());
        BeanUtils.copyProperties(sapChangeItem, supOrderItem);
        return supOrderItem;

    }

    private void insertNewPurOrderItem(String supplierSapCode, String purchaseOrderId, PurchaseOrderItem sapChangeItem) {
        sapChangeItem.setOrderId(purchaseOrderId);
        //新行，需要补充一些其他的信息，比如状态，供应商其他的信息
        //TODO
        //确认状态：1订单未确认，2已确认，3已退回, 4分批
        sapChangeItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanySapCodeEqualTo(supplierSapCode);
        List<Company> companies = this.companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companies)) {
            Company company = companies.get(0);
            //sapChangeItem.setProjectId();
            //sapChangeItem.setPurCompanyId(company.get);
            sapChangeItem.setProjectId(company.getProjectId());
            sapChangeItem.setSupCompanyId(company.getId());
            sapChangeItem.setHaveChange(0);
            //sapChangeItem.setSupCompanyName(company.getCompanyName());
            //
            if (StringUtils.isNotBlank(company.getProjectId())) {
                Project project = projectService.queryObjById(company.getProjectId());
                sapChangeItem.setPurCompanyId(project.getCompanyId());
                Company company1 = this.companyService.queryObjById(project.getCompanyId());

                sapChangeItem.setPurCompanyName(company1.getCompanyName());
                sapChangeItem.setPurCompanyOcde(company1.getCompanyCode());
                sapChangeItem.setPurCompanyName(company1.getCompanyName());
                sapChangeItem.setSapPurCompanyCode(company1.getCompanySapCode());
                //
            }
        }
        sapChangeItem.setUpdateTime(new Date());
        sapChangeItem.setChangeTimes(0);//0次
        this.purchaseOrderItemMapper.insertSelective(sapChangeItem);
    }


    /**
     * 采购订单变更次数更新
     *
     * @param oldPurchaseOrders
     * @param purchaseOrder
     */
    private void createPurOrder(List<PurchaseOrder> oldPurchaseOrders, PurchaseOrder purchaseOrder) {
        purchaseOrder.setId(oldPurchaseOrders.get(0).getId());
        purchaseOrder.setChangeTimes(oldPurchaseOrders.get(0).getChangeTimes() + 1);
        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }


    /**
     * 删除采购订单头和订单行
     *
     * @param oldPurchaseOrders
     * @param purchaseOrderId
     * @param oldPurchaseOrderItems
     */
    private void deleteOrderPurOrder(List<PurchaseOrder> oldPurchaseOrders, String purchaseOrderId) {

        logger.info("订单头删除");
        PurchaseOrder deletePurchaseOrder = new PurchaseOrder();
        deletePurchaseOrder.setId(purchaseOrderId);
        deletePurchaseOrder.setIsEnable(Constant.NO_INT);
        deletePurchaseOrder.setChangeTimes(oldPurchaseOrders.get(0).getChangeTimes() + 1);
        this.purchaseOrderMapper.updateByPrimaryKeySelective(deletePurchaseOrder);

        SupplierOrder supplierOrder = new SupplierOrder();
        supplierOrder.setId(purchaseOrderId);
        supplierOrder.setIsEnable(Constant.NO_INT);
//		supplierOrder.setChangeTimes(oldPurchaseOrders.get(0).getChangeTimes()+1);
        this.supplierOrderService.modifyObj(supplierOrder);

        logger.info("订单行删除");
        //查询采购订单行数据
        PurchaseOrderItemExample orderItemExample = new PurchaseOrderItemExample();
        orderItemExample.createCriteria()
                .andOrderNoEqualTo(oldPurchaseOrders.get(0).getOrderNo());
        List<PurchaseOrderItem> oldPurchaseOrderItems = this.purchaseOrderItemMapper.selectByExample(orderItemExample);

        for (PurchaseOrderItem item : oldPurchaseOrderItems) {
            item.setIsEnable(Constant.NO_INT);
            item.setChangeTimes(item.getChangeTimes() + 1);
            this.purchaseOrderItemMapper.updateByPrimaryKey(item);
        }

        SupplierOrderItemExample supplierOrderItemExample = new SupplierOrderItemExample();
        supplierOrderItemExample.createCriteria()
                .andOrderNoEqualTo(oldPurchaseOrders.get(0).getOrderNo());

        List<SupplierOrderItem> supplierOrderItems = this.supplierOrderItemService.queryAllObjByExample(supplierOrderItemExample);

        for (SupplierOrderItem item : supplierOrderItems) {
            item.setIsEnable(Constant.NO_INT);
//			item.setChangeTimes(item.getChangeTimes()+1);
            this.supplierOrderItemService.modifyObj(item);
        }
    }

    private PurchaseOrderChange addNewChangeOrder(PurchaseOrderItem newItem, PurchaseOrderItem oldItem, PurchaseOrder oldOrder) {
        if (PurchaseOrderSendStatusEnum.NOTSEND.getValue() == oldOrder.getOrderSendStatus()) {
            logger.info("订单行[{}]未确认，不需要进行采购变更申请", oldItem.getOrderItemNo());
            return null;
        }

        PurchaseOrderChange poc = new PurchaseOrderChange();
        BeanUtils.copyProperties(oldItem, poc);

        //防止复制ID进去
        poc.setId(null);

        poc.setStatus("NEW");
        poc.setConfirmStatus(BillStatusConfirmEnum.STATUS_UNCONFIRM.getCode());

        //采购公司信息
        poc.setPurCompanyId(oldItem.getPurCompanyId());
        poc.setPurCompanyName(oldItem.getPurCompanyName());
        poc.setPurCompanySapCode(oldItem.getSapPurCompanyCode());
        poc.setPurCompanySrmCode(oldItem.getPurCompanyOcde());

        //供应商公司信息
        poc.setSupCompanyId(oldOrder.getSupCompanyId());

        if (StringUtils.isBlank(oldItem.getCompanyShortName())) {
            poc.setSupCompanyName(oldItem.getSupCompanyName());
        } else {
            poc.setSupCompanyName(oldItem.getCompanyShortName());
        }
        poc.setSupCompanyFullName(oldItem.getSupCompanyName());
        poc.setSupCompanySapCode(oldOrder.getSupCompanySapCode());
        poc.setSupCompanySrmCode(oldItem.getCompanyCode());

        //供应商物料
        poc.setMaterialCode(oldItem.getMaterialCode());
        poc.setMaterialDesc(oldItem.getMaterialName());
        poc.setReceiveQuantity(oldItem.getReceivedQuantity());

        //订单单位
        poc.setUnit(oldItem.getOrderUnit());
        String priceUnit = oldItem.getPriceUnit();
        if (StringUtils.isNotBlank(priceUnit)) {
            poc.setPriceUnit(new BigDecimal(priceUnit));
        }
        poc.setApplyDate(new Date());

        poc.setOrderDate(oldItem.getOrderDate());
        String priceTaxTotal = StringUtils.defaultIfBlank(oldItem.getPriceTaxTotal(), "0");
        poc.setItemPriceTaxTotal(new BigDecimal(priceTaxTotal));

        poc.setNeedFollowNo(oldItem.getNeedFollowNo());
        poc.setWbsNo(oldItem.getWbsNo());
        poc.setWbsNoDesc(oldItem.getWbsNoDesc());
        poc.setProjectDesc(oldItem.getProjectDesc());


        //主要业务问题
        poc.setBeforeDeliveryDate(oldItem.getDeliveredDate());
        poc.setBeforeDeliveryNum(oldItem.getQuantity());
        poc.setDeliveryDate(newItem.getDeliveredDate());
        poc.setQuantity(newItem.getQuantity());

        return poc;
    }

    @Override
    public List<FileData> getPdfFiles(List<String> orderNoList) {
        List<FileData> fileDatas = new ArrayList<>();

        for (String orderNo : orderNoList) {
            KnPurOrderPdfVO headerVo = new KnPurOrderPdfVO();
            List<KnPurOrderPdfItemVO> orderItemVOs = new ArrayList<>();
            // PDF头信息
            PurchaseOrderExample example = new PurchaseOrderExample();
            example.createCriteria().andOrderNoEqualTo(orderNo);
            List<PurchaseOrder> orderList = purchaseOrderMapper.selectByExample(example);
            if (!orderList.isEmpty()) {
                BeanUtils.copyProperties(orderList.get(0), headerVo);
                // 公司信息
                Company company = companyService.queryObjById(orderList.get(0).getSupCompanyId());
                BeanUtils.copyProperties(company, headerVo);
                headerVo.setSupEmail(company.getEmail());
                headerVo.setSupplierPhone(company.getMobilephone());
                // 需方联系人信息
                UserExample userExample = new UserExample();
                userExample.createCriteria().andLoginNameEqualTo(orderList.get(0).getCreateUser());
                List<User> userList = userMapper.selectByExample(userExample);
                if (!userList.isEmpty()) {
                    User user = userList.get(0);
                    BeanUtils.copyProperties(user, headerVo);
                    headerVo.setNeddEmail(user.getEmail());
                }
            }

            // 物料清单信息
            PurchaseOrderItemExample itemExample = new PurchaseOrderItemExample();
            itemExample.createCriteria().andOrderNoEqualTo(orderNo);
            List<PurchaseOrderItem> orderItemList = purchaseOrderItemMapper.selectByExample(itemExample);
            for (PurchaseOrderItem purchaseOrderItem : orderItemList) {
                KnPurOrderPdfItemVO orderItemVO = new KnPurOrderPdfItemVO();
                BeanUtils.copyProperties(purchaseOrderItem, orderItemVO);
                orderItemVOs.add(orderItemVO);
            }

            // =============================物料清单排序 start===========================
            // 新建集合存放排序字段
            List<String> itemNoList = new ArrayList<>();
            for (KnPurOrderPdfItemVO itemVO : orderItemVOs) {
                // 增加排序字段
                itemNoList.add(itemVO.getOrderItemNo());
            }
            // 排序
            Collections.sort(itemNoList);
            // 存放排序完成的物料清单集合
            List<KnPurOrderPdfItemVO> sortOrderItemVOs = new ArrayList<>();
            for (String itemNo : itemNoList) {
                for (KnPurOrderPdfItemVO itemVO : orderItemVOs) {
                    if (itemNo.equals(itemVO.getOrderItemNo())) {
                        sortOrderItemVOs.add(itemVO);
                    }
                }
            }

            // =============================物料清单排序 end============================

            headerVo.setOrderItemVOs(sortOrderItemVOs);

            FileData pdfFile = PurchaseOrderPdfPrintUtil.getPdfFile(headerVo);
            fileDatas.add(pdfFile);
        }

        return fileDatas;
    }

    @CacheEvict(value = {"purchaseOrder"}, allEntries = true)
    @Override
    public void modifyOrderStatus(PurchaseOrder purchaseOrder) {
        if (StringUtils.isBlank(purchaseOrder.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }
    
    @Cacheable(value = "purchaseOrder", keyGenerator="redisKeyGenerator")
	@Override
	public int countByExample(PurchaseOrderExample purchaseOrderexample) {
		int example = this.purchaseOrderMapper.countByExample(purchaseOrderexample);
		return example;
	}

    @CacheEvict(value = {"purchaseOrder", "purchaseOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void addAll(List<PurchaseOrder> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (PurchaseOrder record : arg0) {
			this.purchaseOrderMapper.insertSelective(record);
		}
	}

    @CacheEvict(value = {"purchaseOrder", "purchaseOrderItem"}, allEntries = true)
	@Override
	public void deleteByExample(PurchaseOrderExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.purchaseOrderMapper.deleteByExample(arg0);
	}

}