package com.els.base.purchase.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.purchase.dao.ReceiveOrderMapper;
import com.els.base.purchase.entity.ReceiveOrder;
import com.els.base.purchase.entity.ReceiveOrderExample;
import com.els.base.purchase.service.ReceiveOrderService;

@Service("receiveOrderService")
public class ReceiveOrderServiceImpl implements ReceiveOrderService {
    @Resource
    protected ReceiveOrderMapper receiveOrderMapper;

    @CacheEvict(value={"receiveOrder"}, allEntries=true)
    @Override
    public void addObj(ReceiveOrder t) {
        this.receiveOrderMapper.insertSelective(t);
    }

    @CacheEvict(value={"receiveOrder"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.receiveOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"receiveOrder"}, allEntries=true)
    @Override
    public void modifyObj(ReceiveOrder t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.receiveOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="receiveOrder", keyGenerator="redisKeyGenerator")
    @Override
    public ReceiveOrder queryObjById(String id) {
        return this.receiveOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="receiveOrder", keyGenerator="redisKeyGenerator")
    @Override
    public List<ReceiveOrder> queryAllObjByExample(ReceiveOrderExample example) {
        return this.receiveOrderMapper.selectByExample(example);
    }

    @Cacheable(value="receiveOrder", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ReceiveOrder> queryObjByPage(ReceiveOrderExample example) {
        PageView<ReceiveOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.receiveOrderMapper.selectByExampleByPage(example));
        return pageView;
    }
    @CacheEvict(value={"receiveOrder"}, allEntries=true)
	@Override
	public void deleteByExample(ReceiveOrderExample example) {
		// TODO Auto-generated method stub
        this.receiveOrderMapper.deleteByExample(example);
	}
    @Cacheable(value="receiveOrder", keyGenerator="redisKeyGenerator")
	@Override
	public ReceiveOrder selectByDeliveryOrderNo(String deliveryOrderNo) {
		ReceiveOrder receiveOrder = receiveOrderMapper.selectByDeliveryOrderNo(deliveryOrderNo);	
		return receiveOrder;
	}

    @CacheEvict(value={"receiveOrder"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<ReceiveOrder> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (ReceiveOrder record : arg0) {
			this.receiveOrderMapper.insertSelective(record);
		}
	}
}