package com.els.base.purchase.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.purchase.vo.KnPurOrderPdfVO;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;

/**
 * 采购订单PDF文件打印
 * @author zhoulongpeng
 *
 */
public class PurchaseOrderPdfPrintUtil {
	
	private static Logger logger = LoggerFactory.getLogger(PurchaseOrderPdfPrintUtil.class);
	
	
	public static FileData getPdfFile(KnPurOrderPdfVO headerVo) {
		
		try {
			logger.info("=====================> 采购订单生成PDF开始");
			
			// 设置参数
			Map<String, Object> params = new HashMap<>();
			params.put("purchaseOrder", headerVo);
			params.put("fontPath", PurchaseOrderPdfPrintUtil.class.getClassLoader().getResource("").toString() + "fonts/nsimsum.ttf");

			String filename = null;  //pdf文件名
			FileData pdfFile = null; //pdf文件
			String html = null;      //pdf生成需要的html
			
			// 选择html模板
			html = BeetlTemplateUtils.renderFromFile("purchaseOrderPdf.html", params);
			logger.info(html);
			// 生成文件名
			filename =  "采购订单PDF" + DateFormatUtils.format(new Date(), "yyyy-MM-dd-HH-mm");
			// 生成空的PDF文件
			pdfFile = createEmptyPDF(headerVo.getProjectId(), headerVo.getCompanyId(), filename);
			// 根据html 生成pdf，并写入pdf文件里面
			HtmlToPdfUtils.generatePdf(html, pdfFile.toFile(),HtmlToPdfUtils.PAGE_SIZE_A4, true, filename);
//			HtmlToPdfUtils.generatePdf(html, pdfFile.toFile(), 216f, 139.5f, filename);
			logger.info("=====================> 采购订单生成PDF结束");
			
			return pdfFile;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("=====================> 采购订单生成PDF异常");
			throw new CommonException("采购订单导出PDF异常");
		}
	}

	public static FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException{
		FileData pdfFile = new FileData();
		pdfFile.setProjectId(projectId);
		pdfFile.setCompanyId(companyId);
		
		pdfFile.setFileName(filename+".pdf");
		pdfFile.setFileSuffix("pdf");
		pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
		pdfFile.setExpiryDay(DateUtils.addMinutes(new Date(), 30));
		FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
		return pdfFile;
	}
}
