package com.els.base.purchase.utils;

/**
 * 订单状态
 * 
 * @author Administrator
 *
 */
public enum PurchaseOrderStatusEnum {

	UNCONFIRM(1, "订单未确认"), //头、行状态，未确认
	CONFIRM(2, "订单确认"), //头、行状态，已确认
	BACK(3, "订单拒绝"), //头、行状态，已拒绝
	PART_BACK(4, "部分拒绝"),//头状态，部分拒绝
	ITEM_BATCH(4, "订单行分批"),//行状态，分批
	BATCH(5, "分批"),//头状态，分批
	PART_CONFIRM(6, "部分确认");//部分分批

	
	private final int value;
	private final String desc;

	PurchaseOrderStatusEnum(int value, String desc) {
		this.value = value;
		this.desc = desc;
	}

	public int getValue() {
		return value;
	}

	public String getDesc() {
		return desc;
	}

}
