package com.els.base.purchase.utils;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;

import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.supperorder.entity.SupplierOrder;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.qrcode.QrcodeUtils;

public class SysUtil {

    private static final Logger logger = LoggerFactory.getLogger(SysUtil.class);
    private static final int PRINT_PAGE_SIZE = 10;// 打印分页数

    /**
     * 生成新的订单号
     *
     * @param purchaseOrderNumber
     * @return
     */
    public static String getOrderNumber(String purchaseOrderNumber) {
        String newPurchaseOrderNumber = "";
        Calendar a = Calendar.getInstance();
        int year = a.get(Calendar.YEAR) % 100;// 得到年
        // 如果数据库中没有订单，给个默认订单号
        if (StringUtils.isBlank(purchaseOrderNumber)) {
            newPurchaseOrderNumber = "20" + year + "00000001";
        } else {
            int lastNumber = Integer.parseInt(purchaseOrderNumber.substring(4)) + 1;
            String addZero = "";
            for (int i = 0; i < 8 - (lastNumber + "").length(); i++) {
                addZero += "0";
            }
            newPurchaseOrderNumber = "20" + year + addZero + lastNumber;
        }
        return newPurchaseOrderNumber;
    }

    /**
     * 生成新的发货单号
     *
     * @return
     */
    public static String getNextDeliveryNumber() {
        GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
        String newNo = generateCodeService.getNextCode("DELIVERY_NO_GENERATOR");
        return newNo;
    }

    /**
     * 生成新的物流单号
     *
     * @return
     */
    public static String getNextLogisticsNumber() {
        GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
        String newNo = generateCodeService.getNextCode("LOGISTIC_NO_GENERATOR");
        return newNo;
    }

    /**
     * 生成新的invoice单号
     *
     * @return
     */
    public static String getNextInvoiceNumber() {
        GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
        String newNo = generateCodeService.getNextCode("VOINCE_NO_GENERATOR");
        return newNo;
    }

    /**
     * 去除字符串前面的零
     *
     * @param val
     * @return
     */
    public static String removeZero(String val) {
        if (StringUtils.isBlank(val)) {
            return val;
        }
        int len = val.length();// 取得字符串的长度
        int index = 0;// 预定义第一个非零字符串的位置
        char strs[] = val.toCharArray();// 将字符串转化成字符数组
        for (int i = 0; i < len; i++) {
            if ('0' != strs[i]) {
                index = i;// 找到非零字符串并跳出
                break;
            }
        }
        return val.substring(index, len);// 截取字符串
    }

    public static String addZero(String val, int length) {
        if (StringUtils.isBlank(val)) {
            return val;
        }
        int len = val.length();// 取得字符串的长度
        int index = 0;// 预定义第一个非零字符串的位置
        char strs[] = val.toCharArray();// 将字符串转化成字符数组
        String zeroStr = "";
        for (int i = 0; i < length - len; i++) {
            zeroStr += "0";
        }
        return zeroStr + val;
    }

    /**
     * 文件名称
     *
     * @param val
     * @param length
     * @return
     */
    public static String getNextFileName() {
        String rid = "";
        rid = "f"
                + DateFormatUtils.format(new Date(), "yyyyMMdd").substring(2,
                DateFormatUtils.format(new Date(), "yyyyMMdd").length());
        Random random = new Random();
        int rannum = (int) (random.nextDouble() * (99999 - 10000 + 1)) + 10000;// 获取5位随机数
        return rid + rannum;
    }

    /**
     * 生成条码
     *
     * @param content     条码内容
     * @param charsetName 编码格式
     * @param width       宽度
     * @param fileUpload  文件
     * @return
     */

    public static FileData createQrcode(String content, String charsetName, int width, FileData fileUpload) {
        FileData fileData = null;
        try {
            BufferedImage bufferedImage = QrcodeUtils.writeQrcode(content, charsetName, width);
            InputStream in = getImageStream(bufferedImage);
            fileData = FileManagerFactory.getFileManager().write(in, fileUpload);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return fileData;
    }

    /**
     * BufferedImage 转换为 InputStream
     *
     * @param bi
     * @return
     */
    public static InputStream getImageStream(BufferedImage bi) {
        InputStream is = null;
        bi.flush();
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ImageOutputStream imOut;
        try {
            imOut = ImageIO.createImageOutputStream(bs);
            ImageIO.write(bi, "png", imOut);
            is = new ByteArrayInputStream(bs.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }


    /**
     * 送货单打印2
     *
     * @param deliveryOrderPrint
     * @return
     */
    /*
     * public static FileData deliveryOrderPrint2(DeliveryOrderPrint deliveryOrderPrint) { FileData
     * fileData = new FileData(); StringBuffer result=new StringBuffer();
     *
     *
     * try {
     *
     * //头部 String A4Heather=
     * TemplateUtils.write(DataResultUtils.process(deliveryOrderPrint),"A4-Heather.ftl");
     * result.append(A4Heather);
     *
     * Map map=DataResultUtils.process(deliveryOrderPrint); //变化部分 int totalPage=1; int
     * startRowNo=1; int endRowNo=10; int pageSize=10;
     * if(deliveryOrderPrint.getPrintItems().size()%pageSize==0){
     * totalPage=deliveryOrderPrint.getPrintItems().size()/pageSize; }else{
     * totalPage=deliveryOrderPrint.getPrintItems().size()/pageSize+1; }
     *
     * for (int i = 0; i <totalPage ; i++) { //数据头部 String A4BodyHeader=
     * TemplateUtils.write(map,"A4-Body-Header.ftl"); result.append(A4BodyHeader);
     *
     * String A4DataHeader= TemplateUtils.write(map,"A4-Data-Header.ftl");
     * result.append(A4DataHeader);
     *
     * //数据的拼装 List<DeliveryOrderItemPrint> printItems=deliveryOrderPrint.getPrintItems();
     *
     *
     * for (int j = 0; j < 20; j++) { DeliveryOrderItemPrint
     * deliveryOrderItemPrint=printItems.get(j); Map<String,Object> root=new
     * HashMap<String,Object>(); //序号 root.put("num",j+1);
     * root.put("purOrderNo",deliveryOrderItemPrint
     * .getPurOrderNo()==null?"":deliveryOrderItemPrint.getPurOrderNo());
     * root.put("purOrderItemNo",deliveryOrderItemPrint
     * .getPurOrderItemNo()==null?"":deliveryOrderItemPrint.getPurOrderItemNo());
     * root.put("materialNo"
     * ,deliveryOrderItemPrint.getMaterialNo()==null?"":deliveryOrderItemPrint.getMaterialNo());
     * root
     * .put("materialDesc",deliveryOrderItemPrint.getMaterialDesc()==null?"":deliveryOrderItemPrint
     * .getMaterialDesc());
     * root.put("deliveryQuantity",deliveryOrderItemPrint.getDeliveredQuantity()
     * ==null?"":deliveryOrderItemPrint.getDeliveredQuantity());
     * root.put("orderUnit",deliveryOrderItemPrint
     * .getOrderUnit()==null?"":deliveryOrderItemPrint.getOrderUnit());
     * root.put("packQuantity",deliveryOrderItemPrint
     * .getPackQuantity()==null?"":deliveryOrderItemPrint.getPackQuantity());
     * root.put("remark",deliveryOrderItemPrint
     * .getRemark()==null?"":deliveryOrderItemPrint.getRemark());
     *
     * //组装数据 String A4Data= TemplateUtils.write(root,"A4-Data.ftl"); result.append(A4Data); }
     *
     *
     * String A4DataFooter= TemplateUtils.write(map,"A4-Data-Footer.ftl");
     * result.append(A4DataFooter);
     *
     *
     * //数据尾部 String BodyFooter= TemplateUtils.write(map,"A4-Body-Footer.ftl");
     * result.append(BodyFooter);
     *
     * //分页 String A4Page= TemplateUtils.write(map,"A4-Page.ftl"); result.append(A4Page); }
     *
     *
     * //尾部 String A4Footer= TemplateUtils.write(map,"A4-Footer.ftl"); result.append(A4Footer);
     *
     * } catch (NoSuchAlgorithmException e) { e.printStackTrace(); } catch (IOException e) {
     * e.printStackTrace(); } catch (TemplateException e) { e.printStackTrace(); }
     * fileData=htmlToPdfForJavaUtils(result.toString(), deliveryOrderPrint.getProjectId(),
     * deliveryOrderPrint.getCompanyId()); return fileData; }
     */

    /**
     * 送货单打印
     *
     * @param deliveryOrderPrint
     * @return
     */
    /*
     * public static FileData deliveryOrderPrint(DeliveryOrderPrint deliveryOrderPrint) {
     *
     * FileData fileData = new FileData(); StringBuffer html = new StringBuffer(); //
     * 组装成符合W3C标准的html文件，否则不能正确解析 html.append(
     * "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"
     * ); Date date=deliveryOrderPrint.getDeliveryDate(); if(date==null){
     * date=deliveryOrderPrint.getCreateTime(); } if(deliveryOrderPrint.getPurchaseTel()==null){
     * deliveryOrderPrint.setPurchaseTel(""); } if(deliveryOrderPrint.getReceiveAddress()==null){
     * deliveryOrderPrint.setReceiveAddress(""); } if(deliveryOrderPrint.getPurchasePerson()==null){
     * deliveryOrderPrint.setPurchasePerson(""); } if(deliveryOrderPrint.getSupplierTel()==null){
     * deliveryOrderPrint.setSupplierTel(""); }
     *
     * String tables=""; int index=1; List<DeliveryOrderItemPrint> printItems =
     * deliveryOrderPrint.getPrintItems(); //判断打印是A4还A5
     * if(StringUtils.isNotBlank(deliveryOrderPrint.
     * getPrintSizeType())&&deliveryOrderPrint.getPrintSizeType().equals("A5")){
     *
     * html.append("<html><head><meta charset='utf-8'></meta><title></title>" +
     * "<style type='text/css'>" +
     * ".pageNext{page-break-after:always;}.header1 {position: running(header);color:#cccccc;font-family: SimSun;padding-top:25pt;}.footer { position: running(footer) }@page {@top-center {content: element(header)}@bottom-center {content: element(footer)} "
     * +
     * "size: 210mm 148mm; margin: 0.25in;-fs-flow-top: 'header'; -fs-flow-bottom: 'footer'; -fs-flow-left: 'left'; -fs-flow-right: 'right';  padding: 1em; }"
     * +
     * "*{padding:0;margin:0;}.page{padding:8mm 5mm 5mm;box-shadow:1px 1px 10px rgba(0,0,0,0.42);margin:10px auto;}.page{background:#fff;color:#000;box-sizing:border-box;font-weight:350px;position:relative;font-family:SimHei,Microsoft YaHei,SimSun,'宋体','黑体','幼圆',Helvetica Neue,Helvetica,Arial,sans-serif;}.headTable{margin-bottom:-1px;}.T-w100{width:100%;}table{max-width:100%;background-color:transparent;border-collapse:collapse;border-spacing:0;}.headTable tr{border:1px solid #000;color:#000;}.text-center{text-align:center;}.P0{padding-left:0!important;}.headTable tr td{padding-left:10px;font-size:10pt;border:1px solid #000;line-height:16px;}.headTable .T-title{line-height:1;font-size:20px;font-weight:bold;padding:4px 0;}.lh34{line-height:34px;}.bodyTable tr .T-body-w1{width:4%;}.bodyTable tr th,.bodyTable tr td{border:1px solid #000;text-align:center;line-height:16px;color:#000;}.bodyTable{text-align:center;font-size:12pt;}.bodyTable tr .T-body-w8{width:13%;}.bodyTable tr .T-body-w9{width:5%;}.bodyTable tr .T-body-w7{width:5%;}.bodyTable tr .T-body-w6{width:5%;}.bodyTable tr .T-body-w5{width:15%;}.bodyTable tr .T-body-w4{width:12%;}.bodyTable tr .T-body-w3{width:5%;}.bodyTable tr .T-body-w2{width:13%;padding:6px 0;}.T-head-w2{width:66%;}.page table.fl td,.page table.fl th{font-size:14px;}.c45{width:45%;}.c30{width:30%;}.code.abs{top:2mm;}.page table.fl th:nth-child(4){width:auto;}.page .fl label,.page .fl span{font-size:16px;}.b32{font-size:32px;font-weight:600;line-height:1;}.abs{position:absolute!important;right:0;bottom:-40px;} img {max-height: 40px;}</style>"
     * + "</head><body>" + "<div class='page' style='width: 180mm;'>" +
     * "<div><div class='tpl tpl-css'></div>" + "<div class='tpl tpl-title'>" +
     * "<div class='title b32' style='display:none;'>标准送货单</div></div>" +
     * "<div class='tpl tpl-header'><div style='position: absolute;right: 16px;top: 34px;'>" +
     * "<img src='"+deliveryOrderPrint.getScanPicPath()+"'></img></div>" +
     * "<div class='text-center T-title P0' style='font-size: 24px;' colspan='3'>" +
     * "<span >"+deliveryOrderPrint.getCompanyName()+"</span></div>" +
     * "<div class='text-center T-title P0' colspan='3' style='font-size: 24px;padding:10px 0;'>送货单</div>"
     * + "<table class='T-w100 headTable'><tbody><tr>" +
     * "<td class='T-head-w1'><span class='T-detail'>送货单号：<span class='T-deatilTxt' >"
     * +deliveryOrderPrint.getDeliveryOrderNo()+"</span></span></td>" +
     * "<td class='T-head-w2'><span class='T-detail'>客户：<span class='T-deatilTxt'>华阳通用电子有限公司</span></span></td></tr>"
     * + "<tr><td class='T-head-w1'><span class='T-detail'>单据日期：<span class='T-deatilTxt' >"+
     * DateFormatUtils.format(date, "yyyy-MM-dd")+"</span></span></td>" +
     * "<td class='T-head-w2'><span class='T-detail'>收货地址：<span class='T-deatilTxt'>"
     * +deliveryOrderPrint.getReceiveAddress()+"</span></span></td></tr>" +
     * "<tr><td class='T-head-w1'><span class='T-detail'>供应商联系人：<span class='T-deatilTxt' >"
     * +deliveryOrderPrint.getSupplierPerson()+"</span></span></td>" +
     * "<td class='T-head-w2'><span class='T-detail'>客户联系人：<span class='T-deatilTxt' >"
     * +deliveryOrderPrint.getPurchasePerson()+"</span></span></td></tr>" +
     * "<tr><td class='T-head-w1 lastRowTd'><span class='T-detail'>供应商联系电话：<span class='T-deatilTxt' >"
     * +deliveryOrderPrint.getSupplierTel()+"</span></span></td>" +
     * "<td class='T-head-w2 lastRowTd'><span class='T-detail'>客户联系电话：<span class='T-deatilTxt' >"
     * +deliveryOrderPrint.getPurchaseTel()+"</span></span></td></tr>" + "</tbody></table></div>");
     * }else{ html.append("<html><head><meta charset='utf-8'></meta><title></title>" +
     * "<style type='text/css'>" +
     * ".pageNext{page-break-after:always;}.header1 {position: running(header);color:#cccccc;font-family: SimSun;padding-top:25pt;}.footer { position: running(footer) }@page {@top-center {content: element(header)}@bottom-center {content: element(footer)} "
     * +
     * "size: 210mm 297mm; margin: 0.25in; -fs-flow-top: 'header'; -fs-flow-bottom: 'footer'; -fs-flow-left: 'left'; -fs-flow-right: 'right'; padding: 1em; }"
     * + "*{
     *
     */

    /**
     * 计算订单的可发货数量
     *
     * @param quantity
     * @param onwayQuantity
     * @param receivedQuantity
     * @return public static long getCanDeliveryAmount(BigDecimal quantity, BigDecimal onwayQuantity,
     * BigDecimal receivedQuantity, BigDecimal freezeQuantity) {
     */
    public static BigDecimal getCanDeliveryAmount(BigDecimal quantity, BigDecimal onwayQuantity,
                                                  BigDecimal receivedQuantity, BigDecimal freezeQuantity) {
        //long canDeliveryAmount = 0;
        BigDecimal canDeliveryAmount = new BigDecimal("0");
        quantity = quantity == null ? BigDecimal.ZERO : quantity;// 采购订单数量
        onwayQuantity = onwayQuantity == null ? BigDecimal.ZERO : onwayQuantity;// 在途数量
        receivedQuantity = receivedQuantity == null ? BigDecimal.ZERO : receivedQuantity;// 收货数量
        freezeQuantity = freezeQuantity == null ? BigDecimal.ZERO : freezeQuantity;// 冻结数量

        // 可发货数量 = 订单数量 - 已收货数量 -在途数量 -冻结数量
        //canDeliveryAmount = quantity.subtract(onwayQuantity)
        //                .subtract(receivedQuantity)
        //                .subtract(freezeQuantity).longValue();
        canDeliveryAmount = quantity.subtract(onwayQuantity)
                .subtract(receivedQuantity)
                .subtract(freezeQuantity);
        logger.info("----------quantity--------[" + quantity + "]-----onwayQuantity------["
                + onwayQuantity + "]--------canDeliveryAmount----[" + canDeliveryAmount
                + "]-------freezeQuantity----[" + freezeQuantity + "]-----");

        return canDeliveryAmount;
    }

    /**
     * 采购订单头行转销售订单头行
     *
     * @param purchaseOrder
     * @param supplierOrder
     */
    public static void purhcaseTosSupplier(PurchaseOrder purchaseOrder, SupplierOrder supplierOrder) {

        //供应商采购订单头
        BeanUtils.copyProperties(purchaseOrder, supplierOrder);
        supplierOrder.setUserId(purchaseOrder.getSupUserId());
        supplierOrder.setUserName(purchaseOrder.getSupUserName());
        supplierOrder.setCompanyId(purchaseOrder.getSupCompanyId());
        supplierOrder.setCompanySapCode(purchaseOrder.getSupCompanySapCode());
        supplierOrder.setCompanyName(purchaseOrder.getSupCompanyName());
        supplierOrder.setPurUserId(purchaseOrder.getUserId());
        supplierOrder.setPurUserName(purchaseOrder.getUserName());
        supplierOrder.setPurCompanyId(purchaseOrder.getCompanyId());
        supplierOrder.setPurCompanyCode(purchaseOrder.getCompanyCode());
        supplierOrder.setPurCompanyName(purchaseOrder.getCompanyName());
        Date date = new Date();
        supplierOrder.setCreateTime(date);
        supplierOrder.setLastUpdateTime(date);

        //供应商订单行
        List<SupplierOrderItem> supplierOrderItems = new ArrayList<SupplierOrderItem>();
        List<PurchaseOrderItem> purchaseOrderItems = purchaseOrder.getItems();
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrderItems) {
            SupplierOrderItem supplierOrderItem = new SupplierOrderItem();
            BeanUtils.copyProperties(purchaseOrderItem, supplierOrderItem);
            supplierOrderItem.setUserId(supplierOrder.getUserId());
            supplierOrderItem.setUserName(supplierOrder.getUserName());
            supplierOrderItem.setCompanyId(supplierOrder.getCompanyId());
            supplierOrderItem.setCompanyName(supplierOrder.getCompanyName());
            supplierOrderItem.setPurUserId(supplierOrder.getPurUserId());
            supplierOrderItem.setPurUserName(supplierOrder.getPurUserName());
            supplierOrderItem.setPurCompanyId(supplierOrder.getPurCompanyId());
            supplierOrderItem.setPurCompanyName(supplierOrder.getPurCompanyName());
            supplierOrderItem.setSapSupCompanyCode(supplierOrder.getCompanySapCode());
            supplierOrderItem.setUpdateTime(date);

            //添加项目类别
            supplierOrderItem.setItemDescription(purchaseOrderItem.getItemDescription());
            supplierOrderItem.setItemType(purchaseOrderItem.getItemType());
            supplierOrderItem.setOrderType(purchaseOrder.getOrderType());
            supplierOrderItem.setOrderTypeDesc(purchaseOrder.getOrderTypeDesc());
            supplierOrderItem.setNeedFollowNo(purchaseOrderItem.getNeedFollowNo());
            supplierOrderItem.setWbsNo(purchaseOrderItem.getWbsNo());
            supplierOrderItem.setWbsNoDesc(purchaseOrderItem.getWbsNoDesc());

            supplierOrderItems.add(supplierOrderItem);
        }
        supplierOrder.setItems(supplierOrderItems);
    }

    /**
     * 采购订单行转销售订单行
     *
     * @param purchaseOrder
     * @param purchaseOrderItem
     */
    public static SupplierOrderItem purhcaseItemTosSupplierItem(PurchaseOrder purchaseOrder, PurchaseOrderItem purchaseOrderItem) {
        SupplierOrderItem supplierOrderItem=new SupplierOrderItem();

        BeanUtils.copyProperties(purchaseOrderItem, supplierOrderItem);
        supplierOrderItem.setUserId(purchaseOrder.getUserId());
        supplierOrderItem.setUserName(purchaseOrder.getUserName());
        supplierOrderItem.setCompanyId(purchaseOrder.getCompanyId());
        supplierOrderItem.setCompanyName(purchaseOrder.getCompanyName());
        supplierOrderItem.setPurUserId(purchaseOrderItem.getPurUserId());
        supplierOrderItem.setPurUserName(purchaseOrderItem.getPurUserName());
        supplierOrderItem.setPurCompanyId(purchaseOrderItem.getPurCompanyId());
        supplierOrderItem.setPurCompanyName(purchaseOrderItem.getPurCompanyName());
        supplierOrderItem.setSapSupCompanyCode(purchaseOrderItem.getSapSupCompanyCode());
        supplierOrderItem.setUpdateTime(new Date());

        //添加项目类别
        supplierOrderItem.setItemDescription(purchaseOrderItem.getItemDescription());
        supplierOrderItem.setItemType(purchaseOrderItem.getItemType());
        supplierOrderItem.setOrderType(purchaseOrderItem.getOrderType());
        supplierOrderItem.setOrderTypeDesc(purchaseOrder.getOrderTypeDesc());
        supplierOrderItem.setNeedFollowNo(purchaseOrderItem.getNeedFollowNo());
        supplierOrderItem.setWbsNo(purchaseOrderItem.getWbsNo());
        supplierOrderItem.setWbsNoDesc(purchaseOrderItem.getWbsNoDesc());
        return  supplierOrderItem;
    }

    /**
     * 判断销售订单确认是否进行最新记录还原
     *
     * @return
     */
    public static boolean isReturnNewRecord() {
        Properties properties = SpringContextHolder.getBean("sysConfig");
        if (properties != null) {
            String isReturnNewRecord = properties.getProperty("order.isReturnNewRecord", "true"); //
            return Boolean.valueOf(isReturnNewRecord);
        } else {
            return true;
        }
    }

}
