package com.els.base.purchase.vo;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;

/**
 * 供应商订单PDF导出数据VO
 * 
 * @author linyuqin
 * @date 2018年3月22日15:08:35
 */
public class KnSupOrderPdfVO {
	
	// 物料清单
	@ApiModelProperty("物料清单")
	private List<KnSupOrderPdfItemVO> orderItemVOs;
	
	@ApiModelProperty("项目id")
	private String projectId;
	
	@ApiModelProperty("公司id")
	private String companyId;
	
	//=========================pdf头信息开始=============================	
	
	// 采购部门
	@ApiModelProperty("采购部门")
	private String departmentName;
	
	// 需方
	@ApiModelProperty("需方")
	private String companyName;
	
	// 需方联系人
	@ApiModelProperty("需方联系人")
	private String nickName;
	
	// 需方联系人电话
	
	// 需方联系人手机
	@ApiModelProperty("需方联系人手机")
    private String mobilePhone;
	
	// 需方联系人传真
	@ApiModelProperty("需方联系人传真")
    private String fax;
	
	// 需方联系人邮箱
	@ApiModelProperty("需方联系人邮箱")
    private String neddEmail;
	
	// 供应商
	@ApiModelProperty("供应商")
	private String supCompanyName;
	
	// 供应商联系人
	@ApiModelProperty("供应商联系人")
	private String supplierPersion;
	
	// 供应商电话
	@ApiModelProperty("供应商电话")
	private String supplierTel;
	
	// 供应商手机
	@ApiModelProperty("供应商电话")
	private String supplierPhone;
	
	// 供应商传真
	@ApiModelProperty("供应商传真")
	private String supplierTax;
	
	// 采购订单号
	@ApiModelProperty("采购订单号")
	private String orderNo;
	
	// 采购订单日期
	@ApiModelProperty("采购订单日期")
	private Date orderDate;
	
	@ApiModelProperty("供应商银行账号")
    private String bankAccount;
	
	@ApiModelProperty("供应商邮箱")
    private String supEmail;
	
	@ApiModelProperty("供应商详细地址")
    private String address;
	
	@ApiModelProperty("供应商纳税号")
    private String taxCert;
	//=========================pdf头信息结束==============================
	
	
	//=========================pdf尾部信息开始=============================
	
	// 含税金额
	@ApiModelProperty("含税金额")
	private BigDecimal priceHs;
	
	// 货币
	@ApiModelProperty("货币")
	private String currency;
	
	@ApiModelProperty("付款方式")
	private String payTermsDesc;
	
	@ApiModelProperty("不含税金额")
	private BigDecimal totalAmount;

	//=========================pdf尾部信息结束=============================

	public String getDepartmentName() {
		return departmentName;
	}

	public List<KnSupOrderPdfItemVO> getOrderItemVOs() {
		return orderItemVOs;
	}

	public void setOrderItemVOs(List<KnSupOrderPdfItemVO> orderItemVOs) {
		this.orderItemVOs = orderItemVOs;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public String getSupCompanyName() {
		return supCompanyName;
	}

	public void setSupCompanyName(String supCompanyName) {
		this.supCompanyName = supCompanyName;
	}

	public String getSupplierPersion() {
		return supplierPersion;
	}

	public void setSupplierPersion(String supplierPersion) {
		this.supplierPersion = supplierPersion;
	}

	public String getSupplierTel() {
		return supplierTel;
	}

	public void setSupplierTel(String supplierTel) {
		this.supplierTel = supplierTel;
	}

	public String getSupplierTax() {
		return supplierTax;
	}

	public void setSupplierTax(String supplierTax) {
		this.supplierTax = supplierTax;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	public String getCompanyId() {
		return companyId;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public String getOrderDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		
		return sdf.format(this.orderDate);
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public BigDecimal getPriceHs() {
		return priceHs;
	}

	public void setPriceHs(BigDecimal priceHs) {
		this.priceHs = priceHs;
	}

	public String getCurrency() {
		return currency;
	}

	public void setCurrency(String currency) {
		this.currency = currency;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getSupEmail() {
		return supEmail;
	}

	public void setSupEmail(String supEmail) {
		this.supEmail = supEmail;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTaxCert() {
		return taxCert;
	}

	public void setTaxCert(String taxCert) {
		this.taxCert = taxCert;
	}

	public String getMobilePhone() {
		return mobilePhone;
	}

	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}

	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	public String getNeddEmail() {
		return neddEmail;
	}

	public void setNeddEmail(String neddEmail) {
		this.neddEmail = neddEmail;
	}

	public String getPayTermsDesc() {
		return payTermsDesc;
	}

	public void setPayTermsDesc(String payTermsDesc) {
		this.payTermsDesc = payTermsDesc;
	}

	public String getSupplierPhone() {
		return supplierPhone;
	}

	public void setSupplierPhone(String supplierPhone) {
		this.supplierPhone = supplierPhone;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

}
