package com.els.base.purchase.web.controller;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.purchase.entity.ReceiveOrder;
import com.els.base.purchase.entity.ReceiveOrderExample;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.purchase.service.ReceiveOrderService;
import com.els.base.delivery.utils.DeliveryStatusEnum;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value = "收货表")
@Controller
@RequestMapping("receiveOrder")
public class ReceiveOrderController {
    @Resource
    protected ReceiveOrderService receiveOrderService;

    @Resource
    protected DeliveryOrderService deliveryOrderService;

    @ApiOperation(httpMethod = "POST", value = "查询收货表")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        ReceiveOrderExample example = new ReceiveOrderExample();
        example.createCriteria().andCompanyIdEqualTo(companyId).andProjectIdEqualTo(projectId);
        List<ReceiveOrder> receiveOrderList = this.receiveOrderService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(receiveOrderList)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }
        List<String> ids = new ArrayList<String>();
        for (ReceiveOrder receiveOrder : receiveOrderList) {
            ids.add(receiveOrder.getDeliveryOrderId());
        }
        DeliveryOrderExample example2 = new DeliveryOrderExample();
        example2.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));

        DeliveryOrderExample.Criteria criteria = example2.createCriteria();
        criteria.andIdIn(ids);
        List<Integer> deliveryStatus = new ArrayList<Integer>();
        // 已经收获的状态
        deliveryStatus.add(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        criteria.andDeliveryStatusIn(deliveryStatus);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example2);
        return ResponseResult.success(pageData);
    }
}