package com.els.base.supperorder.dao;

import java.util.List;

import com.els.base.supperorder.entity.*;
import org.apache.ibatis.annotations.Param;

public interface SupplierOrderItemMapper {
    int countByExample(SupplierOrderItemExample example);

    int deleteByExample(SupplierOrderItemExample example);

    int deleteByPrimaryKey(String id);

    int insert(SupplierOrderItem record);

    int insertSelective(SupplierOrderItem record);

    List<SupplierOrderItem> selectByExample(SupplierOrderItemExample example);

    SupplierOrderItem selectByPrimaryKey(String id);

    int updateByExampleSelective(@Param("record") SupplierOrderItem record, @Param("example") SupplierOrderItemExample example);

    int updateByExample(@Param("record") SupplierOrderItem record, @Param("example") SupplierOrderItemExample example);

    int updateByPrimaryKeySelective(SupplierOrderItem record);

    int updateByPrimaryKey(SupplierOrderItem record);

    List<SupplierOrderItem> selectByExampleByPage(SupplierOrderItemExample example);

    /**
	 * 根据查询条件，查询历史纪录
	 * @param example
	 * @return
	 */
	List<SupplierOrderItem> selectHisByExampleByPage(SupplierOrderItemExample example);
	/**
	 * 根据订单id号，保存当前数据到历史记录表
	 * @param id
	 * @param cause
	 * @return
	 */
	int insertHis(@Param("orderHisId") String hisId, @Param("orderId") String orderId, @Param("cause") String cause);
	/**
     * 分页查询销售订单行
     * @param map
     * @return
     */
    List<SupplierOrderItem> selectSupplierOrderItemByPage(SupplierOrderItemExample example);
    /**
     * 销售订单导出查询
     * @param supplierOrder
     * @return
     */
    List<SupplierOrderItem> selectForExcel(SupplierOrderExample example);

    List<SupplierOrderItem> selectForExcelFirst(SupplierOrderExample example);


    List<SupplierOrderItem> selectForExcelByOutstandingOrder(SupplierOrderExample supplierOrderExample);

    /**
     * 根据订单行的查询条件，查询出所有的采购订单id
     * @param example
     * @return
     */
	List<String> selectOrderIdByExample(SupplierOrderItemExample example);

	/**
     * 查询采购订单报表
	* */
    List<SupplierOrderReport> selectSupplierOrderReportByPage(SupplierOrderReportExample supplierOrderExample);

    /**
     * 采购订单报表导出excel
     * */
    List<SupplierOrderReport> selectSupplierOrderReportForExcel(SupplierOrderReportExample supplierOrderExample);
}