package com.els.base.supperorder.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;

@ApiModel(value = "供应商方-订单行")
public class SupplierOrderItem implements Serializable {

	//--------------以下非自动生成----------
    @ApiModelProperty("冻结标识")
    private String frozenFlag;

    public String getFrozenFlag() {
        return frozenFlag;
    }

    public void setFrozenFlag(String frozenFlag) {
        this.frozenFlag = frozenFlag;
    }

    @ApiModelProperty("未收货数量")
    private BigDecimal noReceivedQuantity;

    public BigDecimal getNoReceivedQuantity() {
        return noReceivedQuantity;
    }

    public void setNoReceivedQuantity(BigDecimal noReceivedQuantity) {
        this.noReceivedQuantity = noReceivedQuantity;
    }

    @ApiModelProperty("供应商简称")
    private String companyShortName;

    public String getCompanyShortName() {
        return companyShortName;
    }

    public void setCompanyShortName(String companyShortName) {
        this.companyShortName = companyShortName;
    }

    @ApiModelProperty("订单类型")
    private String orderType;

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    /** 供应商编码 */
    private String companyCode;

    /** 操作历史id */
    @JsonIgnore
    private String hisId;

    @ApiModelProperty("操作原因")
    private String cause;

    @ApiModelProperty("首批订单发送状态")
    private Integer sendStatus;

    @ApiModelProperty("审核状态")
    private Integer approveStatus;

    @ApiModelProperty("审核结果")
    private String approveResult;
    
    @ApiModelProperty("拒绝原因")
    private String rejectReason;

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getHisId() {
        return hisId;
    }

    public void setHisId(String hisId) {
        this.hisId = hisId;
    }

    public String getCause() {
        return cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Integer getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    public String getApproveResult() {
        return approveResult;
    }

    public void setApproveResult(String approveResult) {
        this.approveResult = approveResult;
    }
    
    public String getRejectReason() {
		return rejectReason;
	}

	public void setRejectReason(String rejectReason) {
		this.rejectReason = rejectReason;
	}

    //	--------------------------------

	@ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("供应商公司id")
    private String companyId;

    @ApiModelProperty("供应商公司名称")
    private String companyName;

    @ApiModelProperty("供应商名称")
    private String userName;

    @ApiModelProperty("供应商用户id")
    private String userId;

    @ApiModelProperty("采购公司id")
    private String purCompanyId;

    @ApiModelProperty("采购公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("订单id")
    private String orderId;

    @ApiModelProperty("采购凭证号")
    private String orderNo;

    @ApiModelProperty("采购凭证的项目编号")
    private String orderItemNo;

    @ApiModelProperty("采购凭证日期")
    private Date orderDate;

    @ApiModelProperty("物料组id")
    private String materialCategoryId;

    @ApiModelProperty("物料组名称")
    private String materialCategoryName;

    @ApiModelProperty("物料ID")
    private String materialId;

    @ApiModelProperty("物料描述")
    private String materialName;

    @ApiModelProperty("物料号")
    private String materialCode;

    @ApiModelProperty("采购订单数量")
    private BigDecimal quantity;

    @ApiModelProperty("物料单价")
    private BigDecimal price;

    @ApiModelProperty("不含税单价")
    private BigDecimal noTaxPrice;

    @ApiModelProperty("价格单位")
    private String priceUnit;

    @ApiModelProperty("订单单位")
    private String orderUnit;

    @ApiModelProperty("交货日期")
    private Date deliveredDate;

    @ApiModelProperty("已经发货数量")
    private BigDecimal deliveredQuantity;

    @ApiModelProperty("在途数量")
    private BigDecimal onwayQuantity;

    @ApiModelProperty("已经收货数量")
    private BigDecimal receivedQuantity;

    @ApiModelProperty("退货数量")
    private BigDecimal returnQuantity;

    @ApiModelProperty("仓库地点")
    private String warehouseLocation;

    @ApiModelProperty("仓库名称")
    private String warehouseName;

    @ApiModelProperty("待检入库数量")
    private BigDecimal quaWarehouseQuantity;

    @ApiModelProperty("是否被修改过，0没有，1已修改")
    private Integer isUpdated;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("更新日期")
    private Date updateTime;

    @ApiModelProperty("币别")
    private String currency;

    @ApiModelProperty("不含税金额")
    private BigDecimal nonTaxAmount;

    @ApiModelProperty("采购申请单号")
    private String purReqNo;

    @ApiModelProperty("品号")
    private String productNo;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除,2已经冻结")
    private Integer isEnable;

    @ApiModelProperty("交货已完成标识,Y完成")
    private String finishFlag;

    @ApiModelProperty("版本")
    private String version;

    @ApiModelProperty("交货地点")
    private String deliveryLocation;

    @ApiModelProperty("采购组")
    private String purchaseGroup;

    @ApiModelProperty("变更数量（预留）")
    private BigDecimal changeAmount;

    @ApiModelProperty("可发货数量")
    private BigDecimal deliveryAmount;

    @ApiModelProperty("价税合计")
    private String priceTaxTotal;

    @ApiModelProperty("销售单机型")
    private String saleOrderModel;

    @ApiModelProperty("短文本")
    private String shortTxt;

    @ApiModelProperty("税码")
    private String saleTaxCode;

    @ApiModelProperty("税率描述")
    private String addedTax;

    @ApiModelProperty("订单金额")
    private String orderValue;

    @ApiModelProperty("行业标准")
    private String industryStandard;

    @ApiModelProperty("工厂")
    private String factory;

    @ApiModelProperty("供应商物料号")
    private String supMaterialCode;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty("采购公司编码")
    private String purCompanyOcde;

    @ApiModelProperty("采购sap公司代码")
    private String sapPurCompanyCode;

    @ApiModelProperty("确认状态：1订单未确认，2已确认，3已退回")
    private Integer orderStatus;

    @ApiModelProperty("采购备注")
    private String purRemark;

    @ApiModelProperty("供应商备注")
    private String supRemark;

    @ApiModelProperty("供应商物料描述")
    private String supMaterialDesc;

    @ApiModelProperty("订单是否有更改: 0没有更改，1有更改")
    private Integer haveChange;

    @ApiModelProperty("发货物料名称")
    private String deliveryMaterialName;

    @ApiModelProperty("国际类型：国内采购1；转厂订单2；香港上料3.")
    private String interType;

    @ApiModelProperty("冻结数量")
    private BigDecimal freezeQuantity;

    @ApiModelProperty("供应商SAP编码")
    private String sapSupCompanyCode;

    @ApiModelProperty("已申请金额")
    private BigDecimal alreadyApplyMoney;

    @ApiModelProperty("可申请金额")
    private BigDecimal availableApplyMoney;

    @ApiModelProperty("内部交易编码")
    private String interTradeCode;

    @ApiModelProperty("内部交易描述")
    private String interTradeDesc;

    @ApiModelProperty("1合格，0不合格")
    private String qualified;

    @ApiModelProperty("同意分批: 0不同意，1同意")
    private Integer agreeBatch;

    @ApiModelProperty("订单价格单位")
    private String orderPriceUnit;

    @ApiModelProperty("收货金额")
    private BigDecimal receivingDeliveryAmount;

    @ApiModelProperty("项目类别编码")
    private String projectTypeCode;

    @ApiModelProperty("项目类别描述")
    private String projectTypeDesc;

    @ApiModelProperty("项目描述")
    private String projectDesc;

    @ApiModelProperty("图号")
    private String mapNo;

    @ApiModelProperty("规格")
    private String specification;

    @ApiModelProperty("需求跟踪号")
    private String needFollowNo;

    @ApiModelProperty("WBS号")
    private String wbsNo;

    @ApiModelProperty("WBS号描述")
    private String wbsNoDesc;

    @ApiModelProperty("理论交货日期")
    private Date theoryDeliverDate;

    @ApiModelProperty("采购周期")
    private BigDecimal purchasePeriod;

    @ApiModelProperty("是否紧急")
    private Integer isUrgency;

    @ApiModelProperty("预制发票数量")
    private BigDecimal preInvoiceQuantity;

    @ApiModelProperty("预制发票金额")
    private BigDecimal preInvoiceAmount;

    @ApiModelProperty("已开发票金额")
    private BigDecimal haveInvoiceAmount;

    @ApiModelProperty("待开发票数量")
    private BigDecimal waitInvoiceQuantity;

    @ApiModelProperty("发票已过账数量")
    private BigDecimal postAccountQuantity;

    @ApiModelProperty("项目类别")
    private String itemType;

    @ApiModelProperty("项目类别描述：一般指的是标准的订单还是外协的订单行")
    private String itemDescription;

    @ApiModelProperty("订单类型描述")
    private String orderTypeDesc;

    @ApiModelProperty("科目类别")
    private String courseAssignType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("质检报告")
    private String attachment;

    @ApiModelProperty("批次启用标识符")
    private String batchFlag;

    @ApiModelProperty("待收货数量")
    private BigDecimal waitReceiveQuantity;

    @ApiModelProperty("质检状态")
    private String quanlityTestStatus;
    @ApiModelProperty("变更次数")
    private Integer changeTimes;

    @ApiModelProperty("净重")
    private BigDecimal suttle;

    @ApiModelProperty("毛重")
    private BigDecimal rougthWeight;

    @ApiModelProperty("采购信息记录")
    private String purchaseInfoRecord;

    @ApiModelProperty("需求者")
    private String needer;

    @ApiModelProperty("采购申请h行号")
    private String purchaseApplyItemNo;

    @ApiModelProperty("采购协议号")
    private String purchaseProtocalNo;

    @ApiModelProperty("采购协议项目")
    private String purchaseProtocalItemNo;

    @ApiModelProperty("物料组")
    private String materialGroup;

    @ApiModelProperty("库存地点")
    private String storageSite;

    @ApiModelProperty("退货项目")
    private String backGoodsItem;

    @ApiModelProperty("最近收货日期")
    private Date nearReceiveGoodsDate;

    @ApiModelProperty("确认控制")
    private String confirmControl;

    @ApiModelProperty("库存类型")
    private String storageType;

    @ApiModelProperty("材质")
    private String texture;

    @ApiModelProperty("采购申请创建人")
    private String purApplyCreator;

    @ApiModelProperty("需发票")
    private String needInvoice;

    @ApiModelProperty("仅此一批")
    private String onlyBatch;

    @ApiModelProperty("估计价格")
    private BigDecimal evaluatePrice;

    @ApiModelProperty("首款金额")
    private BigDecimal payeeAmount;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    @ApiModelProperty("备用字段6")
    private String attribute6;

    @ApiModelProperty("备用字段7")
    private String attribute7;

    @ApiModelProperty("备用字段8")
    private String attribute8;

    @ApiModelProperty("备用字段9")
    private String attribute9;

    @ApiModelProperty("备用字段10")
    private String attribute10;
    @ApiModelProperty("首批标记")
    private Integer firstFlag;

    @ApiModelProperty("物料有效期管理")
    private Integer materialValidityFlag;

    @ApiModelProperty("物料过期日")
    private Date materialValidityDate;

    @ApiModelProperty("首批订单生成日期")
    private Date firstOrderDate;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId == null ? null : orderId.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public String getOrderItemNo() {
        return orderItemNo;
    }

    public void setOrderItemNo(String orderItemNo) {
        this.orderItemNo = orderItemNo == null ? null : orderItemNo.trim();
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public String getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(String materialCategoryId) {
        this.materialCategoryId = materialCategoryId == null ? null : materialCategoryId.trim();
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName == null ? null : materialCategoryName.trim();
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId == null ? null : materialId.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getNoTaxPrice() {
        return noTaxPrice;
    }

    public void setNoTaxPrice(BigDecimal noTaxPrice) {
        this.noTaxPrice = noTaxPrice;
    }

    public String getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(String priceUnit) {
        this.priceUnit = priceUnit == null ? null : priceUnit.trim();
    }

    public String getOrderUnit() {
        return orderUnit;
    }

    public void setOrderUnit(String orderUnit) {
        this.orderUnit = orderUnit == null ? null : orderUnit.trim();
    }

    public Date getDeliveredDate() {
        return deliveredDate;
    }

    public void setDeliveredDate(Date deliveredDate) {
        this.deliveredDate = deliveredDate;
    }

    public BigDecimal getDeliveredQuantity() {
        return deliveredQuantity;
    }

    public void setDeliveredQuantity(BigDecimal deliveredQuantity) {
        this.deliveredQuantity = deliveredQuantity;
    }

    public BigDecimal getOnwayQuantity() {
        return onwayQuantity;
    }

    public void setOnwayQuantity(BigDecimal onwayQuantity) {
        this.onwayQuantity = onwayQuantity;
    }

    public BigDecimal getReceivedQuantity() {
        return receivedQuantity;
    }

    public void setReceivedQuantity(BigDecimal receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
    }

    public BigDecimal getReturnQuantity() {
        return returnQuantity;
    }

    public void setReturnQuantity(BigDecimal returnQuantity) {
        this.returnQuantity = returnQuantity;
    }

    public String getWarehouseLocation() {
        return warehouseLocation;
    }

    public void setWarehouseLocation(String warehouseLocation) {
        this.warehouseLocation = warehouseLocation == null ? null : warehouseLocation.trim();
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName == null ? null : warehouseName.trim();
    }

    public BigDecimal getQuaWarehouseQuantity() {
        return quaWarehouseQuantity;
    }

    public void setQuaWarehouseQuantity(BigDecimal quaWarehouseQuantity) {
        this.quaWarehouseQuantity = quaWarehouseQuantity;
    }

    public Integer getIsUpdated() {
        return isUpdated;
    }

    public void setIsUpdated(Integer isUpdated) {
        this.isUpdated = isUpdated;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public BigDecimal getNonTaxAmount() {
        return nonTaxAmount;
    }

    public void setNonTaxAmount(BigDecimal nonTaxAmount) {
        this.nonTaxAmount = nonTaxAmount;
    }

    public String getPurReqNo() {
        return purReqNo;
    }

    public void setPurReqNo(String purReqNo) {
        this.purReqNo = purReqNo == null ? null : purReqNo.trim();
    }

    public String getProductNo() {
        return productNo;
    }

    public void setProductNo(String productNo) {
        this.productNo = productNo == null ? null : productNo.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(String finishFlag) {
        this.finishFlag = finishFlag == null ? null : finishFlag.trim();
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version == null ? null : version.trim();
    }

    public String getDeliveryLocation() {
        return deliveryLocation;
    }

    public void setDeliveryLocation(String deliveryLocation) {
        this.deliveryLocation = deliveryLocation == null ? null : deliveryLocation.trim();
    }

    public String getPurchaseGroup() {
        return purchaseGroup;
    }

    public void setPurchaseGroup(String purchaseGroup) {
        this.purchaseGroup = purchaseGroup == null ? null : purchaseGroup.trim();
    }

    public BigDecimal getChangeAmount() {
        return changeAmount;
    }

    public void setChangeAmount(BigDecimal changeAmount) {
        this.changeAmount = changeAmount;
    }

    public BigDecimal getDeliveryAmount() {
        return deliveryAmount;
    }

    public void setDeliveryAmount(BigDecimal deliveryAmount) {
        this.deliveryAmount = deliveryAmount;
    }

    public String getPriceTaxTotal() {
        return priceTaxTotal;
    }

    public void setPriceTaxTotal(String priceTaxTotal) {
        this.priceTaxTotal = priceTaxTotal;
    }

    public String getSaleOrderModel() {
        return saleOrderModel;
    }

    public void setSaleOrderModel(String saleOrderModel) {
        this.saleOrderModel = saleOrderModel == null ? null : saleOrderModel.trim();
    }

    public String getShortTxt() {
        return shortTxt;
    }

    public void setShortTxt(String shortTxt) {
        this.shortTxt = shortTxt == null ? null : shortTxt.trim();
    }

    public String getSaleTaxCode() {
        return saleTaxCode;
    }

    public void setSaleTaxCode(String saleTaxCode) {
        this.saleTaxCode = saleTaxCode == null ? null : saleTaxCode.trim();
    }

    public String getAddedTax() {
        return addedTax;
    }

    public void setAddedTax(String addedTax) {
        this.addedTax = addedTax == null ? null : addedTax.trim();
    }

    public String getOrderValue() {
        return orderValue;
    }

    public void setOrderValue(String orderValue) {
        this.orderValue = orderValue;
    }

    public String getIndustryStandard() {
        return industryStandard;
    }

    public void setIndustryStandard(String industryStandard) {
        this.industryStandard = industryStandard == null ? null : industryStandard.trim();
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory == null ? null : factory.trim();
    }

    public String getSupMaterialCode() {
        return supMaterialCode;
    }

    public void setSupMaterialCode(String supMaterialCode) {
        this.supMaterialCode = supMaterialCode == null ? null : supMaterialCode.trim();
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand == null ? null : brand.trim();
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName == null ? null : factoryName.trim();
    }

    public String getPurCompanyOcde() {
        return purCompanyOcde;
    }

    public void setPurCompanyOcde(String purCompanyOcde) {
        this.purCompanyOcde = purCompanyOcde == null ? null : purCompanyOcde.trim();
    }

    public String getSapPurCompanyCode() {
        return sapPurCompanyCode;
    }

    public void setSapPurCompanyCode(String sapPurCompanyCode) {
        this.sapPurCompanyCode = sapPurCompanyCode == null ? null : sapPurCompanyCode.trim();
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getPurRemark() {
        return purRemark;
    }

    public void setPurRemark(String purRemark) {
        this.purRemark = purRemark == null ? null : purRemark.trim();
    }

    public String getSupRemark() {
        return supRemark;
    }

    public void setSupRemark(String supRemark) {
        this.supRemark = supRemark == null ? null : supRemark.trim();
    }

    public String getSupMaterialDesc() {
        return supMaterialDesc;
    }

    public void setSupMaterialDesc(String supMaterialDesc) {
        this.supMaterialDesc = supMaterialDesc == null ? null : supMaterialDesc.trim();
    }

    public Integer getHaveChange() {
        return haveChange;
    }

    public void setHaveChange(Integer haveChange) {
        this.haveChange = haveChange;
    }

    public String getDeliveryMaterialName() {
        return deliveryMaterialName;
    }

    public void setDeliveryMaterialName(String deliveryMaterialName) {
        this.deliveryMaterialName = deliveryMaterialName == null ? null : deliveryMaterialName.trim();
    }

    public String getInterType() {
        return interType;
    }

    public void setInterType(String interType) {
        this.interType = interType == null ? null : interType.trim();
    }

    public BigDecimal getFreezeQuantity() {
        return freezeQuantity;
    }

    public void setFreezeQuantity(BigDecimal freezeQuantity) {
        this.freezeQuantity = freezeQuantity;
    }

    public String getSapSupCompanyCode() {
        return sapSupCompanyCode;
    }

    public void setSapSupCompanyCode(String sapSupCompanyCode) {
        this.sapSupCompanyCode = sapSupCompanyCode == null ? null : sapSupCompanyCode.trim();
    }

    public BigDecimal getAlreadyApplyMoney() {
        return alreadyApplyMoney;
    }

    public void setAlreadyApplyMoney(BigDecimal alreadyApplyMoney) {
        this.alreadyApplyMoney = alreadyApplyMoney;
    }

    public BigDecimal getAvailableApplyMoney() {
        return availableApplyMoney;
    }

    public void setAvailableApplyMoney(BigDecimal availableApplyMoney) {
        this.availableApplyMoney = availableApplyMoney;
    }

    public String getInterTradeCode() {
        return interTradeCode;
    }

    public void setInterTradeCode(String interTradeCode) {
        this.interTradeCode = interTradeCode == null ? null : interTradeCode.trim();
    }

    public String getInterTradeDesc() {
        return interTradeDesc;
    }

    public void setInterTradeDesc(String interTradeDesc) {
        this.interTradeDesc = interTradeDesc == null ? null : interTradeDesc.trim();
    }

    public String getQualified() {
        return qualified;
    }

    public void setQualified(String qualified) {
        this.qualified = qualified == null ? null : qualified.trim();
    }

    public Integer getAgreeBatch() {
        return agreeBatch;
    }

    public void setAgreeBatch(Integer agreeBatch) {
        this.agreeBatch = agreeBatch;
    }

    public String getOrderPriceUnit() {
        return orderPriceUnit;
    }

    public void setOrderPriceUnit(String orderPriceUnit) {
        this.orderPriceUnit = orderPriceUnit == null ? null : orderPriceUnit.trim();
    }

    public BigDecimal getReceivingDeliveryAmount() {
        return receivingDeliveryAmount;
    }

    public void setReceivingDeliveryAmount(BigDecimal receivingDeliveryAmount) {
        this.receivingDeliveryAmount = receivingDeliveryAmount;
    }

    public String getProjectTypeCode() {
        return projectTypeCode;
    }

    public void setProjectTypeCode(String projectTypeCode) {
        this.projectTypeCode = projectTypeCode == null ? null : projectTypeCode.trim();
    }

    public String getProjectTypeDesc() {
        return projectTypeDesc;
    }

    public void setProjectTypeDesc(String projectTypeDesc) {
        this.projectTypeDesc = projectTypeDesc == null ? null : projectTypeDesc.trim();
    }

    public String getProjectDesc() {
        return projectDesc;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc == null ? null : projectDesc.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification == null ? null : specification.trim();
    }

    public String getNeedFollowNo() {
        return needFollowNo;
    }

    public void setNeedFollowNo(String needFollowNo) {
        this.needFollowNo = needFollowNo == null ? null : needFollowNo.trim();
    }

    public String getWbsNo() {
        return wbsNo;
    }

    public void setWbsNo(String wbsNo) {
        this.wbsNo = wbsNo == null ? null : wbsNo.trim();
    }

    public String getWbsNoDesc() {
        return wbsNoDesc;
    }

    public void setWbsNoDesc(String wbsNoDesc) {
        this.wbsNoDesc = wbsNoDesc == null ? null : wbsNoDesc.trim();
    }

    public Date getTheoryDeliverDate() {
        return theoryDeliverDate;
    }

    public void setTheoryDeliverDate(Date theoryDeliverDate) {
        this.theoryDeliverDate = theoryDeliverDate;
    }

    public BigDecimal getPurchasePeriod() {
        return purchasePeriod;
    }

    public void setPurchasePeriod(BigDecimal purchasePeriod) {
        this.purchasePeriod = purchasePeriod;
    }

    public Integer getIsUrgency() {
        return isUrgency;
    }

    public void setIsUrgency(Integer isUrgency) {
        this.isUrgency = isUrgency;
    }

    public BigDecimal getPreInvoiceQuantity() {
        return preInvoiceQuantity;
    }

    public void setPreInvoiceQuantity(BigDecimal preInvoiceQuantity) {
        this.preInvoiceQuantity = preInvoiceQuantity;
    }

    public BigDecimal getPreInvoiceAmount() {
        return preInvoiceAmount;
    }

    public void setPreInvoiceAmount(BigDecimal preInvoiceAmount) {
        this.preInvoiceAmount = preInvoiceAmount;
    }

    public BigDecimal getHaveInvoiceAmount() {
        return haveInvoiceAmount;
    }

    public void setHaveInvoiceAmount(BigDecimal haveInvoiceAmount) {
        this.haveInvoiceAmount = haveInvoiceAmount;
    }

    public BigDecimal getWaitInvoiceQuantity() {
        return waitInvoiceQuantity;
    }

    public void setWaitInvoiceQuantity(BigDecimal waitInvoiceQuantity) {
        this.waitInvoiceQuantity = waitInvoiceQuantity;
    }

    public BigDecimal getPostAccountQuantity() {
        return postAccountQuantity;
    }

    public void setPostAccountQuantity(BigDecimal postAccountQuantity) {
        this.postAccountQuantity = postAccountQuantity;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType == null ? null : itemType.trim();
    }

    public String getItemDescription() {
        return itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription == null ? null : itemDescription.trim();
    }

    public String getOrderTypeDesc() {
        return orderTypeDesc;
    }

    public void setOrderTypeDesc(String orderTypeDesc) {
        this.orderTypeDesc = orderTypeDesc == null ? null : orderTypeDesc.trim();
    }

    public String getCourseAssignType() {
        return courseAssignType;
    }

    public void setCourseAssignType(String courseAssignType) {
        this.courseAssignType = courseAssignType == null ? null : courseAssignType.trim();
    }

    public Integer getChangeTimes() {
        return changeTimes;
    }

    public void setChangeTimes(Integer changeTimes) {
        this.changeTimes = changeTimes;
    }

    public BigDecimal getSuttle() {
        return suttle;
    }

    public void setSuttle(BigDecimal suttle) {
        this.suttle = suttle;
    }

    public BigDecimal getRougthWeight() {
        return rougthWeight;
    }

    public void setRougthWeight(BigDecimal rougthWeight) {
        this.rougthWeight = rougthWeight;
    }

    public String getPurchaseInfoRecord() {
        return purchaseInfoRecord;
    }

    public void setPurchaseInfoRecord(String purchaseInfoRecord) {
        this.purchaseInfoRecord = purchaseInfoRecord == null ? null : purchaseInfoRecord.trim();
    }

    public String getNeeder() {
        return needer;
    }

    public void setNeeder(String needer) {
        this.needer = needer == null ? null : needer.trim();
    }

    public String getPurchaseApplyItemNo() {
        return purchaseApplyItemNo;
    }

    public void setPurchaseApplyItemNo(String purchaseApplyItemNo) {
        this.purchaseApplyItemNo = purchaseApplyItemNo == null ? null : purchaseApplyItemNo.trim();
    }

    public String getPurchaseProtocalNo() {
        return purchaseProtocalNo;
    }

    public void setPurchaseProtocalNo(String purchaseProtocalNo) {
        this.purchaseProtocalNo = purchaseProtocalNo == null ? null : purchaseProtocalNo.trim();
    }

    public String getPurchaseProtocalItemNo() {
        return purchaseProtocalItemNo;
    }

    public void setPurchaseProtocalItemNo(String purchaseProtocalItemNo) {
        this.purchaseProtocalItemNo = purchaseProtocalItemNo == null ? null : purchaseProtocalItemNo.trim();
    }

    public String getMaterialGroup() {
        return materialGroup;
    }

    public void setMaterialGroup(String materialGroup) {
        this.materialGroup = materialGroup == null ? null : materialGroup.trim();
    }

    public String getStorageSite() {
        return storageSite;
    }

    public void setStorageSite(String storageSite) {
        this.storageSite = storageSite == null ? null : storageSite.trim();
    }

    public String getBackGoodsItem() {
        return backGoodsItem;
    }

    public void setBackGoodsItem(String backGoodsItem) {
        this.backGoodsItem = backGoodsItem == null ? null : backGoodsItem.trim();
    }

    public Date getNearReceiveGoodsDate() {
        return nearReceiveGoodsDate;
    }

    public void setNearReceiveGoodsDate(Date nearReceiveGoodsDate) {
        this.nearReceiveGoodsDate = nearReceiveGoodsDate;
    }

    public String getConfirmControl() {
        return confirmControl;
    }

    public void setConfirmControl(String confirmControl) {
        this.confirmControl = confirmControl == null ? null : confirmControl.trim();
    }

    public String getStorageType() {
        return storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType == null ? null : storageType.trim();
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture == null ? null : texture.trim();
    }

    public String getPurApplyCreator() {
        return purApplyCreator;
    }

    public void setPurApplyCreator(String purApplyCreator) {
        this.purApplyCreator = purApplyCreator == null ? null : purApplyCreator.trim();
    }

    public String getNeedInvoice() {
        return needInvoice;
    }

    public void setNeedInvoice(String needInvoice) {
        this.needInvoice = needInvoice == null ? null : needInvoice.trim();
    }

    public String getOnlyBatch() {
        return onlyBatch;
    }

    public void setOnlyBatch(String onlyBatch) {
        this.onlyBatch = onlyBatch == null ? null : onlyBatch.trim();
    }

    public BigDecimal getEvaluatePrice() {
        return evaluatePrice;
    }

    public void setEvaluatePrice(BigDecimal evaluatePrice) {
        this.evaluatePrice = evaluatePrice;
    }

    public BigDecimal getPayeeAmount() {
        return payeeAmount;
    }

    public void setPayeeAmount(BigDecimal payeeAmount) {
        this.payeeAmount = payeeAmount;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }

    public String getAttribute6() {
        return attribute6;
    }

    public void setAttribute6(String attribute6) {
        this.attribute6 = attribute6 == null ? null : attribute6.trim();
    }

    public String getAttribute7() {
        return attribute7;
    }

    public void setAttribute7(String attribute7) {
        this.attribute7 = attribute7 == null ? null : attribute7.trim();
    }

    public String getAttribute8() {
        return attribute8;
    }

    public void setAttribute8(String attribute8) {
        this.attribute8 = attribute8 == null ? null : attribute8.trim();
    }

    public String getAttribute9() {
        return attribute9;
    }

    public void setAttribute9(String attribute9) {
        this.attribute9 = attribute9 == null ? null : attribute9.trim();
    }

    public String getAttribute10() {
        return attribute10;
    }

    public void setAttribute10(String attribute10) {
        this.attribute10 = attribute10 == null ? null : attribute10.trim();
    }
    public Integer getFirstFlag() {
        return firstFlag;
    }

    public void setFirstFlag(Integer firstFlag) {
        this.firstFlag = firstFlag;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getBatchFlag() {
        return batchFlag;
    }

    public void setBatchFlag(String batchFlag) {
        this.batchFlag = batchFlag == null ? null : batchFlag.trim();
    }
	    public BigDecimal getWaitReceiveQuantity() {
        return waitReceiveQuantity;
    }

    public void setWaitReceiveQuantity(BigDecimal waitReceiveQuantity) {
        this.waitReceiveQuantity = waitReceiveQuantity;
    }

    public String getQuanlityTestStatus() {
        return quanlityTestStatus;
    }

    public void setQuanlityTestStatus(String quanlityTestStatus) {
        this.quanlityTestStatus = quanlityTestStatus == null ? null : quanlityTestStatus.trim();
    }

    public Integer getMaterialValidityFlag() {
        return materialValidityFlag;
    }

    public void setMaterialValidityFlag(Integer materialValidityFlag) {
        this.materialValidityFlag = materialValidityFlag;
    }

    public Date getMaterialValidityDate() {
        return materialValidityDate;
    }

    public void setMaterialValidityDate(Date materialValidityDate) {
        this.materialValidityDate = materialValidityDate;
    }

    public Date getFirstOrderDate() {
        return firstOrderDate;
    }

    public void setFirstOrderDate(Date firstOrderDate) {
        this.firstOrderDate = firstOrderDate;
    }
}