package com.els.base.supperorder.service;

import java.util.List;

import com.els.base.supperorder.entity.*;
import org.apache.ibatis.annotations.Param;

import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;

public interface SupplierOrderItemService extends BaseService<SupplierOrderItem, SupplierOrderItemExample, String> {
	/**
     * 根据订单id号，保存当前数据到历史记录表
     * @param id
     * @param cause
     * @return
     */
    int insertHis(@Param("orderHisId") String hisId, @Param("orderId") String orderId, @Param("cause") String cause);
    /**
	 * 分页查询采购订单行
	 * 
	 * @param
	 */
//	PageView<SupplierOrderItem> querySupplierOrderItemByPage(Map<String, Object> map);
	PageView<SupplierOrderItem> querySupplierOrderItemByPage(SupplierOrderItemExample example);
	
	/**
	 * 批量修改销售订单行
	 * @param supplierOrderItem
	 * @param supplierOrderItemExample
	 */
	void updateBySupplierOrder(SupplierOrderItem supplierOrderItem, SupplierOrderItemExample supplierOrderItemExample);
	
	/**
     * 销售订单导出查询
     * @param supplierOrder
     * @return
     */
    List<SupplierOrderItem> selectForExcel(SupplierOrderExample example);

	List<SupplierOrderItem> selectForExcelFirst(SupplierOrderExample example);

    List<SupplierOrderItem> selectForExcelByOutstandingOrder(SupplierOrderExample supplierOrderExample);
    
    /**
     * 查询出订单行关联的订单id
     * @param example
     * @return
     */
    List<String> queryOrderIdByExample(SupplierOrderItemExample example);

    /**
	 *
	 * 采购订单报表
	 * */
	PageView<SupplierOrderReport> selectSupplierOrderReportByPage(SupplierOrderReportExample example);

    /**
     * 采购订单报表导出excel
     * */
    List<SupplierOrderReport> selectSupplierOrderReportForExcel(SupplierOrderReportExample example);

	/**
	 * 供应商确认订单行
	 * @param supplierOrderItems
	 * */
	public void supplierOrderItemRefuse(List<SupplierOrderItem> supplierOrderItems);

	int countByExample(SupplierOrderItemExample example);

	void updateByExampleSelective(SupplierOrderItem supplierOrderItem,
			SupplierOrderItemExample supplierOrderItemExample);
	
	void modifyByExample(SupplierOrderItem supplierOrderItem, SupplierOrderItemExample supplierOrderItemExamples);
}