package com.els.base.supperorder.service;

import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;
import com.els.base.file.entity.FileData;
import com.els.base.supperorder.entity.SupplierOrder;
import com.els.base.supperorder.entity.SupplierOrderExample;

public interface SupplierOrderService extends BaseService<SupplierOrder, SupplierOrderExample, String> {
    /**
     * 保存销售订单
     * 
     * @param supplierOrder
     */
    public void saveSupplierOrder(SupplierOrder supplierOrder);

    /**
     * 操作销售订单行（拒绝或者确认）
     * 
     * @param supplierOrder
     */
    public void supplierOrderItemRefuse(SupplierOrder supplierOrder);

    /**
     * 操作销售订单头（拒绝）
     * 
     * @param supplierOrder
     */
    public void supplierOrderRefuse(SupplierOrder supplierOrder);

    /**
     * 操作销售订单头（确认）
     * 
     * @param supplierOrder
     */
    public void supplierOrderComfirm(SupplierOrder supplierOrder);

    /**
     * 根据订单id号，保存当前数据到历史记录表
     * 
     * @param id
     * @param cause
     * @return
     */
    int insertHis(@Param("orderHisId") String hisId, @Param("orderId") String orderId,
            @Param("cause") String cause);

    /**
     * 批量修改销售单头
     * 
     * @param record
     * @param example
     */
    public void updateBySupplierOrder(SupplierOrder record, SupplierOrderExample example);

    /**
     * 供应商确认或者拒绝之前判断采购方是否修改了订单
     * 
     * @param supplierOrder
     */
    public void isHaveNewOrder(SupplierOrder supplierOrder);

    /**
     * 查询所有可用的采购订单，排除那些没确认，而且采购方变更为发送的订单
     * @param example
     * @return
     */
    public PageView<SupplierOrder> findByPageForAvaliableOrder(SupplierOrderExample example);

    boolean isSameType(Set<String> orderIdList);

    /**
     * 供应商PDF导出
     * @param orderNoList 订单id
     * @return 文件信息集合
     */
	public List<FileData> getPdfFiles(List<String> orderNoList);

	//订单未确认(供方)的数量
	public int countByExample(SupplierOrderExample supplierOrderExample);
	
}