package com.els.base.supperorder.web.controller;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.druid.sql.ast.statement.SQLIfStatement.ElseIf;
import com.els.base.core.utils.Assert;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.supperorder.entity.SupplierOrder;
import com.els.base.supperorder.entity.SupplierOrderExample;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.supperorder.entity.SupplierOrderItemExample;
import com.els.base.supperorder.service.SupplierOrderItemService;
import com.els.base.supperorder.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jxl.write.WritableWorkbook;

@Api(value = "销售订单头")
@Controller
@RequestMapping("supplierOrder")
public class SupplierOrderController {
	
	private static Logger logger = LoggerFactory.getLogger(SupplierOrderController.class);
	
    @Resource
    protected SupplierOrderService supplierOrderService;

    @Resource
    protected SupplierOrderItemService supplierOrderItemService;

    @ApiOperation(httpMethod = "POST", value = "查询销售订单头")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 SupplierOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.setPageView(new PageView<SupplierOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();

        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
//        List<Integer> isEnableValues = new ArrayList<Integer>();
//        isEnableValues.add(1);
//        isEnableValues.add(2);
//        criteria.andIsEnableIn(isEnableValues);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
//        example.setOrderByClause("LAST_UPDATE_TIME DESC , SEND_TIME DESC");
        example.setOrderByClause("SEND_TIME DESC, ORDER_DATE DESC , LAST_UPDATE_TIME DESC , CREATE_TIME DESC");
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商订单协同-供应商订单查询")
    @RequestMapping("service/findByPageForAll")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findByPageForAll(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "客户物料编码") @RequestParam(required=false) String purMaterialCode ,
            @ApiParam(value = "查询条件,属性名请参考 SupplierOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.setPageView(new PageView<SupplierOrder>(pageNo, pageSize));
        
        List<Integer> isEnableValues = new ArrayList<Integer>();
        isEnableValues.add(1);
        isEnableValues.add(2);

        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
            .andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
            .andIsEnableIn(isEnableValues);
        
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        if (StringUtils.isNotBlank(purMaterialCode)) {
        	SupplierOrderItemExample orderItemExample = new SupplierOrderItemExample();
        	SupplierOrderItemExample.Criteria cri = orderItemExample.createCriteria();
        	cri.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        	
        	if (purMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
        		cri.andMaterialCodeIn(Arrays.asList(purMaterialCode.trim().split("\\s+")));
        	}else{
        		cri.andMaterialCodeLike("%"+purMaterialCode+"%");
        	}
        	
        	List<String> orderIdList = this.supplierOrderItemService.queryOrderIdByExample(orderItemExample);
        	if (CollectionUtils.isEmpty(orderIdList)) {
        		return ResponseResult.success(new PageView<SupplierOrder>(pageNo, pageSize));
			}
        	
        	criteria.andIdIn(orderIdList);
		}
        
        example.setOrderByClause("  SEND_TIME DESC ,LAST_UPDATE_TIME DESC ,ORDER_DATE DESC ,  CREATE_TIME DESC");
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "POST", value = "供应商未完成订单")
    @RequestMapping("service/findUnFinishedOrder")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findUnFinishedOrder(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "供应商物料编码") @RequestParam(required=false) String supMaterialCode ,
            @ApiParam(value = "客户物料编码") @RequestParam(required=false) String purMaterialCode ,
            @ApiParam(value = "查询条件,属性名请参考 SupplierOrder") @RequestBody(required = false) QueryParamWapper wapper
            ){
    	List<Integer> isEnableValues = new ArrayList<Integer>();
    	isEnableValues.add(1);
    	isEnableValues.add(2);
    	
    	SupplierOrderExample example = new SupplierOrderExample();
        example.setPageView(new PageView<SupplierOrder>(pageNo, pageSize));

        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
            .andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
            .andIsEnableIn(isEnableValues)
            .andDeliveryStatusEqualTo(1);
        
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        if (StringUtils.isNotBlank(supMaterialCode) || StringUtils.isNotBlank(purMaterialCode)) {
        	SupplierOrderItemExample orderItemExample = new SupplierOrderItemExample();
        	SupplierOrderItemExample.Criteria cri = orderItemExample.createCriteria()
        			                                    .andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
        			                                    .andFinishFlagEqualTo(Constant.NO_STRING);
        	
        	if (StringUtils.isNotBlank(supMaterialCode)) {
        		if (supMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
					cri.andSupMaterialCodeIn(Arrays.asList(supMaterialCode.trim().split("\\s+")));
				}else{
					cri.andSupMaterialCodeLike("%"+supMaterialCode+"%");
				}
			}
        	
        	if (StringUtils.isNotBlank(purMaterialCode)) {
        		if (purMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
					cri.andMaterialCodeIn(Arrays.asList(purMaterialCode.trim().split("\\s+")));
				}else{
					cri.andMaterialCodeLike("%"+purMaterialCode+"%");
				}
			}
        	
        	List<String> orderIdList = this.supplierOrderItemService.queryOrderIdByExample(orderItemExample);
        	if (CollectionUtils.isEmpty(orderIdList)) {
        		return ResponseResult.success(new PageView<SupplierOrder>(pageNo, pageSize));
			}
        	
        	criteria.andIdIn(orderIdList);
		}
        
        example.setOrderByClause(" SEND_TIME DESC,ORDER_DATE DESC , LAST_UPDATE_TIME DESC , CREATE_TIME DESC");
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "销售方拒绝或者确认订单行：入参（整个销售单实体包括行项目）")
    @RequestMapping("service/supplierOrderItemRefuse")
    @ResponseBody
    public ResponseResult<String> supplierOrderItemRefuse(@RequestBody SupplierOrder supplierOrder) {
        if (supplierOrder == null) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "数据");
        }
        if (CollectionUtils.isEmpty(supplierOrder.getItems())) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        this.supplierOrderService.isHaveNewOrder(supplierOrder);
        supplierOrder.setUserId(SpringSecurityUtils.getLoginUserId());
        supplierOrder.setUserName(SpringSecurityUtils.getLoginUserName());
        this.supplierOrderService.supplierOrderItemRefuse(supplierOrder);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "销售方批量拒绝或者确认订单头：入参（整个销售单实体数组）")
    @RequestMapping("service/supplierOrderRefuseOrComfirm")
    @ResponseBody
    public ResponseResult<String> supplierOrderRefuseOrComfirm(
            @RequestBody List<SupplierOrder> supplierOrderList) {
        Assert.isNotEmpty(supplierOrderList,"数据不能为空");

        logger.info("供应商开始回签");
        for (SupplierOrder supplierOrder : supplierOrderList) {

            if (supplierOrder.getSupRemark() != null && supplierOrder.getSupRemark().length() > 255) {
                throw new CommonException("输入的参数长度超标", "database_length_error");
            }

            //1、检查一下该订单是否已经变更
            this.supplierOrderService.isHaveNewOrder(supplierOrder);

            //2、更改订单状态
            supplierOrder.setUserId(SpringSecurityUtils.getLoginUserId());
            supplierOrder.setUserName(SpringSecurityUtils.getLoginUserName());

            // 情况一、拒绝
            if (supplierOrder.getOrderStatus() == PurchaseOrderStatusEnum.BACK.getValue()) {
                String supRemark = supplierOrder.getSupRemark();
                String orderNo = supplierOrder.getOrderNo();
                Assert.isNotBlank(supRemark,"拒绝订单，备注不能为空,订单号" + orderNo + "备注为空");
                this.supplierOrderService.supplierOrderRefuse(supplierOrder);

           //情况二、确认
            } else {
                this.supplierOrderService.supplierOrderComfirm(supplierOrder);
            }
        }
        logger.info("供应商回签结束");
        return ResponseResult.success();
    }

    @ApiOperation(value = "销售订单批量导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadExcel")
    @ResponseBody
    public ModelAndView downloadExcel(
            String queryParams,
            HttpServletResponse response,
            @ApiParam(value = "交货是否已完成标识,Y完成", defaultValue = "") @RequestParam(defaultValue = "") String finishFlag) {
        try {
            SupplierOrderExample supplierOrderExample = new SupplierOrderExample();
            SupplierOrderExample.Criteria cri = supplierOrderExample.createCriteria();
            cri.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(
                    ProjectUtils.getProjectId());

            if (StringUtils.isNotBlank(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil
                        .convertValue(queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion(cri, queryParamWapper);
            }

            List<SupplierOrderItem> list = null;
            if (StringUtils.isNotBlank(finishFlag) && finishFlag.equals("N")) {
                list = this.supplierOrderItemService.selectForExcelByOutstandingOrder(supplierOrderExample);
            } else {
                list = this.supplierOrderItemService.selectForExcel(supplierOrderExample);
            }

            for (int i = 0; CollectionUtils.isNotEmpty(list) && i < list.size(); i++) {
                SupplierOrderItem supplierOrderItem = list.get(i);
                BigDecimal quantity = supplierOrderItem.getQuantity();// 订单数量
                BigDecimal receivedQuantity = supplierOrderItem.getReceivedQuantity();// 已经收货数量
                BigDecimal noReceivedQuantity = BigDecimal.ZERO;
                if (supplierOrderItem.getQuantity() != null) {
                    if (supplierOrderItem.getReceivedQuantity() != null) {
                        noReceivedQuantity = quantity.subtract(receivedQuantity);
                    }
                    //如果交货已完成，设置待收货数量为
                    if (supplierOrderItem.getFinishFlag().equals("Y")) {
                    	noReceivedQuantity=BigDecimal.ZERO;
					}
                    else {
                        noReceivedQuantity = supplierOrderItem.getQuantity();
                    }
                }
                supplierOrderItem.setNoReceivedQuantity(noReceivedQuantity);
                if (supplierOrderItem.getIsEnable() != null && supplierOrderItem.getIsEnable() == 2) {
                    supplierOrderItem.setFrozenFlag("已冻结");
                } else {
                    supplierOrderItem.setFrozenFlag("未冻结");
                }
            }

            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String companyShortName = CompanyUtils.currentCompany().getCompanyName();
            header.append("filename=\"" + URLEncoder.encode("" + companyShortName + "PO明细.xls", "UTF-8")
                    + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream,
                    createExcelHeader(), list, "销售订单", null, 0);

            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
            logger.error("导出供应商订单失败", e);
        }
        return null;
    }

    private List<TitleAndModelKey> createExcelHeader() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("客户名称", "purCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单号", "orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("品号", "materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("品名规格", "materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单数量", "quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已交数量", "receivedQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("未交数量", "noReceivedQuantity"));
        
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("交货日期", "deliveredDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter(dateConverter);
        titleAndModelKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey);
        
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单位", "orderUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("净价", "noTaxPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购金额", "nonTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("币种", "currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("税率", "saleTaxCode"));
        
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("凭证日期", "orderDate");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter(dateConverter2);
        titleAndModelKey2.setToStrConverter(dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);
        
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("冻结标识", "frozenFlag"));

        return titleAndModelKeys;
    }

    @ApiOperation(value = "销售订单选中导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadExcelBySelect")
    @ResponseBody
    public ModelAndView downloadExcelBySelect(
            @ApiParam(value = "采购订单号", defaultValue = "") @RequestParam(defaultValue = "") String orderNOList,
            @ApiParam(value = "交货是否已完成标识", defaultValue = "") @RequestParam(defaultValue = "") Integer deliveryStatus,
            @ApiParam(value = "交货是否已完成标识,Y完成", defaultValue = "") @RequestParam(defaultValue = "") String finishFlag,
            HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String companyShortName = CompanyUtils.currentCompany().getCompanyName();
            header.append("filename=\"" + URLEncoder.encode("" + companyShortName + "PO明细.xls", "UTF-8")
                    + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            SupplierOrderExample example = new SupplierOrderExample();
            SupplierOrderExample.Criteria cri = example.createCriteria()
                    .andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                    .andProjectIdEqualTo(ProjectUtils.getProjectId());

            if (StringUtils.isNotBlank(orderNOList)) {
                cri.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
            }

            if (deliveryStatus != null) {
                cri.andDeliveryStatusEqualTo(deliveryStatus);
            }

            List<SupplierOrderItem> listOrderItem = null;
            if (StringUtils.isNotBlank(finishFlag) && finishFlag.equals("N")) {
                listOrderItem = this.supplierOrderItemService.selectForExcelByOutstandingOrder(example);
            } else {
                listOrderItem = this.supplierOrderItemService.selectForExcel(example);
            }

            for (int i = 0; CollectionUtils.isNotEmpty(listOrderItem) && i < listOrderItem.size(); i++) {
                SupplierOrderItem supplierOrderItem = listOrderItem.get(i);
                BigDecimal quantity = supplierOrderItem.getQuantity();// 订单数量
                BigDecimal receivedQuantity = supplierOrderItem.getReceivedQuantity();// 已经收货数量
                BigDecimal noReceivedQuantity = BigDecimal.ZERO;
                
                if (supplierOrderItem.getQuantity() != null) {
                    if (supplierOrderItem.getReceivedQuantity() != null) {
                        noReceivedQuantity = quantity.subtract(receivedQuantity);
                    }
                    //如果交货已完成，设置待收货数量为
                    if (supplierOrderItem.getFinishFlag().equals("Y")) {
                    	noReceivedQuantity=BigDecimal.ZERO;
					}
                    else {
                        noReceivedQuantity = supplierOrderItem.getQuantity();
                    }
                }
                supplierOrderItem.setNoReceivedQuantity(noReceivedQuantity);
                if (supplierOrderItem.getIsEnable() != null && supplierOrderItem.getIsEnable() == 2) {
                    supplierOrderItem.setFrozenFlag("已冻结");
                } else {
                    supplierOrderItem.setFrozenFlag("未冻结");
                }
            }

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream,
                    createExcelHeader(), listOrderItem, "销售订单", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }
    
    /**
     * 供应商pdf导出
     */
    @ApiOperation(httpMethod = "POST", value = "供应商PDF导出")
    @RequestMapping("service/supExportPDF")
    @ResponseBody
    public ResponseResult<List<FileData>> supExportPdf(@ApiParam("供应商订单头id") @RequestBody List<String> orderNoList) {
    	// 检验参数
    	if (orderNoList.isEmpty()) {
    		throw new CommonException("导出失败，未选择导出数据！");
    	}
    	
    	List<FileData> fileDatas = supplierOrderService.getPdfFiles(orderNoList);
    	// 判断是否查询出文件信息集合
    	if (fileDatas.isEmpty()) {
    		throw new CommonException("未查询出数据，导出失败！");
    	}
    	
    	return ResponseResult.success(fileDatas);
    }
}