package com.els.base.voucher.entity;

import com.els.base.delivery.entity.DeliveryOrderItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="凭证行和送货行关联表")
public class VoucherDelivery implements Serializable {
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("供应商企业id")
    private String companyId;

    @ApiModelProperty("供应商企业名称")
    private String companyName;

    @ApiModelProperty("销售方负责人")
    private String userName;

    @ApiModelProperty("供应商id")
    private String userId;

    @ApiModelProperty("采购员公司id")
    private String purCompanyId;

    @ApiModelProperty("采购公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("用户名")
    private String purUserName;

    @ApiModelProperty("凭证编号")
    private String voucherNo;

    @ApiModelProperty("凭证项目编号")
    private String voucherItemNo;

    @ApiModelProperty("过账日期")
    private Date postTime;

    @ApiModelProperty("凭证日期")
    private Date voucherDate;

    @ApiModelProperty("凭证年度")
    private String voucherYear;

    @ApiModelProperty("输入时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("采购公司代码")
    private String purCompanyCode;

    @ApiModelProperty("移动类型：601/602：销售订单 发货/接收退货;   101/102：采购订单 收货/退货;")
    private Integer mobileType;

    @ApiModelProperty("物料编码")
    private String materialNo;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("采购订单")
    private String purOrderNo;

    @ApiModelProperty("订单项")
    private String purOrderItemNo;

    @ApiModelProperty("入库数量")
    private BigDecimal quantity;

    @ApiModelProperty("供应商编码")
    private String supCompanySapCode;

    @ApiModelProperty("送货单号")
    private String deliveryOrderNo;

    @ApiModelProperty("送货单行号")
    private String deliveryOrderItemNo;
    
    private DeliveryOrderItem deliveryOrderItem;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getVoucherNo() {
        return voucherNo;
    }

    public void setVoucherNo(String voucherNo) {
        this.voucherNo = voucherNo == null ? null : voucherNo.trim();
    }

    public String getVoucherItemNo() {
        return voucherItemNo;
    }

    public void setVoucherItemNo(String voucherItemNo) {
        this.voucherItemNo = voucherItemNo == null ? null : voucherItemNo.trim();
    }

    public Date getPostTime() {
        return postTime;
    }

    public void setPostTime(Date postTime) {
        this.postTime = postTime;
    }

    public Date getVoucherDate() {
        return voucherDate;
    }

    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    public String getVoucherYear() {
        return voucherYear;
    }

    public void setVoucherYear(String voucherYear) {
        this.voucherYear = voucherYear == null ? null : voucherYear.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public Integer getMobileType() {
        return mobileType;
    }

    public void setMobileType(Integer mobileType) {
        this.mobileType = mobileType;
    }

    public String getMaterialNo() {
        return materialNo;
    }

    public void setMaterialNo(String materialNo) {
        this.materialNo = materialNo == null ? null : materialNo.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getPurOrderNo() {
        return purOrderNo;
    }

    public void setPurOrderNo(String purOrderNo) {
        this.purOrderNo = purOrderNo == null ? null : purOrderNo.trim();
    }

    public String getPurOrderItemNo() {
        return purOrderItemNo;
    }

    public void setPurOrderItemNo(String purOrderItemNo) {
        this.purOrderItemNo = purOrderItemNo == null ? null : purOrderItemNo.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo == null ? null : deliveryOrderNo.trim();
    }

    public String getDeliveryOrderItemNo() {
        return deliveryOrderItemNo;
    }

    public void setDeliveryOrderItemNo(String deliveryOrderItemNo) {
        this.deliveryOrderItemNo = deliveryOrderItemNo == null ? null : deliveryOrderItemNo.trim();
    }

	public DeliveryOrderItem getDeliveryOrderItem() {
		return deliveryOrderItem;
	}

	public void setDeliveryOrderItem(DeliveryOrderItem deliveryOrderItem) {
		this.deliveryOrderItem = deliveryOrderItem;
	}
    
}