package com.els.base.voucher.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.voucher.entity.Voucher;
import com.els.base.voucher.entity.VoucherExample;
import com.els.base.voucher.service.VoucherService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="凭证头")
@Controller
@RequestMapping("voucher")
public class VoucherController {
    @Resource
    protected VoucherService voucherService;

    @ApiOperation(httpMethod="POST", value="创建凭证头")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Voucher voucher) {
        this.voucherService.addObj(voucher);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑凭证头")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Voucher voucher) {
        if (StringUtils.isBlank(voucher.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.voucherService.modifyObj(voucher);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除凭证头")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.voucherService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询凭证头")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Voucher>> findByPage(@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="查询条件,属性名请参考 Voucher") @RequestBody(required=false) QueryParamWapper wapper) {
        VoucherExample example = new VoucherExample();
        example.setPageView(new PageView<Voucher>(pageNo, pageSize));
        
        if (wapper != null) {
            VoucherExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<Voucher> pageData = this.voucherService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}