package com.els.base.delivery.dao;

import java.util.Date;
import java.util.List;

import com.els.base.delivery.entity.DeliveryOrderReport;
import com.els.base.delivery.entity.DeliveryOrderReportItemExample;
import org.apache.ibatis.annotations.Param;

import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;

public interface DeliveryOrderItemMapper {
    int countByExample(DeliveryOrderItemExample example);

    int deleteByExample(DeliveryOrderItemExample example);

    int deleteByPrimaryKey(String id);

    int insert(DeliveryOrderItem record);

    int insertSelective(DeliveryOrderItem record);

    List<DeliveryOrderItem> selectByExample(DeliveryOrderItemExample example);

    DeliveryOrderItem selectByPrimaryKey(String id);

    int updateByExampleSelective(@Param("record") DeliveryOrderItem record, @Param("example") DeliveryOrderItemExample example);

    int updateByExample(@Param("record") DeliveryOrderItem record, @Param("example") DeliveryOrderItemExample example);

    int updateByPrimaryKeySelective(DeliveryOrderItem record);

    int updateByPrimaryKey(DeliveryOrderItem record);

    void insertBatch(List<DeliveryOrderItem> list);

    List<DeliveryOrderItem> selectByExampleByPage(DeliveryOrderItemExample example);

    /**
     * 根据订单id号，保存当前数据到历史记录表
     *
     * @param id
     * @param cause
     * @param causeTime
     * @return
     */
    int insertHis(@Param("hisId") String hisId, @Param("deliveryOrderItemId") String deliveryOrderItemId,
            @Param("cause") String cause,@Param("operateTime") Date operateTime);

    /**
     * 根据查询条件，查询历史纪录
     *
     * @param example
     * @return
     */
    List<DeliveryOrderItem> selectHisByExampleByPage(DeliveryOrderItemExample example);
    /**
     * 物流进度报表
     * @param example
     * @return
     */
    public List<DeliveryOrderItem> queryDeliveryOrderItemForLogisticByPage(DeliveryOrderItemExample example);

    /**
     * 送货单报表
     * @param example
     * @return
     */
    public List<DeliveryOrderReport> queryDeliveryOrderReportByPage(DeliveryOrderReportItemExample example);
    /**
     * 送货单报表导出
     * @param example
     * @return
     */
    public List<DeliveryOrderReport> queryDeliveryOrderReportForExcel(DeliveryOrderReportItemExample example);
}