package com.els.base.delivery.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="发货单头")
public class DeliveryOrder implements Serializable {


    //################生成请勿覆盖########################
    @JsonIgnore
    private String mobileType;

    @JsonIgnore
    @ApiModelProperty("操作历史id")
    private String hisId;

    @ApiModelProperty("操作时间")
    @JsonIgnore
    private Date operateTime;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("操作原因")
    private String cause;

    private List<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();

    
    
    public String getMobileType() {
        return mobileType;
    }

    public void setMobileType(String mobileType) {
        this.mobileType = mobileType;
    }

    public String getHisId() {
        return hisId;
    }

    public void setHisId(String hisId) {
        this.hisId = hisId;
    }

    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCause() {
        return cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public List<DeliveryOrderItem> getItems() {
        return items;
    }

    public void setItems(List<DeliveryOrderItem> items) {
        this.items = items;
    }

    //################生成请勿覆盖########################

    @Override
	public String toString() {
		return "DeliveryOrder [mobileType=" + mobileType + ", hisId=" + hisId + ", operateTime=" + operateTime
				+ ", projectName=" + projectName + ", cause=" + cause + ", items=" + items + ", id=" + id
				+ ", projectId=" + projectId + ", companyId=" + companyId + ", companyName=" + companyName
				+ ", companyCode=" + companyCode + ", userName=" + userName + ", userId=" + userId + ", purCompanyId="
				+ purCompanyId + ", purCompanyName=" + purCompanyName + ", purCompanyCode=" + purCompanyCode
				+ ", purUserId=" + purUserId + ", purUserName=" + purUserName + ", logisticOrderNo=" + logisticOrderNo
				+ ", deliveryOrderNo=" + deliveryOrderNo + ", deliveryOrderTime=" + deliveryOrderTime
				+ ", deliveryDate=" + deliveryDate + ", deliveryStatus=" + deliveryStatus + ", receiveDate="
				+ receiveDate + ", purchaseOrderId=" + purchaseOrderId + ", purchaseOrderNo=" + purchaseOrderNo
				+ ", idCard=" + idCard + ", car=" + car + ", driverName=" + driverName + ", expectDeliveryTime="
				+ expectDeliveryTime + ", expectArriveTime=" + expectArriveTime + ", invoiceNo=" + invoiceNo
				+ ", createTime=" + createTime + ", lastUpdateTime=" + lastUpdateTime + ", lastUpdateUser="
				+ lastUpdateUser + ", outFactoryTime=" + outFactoryTime + ", gateScanTime=" + gateScanTime + ", type="
				+ type + ", isHk=" + isHk + ", itemType=" + itemType + ", expressCompany=" + expressCompany
				+ ", expressNumber=" + expressNumber + ", isEnable=" + isEnable + ", voucherType=" + voucherType
				+ ", attachment=" + attachment + ", remark=" + remark + ", batch=" + batch + "]";
	}

	@ApiModelProperty("编号")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("供应商企业id")
    private String companyId;

    @ApiModelProperty("供应商企业名称")
    private String companyName;

    @ApiModelProperty("供应商编码")
    private String companyCode;

    @ApiModelProperty("销售方负责人")
    private String userName;

    @ApiModelProperty("用户ID")
    private String userId;

    @ApiModelProperty("采购公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("物流单号")
    private String logisticOrderNo;

    @ApiModelProperty("送货单号")
    private String deliveryOrderNo;

    @ApiModelProperty("送货单生成时间")
    private Date deliveryOrderTime;

    @ApiModelProperty("送货日期")
    private Date deliveryDate;

    @ApiModelProperty("发货状态:1 未发货，2 在途，3收货,4 香港到货")
    private Integer deliveryStatus;

    @ApiModelProperty("仓库收货")
    private Date receiveDate;

    @ApiModelProperty("采购单id")
    private String purchaseOrderId;

    @ApiModelProperty("采购订单号")
    private String purchaseOrderNo;

    @ApiModelProperty("身份证")
    private String idCard;

    @ApiModelProperty("车牌号")
    private String car;

    @ApiModelProperty("司机")
    private String driverName;

    @ApiModelProperty("预计发货日期")
    private Date expectDeliveryTime;

    @ApiModelProperty("预计到达日期")
    private Date expectArriveTime;

    @ApiModelProperty("发票号")
    private String invoiceNo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间(如果是invoice暂时用作香港到货时间)")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("供方出厂")
    private Date outFactoryTime;

    @ApiModelProperty("FGE门岗")
    private Date gateScanTime;

    @ApiModelProperty("类型：D为送货单，I为invoice单")
    private String type;

    @ApiModelProperty("是否香港到货；1未到货，2已到货")
    private Integer isHk;

    private String itemType;

    @ApiModelProperty("快递公司")
    private String expressCompany;

    @ApiModelProperty("快递单号")
    private String expressNumber;

    @ApiModelProperty("是否可用，0不可用，1可用")
    private Integer isEnable;

    @ApiModelProperty("采购凭证类型")
    private String voucherType;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("附件质检报告")
    private String attachment;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("批次号")
    private String batch;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode == null ? null : companyCode.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getLogisticOrderNo() {
        return logisticOrderNo;
    }

    public void setLogisticOrderNo(String logisticOrderNo) {
        this.logisticOrderNo = logisticOrderNo == null ? null : logisticOrderNo.trim();
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo == null ? null : deliveryOrderNo.trim();
    }

    public Date getDeliveryOrderTime() {
        return deliveryOrderTime;
    }

    public void setDeliveryOrderTime(Date deliveryOrderTime) {
        this.deliveryOrderTime = deliveryOrderTime;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public String getPurchaseOrderId() {
        return purchaseOrderId;
    }

    public void setPurchaseOrderId(String purchaseOrderId) {
        this.purchaseOrderId = purchaseOrderId == null ? null : purchaseOrderId.trim();
    }

    public String getPurchaseOrderNo() {
        return purchaseOrderNo;
    }

    public void setPurchaseOrderNo(String purchaseOrderNo) {
        this.purchaseOrderNo = purchaseOrderNo == null ? null : purchaseOrderNo.trim();
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard == null ? null : idCard.trim();
    }

    public String getCar() {
        return car;
    }

    public void setCar(String car) {
        this.car = car == null ? null : car.trim();
    }

    public String getDriverName() {
        return driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName == null ? null : driverName.trim();
    }

    public Date getExpectDeliveryTime() {
        return expectDeliveryTime;
    }

    public void setExpectDeliveryTime(Date expectDeliveryTime) {
        this.expectDeliveryTime = expectDeliveryTime;
    }

    public Date getExpectArriveTime() {
        return expectArriveTime;
    }

    public void setExpectArriveTime(Date expectArriveTime) {
        this.expectArriveTime = expectArriveTime;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo == null ? null : invoiceNo.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public Date getOutFactoryTime() {
        return outFactoryTime;
    }

    public void setOutFactoryTime(Date outFactoryTime) {
        this.outFactoryTime = outFactoryTime;
    }

    public Date getGateScanTime() {
        return gateScanTime;
    }

    public void setGateScanTime(Date gateScanTime) {
        this.gateScanTime = gateScanTime;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public Integer getIsHk() {
        return isHk;
    }

    public void setIsHk(Integer isHk) {
        this.isHk = isHk;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType == null ? null : itemType.trim();
    }

    public String getExpressCompany() {
        return expressCompany;
    }

    public void setExpressCompany(String expressCompany) {
        this.expressCompany = expressCompany == null ? null : expressCompany.trim();
    }

    public String getExpressNumber() {
        return expressNumber;
    }

    public void setExpressNumber(String expressNumber) {
        this.expressNumber = expressNumber == null ? null : expressNumber.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getVoucherType() {
        return voucherType;
    }

    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType == null ? null : voucherType.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch == null ? null : batch.trim();
    }
}