package com.els.base.delivery.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

@ApiModel(value="发货行")
public class DeliveryOrderItem implements Serializable {

//	##############以下字段自定义，请勿覆盖##################
	@ApiModelProperty("供应商物料名称")
    private String supplierMaterialName;

    @ApiModelProperty("已经发货数量")
    private BigDecimal deliveredQuantity;

    @ApiModelProperty("可发货数量")
    private BigDecimal canDeliveryQuantity;

    @ApiModelProperty("已经在途数量")
    private BigDecimal onwayQuantity;

    @ApiModelProperty("包装明细")
    private List<DeliveryPackage> deliveryPackageLists;

    @ApiModelProperty("国际贸易条款编码")
    private String interTradeCode;

    @ApiModelProperty("国际贸易条款描述")
    private String interTradeDesc;

    /** 操作历史id */
    @JsonIgnore
    private String hisId;

    @ApiModelProperty("操作时间")
    @JsonIgnore
    private Date operateTime;

    @ApiModelProperty("操作原因")
    private String cause;

    @ApiModelProperty("冻结数量")
    private BigDecimal freezeQuantity;

    public String getSupplierMaterialName() {
        return supplierMaterialName;
    }

    public void setSupplierMaterialName(String supplierMaterialName) {
        this.supplierMaterialName = supplierMaterialName;
    }

    public BigDecimal getDeliveredQuantity() {
        return deliveredQuantity;
    }

    public void setDeliveredQuantity(BigDecimal deliveredQuantity) {
        this.deliveredQuantity = deliveredQuantity;
    }

    public BigDecimal getCanDeliveryQuantity() {
        return canDeliveryQuantity;
    }

    public void setCanDeliveryQuantity(BigDecimal canDeliveryQuantity) {
        this.canDeliveryQuantity = canDeliveryQuantity;
    }

    public BigDecimal getOnwayQuantity() {
        return onwayQuantity;
    }

    public void setOnwayQuantity(BigDecimal onwayQuantity) {
        this.onwayQuantity = onwayQuantity;
    }

    public BigDecimal getFreezeQuantity() {
        return freezeQuantity;
    }

    public void setFreezeQuantity(BigDecimal freezeQuantity) {
        this.freezeQuantity = freezeQuantity;
    }

    public List<DeliveryPackage> getDeliveryPackageLists() {
        return deliveryPackageLists;
    }

    public void setDeliveryPackageLists(List<DeliveryPackage> deliveryPackageLists) {
        this.deliveryPackageLists = deliveryPackageLists;
    }

    public String getHisId() {
        return hisId;
    }

    public void setHisId(String hisId) {
        this.hisId = hisId;
    }

    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }

    public String getCause() {
        return cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public String getInterTradeCode() {
		return interTradeCode;
	}

	public void setInterTradeCode(String interTradeCode) {
		this.interTradeCode = interTradeCode;
	}

	public String getInterTradeDesc() {
		return interTradeDesc;
	}

	public void setInterTradeDesc(String interTradeDesc) {
		this.interTradeDesc = interTradeDesc;
	}

//	##############请勿覆盖##################
    @ApiModelProperty("id")
	private String id;

    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("送货单ID")
    private String deliveryOrderId;

    @ApiModelProperty("送货单号")
    private String deliveryOrderNo;

    @ApiModelProperty("送货单行号")
    private String deliveryOrderItemNo;

    @ApiModelProperty("交货日期")
    private Date deliveryDate;

    @ApiModelProperty("批次")
    private String batch;

    @ApiModelProperty("发货时间")
    private Date createTime;

    @ApiModelProperty("物料id")
    private String materialId;

    @ApiModelProperty("物料编码")
    private String materialNo;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("订单数量(订单单位数量)")
    private BigDecimal quantity;

    @ApiModelProperty("送货数量")
    private BigDecimal deliveryQuantity;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("币别")
    private String currency;

    @ApiModelProperty("订单单位")
    private String orderUnit;

    @ApiModelProperty("度量单位")
    private String priceUnit;

    @ApiModelProperty("采购订单ID")
    private String purOrderId;

    @ApiModelProperty("采购订单号")
    private String purOrderNo;

    @ApiModelProperty("采购订单行ID")
    private String purOrderItemId;

    @ApiModelProperty("采购订单行号")
    private String purOrderItemNo;

    @ApiModelProperty("不含税单价")
    private BigDecimal noTaxPrice;

    @ApiModelProperty("不含税金额")
    private BigDecimal noTaxAmount;

    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;

    @ApiModelProperty("含税金额")
    private BigDecimal taxAmount;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("部门ID")
    private String departmentId;

    @ApiModelProperty("已收货数量")
    private String receiptQuantity;

    @ApiModelProperty("可退货数量")
    private String returnQuantity;

    @ApiModelProperty("退货原因")
    private String returnReason;

    @ApiModelProperty("退货工厂")
    private String returnFactory;

    @ApiModelProperty("退货仓库")
    private String returnWarehouse;

    @ApiModelProperty("包装件数")
    private String packQuantity;

    @ApiModelProperty("汇率")
    private String exchangeRate;

    @ApiModelProperty("采购方工厂")
    private String factoryCode;

    @ApiModelProperty("采购方工厂名称")
    private String factoryName;

    @ApiModelProperty("仓库")
    private String warehouseCode;

    @ApiModelProperty("仓库名称")
    private String warehouseName;

    @ApiModelProperty("是否对账，有值则为对账单号")
    private String isReconciliation;

    @ApiModelProperty("交货地点")
    private String deliveryLocation;

    @ApiModelProperty("供应商料号")
    private String supplierMaterialInt;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("供应商企业id")
    private String companyId;

    @ApiModelProperty("供应商企业名称")
    private String companyName;

    @ApiModelProperty("供应商id")
    private String userId;

    @ApiModelProperty("供应商名称")
    private String userName;

    @ApiModelProperty("采购员公司id")
    private String purCompanyId;

    @ApiModelProperty("客户")
    private String purCompanyName;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员")
    private String purUserName;

    @ApiModelProperty("门岗扫描")
    private String gateScan;

    @ApiModelProperty("仓库扫描")
    private String warehouseScan;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("中文名称")
    private String chineseName;

    @ApiModelProperty("型号")
    private String model;

    @ApiModelProperty("类型：D为送货单，I为invoice单")
    private String type;

    @ApiModelProperty("单重")
    private BigDecimal singleWeight;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("原产地")
    private String sourceArea;

    @ApiModelProperty("总净重")
    private BigDecimal totalNetWeight;

    @ApiModelProperty("总毛重")
    private BigDecimal totalGrossWeight;

    @ApiModelProperty("箱号")
    private String caseNo;

    @ApiModelProperty("sap公司代码")
    private String sapPurCompanyCode;

    @ApiModelProperty("发货物料名称")
    private String deliveryMaterialName;

    @ApiModelProperty("卡板INT")
    private String palletInt;

    @ApiModelProperty("是否可用")
    private Integer isEnable;

    @ApiModelProperty("送货单状态")
    private Integer deliveryStatus;

    @ApiModelProperty("供应商物料号")
    private String supplierMaterialNumber;

    @ApiModelProperty("卡板号")
    private String palletNumber;

    @ApiModelProperty("项目类别描述：一般指的是标准的订单还是外协的订单行")
    private String itemDescription;

    @ApiModelProperty("订单类别描述")
    private String orderTypeDesc;

    @ApiModelProperty("需求跟踪号")
    private String needFollowNo;

    @ApiModelProperty("WBS号")
    private String wbsNo;

    @ApiModelProperty("WBS号描述")
    private String wbsNoDesc;

    @ApiModelProperty("项目描述")
    private String projectDesc;

    @ApiModelProperty("科目类别")
    private String courseAssignType;

    @ApiModelProperty("规格")
    private String specification;

    @ApiModelProperty("图号")
    private String mapNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("附件质检报告")
    private String attachment;
    
    @ApiModelProperty("质检状态")
    private String quanlityTestStatus;
    
    @ApiModelProperty("仓位")
    private String position;
    
    @ApiModelProperty("批次启用标识符")
    private String batchFlag;

    @ApiModelProperty("物料有效期管理")
    private Integer materialValidityFlag;

    @ApiModelProperty("物料过期日")
    private Date materialValidityDate;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode == null ? null : companyCode.trim();
    }

    public String getDeliveryOrderId() {
        return deliveryOrderId;
    }

    public void setDeliveryOrderId(String deliveryOrderId) {
        this.deliveryOrderId = deliveryOrderId == null ? null : deliveryOrderId.trim();
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo == null ? null : deliveryOrderNo.trim();
    }

    public String getDeliveryOrderItemNo() {
        return deliveryOrderItemNo;
    }

    public void setDeliveryOrderItemNo(String deliveryOrderItemNo) {
        this.deliveryOrderItemNo = deliveryOrderItemNo == null ? null : deliveryOrderItemNo.trim();
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch == null ? null : batch.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId == null ? null : materialId.trim();
    }

    public String getMaterialNo() {
        return materialNo;
    }

    public void setMaterialNo(String materialNo) {
        this.materialNo = materialNo == null ? null : materialNo.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public String getOrderUnit() {
        return orderUnit;
    }

    public void setOrderUnit(String orderUnit) {
        this.orderUnit = orderUnit == null ? null : orderUnit.trim();
    }

    public String getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(String priceUnit) {
        this.priceUnit = priceUnit == null ? null : priceUnit.trim();
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    public String getPurOrderNo() {
        return purOrderNo;
    }

    public void setPurOrderNo(String purOrderNo) {
        this.purOrderNo = purOrderNo == null ? null : purOrderNo.trim();
    }

    public String getPurOrderItemId() {
        return purOrderItemId;
    }

    public void setPurOrderItemId(String purOrderItemId) {
        this.purOrderItemId = purOrderItemId == null ? null : purOrderItemId.trim();
    }

    public String getPurOrderItemNo() {
        return purOrderItemNo;
    }

    public void setPurOrderItemNo(String purOrderItemNo) {
        this.purOrderItemNo = purOrderItemNo == null ? null : purOrderItemNo.trim();
    }

    public BigDecimal getNoTaxPrice() {
        return noTaxPrice;
    }

    public void setNoTaxPrice(BigDecimal noTaxPrice) {
        this.noTaxPrice = noTaxPrice;
    }

    public BigDecimal getNoTaxAmount() {
        return noTaxAmount;
    }

    public void setNoTaxAmount(BigDecimal noTaxAmount) {
        this.noTaxAmount = noTaxAmount;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName == null ? null : departmentName.trim();
    }

    public String getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId == null ? null : departmentId.trim();
    }

    public String getReceiptQuantity() {
        return receiptQuantity;
    }

    public void setReceiptQuantity(String receiptQuantity) {
        this.receiptQuantity = receiptQuantity;
    }

    public String getReturnQuantity() {
        return returnQuantity;
    }

    public void setReturnQuantity(String returnQuantity) {
        this.returnQuantity = returnQuantity == null ? null : returnQuantity.trim();
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason == null ? null : returnReason.trim();
    }

    public String getReturnFactory() {
        return returnFactory;
    }

    public void setReturnFactory(String returnFactory) {
        this.returnFactory = returnFactory == null ? null : returnFactory.trim();
    }

    public String getReturnWarehouse() {
        return returnWarehouse;
    }

    public void setReturnWarehouse(String returnWarehouse) {
        this.returnWarehouse = returnWarehouse == null ? null : returnWarehouse.trim();
    }

    public String getPackQuantity() {
        return packQuantity;
    }

    public void setPackQuantity(String packQuantity) {
        this.packQuantity = packQuantity == null ? null : packQuantity.trim();
    }

    public String getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate == null ? null : exchangeRate.trim();
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode == null ? null : factoryCode.trim();
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName == null ? null : factoryName.trim();
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode == null ? null : warehouseCode.trim();
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName == null ? null : warehouseName.trim();
    }

    public String getIsReconciliation() {
        return isReconciliation;
    }

    public void setIsReconciliation(String isReconciliation) {
        this.isReconciliation = isReconciliation == null ? null : isReconciliation.trim();
    }

    public String getDeliveryLocation() {
        return deliveryLocation;
    }

    public void setDeliveryLocation(String deliveryLocation) {
        this.deliveryLocation = deliveryLocation == null ? null : deliveryLocation.trim();
    }

    public String getSupplierMaterialInt() {
        return supplierMaterialInt;
    }

    public void setSupplierMaterialInt(String supplierMaterialInt) {
        this.supplierMaterialInt = supplierMaterialInt == null ? null : supplierMaterialInt.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getGateScan() {
        return gateScan;
    }

    public void setGateScan(String gateScan) {
        this.gateScan = gateScan == null ? null : gateScan.trim();
    }

    public String getWarehouseScan() {
        return warehouseScan;
    }

    public void setWarehouseScan(String warehouseScan) {
        this.warehouseScan = warehouseScan == null ? null : warehouseScan.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getChineseName() {
        return chineseName;
    }

    public void setChineseName(String chineseName) {
        this.chineseName = chineseName == null ? null : chineseName.trim();
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model == null ? null : model.trim();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public BigDecimal getSingleWeight() {
        return singleWeight;
    }

    public void setSingleWeight(BigDecimal singleWeight) {
        this.singleWeight = singleWeight;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand == null ? null : brand.trim();
    }

    public String getSourceArea() {
        return sourceArea;
    }

    public void setSourceArea(String sourceArea) {
        this.sourceArea = sourceArea == null ? null : sourceArea.trim();
    }

    public BigDecimal getTotalNetWeight() {
        return totalNetWeight;
    }

    public void setTotalNetWeight(BigDecimal totalNetWeight) {
        this.totalNetWeight = totalNetWeight;
    }

    public BigDecimal getTotalGrossWeight() {
        return totalGrossWeight;
    }

    public void setTotalGrossWeight(BigDecimal totalGrossWeight) {
        this.totalGrossWeight = totalGrossWeight;
    }

    public String getCaseNo() {
        return caseNo;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo == null ? null : caseNo.trim();
    }

    public String getSapPurCompanyCode() {
        return sapPurCompanyCode;
    }

    public void setSapPurCompanyCode(String sapPurCompanyCode) {
        this.sapPurCompanyCode = sapPurCompanyCode == null ? null : sapPurCompanyCode.trim();
    }

    public String getDeliveryMaterialName() {
        return deliveryMaterialName;
    }

    public void setDeliveryMaterialName(String deliveryMaterialName) {
        this.deliveryMaterialName = deliveryMaterialName == null ? null : deliveryMaterialName.trim();
    }

    public String getPalletInt() {
        return palletInt;
    }

    public void setPalletInt(String palletInt) {
        this.palletInt = palletInt == null ? null : palletInt.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public String getSupplierMaterialNumber() {
        return supplierMaterialNumber;
    }

    public void setSupplierMaterialNumber(String supplierMaterialNumber) {
        this.supplierMaterialNumber = supplierMaterialNumber == null ? null : supplierMaterialNumber.trim();
    }

    public String getPalletNumber() {
        return palletNumber;
    }

    public void setPalletNumber(String palletNumber) {
        this.palletNumber = palletNumber == null ? null : palletNumber.trim();
    }

    public String getItemDescription() {
        return itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription == null ? null : itemDescription.trim();
    }

    public String getOrderTypeDesc() {
        return orderTypeDesc;
    }

    public void setOrderTypeDesc(String orderTypeDesc) {
        this.orderTypeDesc = orderTypeDesc == null ? null : orderTypeDesc.trim();
    }

    public String getNeedFollowNo() {
        return needFollowNo;
    }

    public void setNeedFollowNo(String needFollowNo) {
        this.needFollowNo = needFollowNo == null ? null : needFollowNo.trim();
    }

    public String getWbsNo() {
        return wbsNo;
    }

    public void setWbsNo(String wbsNo) {
        this.wbsNo = wbsNo == null ? null : wbsNo.trim();
    }

    public String getWbsNoDesc() {
        return wbsNoDesc;
    }

    public void setWbsNoDesc(String wbsNoDesc) {
        this.wbsNoDesc = wbsNoDesc == null ? null : wbsNoDesc.trim();
    }

    public String getProjectDesc() {
        return projectDesc;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc == null ? null : projectDesc.trim();
    }

    public String getCourseAssignType() {
        return courseAssignType;
    }

    public void setCourseAssignType(String courseAssignType) {
        this.courseAssignType = courseAssignType == null ? null : courseAssignType.trim();
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification == null ? null : specification.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }
    
    public String getQuanlityTestStatus() {
        return quanlityTestStatus;
    }

    public void setQuanlityTestStatus(String quanlityTestStatus) {
        this.quanlityTestStatus = quanlityTestStatus == null ? null : quanlityTestStatus.trim();
    }
    
    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position == null ? null : position.trim();
    }
    
    public String getBatchFlag() {
        return batchFlag;
    }

    public void setBatchFlag(String batchFlag) {
        this.batchFlag = batchFlag == null ? null : batchFlag.trim();
    }

    public Integer getMaterialValidityFlag() {
        return materialValidityFlag;
    }

    public void setMaterialValidityFlag(Integer materialValidityFlag) {
        this.materialValidityFlag = materialValidityFlag;
    }

    public Date getMaterialValidityDate() {
        return materialValidityDate;
    }

    public void setMaterialValidityDate(Date materialValidityDate) {
        this.materialValidityDate = materialValidityDate;
    }
}