package com.els.base.delivery.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;

import com.fasterxml.jackson.annotation.JsonIgnore;

import io.swagger.annotations.ApiModelProperty;

public class DeliveryOrderPrint extends DeliveryOrder {
	
	public static final String DEFAULT_FONT_PATH = DeliveryOrderPrint.class.getClassLoader().getResource("").toString() + "fonts/nsimsum.ttf";

	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty("国际贸易条款编码")
    private String interTradeCode;

    @ApiModelProperty("国际贸易条款描述")
    private String interTradeDesc;
	
    @ApiModelProperty("打印尺寸（A4、A5）")
	private String printSizeType;
	
    @ApiModelProperty("中文地址")
	private String chineseAddress;
    
    @ApiModelProperty("英文地址")
	private String englishAddress;

    @ApiModelProperty("供应商联系人")
	private String supplierPerson;
    
    @ApiModelProperty("供应商联系电话")
	private String supplierTel;
	
    @ApiModelProperty("供应商中文名")
	private String supplierCompanyChinessName;

    @ApiModelProperty("供应商英文名")
	private String supplierCompanyEnglishName;

    @ApiModelProperty("收货地址")
	private String receiveAddress;

    @ApiModelProperty("客户联系人")
	private String purchasePerson;
    
    @ApiModelProperty("客户联系电话")
	private String purchaseTel;
    
    @ApiModelProperty("条形码路径")
	private String scanPicPath;

    @ApiModelProperty("字体路径")
	private String fontPath = DEFAULT_FONT_PATH;
    
    @JsonIgnore
    public List<Map<String, Object>> itemAndPackList = new ArrayList<>();
	
	public String getSupplierPerson() {
		return supplierPerson;
	}

	public void setSupplierPerson(String supplierPerson) {
		this.supplierPerson = supplierPerson;
	}

	public String getSupplierTel() {
		return supplierTel;
	}

	public void setSupplierTel(String supplierTel) {
		this.supplierTel = supplierTel;
	}

	public String getReceiveAddress() {
		return receiveAddress;
	}

	public void setReceiveAddress(String receiveAddress) {
		this.receiveAddress = receiveAddress;
	}

	public String getPurchasePerson() {
		return purchasePerson;
	}

	public void setPurchasePerson(String purchasePerson) {
		this.purchasePerson = purchasePerson;
	}

	public String getPurchaseTel() {
		return purchaseTel;
	}

	public void setPurchaseTel(String purchaseTel) {
		this.purchaseTel = purchaseTel;
	}

	public String getScanPicPath() {
		return scanPicPath;
	}

	public void setScanPicPath(String scanPicPath) {
		this.scanPicPath = scanPicPath;
	}

	public String getChineseAddress() {
		return chineseAddress;
	}

	public void setChineseAddress(String chineseAddress) {
		this.chineseAddress = chineseAddress;
	}

	public String getEnglishAddress() {
		return englishAddress;
	}

	public void setEnglishAddress(String englishAddress) {
		this.englishAddress = englishAddress;
	}

	public String getPrintSizeType() {
		return printSizeType;
	}

	public void setPrintSizeType(String printSizeType) {
		this.printSizeType = printSizeType;
	}

	public String getFontPath() {
		return fontPath;
	}

	public void setFontPath(String fontPath) {
		this.fontPath = fontPath;
	}

	public String getSupplierCompanyChinessName() {
		return supplierCompanyChinessName;
	}

	public void setSupplierCompanyChinessName(String supplierCompanyChinessName) {
		this.supplierCompanyChinessName = supplierCompanyChinessName;
	}

	public String getSupplierCompanyEnglishName() {
		return supplierCompanyEnglishName;
	}

	public void setSupplierCompanyEnglishName(String supplierCompanyEnglishName) {
		this.supplierCompanyEnglishName = supplierCompanyEnglishName;
	}

	public String getInterTradeCode() {
		return interTradeCode;
	}

	public void setInterTradeCode(String interTradeCode) {
		this.interTradeCode = interTradeCode;
	}

	public String getInterTradeDesc() {
		return interTradeDesc;
	}

	public void setInterTradeDesc(String interTradeDesc) {
		this.interTradeDesc = interTradeDesc;
	}

	public List<Map<String, Object>> getItemAndPackList() {
		if (CollectionUtils.isEmpty(this.getItems())) {
			return null;
		}
		
		List<Map<String, Object>> itemAndPackList = new ArrayList<>();
		
	    List<DeliveryOrderItem> subItems = this.getItems();
		for(DeliveryOrderItem item : subItems){
			BigDecimal totalNetWeight = BigDecimal.ZERO;
			
			List<DeliveryPackage> packageList = item.getDeliveryPackageLists();
			if (CollectionUtils.isEmpty(packageList)) {
				
				if (item.getSingleWeight() != null && !item.getSingleWeight().equals(BigDecimal.ZERO)) {
					totalNetWeight = item.getTotalNetWeight().setScale(2, BigDecimal.ROUND_HALF_UP);
				}
				
				Map<String, Object> map = new HashedMap();
				map.put("item", item);
				map.put("totalNetWeight", totalNetWeight);
				itemAndPackList.add(map);
				continue;
			}
			
			for(DeliveryPackage packageItem: packageList){
				if (item.getSingleWeight() != null && !item.getSingleWeight().equals(BigDecimal.ZERO)) {
					totalNetWeight = item.getSingleWeight().multiply(new BigDecimal(packageItem.getTotalQuantity())).divide(new BigDecimal(1000)).setScale(3, BigDecimal.ROUND_HALF_UP);
				}
				
				if (packageItem.getGrossWeight() != null && !packageItem.getGrossWeight().equals(BigDecimal.ZERO)) {
					BigDecimal pgGrossWeight = packageItem.getGrossWeight().multiply(new BigDecimal(packageItem.getPackageQuantity()));
					packageItem.setGrossWeight(pgGrossWeight.setScale(3, BigDecimal.ROUND_HALF_UP));
				}
				if (packageItem.getVolume() != null && !packageItem.getVolume().equals("0")) {
					packageItem.setVolume(new BigDecimal(packageItem.getVolume()).setScale(3, BigDecimal.ROUND_HALF_UP).toString());
				}
				
				Map<String, Object> map = new HashedMap();
				map.put("item", item);
				map.put("package", packageItem);
				map.put("totalNetWeight", totalNetWeight);
				
				itemAndPackList.add(map);
			}
			
		}
		return itemAndPackList;
	}

}
