package com.els.base.delivery.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DeliveryOrderReportItemExample extends AbstractExample<DeliveryOrderReport> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<DeliveryOrderReport> pageView = new PageView<DeliveryOrderReport>(1, 10);

    private static final long serialVersionUID = 1L;

    public DeliveryOrderReportItemExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<DeliveryOrderReport> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<DeliveryOrderReport> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andMidIsNull() {
            addCriterion("MID is null");
            return (Criteria) this;
        }

        public Criteria andMidIsNotNull() {
            addCriterion("MID is not null");
            return (Criteria) this;
        }

        public Criteria andMidEqualTo(String value) {
            addCriterion("MID =", value, "mid");
            return (Criteria) this;
        }


        public Criteria andMdeliveryStatusIsNull() {
            addCriterion("MDELIVERY_STATUS is null");
            return (Criteria) this;
        }

        public Criteria andMdeliveryStatusNotNull() {
            addCriterion("MDELIVERY_STATUS is not null");
            return (Criteria) this;
        }

        public Criteria andMdeliveryStatusEqualTo(String value) {
            addCriterion("MDELIVERY_STATUS =", value, "mDeliveryStatus");
            return (Criteria) this;
        }

        public Criteria andMdeliveryStatusNotEqualTo(String value) {
            addCriterion("MDELIVERY_STATUS !=", value, "mDeliveryStatus");
            return (Criteria) this;
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIsNull() {
            addCriterion("COMPANY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIsNotNull() {
            addCriterion("COMPANY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeEqualTo(String value) {
            addCriterion("COMPANY_CODE =", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotEqualTo(String value) {
            addCriterion("COMPANY_CODE <>", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeGreaterThan(String value) {
            addCriterion("COMPANY_CODE >", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_CODE >=", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLessThan(String value) {
            addCriterion("COMPANY_CODE <", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_CODE <=", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLike(String value) {
            addCriterion("COMPANY_CODE like", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotLike(String value) {
            addCriterion("COMPANY_CODE not like", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIn(List<String> values) {
            addCriterion("COMPANY_CODE in", values, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotIn(List<String> values) {
            addCriterion("COMPANY_CODE not in", values, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeBetween(String value1, String value2) {
            addCriterion("COMPANY_CODE between", value1, value2, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotBetween(String value1, String value2) {
            addCriterion("COMPANY_CODE not between", value1, value2, "companyCode");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdIsNull() {
            addCriterion("DELIVERY_ORDER_ID is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdIsNotNull() {
            addCriterion("DELIVERY_ORDER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ID =", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdNotEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ID <>", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdGreaterThan(String value) {
            addCriterion("DELIVERY_ORDER_ID >", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ID >=", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdLessThan(String value) {
            addCriterion("DELIVERY_ORDER_ID <", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ID <=", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdLike(String value) {
            addCriterion("DELIVERY_ORDER_ID like", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdNotLike(String value) {
            addCriterion("DELIVERY_ORDER_ID not like", value, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_ID in", values, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdNotIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_ID not in", values, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_ID between", value1, value2, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderIdNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_ID not between", value1, value2, "deliveryOrderId");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoIsNull() {
            addCriterion("DELIVERY_ORDER_NO is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoIsNotNull() {
            addCriterion("DELIVERY_ORDER_NO is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO =", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO <>", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoGreaterThan(String value) {
            addCriterion("DELIVERY_ORDER_NO >", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO >=", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoLessThan(String value) {
            addCriterion("DELIVERY_ORDER_NO <", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO <=", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoLike(String value) {
            addCriterion("DELIVERY_ORDER_NO like", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotLike(String value) {
            addCriterion("DELIVERY_ORDER_NO not like", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_NO in", values, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_NO not in", values, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_NO between", value1, value2, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_NO not between", value1, value2, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoIsNull() {
            addCriterion("DELIVERY_ORDER_ITEM_NO is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoIsNotNull() {
            addCriterion("DELIVERY_ORDER_ITEM_NO is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO =", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO <>", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoGreaterThan(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO >", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO >=", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoLessThan(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO <", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO <=", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoLike(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO like", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotLike(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO not like", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_ITEM_NO in", values, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_ITEM_NO not in", values, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_ITEM_NO between", value1, value2, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_ITEM_NO not between", value1, value2, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateIsNull() {
            addCriterion("DELIVERY_DATE is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateIsNotNull() {
            addCriterion("DELIVERY_DATE is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateEqualTo(Date value) {
            addCriterion("DELIVERY_DATE =", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateNotEqualTo(Date value) {
            addCriterion("DELIVERY_DATE <>", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateGreaterThan(Date value) {
            addCriterion("DELIVERY_DATE >", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateGreaterThanOrEqualTo(Date value) {
            addCriterion("DELIVERY_DATE >=", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateLessThan(Date value) {
            addCriterion("DELIVERY_DATE <", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateLessThanOrEqualTo(Date value) {
            addCriterion("DELIVERY_DATE <=", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateIn(List<Date> values) {
            addCriterion("DELIVERY_DATE in", values, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateNotIn(List<Date> values) {
            addCriterion("DELIVERY_DATE not in", values, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateBetween(Date value1, Date value2) {
            addCriterion("DELIVERY_DATE between", value1, value2, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateNotBetween(Date value1, Date value2) {
            addCriterion("DELIVERY_DATE not between", value1, value2, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andBatchIsNull() {
            addCriterion("BATCH is null");
            return (Criteria) this;
        }

        public Criteria andBatchIsNotNull() {
            addCriterion("BATCH is not null");
            return (Criteria) this;
        }

        public Criteria andBatchEqualTo(String value) {
            addCriterion("BATCH =", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchNotEqualTo(String value) {
            addCriterion("BATCH <>", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchGreaterThan(String value) {
            addCriterion("BATCH >", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchGreaterThanOrEqualTo(String value) {
            addCriterion("BATCH >=", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchLessThan(String value) {
            addCriterion("BATCH <", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchLessThanOrEqualTo(String value) {
            addCriterion("BATCH <=", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchLike(String value) {
            addCriterion("BATCH like", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchNotLike(String value) {
            addCriterion("BATCH not like", value, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchIn(List<String> values) {
            addCriterion("BATCH in", values, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchNotIn(List<String> values) {
            addCriterion("BATCH not in", values, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchBetween(String value1, String value2) {
            addCriterion("BATCH between", value1, value2, "batch");
            return (Criteria) this;
        }

        public Criteria andBatchNotBetween(String value1, String value2) {
            addCriterion("BATCH not between", value1, value2, "batch");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andMaterialIdIsNull() {
            addCriterion("MATERIAL_ID is null");
            return (Criteria) this;
        }

        public Criteria andMaterialIdIsNotNull() {
            addCriterion("MATERIAL_ID is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialIdEqualTo(String value) {
            addCriterion("MATERIAL_ID =", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotEqualTo(String value) {
            addCriterion("MATERIAL_ID <>", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdGreaterThan(String value) {
            addCriterion("MATERIAL_ID >", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_ID >=", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdLessThan(String value) {
            addCriterion("MATERIAL_ID <", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_ID <=", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdLike(String value) {
            addCriterion("MATERIAL_ID like", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotLike(String value) {
            addCriterion("MATERIAL_ID not like", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdIn(List<String> values) {
            addCriterion("MATERIAL_ID in", values, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotIn(List<String> values) {
            addCriterion("MATERIAL_ID not in", values, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdBetween(String value1, String value2) {
            addCriterion("MATERIAL_ID between", value1, value2, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_ID not between", value1, value2, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialNoIsNull() {
            addCriterion("MATERIAL_NO is null");
            return (Criteria) this;
        }

        public Criteria andMaterialNoIsNotNull() {
            addCriterion("MATERIAL_NO is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialNoEqualTo(String value) {
            addCriterion("MATERIAL_NO =", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotEqualTo(String value) {
            addCriterion("MATERIAL_NO <>", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoGreaterThan(String value) {
            addCriterion("MATERIAL_NO >", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_NO >=", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoLessThan(String value) {
            addCriterion("MATERIAL_NO <", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_NO <=", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoLike(String value) {
            addCriterion("MATERIAL_NO like", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotLike(String value) {
            addCriterion("MATERIAL_NO not like", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoIn(List<String> values) {
            addCriterion("MATERIAL_NO in", values, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotIn(List<String> values) {
            addCriterion("MATERIAL_NO not in", values, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoBetween(String value1, String value2) {
            addCriterion("MATERIAL_NO between", value1, value2, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_NO not between", value1, value2, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIsNull() {
            addCriterion("MATERIAL_DESC is null");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIsNotNull() {
            addCriterion("MATERIAL_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialDescEqualTo(String value) {
            addCriterion("MATERIAL_DESC =", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotEqualTo(String value) {
            addCriterion("MATERIAL_DESC <>", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescGreaterThan(String value) {
            addCriterion("MATERIAL_DESC >", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_DESC >=", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLessThan(String value) {
            addCriterion("MATERIAL_DESC <", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_DESC <=", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLike(String value) {
            addCriterion("MATERIAL_DESC like", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotLike(String value) {
            addCriterion("MATERIAL_DESC not like", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIn(List<String> values) {
            addCriterion("MATERIAL_DESC in", values, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotIn(List<String> values) {
            addCriterion("MATERIAL_DESC not in", values, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescBetween(String value1, String value2) {
            addCriterion("MATERIAL_DESC between", value1, value2, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_DESC not between", value1, value2, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andQuantityIsNull() {
            addCriterion("QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andQuantityIsNotNull() {
            addCriterion("QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andQuantityEqualTo(BigDecimal value) {
            addCriterion("QUANTITY =", value, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityNotEqualTo(BigDecimal value) {
            addCriterion("QUANTITY <>", value, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityGreaterThan(BigDecimal value) {
            addCriterion("QUANTITY >", value, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("QUANTITY >=", value, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityLessThan(BigDecimal value) {
            addCriterion("QUANTITY <", value, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("QUANTITY <=", value, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityIn(List<BigDecimal> values) {
            addCriterion("QUANTITY in", values, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityNotIn(List<BigDecimal> values) {
            addCriterion("QUANTITY not in", values, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("QUANTITY between", value1, value2, "quantity");
            return (Criteria) this;
        }

        public Criteria andQuantityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("QUANTITY not between", value1, value2, "quantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityIsNull() {
            addCriterion("DELIVERY_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityIsNotNull() {
            addCriterion("DELIVERY_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityEqualTo(BigDecimal value) {
            addCriterion("DELIVERY_QUANTITY =", value, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityNotEqualTo(BigDecimal value) {
            addCriterion("DELIVERY_QUANTITY <>", value, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityGreaterThan(BigDecimal value) {
            addCriterion("DELIVERY_QUANTITY >", value, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("DELIVERY_QUANTITY >=", value, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityLessThan(BigDecimal value) {
            addCriterion("DELIVERY_QUANTITY <", value, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("DELIVERY_QUANTITY <=", value, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityIn(List<BigDecimal> values) {
            addCriterion("DELIVERY_QUANTITY in", values, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityNotIn(List<BigDecimal> values) {
            addCriterion("DELIVERY_QUANTITY not in", values, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("DELIVERY_QUANTITY between", value1, value2, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andDeliveryQuantityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("DELIVERY_QUANTITY not between", value1, value2, "deliveryQuantity");
            return (Criteria) this;
        }

        public Criteria andTotalAmountIsNull() {
            addCriterion("TOTAL_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andTotalAmountIsNotNull() {
            addCriterion("TOTAL_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andTotalAmountEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT =", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountNotEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT <>", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountGreaterThan(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT >", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT >=", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountLessThan(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT <", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT <=", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountIn(List<BigDecimal> values) {
            addCriterion("TOTAL_AMOUNT in", values, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountNotIn(List<BigDecimal> values) {
            addCriterion("TOTAL_AMOUNT not in", values, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_AMOUNT between", value1, value2, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_AMOUNT not between", value1, value2, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andCurrencyIsNull() {
            addCriterion("CURRENCY is null");
            return (Criteria) this;
        }

        public Criteria andCurrencyIsNotNull() {
            addCriterion("CURRENCY is not null");
            return (Criteria) this;
        }

        public Criteria andCurrencyEqualTo(String value) {
            addCriterion("CURRENCY =", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotEqualTo(String value) {
            addCriterion("CURRENCY <>", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyGreaterThan(String value) {
            addCriterion("CURRENCY >", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyGreaterThanOrEqualTo(String value) {
            addCriterion("CURRENCY >=", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLessThan(String value) {
            addCriterion("CURRENCY <", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLessThanOrEqualTo(String value) {
            addCriterion("CURRENCY <=", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLike(String value) {
            addCriterion("CURRENCY like", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotLike(String value) {
            addCriterion("CURRENCY not like", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyIn(List<String> values) {
            addCriterion("CURRENCY in", values, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotIn(List<String> values) {
            addCriterion("CURRENCY not in", values, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyBetween(String value1, String value2) {
            addCriterion("CURRENCY between", value1, value2, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotBetween(String value1, String value2) {
            addCriterion("CURRENCY not between", value1, value2, "currency");
            return (Criteria) this;
        }

        public Criteria andOrderUnitIsNull() {
            addCriterion("ORDER_UNIT is null");
            return (Criteria) this;
        }

        public Criteria andOrderUnitIsNotNull() {
            addCriterion("ORDER_UNIT is not null");
            return (Criteria) this;
        }

        public Criteria andOrderUnitEqualTo(String value) {
            addCriterion("ORDER_UNIT =", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitNotEqualTo(String value) {
            addCriterion("ORDER_UNIT <>", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitGreaterThan(String value) {
            addCriterion("ORDER_UNIT >", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitGreaterThanOrEqualTo(String value) {
            addCriterion("ORDER_UNIT >=", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitLessThan(String value) {
            addCriterion("ORDER_UNIT <", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitLessThanOrEqualTo(String value) {
            addCriterion("ORDER_UNIT <=", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitLike(String value) {
            addCriterion("ORDER_UNIT like", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitNotLike(String value) {
            addCriterion("ORDER_UNIT not like", value, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitIn(List<String> values) {
            addCriterion("ORDER_UNIT in", values, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitNotIn(List<String> values) {
            addCriterion("ORDER_UNIT not in", values, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitBetween(String value1, String value2) {
            addCriterion("ORDER_UNIT between", value1, value2, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andOrderUnitNotBetween(String value1, String value2) {
            addCriterion("ORDER_UNIT not between", value1, value2, "orderUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitIsNull() {
            addCriterion("PRICE_UNIT is null");
            return (Criteria) this;
        }

        public Criteria andPriceUnitIsNotNull() {
            addCriterion("PRICE_UNIT is not null");
            return (Criteria) this;
        }

        public Criteria andPriceUnitEqualTo(String value) {
            addCriterion("PRICE_UNIT =", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitNotEqualTo(String value) {
            addCriterion("PRICE_UNIT <>", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitGreaterThan(String value) {
            addCriterion("PRICE_UNIT >", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitGreaterThanOrEqualTo(String value) {
            addCriterion("PRICE_UNIT >=", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitLessThan(String value) {
            addCriterion("PRICE_UNIT <", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitLessThanOrEqualTo(String value) {
            addCriterion("PRICE_UNIT <=", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitLike(String value) {
            addCriterion("PRICE_UNIT like", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitNotLike(String value) {
            addCriterion("PRICE_UNIT not like", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitIn(List<String> values) {
            addCriterion("PRICE_UNIT in", values, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitNotIn(List<String> values) {
            addCriterion("PRICE_UNIT not in", values, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitBetween(String value1, String value2) {
            addCriterion("PRICE_UNIT between", value1, value2, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitNotBetween(String value1, String value2) {
            addCriterion("PRICE_UNIT not between", value1, value2, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdIsNull() {
            addCriterion("PUR_ORDER_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdIsNotNull() {
            addCriterion("PUR_ORDER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdEqualTo(String value) {
            addCriterion("PUR_ORDER_ID =", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotEqualTo(String value) {
            addCriterion("PUR_ORDER_ID <>", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdGreaterThan(String value) {
            addCriterion("PUR_ORDER_ID >", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ID >=", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdLessThan(String value) {
            addCriterion("PUR_ORDER_ID <", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ID <=", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdLike(String value) {
            addCriterion("PUR_ORDER_ID like", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotLike(String value) {
            addCriterion("PUR_ORDER_ID not like", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdIn(List<String> values) {
            addCriterion("PUR_ORDER_ID in", values, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotIn(List<String> values) {
            addCriterion("PUR_ORDER_ID not in", values, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ID between", value1, value2, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ID not between", value1, value2, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoIsNull() {
            addCriterion("PUR_ORDER_NO is null");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoIsNotNull() {
            addCriterion("PUR_ORDER_NO is not null");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoEqualTo(String value) {
            addCriterion("PUR_ORDER_NO =", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoNotEqualTo(String value) {
            addCriterion("PUR_ORDER_NO <>", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoGreaterThan(String value) {
            addCriterion("PUR_ORDER_NO >", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_NO >=", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoLessThan(String value) {
            addCriterion("PUR_ORDER_NO <", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoLessThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_NO <=", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoLike(String value) {
            addCriterion("PUR_ORDER_NO like", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoNotLike(String value) {
            addCriterion("PUR_ORDER_NO not like", value, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoIn(List<String> values) {
            addCriterion("PUR_ORDER_NO in", values, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoNotIn(List<String> values) {
            addCriterion("PUR_ORDER_NO not in", values, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_NO between", value1, value2, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderNoNotBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_NO not between", value1, value2, "purOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdIsNull() {
            addCriterion("PUR_ORDER_ITEM_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdIsNotNull() {
            addCriterion("PUR_ORDER_ITEM_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_ID =", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdNotEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_ID <>", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdGreaterThan(String value) {
            addCriterion("PUR_ORDER_ITEM_ID >", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_ID >=", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdLessThan(String value) {
            addCriterion("PUR_ORDER_ITEM_ID <", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_ID <=", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdLike(String value) {
            addCriterion("PUR_ORDER_ITEM_ID like", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdNotLike(String value) {
            addCriterion("PUR_ORDER_ITEM_ID not like", value, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdIn(List<String> values) {
            addCriterion("PUR_ORDER_ITEM_ID in", values, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdNotIn(List<String> values) {
            addCriterion("PUR_ORDER_ITEM_ID not in", values, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ITEM_ID between", value1, value2, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemIdNotBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ITEM_ID not between", value1, value2, "purOrderItemId");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoIsNull() {
            addCriterion("PUR_ORDER_ITEM_NO is null");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoIsNotNull() {
            addCriterion("PUR_ORDER_ITEM_NO is not null");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_NO =", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoNotEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_NO <>", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoGreaterThan(String value) {
            addCriterion("PUR_ORDER_ITEM_NO >", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_NO >=", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoLessThan(String value) {
            addCriterion("PUR_ORDER_ITEM_NO <", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoLessThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ITEM_NO <=", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoLike(String value) {
            addCriterion("PUR_ORDER_ITEM_NO like", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoNotLike(String value) {
            addCriterion("PUR_ORDER_ITEM_NO not like", value, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoIn(List<String> values) {
            addCriterion("PUR_ORDER_ITEM_NO in", values, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoNotIn(List<String> values) {
            addCriterion("PUR_ORDER_ITEM_NO not in", values, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ITEM_NO between", value1, value2, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurOrderItemNoNotBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ITEM_NO not between", value1, value2, "purOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceIsNull() {
            addCriterion("NO_TAX_PRICE is null");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceIsNotNull() {
            addCriterion("NO_TAX_PRICE is not null");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_PRICE =", value, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceNotEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_PRICE <>", value, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceGreaterThan(BigDecimal value) {
            addCriterion("NO_TAX_PRICE >", value, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_PRICE >=", value, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceLessThan(BigDecimal value) {
            addCriterion("NO_TAX_PRICE <", value, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceLessThanOrEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_PRICE <=", value, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceIn(List<BigDecimal> values) {
            addCriterion("NO_TAX_PRICE in", values, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceNotIn(List<BigDecimal> values) {
            addCriterion("NO_TAX_PRICE not in", values, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NO_TAX_PRICE between", value1, value2, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxPriceNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NO_TAX_PRICE not between", value1, value2, "noTaxPrice");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountIsNull() {
            addCriterion("NO_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountIsNotNull() {
            addCriterion("NO_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_AMOUNT =", value, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_AMOUNT <>", value, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("NO_TAX_AMOUNT >", value, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_AMOUNT >=", value, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountLessThan(BigDecimal value) {
            addCriterion("NO_TAX_AMOUNT <", value, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("NO_TAX_AMOUNT <=", value, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountIn(List<BigDecimal> values) {
            addCriterion("NO_TAX_AMOUNT in", values, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("NO_TAX_AMOUNT not in", values, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NO_TAX_AMOUNT between", value1, value2, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNoTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NO_TAX_AMOUNT not between", value1, value2, "noTaxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxPriceIsNull() {
            addCriterion("TAX_PRICE is null");
            return (Criteria) this;
        }

        public Criteria andTaxPriceIsNotNull() {
            addCriterion("TAX_PRICE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxPriceEqualTo(BigDecimal value) {
            addCriterion("TAX_PRICE =", value, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceNotEqualTo(BigDecimal value) {
            addCriterion("TAX_PRICE <>", value, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceGreaterThan(BigDecimal value) {
            addCriterion("TAX_PRICE >", value, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_PRICE >=", value, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceLessThan(BigDecimal value) {
            addCriterion("TAX_PRICE <", value, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_PRICE <=", value, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceIn(List<BigDecimal> values) {
            addCriterion("TAX_PRICE in", values, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceNotIn(List<BigDecimal> values) {
            addCriterion("TAX_PRICE not in", values, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_PRICE between", value1, value2, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxPriceNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_PRICE not between", value1, value2, "taxPrice");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIsNull() {
            addCriterion("TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIsNotNull() {
            addCriterion("TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andTaxAmountEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT =", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT <>", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("TAX_AMOUNT >", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT >=", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountLessThan(BigDecimal value) {
            addCriterion("TAX_AMOUNT <", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT <=", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIn(List<BigDecimal> values) {
            addCriterion("TAX_AMOUNT in", values, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("TAX_AMOUNT not in", values, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_AMOUNT between", value1, value2, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_AMOUNT not between", value1, value2, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNull() {
            addCriterion("TAX_CODE is null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNotNull() {
            addCriterion("TAX_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeEqualTo(String value) {
            addCriterion("TAX_CODE =", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotEqualTo(String value) {
            addCriterion("TAX_CODE <>", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThan(String value) {
            addCriterion("TAX_CODE >", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThanOrEqualTo(String value) {
            addCriterion("TAX_CODE >=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThan(String value) {
            addCriterion("TAX_CODE <", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThanOrEqualTo(String value) {
            addCriterion("TAX_CODE <=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLike(String value) {
            addCriterion("TAX_CODE like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotLike(String value) {
            addCriterion("TAX_CODE not like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIn(List<String> values) {
            addCriterion("TAX_CODE in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotIn(List<String> values) {
            addCriterion("TAX_CODE not in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeBetween(String value1, String value2) {
            addCriterion("TAX_CODE between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotBetween(String value1, String value2) {
            addCriterion("TAX_CODE not between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameIsNull() {
            addCriterion("DEPARTMENT_NAME is null");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameIsNotNull() {
            addCriterion("DEPARTMENT_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameEqualTo(String value) {
            addCriterion("DEPARTMENT_NAME =", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameNotEqualTo(String value) {
            addCriterion("DEPARTMENT_NAME <>", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameGreaterThan(String value) {
            addCriterion("DEPARTMENT_NAME >", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameGreaterThanOrEqualTo(String value) {
            addCriterion("DEPARTMENT_NAME >=", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameLessThan(String value) {
            addCriterion("DEPARTMENT_NAME <", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameLessThanOrEqualTo(String value) {
            addCriterion("DEPARTMENT_NAME <=", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameLike(String value) {
            addCriterion("DEPARTMENT_NAME like", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameNotLike(String value) {
            addCriterion("DEPARTMENT_NAME not like", value, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameIn(List<String> values) {
            addCriterion("DEPARTMENT_NAME in", values, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameNotIn(List<String> values) {
            addCriterion("DEPARTMENT_NAME not in", values, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameBetween(String value1, String value2) {
            addCriterion("DEPARTMENT_NAME between", value1, value2, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentNameNotBetween(String value1, String value2) {
            addCriterion("DEPARTMENT_NAME not between", value1, value2, "departmentName");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdIsNull() {
            addCriterion("DEPARTMENT_ID is null");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdIsNotNull() {
            addCriterion("DEPARTMENT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdEqualTo(String value) {
            addCriterion("DEPARTMENT_ID =", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdNotEqualTo(String value) {
            addCriterion("DEPARTMENT_ID <>", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdGreaterThan(String value) {
            addCriterion("DEPARTMENT_ID >", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdGreaterThanOrEqualTo(String value) {
            addCriterion("DEPARTMENT_ID >=", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdLessThan(String value) {
            addCriterion("DEPARTMENT_ID <", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdLessThanOrEqualTo(String value) {
            addCriterion("DEPARTMENT_ID <=", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdLike(String value) {
            addCriterion("DEPARTMENT_ID like", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdNotLike(String value) {
            addCriterion("DEPARTMENT_ID not like", value, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdIn(List<String> values) {
            addCriterion("DEPARTMENT_ID in", values, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdNotIn(List<String> values) {
            addCriterion("DEPARTMENT_ID not in", values, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdBetween(String value1, String value2) {
            addCriterion("DEPARTMENT_ID between", value1, value2, "departmentId");
            return (Criteria) this;
        }

        public Criteria andDepartmentIdNotBetween(String value1, String value2) {
            addCriterion("DEPARTMENT_ID not between", value1, value2, "departmentId");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityIsNull() {
            addCriterion("RECEIPT_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityIsNotNull() {
            addCriterion("RECEIPT_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityEqualTo(String value) {
            addCriterion("RECEIPT_QUANTITY =", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityNotEqualTo(String value) {
            addCriterion("RECEIPT_QUANTITY <>", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityGreaterThan(String value) {
            addCriterion("RECEIPT_QUANTITY >", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityGreaterThanOrEqualTo(String value) {
            addCriterion("RECEIPT_QUANTITY >=", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityLessThan(String value) {
            addCriterion("RECEIPT_QUANTITY <", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityLessThanOrEqualTo(String value) {
            addCriterion("RECEIPT_QUANTITY <=", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityLike(String value) {
            addCriterion("RECEIPT_QUANTITY like", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityNotLike(String value) {
            addCriterion("RECEIPT_QUANTITY not like", value, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityIn(List<String> values) {
            addCriterion("RECEIPT_QUANTITY in", values, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityNotIn(List<String> values) {
            addCriterion("RECEIPT_QUANTITY not in", values, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityBetween(String value1, String value2) {
            addCriterion("RECEIPT_QUANTITY between", value1, value2, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReceiptQuantityNotBetween(String value1, String value2) {
            addCriterion("RECEIPT_QUANTITY not between", value1, value2, "receiptQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityIsNull() {
            addCriterion("RETURN_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityIsNotNull() {
            addCriterion("RETURN_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityEqualTo(String value) {
            addCriterion("RETURN_QUANTITY =", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityNotEqualTo(String value) {
            addCriterion("RETURN_QUANTITY <>", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityGreaterThan(String value) {
            addCriterion("RETURN_QUANTITY >", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityGreaterThanOrEqualTo(String value) {
            addCriterion("RETURN_QUANTITY >=", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityLessThan(String value) {
            addCriterion("RETURN_QUANTITY <", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityLessThanOrEqualTo(String value) {
            addCriterion("RETURN_QUANTITY <=", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityLike(String value) {
            addCriterion("RETURN_QUANTITY like", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityNotLike(String value) {
            addCriterion("RETURN_QUANTITY not like", value, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityIn(List<String> values) {
            addCriterion("RETURN_QUANTITY in", values, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityNotIn(List<String> values) {
            addCriterion("RETURN_QUANTITY not in", values, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityBetween(String value1, String value2) {
            addCriterion("RETURN_QUANTITY between", value1, value2, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnQuantityNotBetween(String value1, String value2) {
            addCriterion("RETURN_QUANTITY not between", value1, value2, "returnQuantity");
            return (Criteria) this;
        }

        public Criteria andReturnReasonIsNull() {
            addCriterion("RETURN_REASON is null");
            return (Criteria) this;
        }

        public Criteria andReturnReasonIsNotNull() {
            addCriterion("RETURN_REASON is not null");
            return (Criteria) this;
        }

        public Criteria andReturnReasonEqualTo(String value) {
            addCriterion("RETURN_REASON =", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonNotEqualTo(String value) {
            addCriterion("RETURN_REASON <>", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonGreaterThan(String value) {
            addCriterion("RETURN_REASON >", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonGreaterThanOrEqualTo(String value) {
            addCriterion("RETURN_REASON >=", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonLessThan(String value) {
            addCriterion("RETURN_REASON <", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonLessThanOrEqualTo(String value) {
            addCriterion("RETURN_REASON <=", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonLike(String value) {
            addCriterion("RETURN_REASON like", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonNotLike(String value) {
            addCriterion("RETURN_REASON not like", value, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonIn(List<String> values) {
            addCriterion("RETURN_REASON in", values, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonNotIn(List<String> values) {
            addCriterion("RETURN_REASON not in", values, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonBetween(String value1, String value2) {
            addCriterion("RETURN_REASON between", value1, value2, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnReasonNotBetween(String value1, String value2) {
            addCriterion("RETURN_REASON not between", value1, value2, "returnReason");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryIsNull() {
            addCriterion("RETURN_FACTORY is null");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryIsNotNull() {
            addCriterion("RETURN_FACTORY is not null");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryEqualTo(String value) {
            addCriterion("RETURN_FACTORY =", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryNotEqualTo(String value) {
            addCriterion("RETURN_FACTORY <>", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryGreaterThan(String value) {
            addCriterion("RETURN_FACTORY >", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryGreaterThanOrEqualTo(String value) {
            addCriterion("RETURN_FACTORY >=", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryLessThan(String value) {
            addCriterion("RETURN_FACTORY <", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryLessThanOrEqualTo(String value) {
            addCriterion("RETURN_FACTORY <=", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryLike(String value) {
            addCriterion("RETURN_FACTORY like", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryNotLike(String value) {
            addCriterion("RETURN_FACTORY not like", value, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryIn(List<String> values) {
            addCriterion("RETURN_FACTORY in", values, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryNotIn(List<String> values) {
            addCriterion("RETURN_FACTORY not in", values, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryBetween(String value1, String value2) {
            addCriterion("RETURN_FACTORY between", value1, value2, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnFactoryNotBetween(String value1, String value2) {
            addCriterion("RETURN_FACTORY not between", value1, value2, "returnFactory");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseIsNull() {
            addCriterion("RETURN_WAREHOUSE is null");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseIsNotNull() {
            addCriterion("RETURN_WAREHOUSE is not null");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseEqualTo(String value) {
            addCriterion("RETURN_WAREHOUSE =", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseNotEqualTo(String value) {
            addCriterion("RETURN_WAREHOUSE <>", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseGreaterThan(String value) {
            addCriterion("RETURN_WAREHOUSE >", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseGreaterThanOrEqualTo(String value) {
            addCriterion("RETURN_WAREHOUSE >=", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseLessThan(String value) {
            addCriterion("RETURN_WAREHOUSE <", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseLessThanOrEqualTo(String value) {
            addCriterion("RETURN_WAREHOUSE <=", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseLike(String value) {
            addCriterion("RETURN_WAREHOUSE like", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseNotLike(String value) {
            addCriterion("RETURN_WAREHOUSE not like", value, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseIn(List<String> values) {
            addCriterion("RETURN_WAREHOUSE in", values, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseNotIn(List<String> values) {
            addCriterion("RETURN_WAREHOUSE not in", values, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseBetween(String value1, String value2) {
            addCriterion("RETURN_WAREHOUSE between", value1, value2, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andReturnWarehouseNotBetween(String value1, String value2) {
            addCriterion("RETURN_WAREHOUSE not between", value1, value2, "returnWarehouse");
            return (Criteria) this;
        }

        public Criteria andPackQuantityIsNull() {
            addCriterion("PACK_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andPackQuantityIsNotNull() {
            addCriterion("PACK_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andPackQuantityEqualTo(String value) {
            addCriterion("PACK_QUANTITY =", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityNotEqualTo(String value) {
            addCriterion("PACK_QUANTITY <>", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityGreaterThan(String value) {
            addCriterion("PACK_QUANTITY >", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityGreaterThanOrEqualTo(String value) {
            addCriterion("PACK_QUANTITY >=", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityLessThan(String value) {
            addCriterion("PACK_QUANTITY <", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityLessThanOrEqualTo(String value) {
            addCriterion("PACK_QUANTITY <=", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityLike(String value) {
            addCriterion("PACK_QUANTITY like", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityNotLike(String value) {
            addCriterion("PACK_QUANTITY not like", value, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityIn(List<String> values) {
            addCriterion("PACK_QUANTITY in", values, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityNotIn(List<String> values) {
            addCriterion("PACK_QUANTITY not in", values, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityBetween(String value1, String value2) {
            addCriterion("PACK_QUANTITY between", value1, value2, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andPackQuantityNotBetween(String value1, String value2) {
            addCriterion("PACK_QUANTITY not between", value1, value2, "packQuantity");
            return (Criteria) this;
        }

        public Criteria andExchangeRateIsNull() {
            addCriterion("EXCHANGE_RATE is null");
            return (Criteria) this;
        }

        public Criteria andExchangeRateIsNotNull() {
            addCriterion("EXCHANGE_RATE is not null");
            return (Criteria) this;
        }

        public Criteria andExchangeRateEqualTo(String value) {
            addCriterion("EXCHANGE_RATE =", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateNotEqualTo(String value) {
            addCriterion("EXCHANGE_RATE <>", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateGreaterThan(String value) {
            addCriterion("EXCHANGE_RATE >", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateGreaterThanOrEqualTo(String value) {
            addCriterion("EXCHANGE_RATE >=", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateLessThan(String value) {
            addCriterion("EXCHANGE_RATE <", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateLessThanOrEqualTo(String value) {
            addCriterion("EXCHANGE_RATE <=", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateLike(String value) {
            addCriterion("EXCHANGE_RATE like", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateNotLike(String value) {
            addCriterion("EXCHANGE_RATE not like", value, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateIn(List<String> values) {
            addCriterion("EXCHANGE_RATE in", values, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateNotIn(List<String> values) {
            addCriterion("EXCHANGE_RATE not in", values, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateBetween(String value1, String value2) {
            addCriterion("EXCHANGE_RATE between", value1, value2, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andExchangeRateNotBetween(String value1, String value2) {
            addCriterion("EXCHANGE_RATE not between", value1, value2, "exchangeRate");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeIsNull() {
            addCriterion("FACTORY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeIsNotNull() {
            addCriterion("FACTORY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeEqualTo(String value) {
            addCriterion("FACTORY_CODE =", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotEqualTo(String value) {
            addCriterion("FACTORY_CODE <>", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeGreaterThan(String value) {
            addCriterion("FACTORY_CODE >", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeGreaterThanOrEqualTo(String value) {
            addCriterion("FACTORY_CODE >=", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeLessThan(String value) {
            addCriterion("FACTORY_CODE <", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeLessThanOrEqualTo(String value) {
            addCriterion("FACTORY_CODE <=", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeLike(String value) {
            addCriterion("FACTORY_CODE like", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotLike(String value) {
            addCriterion("FACTORY_CODE not like", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeIn(List<String> values) {
            addCriterion("FACTORY_CODE in", values, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotIn(List<String> values) {
            addCriterion("FACTORY_CODE not in", values, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeBetween(String value1, String value2) {
            addCriterion("FACTORY_CODE between", value1, value2, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotBetween(String value1, String value2) {
            addCriterion("FACTORY_CODE not between", value1, value2, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryNameIsNull() {
            addCriterion("FACTORY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andFactoryNameIsNotNull() {
            addCriterion("FACTORY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andFactoryNameEqualTo(String value) {
            addCriterion("FACTORY_NAME =", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameNotEqualTo(String value) {
            addCriterion("FACTORY_NAME <>", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameGreaterThan(String value) {
            addCriterion("FACTORY_NAME >", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameGreaterThanOrEqualTo(String value) {
            addCriterion("FACTORY_NAME >=", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameLessThan(String value) {
            addCriterion("FACTORY_NAME <", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameLessThanOrEqualTo(String value) {
            addCriterion("FACTORY_NAME <=", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameLike(String value) {
            addCriterion("FACTORY_NAME like", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameNotLike(String value) {
            addCriterion("FACTORY_NAME not like", value, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameIn(List<String> values) {
            addCriterion("FACTORY_NAME in", values, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameNotIn(List<String> values) {
            addCriterion("FACTORY_NAME not in", values, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameBetween(String value1, String value2) {
            addCriterion("FACTORY_NAME between", value1, value2, "factoryName");
            return (Criteria) this;
        }

        public Criteria andFactoryNameNotBetween(String value1, String value2) {
            addCriterion("FACTORY_NAME not between", value1, value2, "factoryName");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeIsNull() {
            addCriterion("WAREHOUSE_CODE is null");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeIsNotNull() {
            addCriterion("WAREHOUSE_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeEqualTo(String value) {
            addCriterion("WAREHOUSE_CODE =", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeNotEqualTo(String value) {
            addCriterion("WAREHOUSE_CODE <>", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeGreaterThan(String value) {
            addCriterion("WAREHOUSE_CODE >", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeGreaterThanOrEqualTo(String value) {
            addCriterion("WAREHOUSE_CODE >=", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeLessThan(String value) {
            addCriterion("WAREHOUSE_CODE <", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeLessThanOrEqualTo(String value) {
            addCriterion("WAREHOUSE_CODE <=", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeLike(String value) {
            addCriterion("WAREHOUSE_CODE like", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeNotLike(String value) {
            addCriterion("WAREHOUSE_CODE not like", value, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeIn(List<String> values) {
            addCriterion("WAREHOUSE_CODE in", values, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeNotIn(List<String> values) {
            addCriterion("WAREHOUSE_CODE not in", values, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeBetween(String value1, String value2) {
            addCriterion("WAREHOUSE_CODE between", value1, value2, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseCodeNotBetween(String value1, String value2) {
            addCriterion("WAREHOUSE_CODE not between", value1, value2, "warehouseCode");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameIsNull() {
            addCriterion("WAREHOUSE_NAME is null");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameIsNotNull() {
            addCriterion("WAREHOUSE_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameEqualTo(String value) {
            addCriterion("WAREHOUSE_NAME =", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameNotEqualTo(String value) {
            addCriterion("WAREHOUSE_NAME <>", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameGreaterThan(String value) {
            addCriterion("WAREHOUSE_NAME >", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameGreaterThanOrEqualTo(String value) {
            addCriterion("WAREHOUSE_NAME >=", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameLessThan(String value) {
            addCriterion("WAREHOUSE_NAME <", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameLessThanOrEqualTo(String value) {
            addCriterion("WAREHOUSE_NAME <=", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameLike(String value) {
            addCriterion("WAREHOUSE_NAME like", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameNotLike(String value) {
            addCriterion("WAREHOUSE_NAME not like", value, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameIn(List<String> values) {
            addCriterion("WAREHOUSE_NAME in", values, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameNotIn(List<String> values) {
            addCriterion("WAREHOUSE_NAME not in", values, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameBetween(String value1, String value2) {
            addCriterion("WAREHOUSE_NAME between", value1, value2, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andWarehouseNameNotBetween(String value1, String value2) {
            addCriterion("WAREHOUSE_NAME not between", value1, value2, "warehouseName");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationIsNull() {
            addCriterion("IS_RECONCILIATION is null");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationIsNotNull() {
            addCriterion("IS_RECONCILIATION is not null");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationEqualTo(String value) {
            addCriterion("IS_RECONCILIATION =", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationNotEqualTo(String value) {
            addCriterion("IS_RECONCILIATION <>", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationGreaterThan(String value) {
            addCriterion("IS_RECONCILIATION >", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationGreaterThanOrEqualTo(String value) {
            addCriterion("IS_RECONCILIATION >=", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationLessThan(String value) {
            addCriterion("IS_RECONCILIATION <", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationLessThanOrEqualTo(String value) {
            addCriterion("IS_RECONCILIATION <=", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationLike(String value) {
            addCriterion("IS_RECONCILIATION like", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationNotLike(String value) {
            addCriterion("IS_RECONCILIATION not like", value, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationIn(List<String> values) {
            addCriterion("IS_RECONCILIATION in", values, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationNotIn(List<String> values) {
            addCriterion("IS_RECONCILIATION not in", values, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationBetween(String value1, String value2) {
            addCriterion("IS_RECONCILIATION between", value1, value2, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andIsReconciliationNotBetween(String value1, String value2) {
            addCriterion("IS_RECONCILIATION not between", value1, value2, "isReconciliation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationIsNull() {
            addCriterion("DELIVERY_LOCATION is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationIsNotNull() {
            addCriterion("DELIVERY_LOCATION is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationEqualTo(String value) {
            addCriterion("DELIVERY_LOCATION =", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationNotEqualTo(String value) {
            addCriterion("DELIVERY_LOCATION <>", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationGreaterThan(String value) {
            addCriterion("DELIVERY_LOCATION >", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_LOCATION >=", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationLessThan(String value) {
            addCriterion("DELIVERY_LOCATION <", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_LOCATION <=", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationLike(String value) {
            addCriterion("DELIVERY_LOCATION like", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationNotLike(String value) {
            addCriterion("DELIVERY_LOCATION not like", value, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationIn(List<String> values) {
            addCriterion("DELIVERY_LOCATION in", values, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationNotIn(List<String> values) {
            addCriterion("DELIVERY_LOCATION not in", values, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationBetween(String value1, String value2) {
            addCriterion("DELIVERY_LOCATION between", value1, value2, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andDeliveryLocationNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_LOCATION not between", value1, value2, "deliveryLocation");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntIsNull() {
            addCriterion("SUPPLIER_MATERIAL_INT is null");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntIsNotNull() {
            addCriterion("SUPPLIER_MATERIAL_INT is not null");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT =", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntNotEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT <>", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntGreaterThan(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT >", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntGreaterThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT >=", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntLessThan(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT <", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntLessThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT <=", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntLike(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT like", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntNotLike(String value) {
            addCriterion("SUPPLIER_MATERIAL_INT not like", value, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntIn(List<String> values) {
            addCriterion("SUPPLIER_MATERIAL_INT in", values, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntNotIn(List<String> values) {
            addCriterion("SUPPLIER_MATERIAL_INT not in", values, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntBetween(String value1, String value2) {
            addCriterion("SUPPLIER_MATERIAL_INT between", value1, value2, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialIntNotBetween(String value1, String value2) {
            addCriterion("SUPPLIER_MATERIAL_INT not between", value1, value2, "supplierMaterialInt");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNull() {
            addCriterion("PROJECT_ID is null");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNotNull() {
            addCriterion("PROJECT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProjectIdEqualTo(String value) {
            addCriterion("PROJECT_ID =", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotEqualTo(String value) {
            addCriterion("PROJECT_ID <>", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThan(String value) {
            addCriterion("PROJECT_ID >", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID >=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThan(String value) {
            addCriterion("PROJECT_ID <", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID <=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLike(String value) {
            addCriterion("PROJECT_ID like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotLike(String value) {
            addCriterion("PROJECT_ID not like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIn(List<String> values) {
            addCriterion("PROJECT_ID in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotIn(List<String> values) {
            addCriterion("PROJECT_ID not in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdBetween(String value1, String value2) {
            addCriterion("PROJECT_ID between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotBetween(String value1, String value2) {
            addCriterion("PROJECT_ID not between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdIsNull() {
            addCriterion("COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andCompanyIdIsNotNull() {
            addCriterion("COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyIdEqualTo(String value) {
            addCriterion("COMPANY_ID =", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotEqualTo(String value) {
            addCriterion("COMPANY_ID <>", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdGreaterThan(String value) {
            addCriterion("COMPANY_ID >", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_ID >=", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdLessThan(String value) {
            addCriterion("COMPANY_ID <", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_ID <=", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdLike(String value) {
            addCriterion("COMPANY_ID like", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotLike(String value) {
            addCriterion("COMPANY_ID not like", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdIn(List<String> values) {
            addCriterion("COMPANY_ID in", values, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotIn(List<String> values) {
            addCriterion("COMPANY_ID not in", values, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdBetween(String value1, String value2) {
            addCriterion("COMPANY_ID between", value1, value2, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotBetween(String value1, String value2) {
            addCriterion("COMPANY_ID not between", value1, value2, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIsNull() {
            addCriterion("COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIsNotNull() {
            addCriterion("COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyNameEqualTo(String value) {
            addCriterion("COMPANY_NAME =", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotEqualTo(String value) {
            addCriterion("COMPANY_NAME <>", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameGreaterThan(String value) {
            addCriterion("COMPANY_NAME >", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_NAME >=", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLessThan(String value) {
            addCriterion("COMPANY_NAME <", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_NAME <=", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLike(String value) {
            addCriterion("COMPANY_NAME like", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotLike(String value) {
            addCriterion("COMPANY_NAME not like", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIn(List<String> values) {
            addCriterion("COMPANY_NAME in", values, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotIn(List<String> values) {
            addCriterion("COMPANY_NAME not in", values, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameBetween(String value1, String value2) {
            addCriterion("COMPANY_NAME between", value1, value2, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotBetween(String value1, String value2) {
            addCriterion("COMPANY_NAME not between", value1, value2, "companyName");
            return (Criteria) this;
        }

        public Criteria andUserIdIsNull() {
            addCriterion("USER_ID is null");
            return (Criteria) this;
        }

        public Criteria andUserIdIsNotNull() {
            addCriterion("USER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andUserIdEqualTo(String value) {
            addCriterion("USER_ID =", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdNotEqualTo(String value) {
            addCriterion("USER_ID <>", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdGreaterThan(String value) {
            addCriterion("USER_ID >", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdGreaterThanOrEqualTo(String value) {
            addCriterion("USER_ID >=", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdLessThan(String value) {
            addCriterion("USER_ID <", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdLessThanOrEqualTo(String value) {
            addCriterion("USER_ID <=", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdLike(String value) {
            addCriterion("USER_ID like", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdNotLike(String value) {
            addCriterion("USER_ID not like", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdIn(List<String> values) {
            addCriterion("USER_ID in", values, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdNotIn(List<String> values) {
            addCriterion("USER_ID not in", values, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdBetween(String value1, String value2) {
            addCriterion("USER_ID between", value1, value2, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdNotBetween(String value1, String value2) {
            addCriterion("USER_ID not between", value1, value2, "userId");
            return (Criteria) this;
        }

        public Criteria andUserNameIsNull() {
            addCriterion("USER_NAME is null");
            return (Criteria) this;
        }

        public Criteria andUserNameIsNotNull() {
            addCriterion("USER_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andUserNameEqualTo(String value) {
            addCriterion("USER_NAME =", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameNotEqualTo(String value) {
            addCriterion("USER_NAME <>", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameGreaterThan(String value) {
            addCriterion("USER_NAME >", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameGreaterThanOrEqualTo(String value) {
            addCriterion("USER_NAME >=", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameLessThan(String value) {
            addCriterion("USER_NAME <", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameLessThanOrEqualTo(String value) {
            addCriterion("USER_NAME <=", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameLike(String value) {
            addCriterion("USER_NAME like", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameNotLike(String value) {
            addCriterion("USER_NAME not like", value, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameIn(List<String> values) {
            addCriterion("USER_NAME in", values, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameNotIn(List<String> values) {
            addCriterion("USER_NAME not in", values, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameBetween(String value1, String value2) {
            addCriterion("USER_NAME between", value1, value2, "userName");
            return (Criteria) this;
        }

        public Criteria andUserNameNotBetween(String value1, String value2) {
            addCriterion("USER_NAME not between", value1, value2, "userName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNull() {
            addCriterion("PUR_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNotNull() {
            addCriterion("PUR_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID =", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <>", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThan(String value) {
            addCriterion("PUR_COMPANY_ID >", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID >=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThan(String value) {
            addCriterion("PUR_COMPANY_ID <", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLike(String value) {
            addCriterion("PUR_COMPANY_ID like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotLike(String value) {
            addCriterion("PUR_COMPANY_ID not like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID not in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID not between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNull() {
            addCriterion("PUR_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNotNull() {
            addCriterion("PUR_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME =", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <>", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThan(String value) {
            addCriterion("PUR_COMPANY_NAME >", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME >=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThan(String value) {
            addCriterion("PUR_COMPANY_NAME <", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLike(String value) {
            addCriterion("PUR_COMPANY_NAME like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotLike(String value) {
            addCriterion("PUR_COMPANY_NAME not like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME not in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME not between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurUserIdIsNull() {
            addCriterion("PUR_USER_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurUserIdIsNotNull() {
            addCriterion("PUR_USER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurUserIdEqualTo(String value) {
            addCriterion("PUR_USER_ID =", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdNotEqualTo(String value) {
            addCriterion("PUR_USER_ID <>", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdGreaterThan(String value) {
            addCriterion("PUR_USER_ID >", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_USER_ID >=", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdLessThan(String value) {
            addCriterion("PUR_USER_ID <", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_USER_ID <=", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdLike(String value) {
            addCriterion("PUR_USER_ID like", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdNotLike(String value) {
            addCriterion("PUR_USER_ID not like", value, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdIn(List<String> values) {
            addCriterion("PUR_USER_ID in", values, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdNotIn(List<String> values) {
            addCriterion("PUR_USER_ID not in", values, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdBetween(String value1, String value2) {
            addCriterion("PUR_USER_ID between", value1, value2, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserIdNotBetween(String value1, String value2) {
            addCriterion("PUR_USER_ID not between", value1, value2, "purUserId");
            return (Criteria) this;
        }

        public Criteria andPurUserNameIsNull() {
            addCriterion("PUR_USER_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurUserNameIsNotNull() {
            addCriterion("PUR_USER_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurUserNameEqualTo(String value) {
            addCriterion("PUR_USER_NAME =", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameNotEqualTo(String value) {
            addCriterion("PUR_USER_NAME <>", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameGreaterThan(String value) {
            addCriterion("PUR_USER_NAME >", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_USER_NAME >=", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameLessThan(String value) {
            addCriterion("PUR_USER_NAME <", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_USER_NAME <=", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameLike(String value) {
            addCriterion("PUR_USER_NAME like", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameNotLike(String value) {
            addCriterion("PUR_USER_NAME not like", value, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameIn(List<String> values) {
            addCriterion("PUR_USER_NAME in", values, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameNotIn(List<String> values) {
            addCriterion("PUR_USER_NAME not in", values, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameBetween(String value1, String value2) {
            addCriterion("PUR_USER_NAME between", value1, value2, "purUserName");
            return (Criteria) this;
        }

        public Criteria andPurUserNameNotBetween(String value1, String value2) {
            addCriterion("PUR_USER_NAME not between", value1, value2, "purUserName");
            return (Criteria) this;
        }

        public Criteria andGateScanIsNull() {
            addCriterion("GATE_SCAN is null");
            return (Criteria) this;
        }

        public Criteria andGateScanIsNotNull() {
            addCriterion("GATE_SCAN is not null");
            return (Criteria) this;
        }

        public Criteria andGateScanEqualTo(String value) {
            addCriterion("GATE_SCAN =", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanNotEqualTo(String value) {
            addCriterion("GATE_SCAN <>", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanGreaterThan(String value) {
            addCriterion("GATE_SCAN >", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanGreaterThanOrEqualTo(String value) {
            addCriterion("GATE_SCAN >=", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanLessThan(String value) {
            addCriterion("GATE_SCAN <", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanLessThanOrEqualTo(String value) {
            addCriterion("GATE_SCAN <=", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanLike(String value) {
            addCriterion("GATE_SCAN like", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanNotLike(String value) {
            addCriterion("GATE_SCAN not like", value, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanIn(List<String> values) {
            addCriterion("GATE_SCAN in", values, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanNotIn(List<String> values) {
            addCriterion("GATE_SCAN not in", values, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanBetween(String value1, String value2) {
            addCriterion("GATE_SCAN between", value1, value2, "gateScan");
            return (Criteria) this;
        }

        public Criteria andGateScanNotBetween(String value1, String value2) {
            addCriterion("GATE_SCAN not between", value1, value2, "gateScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanIsNull() {
            addCriterion("WAREHOUSE_SCAN is null");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanIsNotNull() {
            addCriterion("WAREHOUSE_SCAN is not null");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanEqualTo(String value) {
            addCriterion("WAREHOUSE_SCAN =", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanNotEqualTo(String value) {
            addCriterion("WAREHOUSE_SCAN <>", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanGreaterThan(String value) {
            addCriterion("WAREHOUSE_SCAN >", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanGreaterThanOrEqualTo(String value) {
            addCriterion("WAREHOUSE_SCAN >=", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanLessThan(String value) {
            addCriterion("WAREHOUSE_SCAN <", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanLessThanOrEqualTo(String value) {
            addCriterion("WAREHOUSE_SCAN <=", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanLike(String value) {
            addCriterion("WAREHOUSE_SCAN like", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanNotLike(String value) {
            addCriterion("WAREHOUSE_SCAN not like", value, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanIn(List<String> values) {
            addCriterion("WAREHOUSE_SCAN in", values, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanNotIn(List<String> values) {
            addCriterion("WAREHOUSE_SCAN not in", values, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanBetween(String value1, String value2) {
            addCriterion("WAREHOUSE_SCAN between", value1, value2, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andWarehouseScanNotBetween(String value1, String value2) {
            addCriterion("WAREHOUSE_SCAN not between", value1, value2, "warehouseScan");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeIsNull() {
            addCriterion("PUR_COMPANY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeIsNotNull() {
            addCriterion("PUR_COMPANY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeEqualTo(String value) {
            addCriterion("PUR_COMPANY_CODE =", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_CODE <>", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeGreaterThan(String value) {
            addCriterion("PUR_COMPANY_CODE >", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_CODE >=", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeLessThan(String value) {
            addCriterion("PUR_COMPANY_CODE <", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_CODE <=", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeLike(String value) {
            addCriterion("PUR_COMPANY_CODE like", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeNotLike(String value) {
            addCriterion("PUR_COMPANY_CODE not like", value, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeIn(List<String> values) {
            addCriterion("PUR_COMPANY_CODE in", values, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_CODE not in", values, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_CODE between", value1, value2, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyCodeNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_CODE not between", value1, value2, "purCompanyCode");
            return (Criteria) this;
        }

        public Criteria andChineseNameIsNull() {
            addCriterion("CHINESE_NAME is null");
            return (Criteria) this;
        }

        public Criteria andChineseNameIsNotNull() {
            addCriterion("CHINESE_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andChineseNameEqualTo(String value) {
            addCriterion("CHINESE_NAME =", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameNotEqualTo(String value) {
            addCriterion("CHINESE_NAME <>", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameGreaterThan(String value) {
            addCriterion("CHINESE_NAME >", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameGreaterThanOrEqualTo(String value) {
            addCriterion("CHINESE_NAME >=", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameLessThan(String value) {
            addCriterion("CHINESE_NAME <", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameLessThanOrEqualTo(String value) {
            addCriterion("CHINESE_NAME <=", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameLike(String value) {
            addCriterion("CHINESE_NAME like", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameNotLike(String value) {
            addCriterion("CHINESE_NAME not like", value, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameIn(List<String> values) {
            addCriterion("CHINESE_NAME in", values, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameNotIn(List<String> values) {
            addCriterion("CHINESE_NAME not in", values, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameBetween(String value1, String value2) {
            addCriterion("CHINESE_NAME between", value1, value2, "chineseName");
            return (Criteria) this;
        }

        public Criteria andChineseNameNotBetween(String value1, String value2) {
            addCriterion("CHINESE_NAME not between", value1, value2, "chineseName");
            return (Criteria) this;
        }

        public Criteria andModelIsNull() {
            addCriterion("MODEL is null");
            return (Criteria) this;
        }

        public Criteria andModelIsNotNull() {
            addCriterion("MODEL is not null");
            return (Criteria) this;
        }

        public Criteria andModelEqualTo(String value) {
            addCriterion("MODEL =", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelNotEqualTo(String value) {
            addCriterion("MODEL <>", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelGreaterThan(String value) {
            addCriterion("MODEL >", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelGreaterThanOrEqualTo(String value) {
            addCriterion("MODEL >=", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelLessThan(String value) {
            addCriterion("MODEL <", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelLessThanOrEqualTo(String value) {
            addCriterion("MODEL <=", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelLike(String value) {
            addCriterion("MODEL like", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelNotLike(String value) {
            addCriterion("MODEL not like", value, "model");
            return (Criteria) this;
        }

        public Criteria andModelIn(List<String> values) {
            addCriterion("MODEL in", values, "model");
            return (Criteria) this;
        }

        public Criteria andModelNotIn(List<String> values) {
            addCriterion("MODEL not in", values, "model");
            return (Criteria) this;
        }

        public Criteria andModelBetween(String value1, String value2) {
            addCriterion("MODEL between", value1, value2, "model");
            return (Criteria) this;
        }

        public Criteria andModelNotBetween(String value1, String value2) {
            addCriterion("MODEL not between", value1, value2, "model");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNull() {
            addCriterion("REMARK is null");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNotNull() {
            addCriterion("REMARK is not null");
            return (Criteria) this;
        }

        public Criteria andRemarkEqualTo(String value) {
            addCriterion("REMARK =", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotEqualTo(String value) {
            addCriterion("REMARK <>", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThan(String value) {
            addCriterion("REMARK >", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThanOrEqualTo(String value) {
            addCriterion("REMARK >=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThan(String value) {
            addCriterion("REMARK <", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThanOrEqualTo(String value) {
            addCriterion("REMARK <=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLike(String value) {
            addCriterion("REMARK like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotLike(String value) {
            addCriterion("REMARK not like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkIn(List<String> values) {
            addCriterion("REMARK in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotIn(List<String> values) {
            addCriterion("REMARK not in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkBetween(String value1, String value2) {
            addCriterion("REMARK between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotBetween(String value1, String value2) {
            addCriterion("REMARK not between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andTypeIsNull() {
            addCriterion("TYPE is null");
            return (Criteria) this;
        }

        public Criteria andTypeIsNotNull() {
            addCriterion("TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andTypeEqualTo(String value) {
            addCriterion("TYPE =", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotEqualTo(String value) {
            addCriterion("TYPE <>", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThan(String value) {
            addCriterion("TYPE >", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThanOrEqualTo(String value) {
            addCriterion("TYPE >=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThan(String value) {
            addCriterion("TYPE <", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThanOrEqualTo(String value) {
            addCriterion("TYPE <=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLike(String value) {
            addCriterion("TYPE like", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotLike(String value) {
            addCriterion("TYPE not like", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeIn(List<String> values) {
            addCriterion("TYPE in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotIn(List<String> values) {
            addCriterion("TYPE not in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeBetween(String value1, String value2) {
            addCriterion("TYPE between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotBetween(String value1, String value2) {
            addCriterion("TYPE not between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andSingleWeightIsNull() {
            addCriterion("SINGLE_WEIGHT is null");
            return (Criteria) this;
        }

        public Criteria andSingleWeightIsNotNull() {
            addCriterion("SINGLE_WEIGHT is not null");
            return (Criteria) this;
        }

        public Criteria andSingleWeightEqualTo(BigDecimal value) {
            addCriterion("SINGLE_WEIGHT =", value, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightNotEqualTo(BigDecimal value) {
            addCriterion("SINGLE_WEIGHT <>", value, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightGreaterThan(BigDecimal value) {
            addCriterion("SINGLE_WEIGHT >", value, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("SINGLE_WEIGHT >=", value, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightLessThan(BigDecimal value) {
            addCriterion("SINGLE_WEIGHT <", value, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightLessThanOrEqualTo(BigDecimal value) {
            addCriterion("SINGLE_WEIGHT <=", value, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightIn(List<BigDecimal> values) {
            addCriterion("SINGLE_WEIGHT in", values, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightNotIn(List<BigDecimal> values) {
            addCriterion("SINGLE_WEIGHT not in", values, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("SINGLE_WEIGHT between", value1, value2, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andSingleWeightNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("SINGLE_WEIGHT not between", value1, value2, "singleWeight");
            return (Criteria) this;
        }

        public Criteria andBrandIsNull() {
            addCriterion("BRAND is null");
            return (Criteria) this;
        }

        public Criteria andBrandIsNotNull() {
            addCriterion("BRAND is not null");
            return (Criteria) this;
        }

        public Criteria andBrandEqualTo(String value) {
            addCriterion("BRAND =", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandNotEqualTo(String value) {
            addCriterion("BRAND <>", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandGreaterThan(String value) {
            addCriterion("BRAND >", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandGreaterThanOrEqualTo(String value) {
            addCriterion("BRAND >=", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandLessThan(String value) {
            addCriterion("BRAND <", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandLessThanOrEqualTo(String value) {
            addCriterion("BRAND <=", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandLike(String value) {
            addCriterion("BRAND like", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandNotLike(String value) {
            addCriterion("BRAND not like", value, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandIn(List<String> values) {
            addCriterion("BRAND in", values, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandNotIn(List<String> values) {
            addCriterion("BRAND not in", values, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandBetween(String value1, String value2) {
            addCriterion("BRAND between", value1, value2, "brand");
            return (Criteria) this;
        }

        public Criteria andBrandNotBetween(String value1, String value2) {
            addCriterion("BRAND not between", value1, value2, "brand");
            return (Criteria) this;
        }

        public Criteria andSourceAreaIsNull() {
            addCriterion("SOURCE_AREA is null");
            return (Criteria) this;
        }

        public Criteria andSourceAreaIsNotNull() {
            addCriterion("SOURCE_AREA is not null");
            return (Criteria) this;
        }

        public Criteria andSourceAreaEqualTo(String value) {
            addCriterion("SOURCE_AREA =", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaNotEqualTo(String value) {
            addCriterion("SOURCE_AREA <>", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaGreaterThan(String value) {
            addCriterion("SOURCE_AREA >", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaGreaterThanOrEqualTo(String value) {
            addCriterion("SOURCE_AREA >=", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaLessThan(String value) {
            addCriterion("SOURCE_AREA <", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaLessThanOrEqualTo(String value) {
            addCriterion("SOURCE_AREA <=", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaLike(String value) {
            addCriterion("SOURCE_AREA like", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaNotLike(String value) {
            addCriterion("SOURCE_AREA not like", value, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaIn(List<String> values) {
            addCriterion("SOURCE_AREA in", values, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaNotIn(List<String> values) {
            addCriterion("SOURCE_AREA not in", values, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaBetween(String value1, String value2) {
            addCriterion("SOURCE_AREA between", value1, value2, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andSourceAreaNotBetween(String value1, String value2) {
            addCriterion("SOURCE_AREA not between", value1, value2, "sourceArea");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightIsNull() {
            addCriterion("TOTAL_NET_WEIGHT is null");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightIsNotNull() {
            addCriterion("TOTAL_NET_WEIGHT is not null");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightEqualTo(BigDecimal value) {
            addCriterion("TOTAL_NET_WEIGHT =", value, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightNotEqualTo(BigDecimal value) {
            addCriterion("TOTAL_NET_WEIGHT <>", value, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightGreaterThan(BigDecimal value) {
            addCriterion("TOTAL_NET_WEIGHT >", value, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_NET_WEIGHT >=", value, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightLessThan(BigDecimal value) {
            addCriterion("TOTAL_NET_WEIGHT <", value, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_NET_WEIGHT <=", value, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightIn(List<BigDecimal> values) {
            addCriterion("TOTAL_NET_WEIGHT in", values, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightNotIn(List<BigDecimal> values) {
            addCriterion("TOTAL_NET_WEIGHT not in", values, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_NET_WEIGHT between", value1, value2, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalNetWeightNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_NET_WEIGHT not between", value1, value2, "totalNetWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightIsNull() {
            addCriterion("TOTAL_GROSS_WEIGHT is null");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightIsNotNull() {
            addCriterion("TOTAL_GROSS_WEIGHT is not null");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightEqualTo(BigDecimal value) {
            addCriterion("TOTAL_GROSS_WEIGHT =", value, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightNotEqualTo(BigDecimal value) {
            addCriterion("TOTAL_GROSS_WEIGHT <>", value, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightGreaterThan(BigDecimal value) {
            addCriterion("TOTAL_GROSS_WEIGHT >", value, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_GROSS_WEIGHT >=", value, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightLessThan(BigDecimal value) {
            addCriterion("TOTAL_GROSS_WEIGHT <", value, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_GROSS_WEIGHT <=", value, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightIn(List<BigDecimal> values) {
            addCriterion("TOTAL_GROSS_WEIGHT in", values, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightNotIn(List<BigDecimal> values) {
            addCriterion("TOTAL_GROSS_WEIGHT not in", values, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_GROSS_WEIGHT between", value1, value2, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andTotalGrossWeightNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_GROSS_WEIGHT not between", value1, value2, "totalGrossWeight");
            return (Criteria) this;
        }

        public Criteria andCaseNoIsNull() {
            addCriterion("CASE_NO is null");
            return (Criteria) this;
        }

        public Criteria andCaseNoIsNotNull() {
            addCriterion("CASE_NO is not null");
            return (Criteria) this;
        }

        public Criteria andCaseNoEqualTo(String value) {
            addCriterion("CASE_NO =", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoNotEqualTo(String value) {
            addCriterion("CASE_NO <>", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoGreaterThan(String value) {
            addCriterion("CASE_NO >", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoGreaterThanOrEqualTo(String value) {
            addCriterion("CASE_NO >=", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoLessThan(String value) {
            addCriterion("CASE_NO <", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoLessThanOrEqualTo(String value) {
            addCriterion("CASE_NO <=", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoLike(String value) {
            addCriterion("CASE_NO like", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoNotLike(String value) {
            addCriterion("CASE_NO not like", value, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoIn(List<String> values) {
            addCriterion("CASE_NO in", values, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoNotIn(List<String> values) {
            addCriterion("CASE_NO not in", values, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoBetween(String value1, String value2) {
            addCriterion("CASE_NO between", value1, value2, "caseNo");
            return (Criteria) this;
        }

        public Criteria andCaseNoNotBetween(String value1, String value2) {
            addCriterion("CASE_NO not between", value1, value2, "caseNo");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeIsNull() {
            addCriterion("SAP_PUR_COMPANY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeIsNotNull() {
            addCriterion("SAP_PUR_COMPANY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeEqualTo(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE =", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeNotEqualTo(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE <>", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeGreaterThan(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE >", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE >=", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeLessThan(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE <", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeLessThanOrEqualTo(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE <=", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeLike(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE like", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeNotLike(String value) {
            addCriterion("SAP_PUR_COMPANY_CODE not like", value, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeIn(List<String> values) {
            addCriterion("SAP_PUR_COMPANY_CODE in", values, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeNotIn(List<String> values) {
            addCriterion("SAP_PUR_COMPANY_CODE not in", values, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeBetween(String value1, String value2) {
            addCriterion("SAP_PUR_COMPANY_CODE between", value1, value2, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andSapPurCompanyCodeNotBetween(String value1, String value2) {
            addCriterion("SAP_PUR_COMPANY_CODE not between", value1, value2, "sapPurCompanyCode");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameIsNull() {
            addCriterion("DELIVERY_MATERIAL_NAME is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameIsNotNull() {
            addCriterion("DELIVERY_MATERIAL_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameEqualTo(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME =", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameNotEqualTo(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME <>", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameGreaterThan(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME >", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME >=", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameLessThan(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME <", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME <=", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameLike(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME like", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameNotLike(String value) {
            addCriterion("DELIVERY_MATERIAL_NAME not like", value, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameIn(List<String> values) {
            addCriterion("DELIVERY_MATERIAL_NAME in", values, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameNotIn(List<String> values) {
            addCriterion("DELIVERY_MATERIAL_NAME not in", values, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameBetween(String value1, String value2) {
            addCriterion("DELIVERY_MATERIAL_NAME between", value1, value2, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andDeliveryMaterialNameNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_MATERIAL_NAME not between", value1, value2, "deliveryMaterialName");
            return (Criteria) this;
        }

        public Criteria andPalletIntIsNull() {
            addCriterion("PALLET_INT is null");
            return (Criteria) this;
        }

        public Criteria andPalletIntIsNotNull() {
            addCriterion("PALLET_INT is not null");
            return (Criteria) this;
        }

        public Criteria andPalletIntEqualTo(String value) {
            addCriterion("PALLET_INT =", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntNotEqualTo(String value) {
            addCriterion("PALLET_INT <>", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntGreaterThan(String value) {
            addCriterion("PALLET_INT >", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntGreaterThanOrEqualTo(String value) {
            addCriterion("PALLET_INT >=", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntLessThan(String value) {
            addCriterion("PALLET_INT <", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntLessThanOrEqualTo(String value) {
            addCriterion("PALLET_INT <=", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntLike(String value) {
            addCriterion("PALLET_INT like", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntNotLike(String value) {
            addCriterion("PALLET_INT not like", value, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntIn(List<String> values) {
            addCriterion("PALLET_INT in", values, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntNotIn(List<String> values) {
            addCriterion("PALLET_INT not in", values, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntBetween(String value1, String value2) {
            addCriterion("PALLET_INT between", value1, value2, "palletInt");
            return (Criteria) this;
        }

        public Criteria andPalletIntNotBetween(String value1, String value2) {
            addCriterion("PALLET_INT not between", value1, value2, "palletInt");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusIsNull() {
            addCriterion("MDELIVERY_STATUS is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusIsNotNull() {
            addCriterion("MDELIVERY_STATUS is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusLike(String value) {
            addCriterion("MDELIVERY_STATUS like", value, "deliveryStatus");
            return (Criteria) this;
        }


        public Criteria andDeliveryStatusEqualTo(String value) {
            addCriterion("MDELIVERY_STATUS =", value, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusNotEqualTo(String value) {
            addCriterion("MDELIVERY_STATUS <>", value, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusGreaterThan(String value) {
            addCriterion("MDELIVERY_STATUS >", value, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusGreaterThanOrEqualTo(String value) {
            addCriterion("MDELIVERY_STATUS >=", value, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusLessThan(String value) {
            addCriterion("MDELIVERY_STATUS  <", value, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusLessThanOrEqualTo(String value) {

            addCriterion("MDELIVERY_STATUS   <=", value, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusIn(List<String> values) {

            addCriterion("MDELIVERY_STATUS in", values, "deliveryStatus");

            return (Criteria) this;
        }

        public Criteria andDeliveryStatusNotIn(List<String> values) {

            addCriterion("MDELIVERY_STATUS not in", values, "deliveryStatus");

            return (Criteria) this;
        }

        public Criteria andDeliveryStatusBetween(String value1, String value2) {
            addCriterion("DELIVERY_STATUS between", value1, value2, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andDeliveryStatusNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_STATUS not between", value1, value2, "deliveryStatus");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberIsNull() {
            addCriterion("SUPPLIER_MATERIAL_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberIsNotNull() {
            addCriterion("SUPPLIER_MATERIAL_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER =", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberNotEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER <>", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberGreaterThan(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER >", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberGreaterThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER >=", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberLessThan(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER <", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberLessThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER <=", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberLike(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER like", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberNotLike(String value) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER not like", value, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberIn(List<String> values) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER in", values, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberNotIn(List<String> values) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER not in", values, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberBetween(String value1, String value2) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER between", value1, value2, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andSupplierMaterialNumberNotBetween(String value1, String value2) {
            addCriterion("SUPPLIER_MATERIAL_NUMBER not between", value1, value2, "supplierMaterialNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberIsNull() {
            addCriterion("PALLET_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andPalletNumberIsNotNull() {
            addCriterion("PALLET_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andPalletNumberEqualTo(String value) {
            addCriterion("PALLET_NUMBER =", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberNotEqualTo(String value) {
            addCriterion("PALLET_NUMBER <>", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberGreaterThan(String value) {
            addCriterion("PALLET_NUMBER >", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberGreaterThanOrEqualTo(String value) {
            addCriterion("PALLET_NUMBER >=", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberLessThan(String value) {
            addCriterion("PALLET_NUMBER <", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberLessThanOrEqualTo(String value) {
            addCriterion("PALLET_NUMBER <=", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberLike(String value) {
            addCriterion("PALLET_NUMBER like", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberNotLike(String value) {
            addCriterion("PALLET_NUMBER not like", value, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberIn(List<String> values) {
            addCriterion("PALLET_NUMBER in", values, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberNotIn(List<String> values) {
            addCriterion("PALLET_NUMBER not in", values, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberBetween(String value1, String value2) {
            addCriterion("PALLET_NUMBER between", value1, value2, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andPalletNumberNotBetween(String value1, String value2) {
            addCriterion("PALLET_NUMBER not between", value1, value2, "palletNumber");
            return (Criteria) this;
        }

        public Criteria andAttachmentIsNull() {
            addCriterion("ATTACHMENT is null");
            return (Criteria) this;
        }

        public Criteria andAttachmentIsNotNull() {
            addCriterion("ATTACHMENT is not null");
            return (Criteria) this;
        }

        public Criteria andAttachmentEqualTo(String value) {
            addCriterion("ATTACHMENT =", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentNotEqualTo(String value) {
            addCriterion("ATTACHMENT <>", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentGreaterThan(String value) {
            addCriterion("ATTACHMENT >", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentGreaterThanOrEqualTo(String value) {
            addCriterion("ATTACHMENT >=", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentLessThan(String value) {
            addCriterion("ATTACHMENT <", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentLessThanOrEqualTo(String value) {
            addCriterion("ATTACHMENT <=", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentLike(String value) {
            addCriterion("ATTACHMENT like", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentNotLike(String value) {
            addCriterion("ATTACHMENT not like", value, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentIn(List<String> values) {
            addCriterion("ATTACHMENT in", values, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentNotIn(List<String> values) {
            addCriterion("ATTACHMENT not in", values, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentBetween(String value1, String value2) {
            addCriterion("ATTACHMENT between", value1, value2, "attachment");
            return (Criteria) this;
        }

        public Criteria andAttachmentNotBetween(String value1, String value2) {
            addCriterion("ATTACHMENT not between", value1, value2, "attachment");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionIsNull() {
            addCriterion("ITEM_DESCRIPTION is null");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionIsNotNull() {
            addCriterion("ITEM_DESCRIPTION is not null");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionEqualTo(String value) {
            addCriterion("ITEM_DESCRIPTION =", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionNotEqualTo(String value) {
            addCriterion("ITEM_DESCRIPTION <>", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionGreaterThan(String value) {
            addCriterion("ITEM_DESCRIPTION >", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionGreaterThanOrEqualTo(String value) {
            addCriterion("ITEM_DESCRIPTION >=", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionLessThan(String value) {
            addCriterion("ITEM_DESCRIPTION <", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionLessThanOrEqualTo(String value) {
            addCriterion("ITEM_DESCRIPTION <=", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionLike(String value) {
            addCriterion("ITEM_DESCRIPTION like", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionNotLike(String value) {
            addCriterion("ITEM_DESCRIPTION not like", value, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionIn(List<String> values) {
            addCriterion("ITEM_DESCRIPTION in", values, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionNotIn(List<String> values) {
            addCriterion("ITEM_DESCRIPTION not in", values, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionBetween(String value1, String value2) {
            addCriterion("ITEM_DESCRIPTION between", value1, value2, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andItemDescriptionNotBetween(String value1, String value2) {
            addCriterion("ITEM_DESCRIPTION not between", value1, value2, "itemDescription");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescIsNull() {
            addCriterion("ORDER_TYPE_DESC is null");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescIsNotNull() {
            addCriterion("ORDER_TYPE_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescEqualTo(String value) {
            addCriterion("ORDER_TYPE_DESC =", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescNotEqualTo(String value) {
            addCriterion("ORDER_TYPE_DESC <>", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescGreaterThan(String value) {
            addCriterion("ORDER_TYPE_DESC >", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescGreaterThanOrEqualTo(String value) {
            addCriterion("ORDER_TYPE_DESC >=", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescLessThan(String value) {
            addCriterion("ORDER_TYPE_DESC <", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescLessThanOrEqualTo(String value) {
            addCriterion("ORDER_TYPE_DESC <=", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescLike(String value) {
            addCriterion("ORDER_TYPE_DESC like", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescNotLike(String value) {
            addCriterion("ORDER_TYPE_DESC not like", value, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescIn(List<String> values) {
            addCriterion("ORDER_TYPE_DESC in", values, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescNotIn(List<String> values) {
            addCriterion("ORDER_TYPE_DESC not in", values, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescBetween(String value1, String value2) {
            addCriterion("ORDER_TYPE_DESC between", value1, value2, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderTypeDescNotBetween(String value1, String value2) {
            addCriterion("ORDER_TYPE_DESC not between", value1, value2, "orderTypeDesc");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoIsNull() {
            addCriterion("NEED_FOLLOW_NO is null");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoIsNotNull() {
            addCriterion("NEED_FOLLOW_NO is not null");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoEqualTo(String value) {
            addCriterion("NEED_FOLLOW_NO =", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoNotEqualTo(String value) {
            addCriterion("NEED_FOLLOW_NO <>", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoGreaterThan(String value) {
            addCriterion("NEED_FOLLOW_NO >", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoGreaterThanOrEqualTo(String value) {
            addCriterion("NEED_FOLLOW_NO >=", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoLessThan(String value) {
            addCriterion("NEED_FOLLOW_NO <", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoLessThanOrEqualTo(String value) {
            addCriterion("NEED_FOLLOW_NO <=", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoLike(String value) {
            addCriterion("NEED_FOLLOW_NO like", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoNotLike(String value) {
            addCriterion("NEED_FOLLOW_NO not like", value, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoIn(List<String> values) {
            addCriterion("NEED_FOLLOW_NO in", values, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoNotIn(List<String> values) {
            addCriterion("NEED_FOLLOW_NO not in", values, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoBetween(String value1, String value2) {
            addCriterion("NEED_FOLLOW_NO between", value1, value2, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andNeedFollowNoNotBetween(String value1, String value2) {
            addCriterion("NEED_FOLLOW_NO not between", value1, value2, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoIsNull() {
            addCriterion("WBS_NO is null");
            return (Criteria) this;
        }

        public Criteria andWbsNoIsNotNull() {
            addCriterion("WBS_NO is not null");
            return (Criteria) this;
        }

        public Criteria andWbsNoEqualTo(String value) {
            addCriterion("WBS_NO =", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoNotEqualTo(String value) {
            addCriterion("WBS_NO <>", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoGreaterThan(String value) {
            addCriterion("WBS_NO >", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoGreaterThanOrEqualTo(String value) {
            addCriterion("WBS_NO >=", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoLessThan(String value) {
            addCriterion("WBS_NO <", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoLessThanOrEqualTo(String value) {
            addCriterion("WBS_NO <=", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoLike(String value) {
            addCriterion("WBS_NO like", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoNotLike(String value) {
            addCriterion("WBS_NO not like", value, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoIn(List<String> values) {
            addCriterion("WBS_NO in", values, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoNotIn(List<String> values) {
            addCriterion("WBS_NO not in", values, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoBetween(String value1, String value2) {
            addCriterion("WBS_NO between", value1, value2, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoNotBetween(String value1, String value2) {
            addCriterion("WBS_NO not between", value1, value2, "wbsNo");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescIsNull() {
            addCriterion("WBS_NO_DESC is null");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescIsNotNull() {
            addCriterion("WBS_NO_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescEqualTo(String value) {
            addCriterion("WBS_NO_DESC =", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescNotEqualTo(String value) {
            addCriterion("WBS_NO_DESC <>", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescGreaterThan(String value) {
            addCriterion("WBS_NO_DESC >", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescGreaterThanOrEqualTo(String value) {
            addCriterion("WBS_NO_DESC >=", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescLessThan(String value) {
            addCriterion("WBS_NO_DESC <", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescLessThanOrEqualTo(String value) {
            addCriterion("WBS_NO_DESC <=", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescLike(String value) {
            addCriterion("WBS_NO_DESC like", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescNotLike(String value) {
            addCriterion("WBS_NO_DESC not like", value, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescIn(List<String> values) {
            addCriterion("WBS_NO_DESC in", values, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescNotIn(List<String> values) {
            addCriterion("WBS_NO_DESC not in", values, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescBetween(String value1, String value2) {
            addCriterion("WBS_NO_DESC between", value1, value2, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andWbsNoDescNotBetween(String value1, String value2) {
            addCriterion("WBS_NO_DESC not between", value1, value2, "wbsNoDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescIsNull() {
            addCriterion("PROJECT_DESC is null");
            return (Criteria) this;
        }

        public Criteria andProjectDescIsNotNull() {
            addCriterion("PROJECT_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andProjectDescEqualTo(String value) {
            addCriterion("PROJECT_DESC =", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescNotEqualTo(String value) {
            addCriterion("PROJECT_DESC <>", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescGreaterThan(String value) {
            addCriterion("PROJECT_DESC >", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_DESC >=", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescLessThan(String value) {
            addCriterion("PROJECT_DESC <", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_DESC <=", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescLike(String value) {
            addCriterion("PROJECT_DESC like", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescNotLike(String value) {
            addCriterion("PROJECT_DESC not like", value, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescIn(List<String> values) {
            addCriterion("PROJECT_DESC in", values, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescNotIn(List<String> values) {
            addCriterion("PROJECT_DESC not in", values, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescBetween(String value1, String value2) {
            addCriterion("PROJECT_DESC between", value1, value2, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andProjectDescNotBetween(String value1, String value2) {
            addCriterion("PROJECT_DESC not between", value1, value2, "projectDesc");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeIsNull() {
            addCriterion("COURSE_ASSIGN_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeIsNotNull() {
            addCriterion("COURSE_ASSIGN_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeEqualTo(String value) {
            addCriterion("COURSE_ASSIGN_TYPE =", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeNotEqualTo(String value) {
            addCriterion("COURSE_ASSIGN_TYPE <>", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeGreaterThan(String value) {
            addCriterion("COURSE_ASSIGN_TYPE >", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeGreaterThanOrEqualTo(String value) {
            addCriterion("COURSE_ASSIGN_TYPE >=", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeLessThan(String value) {
            addCriterion("COURSE_ASSIGN_TYPE <", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeLessThanOrEqualTo(String value) {
            addCriterion("COURSE_ASSIGN_TYPE <=", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeLike(String value) {
            addCriterion("COURSE_ASSIGN_TYPE like", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeNotLike(String value) {
            addCriterion("COURSE_ASSIGN_TYPE not like", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeIn(List<String> values) {
            addCriterion("COURSE_ASSIGN_TYPE in", values, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeNotIn(List<String> values) {
            addCriterion("COURSE_ASSIGN_TYPE not in", values, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeBetween(String value1, String value2) {
            addCriterion("COURSE_ASSIGN_TYPE between", value1, value2, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andCourseAssignTypeNotBetween(String value1, String value2) {
            addCriterion("COURSE_ASSIGN_TYPE not between", value1, value2, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLike(String value) {
            addCriterion("SUP_COMPANY_NAME like ", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME = ", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andSupCompanyCodeLike(String value) {
            addCriterion("SUP_COMPANY_CODE like ", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andSupCompanyCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_CODE = ", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andFactoryLike(String value) {
            addCriterion("FACTORY_CODE like ", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andFactoryEqualTo(String value) {
            addCriterion("FACTORY_CODE = ", value, "courseAssignType");
            return (Criteria) this;
        }

        public Criteria andFactoryIn(List<String> values) {
            addCriterion("FACTORY_CODE in", values, "needFollowNo");
            return (Criteria) this;
        }

        public Criteria andCreateDateGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateDateGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateDateLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateDateLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectDeliveryTimeGreaterThan(Date value) {
            addCriterion("EXPECT_DELIVERY_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectDeliveryTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("EXPECT_DELIVERY_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectDeliveryTimeLessThan(Date value) {
            addCriterion("EXPECT_DELIVERY_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectDeliveryTimeLessThanOrEqualTo(Date value) {
            addCriterion("EXPECT_DELIVERY_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectArriveTimeGreaterThan(Date value) {
            addCriterion("EXPECT_ARRIVE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectArriveTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("EXPECT_ARRIVE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectArriveTimeLessThan(Date value) {
            addCriterion("EXPECT_ARRIVE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andExpectArriveTimeLessThanOrEqualTo(Date value) {
            addCriterion("EXPECT_ARRIVE_TIME <=", value, "createTime");
            return (Criteria) this;
        }


        //

        public Criteria andIsFinishIsNull() {
            //addCriterion("");
            return (Criteria) this;
        }

        public Criteria andIsFinishIsNotNull() {
            //addCriterion("");
            return (Criteria) this;
        }

        public Criteria andIsFinishEqualTo(String value) {
            if (value.equals("Y")) {
                addCriterion("DELIVERY_QUANTITY =RECEIPT_QUANTITY");
            } else if (value.equals("N")) {
                addCriterion("DELIVERY_QUANTITY <>RECEIPT_QUANTITY");
            }
            return (Criteria) this;
        }

        public Criteria andIsFinishNotEqualTo(String value) {
            addCriterion("DELIVERY_QUANTITY <>RECEIPT_QUANTITY");
            return (Criteria) this;
        }


    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}
