package com.els.base.delivery.service;

import java.util.Date;
import java.util.List;

import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.entity.DeliveryOrderReport;
import com.els.base.delivery.entity.DeliveryOrderReportItemExample;

public interface DeliveryOrderItemService extends BaseService<DeliveryOrderItem, DeliveryOrderItemExample, String> {
	/**
	 * 查询发货行历史
	 * @param t
	 */
	public PageView<DeliveryOrderItem> queryHisObjByPage(DeliveryOrderItemExample example);
	
	/**
	 * 根据送货单id查询明细信息
	 * @param deliveryOrderId
	 * @return
	 */
    public List<DeliveryOrderItem> queryByDeliveryOrderId(String deliveryOrderId);
	/**
	 * 修改发货行
	 * @param record
	 * @param example
	 */
    public void updateDeliveryOrderItem(DeliveryOrderItem record,DeliveryOrderItemExample example);
    /**
     * 物流进度报表
     * @param example
     * @return
     */
//	public PageView<DeliveryOrderItem> queryDeliveryOrderItemForLogisticByPage(DeliveryOrderItemExample example);
	
	/**
	 * 按照查询提交，批量删除发货单行
	 * @param example
	 */
	public void deleteByExample(DeliveryOrderItemExample example);

	/**
	 * 作废发货行
	 * @param deliveryOrderItemIdList
	 */
	public void cancellation( List<String> deliveryOrderItemIdList);


	/**
	 * 插入历史表
	 * @param hisItemId
	 * @param id
	 * @param remark
	 * @param backupDate
	 */
	public void insertHis(String hisItemId, String id, String remark, Date backupDate);

	/**
	* 送货单报表
	* */
	public PageView<DeliveryOrderReport> queryDeliveryOrderReportByPage(DeliveryOrderReportItemExample example);
	/**
	 * 货单报表导出
	 * */
	public List<DeliveryOrderReport> queryDeliveryOrderReportForExcel(DeliveryOrderReportItemExample example);
}