package com.els.base.delivery.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderPrint;
import com.els.base.file.entity.FileData;
import com.google.zxing.WriterException;
import com.itextpdf.text.DocumentException;

public interface DeliveryOrderService extends BaseService<DeliveryOrder, DeliveryOrderExample, String> {
	
	/**
	 * 生成发货单数据
	 * @param purchaseOrderItemList
	 */
	public  DeliveryOrder createDeliveryData(List<String> purchaseOrderItemList, String projectId);
	/**
	 * 发货
	 * @param deliveryOrder
	 */
	public void sendDelivery(DeliveryOrder deliveryOrder);
	/**
	 * 撤销发货
	 * @param deliveryOrder
	 */
//	public void cancelDelivery(DeliveryOrder deliveryOrder);

	/**
	 * 作废发货
	 * @param deliveryOrderIdList
	 */
	public void cancellation( List<String> deliveryOrderIdList);

	/**
	 * 删除发货
	 * @param deliveryOrderIdList
	 */
	public void deleteDelivery(List<String> deliveryOrderIdList);

	/**
	 * 查询发货头
	 * @param t
	 */
	public PageView<DeliveryOrder> queryDeliveryOrderByPage(DeliveryOrderExample example);
	
	/**
	 * 查询发货头历史
	 * @param t
	 */
	public PageView<DeliveryOrder> queryHisObjByPage(DeliveryOrderExample example);
	/**
	 * 修改为香港到货
	 * @param deliveryOrderIdList
	 */
	public void updateForHK(List<String> deliveryOrderIdList);
	/**
	 * 送货单打印
	 * @param deliveryOrderPrint
	 * @return
	 */
//	public FileData print(DeliveryOrderPrint deliveryOrderPrint);

	/**
	 * 批量修改
	 * @param record
	 * @param example
	 */
	public void updateByDeliveryOrder(DeliveryOrder record,DeliveryOrderExample example);
	/**
	 * 生成Invoice单数据
	 * @param purchaseOrderItemIds
	 * @param projectId
	 */
	public DeliveryOrder createInvoiceData(List<String> purchaseOrderItemIds, String projectId);
	
	/**
	 * packageList打印
	 * @param deliveryOrderPrint
	 * @return
	 * @throws InterruptedException 
	 * @throws DocumentException 
	 * @throws IOException 
	 * @throws WriterException 
	 */
	public FileData packageListPrint(DeliveryOrderPrint deliveryOrderPrint) throws WriterException, IOException, InterruptedException;
	
	/**
	 * 订单行转换为发货单行
	 * @param supplierOrderItemIds
	 * @param projectId
	 */
	public  List<DeliveryOrderItem> orderItemToDeliveryData(List<String> supplierOrderItemIds, String projectId);
	
	/**
	 * 修改发货
	 * @param deliveryOrder
	 */
	public void updateDeliveryOrder(DeliveryOrder deliveryOrder);

	/**
	 * 修改采购订单数量
	 * @param id
	 * @param deliveryQuantity
	 */
	public void updatePurchaseOrderForDelivery(String id, BigDecimal deliveryQuantity);

	/**
	 * 根据送货单id查询明细信息
	 * @param deliveryOrderId
	 * @return
	 */
    public DeliveryOrder queryDeliveryOrderId(String deliveryOrderId);
    
	/**
	 * 根据送货单id查询明细信息
	 * @param deliveryOrderId
	 * @return
	 */
	public List<DeliveryOrder> queryAllExpectArriveTime(String timeStart, String timeEnd);
}